// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

angular.module('mm', ['ionic', 'mm.core', 'mm.core.comments', 'mm.core.contentlinks', 'mm.core.course', 'mm.core.courses', 'mm.core.emulator', 'mm.core.fileuploader', 'mm.core.grades', 'mm.core.login', 'mm.core.question', 'mm.core.settings', 'mm.core.sharedfiles', 'mm.core.sidemenu', 'mm.core.textviewer', 'mm.core.user', 'mm.addons.badges', 'mm.addons.calendar', 'mm.addons.competency', 'mm.addons.coursecompletion', 'mm.addons.files', 'mm.addons.frontpage', 'mm.addons.grades', 'mm.addons.messageoutput', 'mm.addons.messages', 'mm.addons.myoverview', 'mm.addons.notes', 'mm.addons.notifications', 'mm.addons.participants', 'mm.addons.pushnotifications', 'mm.addons.remotestyles', 'mm.addons.messageoutput_airnotifier', 'mm.addons.qbehaviour_adaptive', 'mm.addons.qbehaviour_adaptivenopenalty', 'mm.addons.qbehaviour_deferredcbm', 'mm.addons.qbehaviour_deferredfeedback', 'mm.addons.qbehaviour_immediatecbm', 'mm.addons.qbehaviour_immediatefeedback', 'mm.addons.qbehaviour_informationitem', 'mm.addons.qbehaviour_interactive', 'mm.addons.qbehaviour_interactivecountback', 'mm.addons.qbehaviour_manualgraded', 'mm.addons.userprofilefield_checkbox', 'mm.addons.userprofilefield_datetime', 'mm.addons.userprofilefield_menu', 'mm.addons.userprofilefield_text', 'mm.addons.userprofilefield_textarea', 'mm.addons.qtype_calculated', 'mm.addons.qtype_calculatedmulti', 'mm.addons.qtype_calculatedsimple', 'mm.addons.qtype_ddimageortext', 'mm.addons.qtype_ddmarker', 'mm.addons.qtype_ddwtos', 'mm.addons.qtype_description', 'mm.addons.qtype_essay', 'mm.addons.qtype_gapselect', 'mm.addons.qtype_match', 'mm.addons.qtype_multianswer', 'mm.addons.qtype_multichoice', 'mm.addons.qtype_numerical', 'mm.addons.qtype_randomsamatch', 'mm.addons.qtype_shortanswer', 'mm.addons.qtype_truefalse', 'mm.addons.mod_assign', 'mm.addons.mod_book', 'mm.addons.mod_chat', 'mm.addons.mod_choice', 'mm.addons.mod_data', 'mm.addons.mod_feedback', 'mm.addons.mod_folder', 'mm.addons.mod_forum', 'mm.addons.mod_glossary', 'mm.addons.mod_imscp', 'mm.addons.mod_label', 'mm.addons.mod_lesson', 'mm.addons.mod_lti', 'mm.addons.mod_page', 'mm.addons.mod_quiz', 'mm.addons.mod_resource', 'mm.addons.mod_scorm', 'mm.addons.mod_survey', 'mm.addons.mod_url', 'mm.addons.mod_wiki', 'mm.addons.mod_workshop', 'ngCordova', 'angular-md5', 'pascalprecht.translate', 'ngAria', 'oc.lazyLoad', 'ckeditor',
            'ngMessages', 'ngAnimate'])
.run(["$ionicPlatform", function($ionicPlatform) {
    $ionicPlatform.ready(function() {
        if (window.cordova && window.cordova.plugins && window.cordova.plugins.Keyboard) {
            window.cordova.plugins.Keyboard.hideKeyboardAccessoryBar(false);
            window.cordova.plugins.Keyboard.disableScroll(true);
        }
        if (window.StatusBar) {
            StatusBar.styleDefault();
        }
    });
}]);

angular.module('mm.core', ['pascalprecht.translate'])
.constant('mmCoreSessionExpired', 'mmCoreSessionExpired')
.constant('mmCoreUserDeleted', 'mmCoreUserDeleted')
.constant('mmCoreUserPasswordChangeForced', 'mmCoreUserPasswordChangeForced')
.constant('mmCoreUserNotFullySetup', 'mmCoreUserNotFullySetup')
.constant('mmCoreSitePolicyNotAgreed', 'mmCoreSitePolicyNotAgreed')
.constant('mmCoreUnicodeNotSupported', 'mmCoreUnicodeNotSupported')
.constant('mmCoreSecondsYear', 31536000)
.constant('mmCoreSecondsDay', 86400)
.constant('mmCoreSecondsHour', 3600)
.constant('mmCoreSecondsMinute', 60)
.constant('mmCoreDontShowError', 'mmCoreDontShowError') 
.constant('mmCoreNoSiteId', 'NoSite')
.constant('mmCoreDownloaded', 'downloaded')
.constant('mmCoreDownloading', 'downloading')
.constant('mmCoreNotDownloaded', 'notdownloaded')
.constant('mmCoreOutdated', 'outdated')
.constant('mmCoreNotDownloadable', 'notdownloadable')
.constant('mmCoreWifiDownloadThreshold', 104857600) 
.constant('mmCoreDownloadThreshold', 10485760) 
.config(["$stateProvider", "$provide", "$ionicConfigProvider", "$httpProvider", "$mmUtilProvider", "$mmLogProvider", "$compileProvider", "$mmInitDelegateProvider", "mmInitDelegateMaxAddonPriority", function($stateProvider, $provide, $ionicConfigProvider, $httpProvider, $mmUtilProvider,
        $mmLogProvider, $compileProvider, $mmInitDelegateProvider, mmInitDelegateMaxAddonPriority) {
    $ionicConfigProvider.platform.android.tabs.position('bottom');
    $ionicConfigProvider.form.checkbox('circle');
    $ionicConfigProvider.scrolling.jsScrolling(true);
    if (!ionic.Platform.isAndroid()) {
        $ionicConfigProvider.backButton.text("{{'mm.core.back' | translate}}");
    }
    $provide.decorator('$ionicPlatform', ['$delegate', '$window', function($delegate, $window) {
        $delegate.isTablet = function() {
            var mq = 'only screen and (min-width: 768px) and (-webkit-min-device-pixel-ratio: 1)';
            return $window.matchMedia(mq).matches;
        };
        return $delegate;
    }]);
    $provide.decorator('ionRadioDirective', ['$delegate', function($delegate) {
        var directive = $delegate[0];
        transcludeRegex = /ng-transclude/
        directive.template =  directive.template.replace(transcludeRegex, 'ng-transclude data-tap-disabled="true"');
        return $delegate;
    }]);
    $provide.decorator('ionCheckboxDirective', ['$delegate', function($delegate) {
        var directive = $delegate[0];
        transcludeRegex = /ng-transclude/
        directive.template =  directive.template.replace(transcludeRegex, 'ng-transclude data-tap-disabled="true"');
        return $delegate;
    }]);
    $provide.decorator('$log', ['$delegate', $mmLogProvider.logDecorator]);
    $stateProvider
        .state('redirect', {
            url: '/redirect',
            params: {
                siteid: null,
                state: null,
                params: null
            },
            cache: false,
            template: '<ion-view><ion-content mm-state-class><mm-loading class="mm-loading-center"></mm-loading></ion-content></ion-view>',
            controller: ["$scope", "$state", "$stateParams", "$mmSite", "$mmSitesManager", "$ionicHistory", "$mmAddonManager", "$mmApp", "$mmLoginHelper", "mmCoreNoSiteId", function($scope, $state, $stateParams, $mmSite, $mmSitesManager, $ionicHistory, $mmAddonManager, $mmApp,
                        $mmLoginHelper, mmCoreNoSiteId) {
                $ionicHistory.nextViewOptions({disableBack: true});
                function loadSiteAndGo() {
                    if ($stateParams.siteid == mmCoreNoSiteId) {
                        $state.go($stateParams.state, $stateParams.params);
                    } else {
                        $mmSitesManager.loadSite($stateParams.siteid).then(function() {
                            if (!$mmLoginHelper.isSiteLoggedOut($stateParams.state, $stateParams.params)) {
                                $state.go($stateParams.state, $stateParams.params);
                            }
                        }, function() {
                            $state.go('mm_login.sites');
                        });
                    }
                }
                $scope.$on('$ionicView.enter', function() {
                    if ($mmSite.isLoggedIn()) {
                        if ($stateParams.siteid && $stateParams.siteid != $mmSite.getId()) {
                            if ($mmAddonManager.hasRemoteAddonsLoaded()) {
                                $mmApp.storeRedirect($stateParams.siteid, $stateParams.state, $stateParams.params);
                                $mmSitesManager.logout();
                            } else {
                                $mmSitesManager.logout().then(function() {
                                    loadSiteAndGo();
                                });
                            }
                        } else {
                            $state.go($stateParams.state, $stateParams.params);
                        }
                    } else {
                        if ($stateParams.siteid) {
                            loadSiteAndGo();
                        } else {
                            $state.go('mm_login.sites');
                        }
                    }
                });
            }]
        });
    $httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=utf-8';
    $httpProvider.defaults.transformRequest = [function(data) {
        return angular.isObject(data) && String(data) !== '[object File]' ? $mmUtilProvider.param(data) : data;
    }];
    $httpProvider.defaults.transformResponse = [function(data, headers) {
        if (angular.isString(data)) {
            var JSON_PROTECTION_PREFIX = /^\)\]\}',?\n/,
                tempData = data.replace(JSON_PROTECTION_PREFIX, '').trim();
            if (tempData) {
                var contentType = headers('Content-Type');
                if ((contentType && (contentType.indexOf('application/json') === 0)) || isJsonLike(tempData, contentType)) {
                    try {
                        data = angular.fromJson(tempData);
                    } catch(ex) {
                    }
                }
            }
        }
        return data;
        function isJsonLike(str, contentType) {
            if (contentType && contentType.indexOf('text/rtf') != -1) {
                return false;
            }
            var JSON_START = /^\[|^\{(?!\{)/,
                JSON_ENDS = {
                  '[': /]$/,
                  '{': /}$/
                },
                jsonStart = str.match(JSON_START);
            return jsonStart && JSON_ENDS[jsonStart[0]].test(str);
        }
    }];
    function addProtocolIfMissing(list, protocol) {
        if (list.indexOf(protocol) == -1) {
            list = list.replace('https?', 'https?|' + protocol);
        }
        return list;
    }
    var hreflist = $compileProvider.aHrefSanitizationWhitelist().source,
        imglist = $compileProvider.imgSrcSanitizationWhitelist().source;
    hreflist = addProtocolIfMissing(hreflist, 'file');
    hreflist = addProtocolIfMissing(hreflist, 'tel');
    hreflist = addProtocolIfMissing(hreflist, 'mailto');
    hreflist = addProtocolIfMissing(hreflist, 'geo');
    hreflist = addProtocolIfMissing(hreflist, 'filesystem'); 
    imglist = addProtocolIfMissing(imglist, 'filesystem'); 
    imglist = addProtocolIfMissing(imglist, 'file');
    imglist = addProtocolIfMissing(imglist, 'cdvfile');
    moment.relativeTimeThreshold('M', 12);
    moment.relativeTimeThreshold('d', 31);
    moment.relativeTimeThreshold('h', 24);
    moment.relativeTimeThreshold('m', 60);
    moment.relativeTimeThreshold('s', 60);
    $compileProvider.aHrefSanitizationWhitelist(hreflist);
    $compileProvider.imgSrcSanitizationWhitelist(imglist);
    $mmInitDelegateProvider.registerProcess('mmAppInit', '$mmApp.initProcess', mmInitDelegateMaxAddonPriority + 400, true);
    $mmInitDelegateProvider.registerProcess('mmUpdateManager', '$mmUpdateManager.check', mmInitDelegateMaxAddonPriority + 300, true);
    $mmInitDelegateProvider.registerProcess('mmFSClearTmp', '$mmFS.clearTmpFolder', mmInitDelegateMaxAddonPriority + 150, false);
}])
.run(["$ionicPlatform", "$ionicBody", "$window", "$mmEvents", "$mmInitDelegate", "mmCoreEventKeyboardShow", "mmCoreEventKeyboardHide", "$mmApp", "$timeout", "mmCoreEventOnline", "mmCoreEventOnlineStatusChanged", "$mmUtil", "$ionicScrollDelegate", function($ionicPlatform, $ionicBody, $window, $mmEvents, $mmInitDelegate, mmCoreEventKeyboardShow, mmCoreEventKeyboardHide,
        $mmApp, $timeout, mmCoreEventOnline, mmCoreEventOnlineStatusChanged, $mmUtil, $ionicScrollDelegate) {
    $mmInitDelegate.executeInitProcesses();
    $ionicPlatform.ready(function() {
        var checkTablet = function() {
            $ionicBody.enableClass($ionicPlatform.isTablet(), 'tablet');
        };
        ionic.on('resize', checkTablet, $window);
        checkTablet();
        $window.addEventListener('native.keyboardshow', function(e) {
            $mmEvents.trigger(mmCoreEventKeyboardShow, e);
            if (ionic.Platform.isIOS()) {
                ionic.trigger('resize');
            }
            if (ionic.Platform.isIOS() && document.activeElement && document.activeElement.tagName != 'BODY') {
                if ($mmUtil.closest(document.activeElement, 'ion-footer-bar[keyboard-attach]')) {
                    return;
                }
                if ($mmUtil.isElementOutsideOfScreen(document.activeElement)) {
                    var position = $mmUtil.getElementXY(document.activeElement),
                        delegateHandle = $mmUtil.closest(document.activeElement, '*[delegate-handle]'),
                        scrollView;
                    if (position) {
                        if ($window && $window.innerHeight) {
                            position[1] = position[1] - $window.innerHeight * 0.5;
                        }
                        delegateHandle = delegateHandle && delegateHandle.getAttribute('delegate-handle');
                        scrollView = typeof delegateHandle == 'string' ?
                                $ionicScrollDelegate.$getByHandle(delegateHandle) : $ionicScrollDelegate;
                        scrollView.scrollTo(position[0], position[1]);
                    }
                }
            }
        });
        $window.addEventListener('native.keyboardhide', function(e) {
            $mmEvents.trigger(mmCoreEventKeyboardHide, e);
            if (ionic.Platform.isIOS()) {
                ionic.trigger('resize');
            }
        });
        var fnName = !$mmApp.isDevice() ? 'getParentOrSelfWithClass' : (ionic.Platform.isIOS() ? 'getParentWithClass' : '');
        if (fnName) {
            var originalFunction = ionic.DomUtil[fnName];
            ionic.DomUtil[fnName] = function(e, className, depth) {
                depth = depth || 20;
                return originalFunction(e, className, depth);
            };
        }
    });
    var lastExecution = 0;
    $mmApp.ready().then(function() {
        document.addEventListener('online', function() { sendOnlineEvent(true); }, false); 
        window.addEventListener('online', function() { sendOnlineEvent(true); }, false); 
        document.addEventListener('offline', function() { sendOnlineEvent(false); }, false); 
        window.addEventListener('offline', function() { sendOnlineEvent(false); }, false); 
    });
    function sendOnlineEvent(online) {
        var now = new Date().getTime();
        if (now - lastExecution < 5000) {
            return;
        }
        lastExecution = now;
        $timeout(function() { 
            if (online) {
                $mmEvents.trigger(mmCoreEventOnline);
            }
            $mmEvents.trigger(mmCoreEventOnlineStatusChanged, online);
        }, 1000);
    }
}]);

angular.module('mm.core')
.constant('mmAddonManagerComponent', 'mmAddonManager')
.factory('$mmAddonManager', ["$log", "$injector", "$ocLazyLoad", "$mmFilepool", "$mmSite", "$mmFS", "$mmLang", "$mmSitesManager", "$q", "$mmUtil", "$mmApp", "mmAddonManagerComponent", "mmCoreNotDownloaded", function($log, $injector, $ocLazyLoad, $mmFilepool, $mmSite, $mmFS, $mmLang, $mmSitesManager, $q,
            $mmUtil, $mmApp, mmAddonManagerComponent, mmCoreNotDownloaded) {
    $log = $log.getInstance('$mmAddonManager');
    var self = {},
        instances = {},
        remoteAddonsFolderName = 'remoteaddons',
        remoteAddonFilename = 'addon.js',
        remoteAddonCssFilename = 'styles.css',
        pathWildcardRegex = /\$ADDONPATH\$/g,
        headEl = angular.element(document.querySelector('head')),
        loadedAddons = [],
        loadedModules = [];
    self.downloadRemoteAddon = function(addon, siteId) {
        siteId = siteId || $mmSite.getId();
        var name = self.getRemoteAddonName(addon),
            dirPath = self.getRemoteAddonDirectoryPath(addon),
            revision = addon.filehash,
            file = {
                filename: name + '.zip',
                fileurl: addon.fileurl
            };
        return $mmFilepool.getPackageStatus(siteId, mmAddonManagerComponent, name, revision, 0).then(function(status) {
            if (status !== $mmFilepool.FILEDOWNLOADED) {
                return $mmFilepool.downloadPackage(siteId, [file], mmAddonManagerComponent, name, revision, 0).then(function() {
                    return $mmFS.removeDir(dirPath).catch(function() {});
                }).then(function() {
                    return $mmFilepool.getFilePathByUrl(siteId, addon.fileurl);
                }).then(function(zipPath) {
                    return $mmFS.unzipFile(zipPath, dirPath).then(function() {
                        return $mmFilepool.removeFileByUrl(siteId, addon.fileurl).catch(function() {});
                    });
                }).then(function() {
                    return $mmFS.getDir(dirPath);
                }).then(function(dir) {
                    var absoluteDirPath = $mmFS.getInternalURL(dir);
                    if (absoluteDirPath.slice(-1) == '/') {
                        absoluteDirPath = absoluteDirPath.substring(0, absoluteDirPath.length - 1);
                    }
                    var addonMainFile = $mmFS.concatenatePaths(dirPath, remoteAddonFilename);
                    return $mmFS.replaceInFile(addonMainFile, pathWildcardRegex, absoluteDirPath);
                }).catch(function() {
                    return self.setRemoteAddonStatus(addon, status).then(function() {
                        return $q.reject();
                    });
                });
            }
        });
    };
    self.downloadRemoteAddons = function(siteId) {
        siteId = siteId || $mmSite.getId();
        var downloaded = {},
            preSets = {};
        return $mmSitesManager.getSite(siteId).then(function(site) {
            preSets.getFromCache = 0;
            return site.read('tool_mobile_get_plugins_supporting_mobile', {}, preSets).then(function(data) {
                var promises = [];
                angular.forEach(data.plugins, function(addon) {
                    if (site.isFeatureDisabled('remoteAddOn_' + addon.component + '_' + addon.addon)) {
                        return;
                    }
                    promises.push(self.downloadRemoteAddon(addon, siteId).then(function() {
                        downloaded[addon.addon]= addon;
                    }));
                });
                return $mmUtil.allPromises(promises).then(function() {
                    return downloaded;
                }).catch(function() {
                    return downloaded;
                });
            });
        });
    };
    self.get = function(name) {
        if (self.isAvailable(name)) {
            return instances[name];
        }
    };
    self.getRemoteAddonDirectoryPath = function(addon, siteId) {
        siteId = siteId || $mmSite.getId();
        var subPath = remoteAddonsFolderName + '/' + self.getRemoteAddonName(addon);
        return $mmFS.concatenatePaths($mmFilepool.getFilepoolFolderPath(siteId), subPath);
    };
    self.getRemoteAddonName = function(addon) {
        return addon.component + '_' + addon.addon;
    };
    self.hasRemoteAddonsLoaded = function() {
        return loadedAddons.length;
    };
    self.isAvailable = function(name) {
        if (!name) {
            return false;
        }
        if (instances[name]) {
            return true;
        }
        try {
            instances[name] = $injector.get(name);
            return true;
        } catch(ex) {
            $log.warn('Service not available: '+name);
            return false;
        }
    };
    self.loadRemoteAddon = function(addon) {
        var dirPath = self.getRemoteAddonDirectoryPath(addon),
            absoluteDirPath;
        return $mmFS.getDir(dirPath).then(function(dir) {
            absoluteDirPath = $mmFS.getInternalURL(dir);
            return $mmFS.getDir($mmFS.concatenatePaths(dirPath, 'lang')).then(function() {
                return $mmLang.registerLanguageFolder($mmFS.concatenatePaths(absoluteDirPath, 'lang'));
            }).catch(function() {
            }).then(function() {
                return $ocLazyLoad.load($mmFS.concatenatePaths(absoluteDirPath, remoteAddonFilename));
            }).then(function() {
                loadedAddons.push(addon);
                $mmApp.trustResources($mmFS.concatenatePaths(absoluteDirPath, '**'));
                return $mmFS.getFile($mmFS.concatenatePaths(dirPath, remoteAddonCssFilename)).then(function(file) {
                    headEl.append('<link class="remoteaddonstyles" rel="stylesheet" href="' + $mmFS.getInternalURL(file) + '">');
                }).catch(function() {});
            });
        }, function() {
            return self.setRemoteAddonStatus(addon, mmCoreNotDownloaded).then(function() {
                return $q.reject();
            });
        });
    };
    self.loadRemoteAddons = function(addons) {
        var promises = [];
        loadedModules = $ocLazyLoad.getModules();
        angular.forEach(addons, function(addon) {
            self.setRemoteAddonLoadPromise(addons, addon);
            if (addon.loadPromise) {
                promises.push(addon.loadPromise);
            }
        });
        return $mmUtil.allPromises(promises);
    };
    self.setRemoteAddonLoadPromise = function(addons, addon, dependants) {
        if (typeof addon.loadPromise != 'undefined') {
            return;
        }
        dependants = dependants || [];
        var promises = [],
            stop = false;
        angular.forEach(addon.dependencies, function(dependency) {
            if (stop) {
                return;
            }
            if (dependency == addon.addon) {
                return;
            }
            if (dependants.indexOf(dependency) != -1) {
                stop = true;
                return;
            }
            if (!addons[dependency]) {
                if (dependency.indexOf('mm.addons.') == -1) {
                    dependency = 'mm.addons.' + dependency;
                }
                if (loadedModules.indexOf(dependency) == -1) {
                    stop = true;
                }
            } else {
                self.setRemoteAddonLoadPromise(addons, addons[dependency], dependants.concat(addon.addon));
                if (!addons[dependency].loadPromise) {
                    stop = true;
                } else {
                    promises.push(addons[dependency].loadPromise);
                }
            }
        });
        if (!stop) {
            addon.loadPromise = $q.all(promises).then(function() {
                return self.loadRemoteAddon(addon);
            });
        } else {
            addon.loadPromise = false;
        }
    };
    self.setRemoteAddonStatus = function(addon, status, siteId) {
        siteId = siteId || $mmSite.getId();
        var name = self.getRemoteAddonName(addon),
            revision = addon.filehash;
        return $mmFilepool.storePackageStatus(siteId, mmAddonManagerComponent, name, status, revision, 0);
    };
    return self;
}])
.run(["$mmAddonManager", "$mmEvents", "mmCoreEventLogin", "mmCoreEventLogout", "mmCoreEventRemoteAddonsLoaded", "$mmSite", "$window", function($mmAddonManager, $mmEvents, mmCoreEventLogin, mmCoreEventLogout, mmCoreEventRemoteAddonsLoaded, $mmSite, $window) {
    $mmEvents.on(mmCoreEventLogin, function() {
        var siteId = $mmSite.getId();
        $mmAddonManager.downloadRemoteAddons(siteId).then(function(addons) {
            return $mmAddonManager.loadRemoteAddons(addons).finally(function() {
                if ($mmSite.getId() == siteId && $mmAddonManager.hasRemoteAddonsLoaded()) {
                    $mmEvents.trigger(mmCoreEventRemoteAddonsLoaded);
                }
            });
        });
    });
    $mmEvents.on(mmCoreEventLogout, function() {
        if ($mmAddonManager.hasRemoteAddonsLoaded()) {
            $window.location.reload();
        }
    });
}]);

angular.module('mm.core')
.provider('$mmApp', ["$stateProvider", "$sceDelegateProvider", function($stateProvider, $sceDelegateProvider) {
    var DBNAME = 'MoodleMobile',
        dbschema = {
            stores: []
        },
        dboptions = {
            autoSchema: true
        };
    this.registerStore = function(store) {
        if (typeof(store.name) === 'undefined') {
            console.error('$mmApp: Error: store name is undefined.');
            return;
        } else if (typeof store.keyPath  === 'undefined' || !store.keyPath) {
            console.error('$mmApp: Error: store ' + store.name + ' keyPath is invalid.');
            return;
        } else if (storeExists(store.name)) {
            console.error('$mmApp: Error: store ' + store.name + ' is already defined.');
            return;
        }
        dbschema.stores.push(store);
    };
    this.registerStores = function(stores) {
        var self = this;
        angular.forEach(stores, function(store) {
            self.registerStore(store);
        });
    };
    function storeExists(name) {
        var exists = false;
        angular.forEach(dbschema.stores, function(store) {
            if (store.name === name) {
                exists = true;
            }
        });
        return exists;
    }
    this.$get = ["$mmDB", "$cordovaNetwork", "$log", "$injector", "$ionicPlatform", "$timeout", "$q", function($mmDB, $cordovaNetwork, $log, $injector, $ionicPlatform, $timeout, $q) {
        $log = $log.getInstance('$mmApp');
        var db,
            self = {},
            ssoAuthenticationDeferred;
        self.canGetUserMedia = function() {
            return !!(navigator && navigator.mediaDevices && navigator.mediaDevices.getUserMedia);
        };
        self.canRecordMedia = function() {
            return !!window.MediaRecorder;
        };
        self.createState = function(name, config) {
            $log.debug('Adding new state: '+name);
            $stateProvider.state(name, config);
        };
        self.closeKeyboard = function() {
            if (typeof cordova != 'undefined' && cordova.plugins && cordova.plugins.Keyboard && cordova.plugins.Keyboard.close) {
                cordova.plugins.Keyboard.close();
                return true;
            }
            return false;
        };
        self.getDB = function() {
            if (typeof db == 'undefined') {
                db = $mmDB.getDB(DBNAME, dbschema, dboptions);
            }
            return db;
        };
        self.getSchema = function() {
            return dbschema;
        };
        self.initProcess = function() {
            return $ionicPlatform.ready();
        };
        self.isDesktop = function() {
            return !!(window.process && window.process.versions && typeof window.process.versions.electron != 'undefined');
        };
        self.isDevice = function() {
            return !!window.device;
        };
        self.isKeyboardVisible = function() {
            if (typeof cordova != 'undefined' && cordova.plugins && cordova.plugins.Keyboard) {
                return cordova.plugins.Keyboard.isVisible;
            }
            return false;
        };
        self.isOnline = function() {
            var online = typeof navigator.connection === 'undefined' || $cordovaNetwork.isOnline();
            if (!online && navigator.onLine) {
                online = true;
            }
            return online;
        };
        self.isNetworkAccessLimited = function() {
            if (typeof navigator.connection === 'undefined') {
                return false;
            }
            var type = $cordovaNetwork.getNetwork();
            var limited = [Connection.CELL_2G, Connection.CELL_3G, Connection.CELL_4G, Connection.CELL];
            return limited.indexOf(type) > -1;
        };
        self.isReady = function() {
            var promise = $injector.get('$mmInitDelegate').ready();
            return promise.$$state.status === 1;
        };
        self.openKeyboard = function() {
            if (typeof cordova != 'undefined' && cordova.plugins && cordova.plugins.Keyboard && cordova.plugins.Keyboard.show) {
                cordova.plugins.Keyboard.show();
                return true;
            }
            return false;
        };
        self.ready = function() {
            return $injector.get('$mmInitDelegate').ready();
        };
        self.startSSOAuthentication = function() {
            var cancelPromise;
            ssoAuthenticationDeferred = $q.defer();
            cancelPromise = $timeout(function() {
                self.finishSSOAuthentication();
            }, 10000);
            ssoAuthenticationDeferred.promise.finally(function() {
                $timeout.cancel(cancelPromise);
            });
        };
        self.finishSSOAuthentication = function() {
            ssoAuthenticationDeferred && ssoAuthenticationDeferred.resolve();
            ssoAuthenticationDeferred = undefined;
        };
        self.isSSOAuthenticationOngoing = function() {
            return !!ssoAuthenticationDeferred;
        };
        self.waitForSSOAuthentication = function() {
            if (ssoAuthenticationDeferred) {
                return ssoAuthenticationDeferred.promise;
            }
            return $q.when();
        };
        self.getRedirect = function() {
            if (localStorage && localStorage.getItem) {
                try {
                    var data = {
                        siteid: localStorage.getItem('mmCoreRedirectSiteId'),
                        state: localStorage.getItem('mmCoreRedirectState'),
                        params: localStorage.getItem('mmCoreRedirectParams'),
                        timemodified: localStorage.getItem('mmCoreRedirectTime')
                    };
                    if (data.params) {
                        data.params = JSON.parse(data.params);
                    }
                    return data;
                } catch(ex) {
                    $log.error('Error loading redirect data:', ex);
                }
            }
            return {};
        };
        self.storeRedirect = function(siteId, state, params) {
            if (localStorage && localStorage.setItem) {
                try {
                    localStorage.setItem('mmCoreRedirectSiteId', siteId);
                    localStorage.setItem('mmCoreRedirectState', state);
                    localStorage.setItem('mmCoreRedirectParams', JSON.stringify(params));
                    localStorage.setItem('mmCoreRedirectTime', new Date().getTime());
                } catch(ex) {}
            }
        };
        self.trustResources = function(wildcard) {
            var currentList = $sceDelegateProvider.resourceUrlWhitelist();
            if (currentList.indexOf(wildcard) == -1) {
                currentList.push(wildcard);
                $sceDelegateProvider.resourceUrlWhitelist(currentList);
            }
        };
        return self;
    }];
}]);

angular.module('mm.core')
.constant('mmCoreConfigStore', 'config')
.config(["$mmAppProvider", "mmCoreConfigStore", function($mmAppProvider, mmCoreConfigStore) {
    var stores = [
        {
            name: mmCoreConfigStore,
            keyPath: 'name'
        }
    ];
    $mmAppProvider.registerStores(stores);
}])
.factory('$mmConfig', ["$q", "$log", "$mmApp", "mmCoreConfigStore", function($q, $log, $mmApp, mmCoreConfigStore) {
    $log = $log.getInstance('$mmConfig');
    var self = {};
    self.get = function(name, defaultValue) {
        return $mmApp.getDB().get(mmCoreConfigStore, name).then(function(entry) {
            return entry.value;
        }).catch(function() {
            if (typeof defaultValue != 'undefined') {
                return defaultValue;
            } else {
                return $q.reject();
            }
        });
    };
    self.set = function(name, value) {
        return $mmApp.getDB().insert(mmCoreConfigStore, {name: name, value: value});
    };
    self.delete = function(name) {
        return $mmApp.getDB().remove(mmCoreConfigStore, name);
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmCoreCronInterval', 3600000) 
.constant('mmCoreCronMinInterval', 300000) 
.constant('mmCoreCronDesktopMinInterval', 60000) 
.constant('mmCoreCronMaxTimeProcess', 120000) 
.constant('mmCoreCronStore', 'cron')
.config(["$mmAppProvider", "mmCoreCronStore", function($mmAppProvider, mmCoreCronStore) {
    var stores = [
        {
            name: mmCoreCronStore,
            keyPath: 'id'
        }
    ];
    $mmAppProvider.registerStores(stores);
}])
.factory('$mmCronDelegate', ["$log", "$mmConfig", "$mmApp", "$timeout", "$q", "$mmUtil", "mmCoreCronInterval", "mmCoreCronStore", "mmCoreSettingsSyncOnlyOnWifi", "mmCoreCronMinInterval", "mmCoreCronMaxTimeProcess", "mmCoreCronDesktopMinInterval", function($log, $mmConfig, $mmApp, $timeout, $q, $mmUtil, mmCoreCronInterval, mmCoreCronStore,
            mmCoreSettingsSyncOnlyOnWifi, mmCoreCronMinInterval, mmCoreCronMaxTimeProcess, mmCoreCronDesktopMinInterval) {
    $log = $log.getInstance('$mmCronDelegate');
    var hooks = {},
        self = {},
        queuePromise = $q.when();
    self._executeHook = function(name, force, siteId) {
        if (!hooks[name] || !hooks[name].instance || !angular.isFunction(hooks[name].instance.execute)) {
            $log.debug('Cannot execute hook because is invalid: ' + name);
            return $q.reject();
        }
        var usesNetwork = self._hookUsesNetwork(name),
            isSync = !force && self._isHookSync(name),
            promise;
        if (usesNetwork && !$mmApp.isOnline()) {
            $log.debug('Cannot execute hook because device is offline: ' + name);
            self._stopHook(name);
            return $q.reject();
        }
        if (isSync) {
            promise = $mmConfig.get(mmCoreSettingsSyncOnlyOnWifi, false).catch(function() {
                return false; 
            }).then(function(syncOnlyOnWifi) {
                return !syncOnlyOnWifi || !$mmApp.isNetworkAccessLimited();
            });
        } else {
            promise = $q.when(true);
        }
        return promise.then(function(execute) {
            if (!execute) {
                $log.debug('Cannot execute hook because device is using limited connection: ' + name);
                scheduleNextExecution(name, mmCoreCronMinInterval);
                return $q.reject();
            }
            queuePromise = queuePromise.catch(function() {
            }).then(function() {
                return executeHook(name, siteId).then(function() {
                    $log.debug('Execution of hook \'' + name + '\' was a success.');
                    return self._setHookLastExecutionTime(name, new Date().getTime()).then(function() {
                        scheduleNextExecution(name);
                    });
                }, function() {
                    $log.debug('Execution of hook \'' + name + '\' failed.');
                    scheduleNextExecution(name, mmCoreCronMinInterval);
                    return $q.reject();
                });
            });
            return queuePromise;
        });
    };
    function executeHook(name, siteId) {
        var deferred = $q.defer(),
            cancelPromise;
        $log.debug('Executing hook: ' + name);
        $q.when(hooks[name].instance.execute(siteId)).then(function() {
            deferred.resolve();
        }).catch(function() {
            deferred.reject();
        }).finally(function() {
            $timeout.cancel(cancelPromise);
        });
        cancelPromise = $timeout(function() {
            $log.debug('Resolving execution of hook \'' + name + '\' because it took too long.');
            deferred.resolve();
        }, mmCoreCronMaxTimeProcess);
        return deferred.promise;
    }
    self.forceSyncExecution = function(siteId) {
        var promises = [];
        angular.forEach(hooks, function(hook, name) {
            if (self._isHookManualSync(name)) {
                hook.running = true;
                $timeout.cancel(hook.timeout);
                promises.push(self._executeHook(name, true, siteId));
            }
        });
        return $mmUtil.allPromises(promises);
    };
    self._getHookInterval = function(name) {
        if (!hooks[name] || !hooks[name].instance || !angular.isFunction(hooks[name].instance.getInterval)) {
            return mmCoreCronInterval;
        }
        var minInterval = $mmApp.isDesktop() ? mmCoreCronDesktopMinInterval : mmCoreCronMinInterval;
        return Math.max(minInterval, parseInt(hooks[name].instance.getInterval(), 10));
    };
    self._getHookLastExecutionId = function(name) {
        return 'last_execution_'+name;
    };
    self._getHookLastExecutionTime = function(name) {
        var id = self._getHookLastExecutionId(name);
        return $mmApp.getDB().get(mmCoreCronStore, id).then(function(entry) {
            var time = parseInt(entry.value);
            return isNaN(time) ? 0 : time;
        }).catch(function() {
            return 0; 
        });
    };
    self.hasSyncHooks = function() {
        for (var name in hooks) {
            if (self._isHookSync(name)) {
                return true;
            }
        }
        return false;
    };
    self.hasManualSyncHooks = function() {
        for (var name in hooks) {
            if (self._isHookManualSync(name)) {
                return true;
            }
        }
        return false;
    };
    self._hookUsesNetwork = function(name) {
        if (!hooks[name] || !hooks[name].instance || !angular.isFunction(hooks[name].instance.usesNetwork)) {
            return true;
        }
        return hooks[name].instance.usesNetwork();
    };
    self._isHookSync = function(name) {
        if (!hooks[name] || !hooks[name].instance || !angular.isFunction(hooks[name].instance.isSync)) {
            return true;
        }
        return hooks[name].instance.isSync();
    };
    self._isHookManualSync = function(name) {
        if (!hooks[name] || !hooks[name].instance || !angular.isFunction(hooks[name].instance.canManualSync)) {
            return self._isHookSync(name);
        }
        return hooks[name].instance.canManualSync();
    };
    self.register = function(name, handler) {
        if (typeof hooks[name] != 'undefined') {
            $log.debug('The cron hook \''+name+'\' is already registered.');
            return;
        }
        $log.debug('Register hook \''+name+'\' in cron.');
        hooks[name] = {
            name: name,
            handler: handler,
            instance: $mmUtil.resolveObject(handler, true),
            running: false
        };
        if (!hooks[name].instance) {
            $log.error('The cron hook \''+name+'\' has an invalid instance, deleting.');
            delete hooks[name];
            return;
        }
        self._startHook(name);
    };
    function scheduleNextExecution(name, time) {
        if (!hooks[name]) {
            return;
        }
        if (hooks[name].timeout && hooks[name].timeout.$$state && hooks[name].timeout.$$state.status === 0) {
            return;
        }
        var promise;
        time = parseInt(time, 10);
        if (time) {
            promise = $q.when(time);
        } else {
            promise = self._getHookLastExecutionTime(name).then(function(lastExecution) {
                var interval = self._getHookInterval(name),
                    nextExecution = lastExecution + interval,
                    now = new Date().getTime();
                return nextExecution - now;
            });
        }
        promise.then(function(nextExecution) {
            $log.debug('Scheduling next execution of hook \'' + name + '\' in: ' + nextExecution + 'ms');
            if (nextExecution < 0) {
                nextExecution = 0; 
            }
            hooks[name].timeout = $timeout(function() {
                self._executeHook(name);
            }, nextExecution);
        });
    }
    self._setHookLastExecutionTime = function(name, time) {
        var id = self._getHookLastExecutionId(name),
            entry = {
                id: id,
                value: parseInt(time, 10)
            };
        return $mmApp.getDB().insert(mmCoreCronStore, entry);
    };
    self.startNetworkHooks = function() {
        angular.forEach(hooks, function(hook) {
            if (self._hookUsesNetwork(hook.name)) {
                self._startHook(hook.name);
            }
        });
    };
    self._startHook = function(name) {
        if (!hooks[name]) {
            $log.debug('Cannot start hook \''+name+'\', is invalid.');
            return;
        }
        if (hooks[name].running) {
            $log.debug('Hook \''+name+'\' is already running.');
            return;
        }
        hooks[name].running = true;
        scheduleNextExecution(name);
    };
    self._stopHook = function(name) {
        if (!hooks[name]) {
            $log.debug('Cannot stop hook \''+name+'\', is invalid.');
            return;
        }
        if (!hooks[name].running) {
            $log.debug('Cannot stop hook \''+name+'\', it\'s not running.');
            return;
        }
        hooks[name].running = false;
        $timeout.cancel(hooks[name].timeout);
    };
    return self;
}])
.run(["$mmEvents", "$mmCronDelegate", "mmCoreEventOnlineStatusChanged", function($mmEvents, $mmCronDelegate, mmCoreEventOnlineStatusChanged) {
    $mmEvents.on(mmCoreEventOnlineStatusChanged, function(online) {
        if (online) {
            $mmCronDelegate.startNetworkHooks();
        }
    });
}]);

angular.module('mm.core')
.factory('$mmDB', ["$q", "$log", function($q, $log) {
    $log = $log.getInstance('$mmDB');
    var self = {},
        dbInstances = {};
    function applyOrder(query, order, reverse) {
        if (order) {
            query = query.order(order);
            if (reverse) {
                query = query.reverse();
            }
        }
        return query;
    }
    function applyWhere(query, where) {
        if (where && where.length > 0) {
            query = query.where.apply(query, where);
        }
        return query;
    }
    function callDBFunction(db, func) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer();
        try {
            db[func].apply(db, Array.prototype.slice.call(arguments, 2)).then(function(result) {
                if (typeof result == 'undefined') {
                    deferred.reject();
                } else {
                    deferred.resolve(result);
                }
            }, deferred.reject);
        } catch(ex) {
            $log.error('Error executing function ' + func + ' to DB ' + db.getName());
            $log.error(ex.name + ': ' + ex.message);
            deferred.reject();
        }
        return deferred.promise;
    }
    function callCount(db, store, where) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer();
        try {
            var query = db.from(store);
            query = applyWhere(query, where);
            query.count().then(deferred.resolve, deferred.reject);
        } catch(ex) {
            var promise;
            if (where[1] == '=') {
                promise = callWhereEqualFallBack(db, store, where[0], where[2]).then(function(list) {
                    deferred.resolve(list.length);
                });
            } else {
                promise = $q.reject();
            }
            promise.catch(function () {
                $log.error('Error counting on db ' + db.getName() + '. ' + ex.name + ': ' + ex.message);
                deferred.reject();
            });
        }
        return deferred.promise;
    }
    function callWhere(db, store, field_name, op, value, op2, value2) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer();
        try {
            db.from(store).where(field_name, op, value, op2, value2).list().then(deferred.resolve, deferred.reject);
        } catch(ex) {
            var promise;
            if (op == '=') {
                promise = callWhereEqualFallBack(db, store, field_name, value).then(deferred.resolve).catch(deferred.reject);
            } else {
                promise = $q.reject();
            }
            promise.catch(function () {
                $log.error('Error getting where from db ' + db.getName() + '. ' + ex.name+': ' + ex.message);
                deferred.reject();
            });
        }
        return deferred.promise;
    }
    function callWhereEqual(db, store, field_name, value) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer();
        try {
            db.from(store).where(field_name, '=', value).list().then(deferred.resolve, deferred.reject);
        } catch(ex) {
            callWhereEqualFallBack(db, store, field_name, value).then(deferred.resolve).catch(function () {
                $log.error('Error getting where equal from db ' + db.getName() + '. ' + ex.name + ': ' + ex.message);
                deferred.reject();
            });
        }
        return deferred.promise;
    }
    function callWhereEqualFallBack(db, store, field_name, values) {
        var fields = getCompoundIndex(db, store, field_name);
        if (!fields) {
            return $q.reject();
        }
        if (typeof fields == "string") {
            fields = [fields];
        }
        var deferred = $q.defer();
        try {
            db.from(store).where(fields[0], '=', values[0]).list().then(function(list) {
                var results = filterWhereList(list, fields, values, 1);
                deferred.resolve(results);
            }, deferred.reject);
        } catch(ex) {
            deferred.reject();
        }
        return deferred.promise;
    }
    function getStoreFromName(db, storeName) {
        var stores = db.getSchema().stores;
        for (var x in stores) {
            if (stores[x].name == storeName) {
                return stores[x];
            }
        }
        return false;
    }
    function getCompoundIndex(db, storeName, index) {
        var store = getStoreFromName(db, storeName);
        if (store) {
            var indexes = store.indexes;
            for (var y in indexes) {
                if (indexes[y].name == index) {
                    return indexes[y].keyPath;
                }
            }
        }
        return false;
    }
    function checkKeyPathIsPresent(db, storeName, value) {
        var store = getStoreFromName(db, storeName);
        if (store) {
            keyPath = Array.isArray(store.keyPath) ? store.keyPath : [store.keyPath];
            for (var x in keyPath) {
                var val = value[keyPath[x]];
                if (typeof val == "undefined" || val === null || (typeof val == "number" && isNaN(val))) {
                    var error = "Value inserted does not have key " + keyPath[x] + " required on store " + storeName;
                    if (typeof sendErrorReport == 'function') {
                        sendErrorReport(error);
                    }
                    throw new Error(error);
                }
            }
        }
    }
    function filterWhereList(list, fields, values, indexNum) {
        if (list.length == 0 || fields.length < indexNum || values.length < indexNum) {
            return list;
        }
        var field = fields[indexNum],
            value = values[indexNum];
        list = list.filter(function (item) {
            return item[field] == value;
        });
        return filterWhereList(list, fields, values, indexNum + 1);
    }
    function callEach(db, store, callback) {
        var deferred = $q.defer();
        callDBFunction(db, 'values', store, undefined, 99999999).then(function(entries) {
            for (var i = 0; i < entries.length; i++) {
                callback(entries[i]);
            }
            deferred.resolve();
        }, deferred.reject);
        return deferred.promise;
    }
    function doQuery(db, store, where, order, reverse, limit) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer(),
            query;
        try {
            query = db.from(store);
            query = applyWhere(query, where);
            query = applyOrder(query, order, reverse);
            query.list(limit).then(deferred.resolve, deferred.reject);
        } catch(ex) {
            $log.error('Error querying ' + store + ' on ' + db.getName() + '. ' + ex.name + ': ' + ex.message);
            deferred.reject();
        }
        return deferred.promise;
    }
    function doUpdate(db, store, values, where) {
        if (typeof db == 'undefined') {
            return $q.reject();
        }
        var deferred = $q.defer(),
            query;
        try {
            checkKeyPathIsPresent(db, store, values);
            query = db.from(store);
            query = applyWhere(query, where);
            query.patch(values).then(deferred.resolve, deferred.reject);
        } catch(ex) {
            $log.error('Error updating ' + store + ' on ' + db.getName() + '. ' + ex.name + ': ' + ex.message);
            deferred.reject();
        }
        return deferred.promise;
    }
    self.getDB = function(name, schema, options, forceNew) {
        if (typeof dbInstances[name] === 'undefined' || forceNew) {
            var isSafari = !ionic.Platform.isIOS() && !ionic.Platform.isAndroid() && navigator.userAgent.indexOf('Safari') != -1 &&
                            navigator.userAgent.indexOf('Chrome') == -1 && navigator.userAgent.indexOf('Firefox') == -1;
            if (typeof IDBObjectStore == 'undefined' || typeof IDBObjectStore.prototype.count == 'undefined' || isSafari) {
                if (typeof options.mechanisms == 'undefined') {
                    options.mechanisms = ['websql', 'sqlite', 'localstorage', 'sessionstorage', 'userdata', 'memory'];
                } else {
                    var position = options.mechanisms.indexOf('indexeddb');
                    if (position != -1) {
                        options.mechanisms.splice(position, 1);
                    }
                }
            }
            var db = new ydn.db.Storage(name, schema, options);
            dbInstances[name] = {
                getName: function() {
                    return db.getName();
                },
                get: function(store, id) {
                    return callDBFunction(db, 'get', store, id);
                },
                getAll: function(store) {
                    return callDBFunction(db, 'values', store, undefined, 99999999);
                },
                count: function(store, where) {
                    return callCount(db, store, where);
                },
                insert: function(store, value, id) {
                    try {
                        checkKeyPathIsPresent(db, store, value);
                        return callDBFunction(db, 'put', store, value, id);
                    } catch(ex) {
                        $log.error('Error executing function put to DB ' + db.getName());
                        $log.error(ex.name + ': ' + ex.message);
                    }
                    return false;
                },
                insertSync: function(store, value) {
                    if (db) {
                        try {
                            checkKeyPathIsPresent(db, store, value);
                            db.put(store, value);
                            return true;
                        } catch(ex) {
                            $log.error('Error executing function sync put to DB ' + db.getName());
                            $log.error(ex.name + ': ' + ex.message);
                        }
                    }
                    return false;
                },
                query: function(store, where, order, reverse, limit) {
                    return doQuery(db, store, where, order, reverse, limit);
                },
                remove: function(store, id) {
                    return callDBFunction(db, 'remove', store, id);
                },
                removeAll: function(store) {
                    return callDBFunction(db, 'clear', store);
                },
                update: function(store, values, where) {
                    return doUpdate(db, store, values, where);
                },
                where: function(store, field_name, op, value, op2, value2) {
                    return callWhere(db, store, field_name, op, value, op2, value2);
                },
                whereEqual: function(store, field_name, value) {
                    return callWhereEqual(db, store, field_name, value);
                },
                each: function(store, callback) {
                    return callEach(db, store, callback);
                },
                close: function() {
                    db.close();
                    db = undefined;
                },
                onReady: function(cb) {
                    db.onReady(cb);
                },
                getType: function() {
                    return db.getType();
                }
            };
        }
        return dbInstances[name];
    };
    self.deleteDB = function(name) {
        var deferred = $q.defer();
        function deleteDB() {
            var type = dbInstances[name].getType();
            $q.when(ydn.db.deleteDatabase(name, type).then(function() {
                delete dbInstances[name];
                deferred.resolve();
            }, deferred.reject));
        }
        if (typeof dbInstances[name] != 'undefined') {
            dbInstances[name].onReady(deleteDB);
        } else {
            deleteDB();
        }
        return deferred.promise;
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmCoreEventKeyboardShow', 'keyboard_show')
.constant('mmCoreEventKeyboardHide', 'keyboard_hide')
.constant('mmCoreEventSessionExpired', 'session_expired')
.constant('mmCoreEventPasswordChangeForced', 'password_change_forced')
.constant('mmCoreEventUserNotFullySetup', 'user_not_fully_setup')
.constant('mmCoreEventSitePolicyNotAgreed', 'site_policy_not_agreed')
.constant('mmCoreEventLogin', 'login')
.constant('mmCoreEventLogout', 'logout')
.constant('mmCoreEventLanguageChanged', 'language_changed')
.constant('mmCoreEventNotificationSoundChanged', 'notification_sound_changed')
.constant('mmCoreEventSiteAdded', 'site_added')
.constant('mmCoreEventSiteUpdated', 'site_updated')
.constant('mmCoreEventSiteDeleted', 'site_deleted')
.constant('mmCoreEventQueueEmpty', 'filepool_queue_empty')
.constant('mmCoreEventCompletionModuleViewed', 'completion_module_viewed')
.constant('mmCoreEventUserDeleted', 'user_deleted')
.constant('mmCoreEventPackageStatusChanged', 'filepool_package_status_changed')
.constant('mmCoreEventCourseStatusChanged', 'course_status_changed')
.constant('mmCoreEventSectionStatusChanged', 'section_status_changed')
.constant('mmCoreEventRemoteAddonsLoaded', 'remote_addons_loaded')
.constant('mmCoreEventOnline', 'online') 
.constant('mmCoreEventOnlineStatusChanged', 'online_status_changed')
.factory('$mmEvents', ["$log", "md5", function($log, md5) {
    $log = $log.getInstance('$mmEvents');
    var self = {},
        observers = {},
        uniqueEvents = {},
        uniqueEventsData = {};
    self.on = function(eventName, callBack) {
        if (uniqueEvents[eventName]) {
            callBack(uniqueEventsData[eventName]);
            return {
                id: -1,
                off: function() {}
            };
        }
        var observerID;
        if (typeof(observers[eventName]) === 'undefined') {
            observers[eventName] = {};
        }
        while (typeof(observerID) === 'undefined') {
            var candidateID = md5.createHash(Math.random().toString());
            if (typeof(observers[eventName][candidateID]) === 'undefined') {
                observerID = candidateID;
            }
        }
        $log.debug('Observer ' + observerID + ' listening to event '+eventName);
        observers[eventName][observerID] = callBack;
        var observer = {
            id: observerID,
            off: function() {
                $log.debug('Disable observer ' + observerID + ' for event '+eventName);
                delete observers[eventName][observerID];
            }
        };
        return observer;
    };
    self.trigger = function(eventName, data) {
        $log.debug('Event ' + eventName + ' triggered.');
        var affected = observers[eventName];
        for (var observerName in affected) {
            if (typeof(affected[observerName]) === 'function') {
                affected[observerName](data);
            }
        }
    };
    self.triggerUnique = function(eventName, data) {
        if (uniqueEvents[eventName]) {
            $log.debug('Unique event ' + eventName + ' ignored because it was already triggered.');
        } else {
            $log.debug('Unique event ' + eventName + ' triggered.');
            uniqueEvents[eventName] = true;
            uniqueEventsData[eventName] = data;
            var affected = observers[eventName];
            angular.forEach(affected, function(callBack) {
                if (typeof callBack === 'function') {
                    callBack(data);
                }
            });
        }
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmFilepoolQueueProcessInterval', 0)
.constant('mmFilepoolFolder', 'filepool')
.constant('mmFilepoolStore', 'filepool')
.constant('mmFilepoolQueueStore', 'files_queue')
.constant('mmFilepoolLinksStore', 'files_links')
.constant('mmFilepoolPackagesStore', 'filepool_packages')
.constant('mmFilepoolWifiDownloadThreshold', 20971520) 
.constant('mmFilepoolDownloadThreshold', 2097152) 
.config(["$mmAppProvider", "$mmSitesFactoryProvider", "mmFilepoolStore", "mmFilepoolLinksStore", "mmFilepoolQueueStore", "mmFilepoolPackagesStore", function($mmAppProvider, $mmSitesFactoryProvider, mmFilepoolStore, mmFilepoolLinksStore, mmFilepoolQueueStore,
            mmFilepoolPackagesStore) {
    var siteStores = [
        {
            name: mmFilepoolStore,
            keyPath: 'fileId',
            indexes: []
        },
        {
            name: mmFilepoolLinksStore,
            keyPath: ['fileId', 'component', 'componentId'],
            indexes: [
                {
                    name: 'fileId',
                },
                {
                    name: 'component',
                },
                {
                    name: 'componentAndId',
                    keyPath: ['component', 'componentId']
                }
            ]
        },
        {
            name: mmFilepoolPackagesStore,
            keyPath: 'id',
            indexes: [
                {
                    name: 'component',
                },
                {
                    name: 'componentId',
                },
                {
                    name: 'status',
                }
            ]
        }
    ];
    var appStores = [
        {
            name: mmFilepoolQueueStore,
            keyPath: ['siteId', 'fileId'],
            indexes: [
                {
                    name: 'siteId',
                },
                {
                    name: 'sortorder',
                    generator: function(obj) {
                        var sortorder = parseInt(obj.added, 10),
                            priority = 999 - Math.max(0, Math.min(parseInt(obj.priority || 0, 10), 999)),
                            padding = "000";
                        sortorder = "" + sortorder;
                        priority = "" + priority;
                        priority = padding.substring(0, padding.length - priority.length) + priority;
                        sortorder = priority + '-' + sortorder;
                        return sortorder;
                    }
                }
            ]
        }
    ];
    $mmAppProvider.registerStores(appStores);
    $mmSitesFactoryProvider.registerStores(siteStores);
}])
.factory('$mmFilepool', ["$q", "$log", "$timeout", "$mmApp", "$mmFS", "$mmWS", "$mmSitesManager", "$mmEvents", "md5", "mmFilepoolStore", "mmFilepoolLinksStore", "mmFilepoolQueueStore", "mmFilepoolFolder", "mmFilepoolQueueProcessInterval", "mmCoreEventQueueEmpty", "mmCoreDownloaded", "mmCoreDownloading", "mmCoreNotDownloaded", "mmCoreOutdated", "mmCoreNotDownloadable", "mmFilepoolPackagesStore", "mmCoreEventPackageStatusChanged", "$mmText", "$mmUtil", "mmFilepoolWifiDownloadThreshold", "mmFilepoolDownloadThreshold", "$mmPluginFileDelegate", function($q, $log, $timeout, $mmApp, $mmFS, $mmWS, $mmSitesManager, $mmEvents, md5, mmFilepoolStore,
        mmFilepoolLinksStore, mmFilepoolQueueStore, mmFilepoolFolder, mmFilepoolQueueProcessInterval, mmCoreEventQueueEmpty,
        mmCoreDownloaded, mmCoreDownloading, mmCoreNotDownloaded, mmCoreOutdated, mmCoreNotDownloadable, mmFilepoolPackagesStore,
        mmCoreEventPackageStatusChanged, $mmText, $mmUtil, mmFilepoolWifiDownloadThreshold, mmFilepoolDownloadThreshold,
        $mmPluginFileDelegate) {
    $log = $log.getInstance('$mmFilepool');
    var self = {},
        tokenRegex = new RegExp('(\\?|&)token=([A-Za-z0-9]+)'),
        queueState,
        urlAttributes = [
            tokenRegex,
            new RegExp('(\\?|&)forcedownload=[0-1]'),
            new RegExp('(\\?|&)preview=[A-Za-z0-9]+'),
            new RegExp('(\\?|&)offline=[0-1]', 'g')
        ],
        queueDeferreds = {}, 
        packagesPromises = {}, 
        filePromises = {}, 
        sizeCache = {}; 
    var QUEUE_RUNNING = 'mmFilepool:QUEUE_RUNNING',
        QUEUE_PAUSED = 'mmFilepool:QUEUE_PAUSED';
    var ERR_QUEUE_IS_EMPTY = 'mmFilepoolError:ERR_QUEUE_IS_EMPTY',
        ERR_FS_OR_NETWORK_UNAVAILABLE = 'mmFilepoolError:ERR_FS_OR_NETWORK_UNAVAILABLE',
        ERR_QUEUE_ON_PAUSE = 'mmFilepoolError:ERR_QUEUE_ON_PAUSE';
    self.FILEDOWNLOADED = 'downloaded';
    self.FILEDOWNLOADING = 'downloading';
    self.FILENOTDOWNLOADED = 'notdownloaded';
    self.FILEOUTDATED = 'outdated';
    function getSiteDb(siteId) {
        return $mmSitesManager.getSiteDb(siteId);
    }
    self._addFileLink = function(siteId, fileId, component, componentId) {
        if (!component) {
            return $q.reject();
        }
        componentId = self._fixComponentId(componentId);
        return getSiteDb(siteId).then(function(db) {
            return db.insert(mmFilepoolLinksStore, {
                fileId: fileId,
                component: component,
                componentId: componentId
            });
        });
    };
    self.addFileLinkByUrl = function(siteId, fileUrl, component, componentId) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            var fileId = self._getFileIdByUrl(fileUrl);
            return self._addFileLink(siteId, fileId, component, componentId);
        });
    };
    self._addFileLinks = function(siteId, fileId, links) {
        var promises = [];
        angular.forEach(links, function(link) {
            promises.push(self._addFileLink(siteId, fileId, link.component, link.componentId));
        });
        return $q.all(promises);
    };
    self._addFileToPool = function(siteId, fileId, data) {
        var values = angular.copy(data) || {};
        values.fileId = fileId;
        return getSiteDb(siteId).then(function(db) {
            return db.insert(mmFilepoolStore, values);
        });
    };
    self.addFilesToQueueByUrl = function(siteId, files, component, componentId) {
        return self.downloadOrPrefetchFiles(siteId, files, true, false, component, componentId);
    };
    self.addToQueueByUrl = function(siteId, fileUrl, component, componentId, timemodified, filePath, priority, options) {
        options = options || {};
        var db = $mmApp.getDB(),
            fileId,
            now = new Date(),
            link,
            revision,
            queueDeferred;
        if (!$mmFS.isAvailable()) {
            return $q.reject();
        }
        return $mmSitesManager.getSite(siteId).then(function(site) {
            if (!site.canDownloadFiles()) {
                return $q.reject();
            }
            return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
                timemodified = timemodified || 0;
                revision = self.getRevisionFromUrl(fileUrl);
                fileId = self._getFileIdByUrl(fileUrl);
                priority = priority || 0;
                if (typeof component !== 'undefined') {
                    link = {
                        component: component,
                        componentId: self._fixComponentId(componentId)
                    };
                }
                queueDeferred = self._getQueueDeferred(siteId, fileId, false);
                return db.get(mmFilepoolQueueStore, [siteId, fileId]).then(function(fileObject) {
                    var foundLink = false,
                        update = false;
                    if (fileObject) {
                        if (fileObject.priority < priority) {
                            update = true;
                            fileObject.priority = priority;
                        }
                        if (revision && fileObject.revision !== revision) {
                            update = true;
                            fileObject.revision = revision;
                        }
                        if (timemodified && fileObject.timemodified !== timemodified) {
                            update = true;
                            fileObject.timemodified = timemodified;
                        }
                        if (filePath && fileObject.path !== filePath) {
                            update = true;
                            fileObject.path = filePath;
                        }
                        if (fileObject.isexternalfile !== options.isexternalfile) {
                            update = true;
                            fileObject.isexternalfile = options.isexternalfile;
                        }
                        if (fileObject.repositorytype !== options.repositorytype) {
                            update = true;
                            fileObject.repositorytype = options.repositorytype;
                        }
                        if (link) {
                            angular.forEach(fileObject.links, function(fileLink) {
                                if (fileLink.component == link.component && fileLink.componentId == link.componentId) {
                                    foundLink = true;
                                }
                            });
                            if (!foundLink) {
                                update = true;
                                fileObject.links.push(link);
                            }
                        }
                        if (update) {
                            $log.debug('Updating file ' + fileId + ' which is already in queue');
                            return db.insert(mmFilepoolQueueStore, fileObject).then(function() {
                                return self._getQueuePromise(siteId, fileId);
                            });
                        }
                        $log.debug('File ' + fileId + ' already in queue and does not require update');
                        if (queueDeferred) {
                            return queueDeferred.promise;
                        } else {
                            return self._getQueuePromise(siteId, fileId);
                        }
                    } else {
                        return addToQueue();
                    }
                }, function() {
                    return addToQueue();
                });
                function addToQueue() {
                    $log.debug('Adding ' + fileId + ' to the queue');
                    return db.insert(mmFilepoolQueueStore, {
                        siteId: siteId,
                        fileId: fileId,
                        added: now.getTime(),
                        priority: priority,
                        url: fileUrl,
                        revision: revision,
                        timemodified: timemodified,
                        isexternalfile: options.isexternalfile,
                        repositorytype: options.repositorytype,
                        path: filePath,
                        links: link ? [link] : []
                    }).then(function() {
                        self.checkQueueProcessing();
                        self._notifyFileDownloading(siteId, fileId);
                        return self._getQueuePromise(siteId, fileId);
                    });
                }
            });
        });
    };
    self.checkQueueProcessing = function() {
        if (!$mmFS.isAvailable() || !$mmApp.isOnline()) {
            queueState = QUEUE_PAUSED;
            return;
        } else if (queueState === QUEUE_RUNNING) {
            return;
        }
        queueState = QUEUE_RUNNING;
        self._processQueue();
    };
    self.clearAllPackagesStatus = function(siteId) {
        var promises = [];
        $log.debug('Clear all packages status for site ' + siteId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb();
            return db.getAll(mmFilepoolPackagesStore).then(function(entries) {
                angular.forEach(entries, function(entry) {
                    promises.push(db.remove(mmFilepoolPackagesStore, entry.id).then(function() {
                        self._triggerPackageStatusChanged(siteId, entry.component, entry.componentId, mmCoreNotDownloaded);
                    }));
                });
                return $q.all(promises);
            });
        });
    };
    self.clearFilepool = function(siteId) {
        return getSiteDb(siteId).then(function(db) {
            return db.removeAll(mmFilepoolStore);
        });
    };
    self.componentHasFiles = function(siteId, component, componentId) {
        return getSiteDb(siteId).then(function(db) {
            var where;
            if (typeof componentId !== 'undefined') {
                where = ['componentAndId', '=', [component, self._fixComponentId(componentId)]];
            } else {
                where = ['component', '=', component];
            }
            return db.count(mmFilepoolLinksStore, where).then(function(count) {
                if (count > 0) {
                    return true;
                }
                return $q.reject();
            });
        });
    };
    self.determinePackagesStatus = function(current, packagestatus) {
        if (!current) {
            current = mmCoreNotDownloadable;
        }
        if (packagestatus === mmCoreNotDownloaded) {
            return mmCoreNotDownloaded;
        } else if (packagestatus === mmCoreDownloaded && current === mmCoreNotDownloadable) {
            return mmCoreDownloaded;
        } else if (packagestatus === mmCoreDownloading && (current === mmCoreNotDownloadable || current === mmCoreDownloaded)) {
            return mmCoreDownloading;
        } else if (packagestatus === mmCoreOutdated && current !== mmCoreNotDownloaded) {
            return mmCoreOutdated;
        }
        return current;
    };
    self.downloadOrPrefetchFiles = function(siteId, files, prefetch, ignoreStale, component, componentId) {
        var promises = [];
        angular.forEach(files, function(file) {
            var url = file.url || file.fileurl,
                timemodified = file.timemodified,
                options = {
                    isexternalfile: file.isexternalfile,
                    repositorytype: file.repositorytype
                };
            if (prefetch) {
                promises.push(self.addToQueueByUrl(siteId, url, component, componentId, timemodified, undefined, 0, options));
            } else {
                promises.push(self.downloadUrl(siteId, url, ignoreStale, component, componentId, timemodified, undefined, options));
            }
        });
        return $mmUtil.allPromises(promises);
    };
    self._downloadOrPrefetchPackage = function(siteId, fileList, prefetch, component, componentId, revision, timemod, dirPath) {
        var packageId = self.getPackageId(component, componentId);
        if (packagesPromises[siteId] && packagesPromises[siteId][packageId]) {
            return packagesPromises[siteId][packageId];
        } else if (!packagesPromises[siteId]) {
            packagesPromises[siteId] = {};
        }
        revision = revision || self.getRevisionFromFileList(fileList);
        timemod = timemod || self.getTimemodifiedFromFileList(fileList);
        var dwnPromise,
            deleted = false;
        dwnPromise = self.storePackageStatus(siteId, component, componentId, mmCoreDownloading).then(function() {
            var promises = [],
                deferred = $q.defer(),
                packageLoaded = 0; 
            angular.forEach(fileList, function(file) {
                var path,
                    promise,
                    fileLoaded = 0,
                    fileUrl = file.url || file.fileurl,
                    options = {
                        isexternalfile: file.isexternalfile,
                        repositorytype: file.repositorytype
                    };
                if (dirPath) {
                    path = file.filename;
                    if (file.filepath !== '/') {
                        path = file.filepath.substr(1) + path;
                    }
                    path = $mmFS.concatenatePaths(dirPath, path);
                }
                if (prefetch) {
                    promise = self.addToQueueByUrl(siteId, fileUrl, component, componentId, file.timemodified, path, options);
                } else {
                    promise = self.downloadUrl(siteId, fileUrl, false, component, componentId, file.timemodified, path, options);
                }
                promises.push(promise.then(undefined, undefined, function(progress) {
                    if (progress && progress.loaded) {
                        packageLoaded = packageLoaded + (progress.loaded - fileLoaded);
                        fileLoaded = progress.loaded;
                        deferred.notify({
                            packageDownload: true,
                            loaded: packageLoaded,
                            fileProgress: progress
                        });
                    }
                }));
            });
            $q.all(promises).then(function() {
                return self.storePackageStatus(siteId, component, componentId, mmCoreDownloaded, revision, timemod);
            }).catch(function() {
                return self.setPackagePreviousStatus(siteId, component, componentId).then(function() {
                    return $q.reject();
                });
            }).then(deferred.resolve, deferred.reject);
            return deferred.promise;
        }).finally(function() {
            delete packagesPromises[siteId][packageId];
            deleted = true;
        });
        if (!deleted) { 
            packagesPromises[siteId][packageId] = dwnPromise;
        }
        return dwnPromise;
    };
    self.downloadPackage = function(siteId, fileList, component, componentId, revision, timemodified, dirPath) {
        return self._downloadOrPrefetchPackage(siteId, fileList, false, component, componentId, revision, timemodified, dirPath);
    };
    self.downloadUrl = function(siteId, fileUrl, ignoreStale, component, componentId, timemodified, filePath, options) {
        options = options || {};
        var fileId,
            promise;
        if ($mmFS.isAvailable()) {
            return self._fixPluginfileURL(siteId, fileUrl).then(function(fixedUrl) {
                fileUrl = fixedUrl;
                options.timemodified = timemodified || 0;
                options.revision = self.getRevisionFromUrl(fileUrl);
                fileId = self._getFileIdByUrl(fileUrl);
                return self._hasFileInPool(siteId, fileId).then(function(fileObject) {
                    if (typeof fileObject === 'undefined') {
                        self._notifyFileDownloading(siteId, fileId);
                        return self._downloadForPoolByUrl(siteId, fileUrl, options, filePath);
                    } else if (self._isFileOutdated(fileObject, options.revision, options.timemodified) &&
                                $mmApp.isOnline() && !ignoreStale) {
                        self._notifyFileDownloading(siteId, fileId);
                        return self._downloadForPoolByUrl(siteId, fileUrl, options, filePath, fileObject);
                    }
                    if (filePath) {
                        promise = self._getInternalUrlByPath(filePath);
                    } else {
                        promise = self._getInternalUrlById(siteId, fileId);
                    }
                    return promise.then(function(response) {
                        return response;
                    }, function() {
                        self._notifyFileDownloading(siteId, fileId);
                        return self._downloadForPoolByUrl(siteId, fileUrl, options, filePath, fileObject);
                    });
                }, function() {
                    self._notifyFileDownloading(siteId, fileId);
                    return self._downloadForPoolByUrl(siteId, fileUrl, options, filePath);
                })
                .then(function(response) {
                    if (typeof component !== 'undefined') {
                        self._addFileLink(siteId, fileId, component, componentId);
                    }
                    self._notifyFileDownloaded(siteId, fileId);
                    return response;
                }, function(err) {
                    self._notifyFileDownloadError(siteId, fileId);
                    return $q.reject(err);
                });
            });
        } else {
            return $q.reject();
        }
    };
    self._downloadForPoolByUrl = function(siteId, fileUrl, options, filePath, poolFileObject) {
        options = options || {};
        var fileId = self._getFileIdByUrl(fileUrl),
            extension = $mmFS.guessExtensionFromUrl(fileUrl),
            addExtension = typeof filePath == "undefined",
            pathPromise = filePath ? filePath : self._getFilePath(siteId, fileId, extension);
        return $q.when(pathPromise).then(function(filePath) {
            if (poolFileObject && poolFileObject.fileId !== fileId) {
                $log.error('Invalid object to update passed');
                return $q.reject();
            }
            var downloadId = self.getFileDownloadId(fileUrl, filePath),
                deleted = false,
                promise;
            if (filePromises[siteId] && filePromises[siteId][downloadId]) {
                return filePromises[siteId][downloadId];
            } else if (!filePromises[siteId]) {
                filePromises[siteId] = {};
            }
            promise = $mmSitesManager.getSite(siteId).then(function(site) {
                if (!site.canDownloadFiles()) {
                    return $q.reject();
                }
                return $mmWS.downloadFile(fileUrl, filePath, addExtension).then(function(fileEntry) {
                    var now = new Date(),
                        data = poolFileObject || {};
                    data.downloaded = now.getTime();
                    data.stale = false;
                    data.url = fileUrl;
                    data.revision = options.revision;
                    data.timemodified = options.timemodified;
                    data.isexternalfile = options.isexternalfile;
                    data.repositorytype = options.repositorytype;
                    data.path = fileEntry.path;
                    data.extension = fileEntry.extension;
                    return self._addFileToPool(siteId, fileId, data).then(function() {
                        return fileEntry.toURL();
                    });
                });
            }).finally(function() {
                delete filePromises[siteId][downloadId];
                deleted = true;
            });
            if (!deleted) { 
                filePromises[siteId][downloadId] = promise;
            }
            return promise;
        });
    };
    self._fixComponentId = function(componentId) {
        var id = parseInt(componentId, 10);
        if (isNaN(id)) {
            if (typeof componentId == 'undefined' || componentId === null) {
                return -1;
            } else {
                return componentId;
            }
        }
        return id;
    };
    self._fixPluginfileURL = function(siteId, fileUrl) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.fixPluginfileURL(fileUrl);
        });
    };
    self._getFileLinks = function(siteId, fileId) {
        return getSiteDb(siteId).then(function(db) {
            return db.whereEqual(mmFilepoolLinksStore, 'fileId', fileId);
        });
    };
    self.getFileDownloadId = function(fileUrl, filePath) {
        return md5.createHash(fileUrl + '###' + filePath);
    };
    self._getFileEventName = function(siteId, fileId) {
        return 'mmFilepoolFile:'+siteId+':'+fileId;
    };
    self.getFileEventNameByUrl = function(siteId, fileUrl) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            var fileId = self._getFileIdByUrl(fileUrl);
            return self._getFileEventName(siteId, fileId);
        });
    };
    self.getPackageDownloadPromise = function(siteId, component, componentId) {
        var packageId = self.getPackageId(component, componentId);
        if (packagesPromises[siteId] && packagesPromises[siteId][packageId]) {
            return packagesPromises[siteId][packageId];
        }
    };
    self.getPackageId = function(component, componentId) {
        return md5.createHash(component + '#' + self._fixComponentId(componentId));
    };
    self.getPackageData = function(siteId, component, componentId) {
        componentId = self._fixComponentId(componentId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                packageId = self.getPackageId(component, componentId);
            return db.get(mmFilepoolPackagesStore, packageId).then(function(entry) {
                if (!entry) {
                    return $q.reject();
                }
                return entry;
            });
        });
    };
    self.getPackagePreviousStatus = function(siteId, component, componentId) {
        return self.getPackageData(siteId, component, componentId).then(function(entry) {
            return entry.previous || mmCoreNotDownloaded;
        }).catch(function() {
            return mmCoreNotDownloaded;
        });
    };
    self.getPackageCurrentStatus = function(siteId, component, componentId) {
        return self.getPackageData(siteId, component, componentId).then(function(entry) {
            return entry.status || mmCoreNotDownloaded;
        }).catch(function() {
            return mmCoreNotDownloaded;
        });
    };
    self.getPackageStatus = function(siteId, component, componentId, revision, timemodified) {
        revision = revision || 0;
        timemodified = timemodified || 0;
        componentId = self._fixComponentId(componentId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                packageId = self.getPackageId(component, componentId);
            return db.get(mmFilepoolPackagesStore, packageId).then(function(entry) {
                if (entry.status === mmCoreDownloaded) {
                    if (revision != entry.revision || timemodified > entry.timemodified) {
                        entry.status = mmCoreOutdated;
                        entry.updated = new Date().getTime();
                        db.insert(mmFilepoolPackagesStore, entry).then(function() {
                            self._triggerPackageStatusChanged(siteId, component, componentId, mmCoreOutdated);
                        });
                    }
                } else if (entry.status === mmCoreOutdated) {
                    if (revision === entry.revision && timemodified === entry.timemodified) {
                        entry.status = mmCoreDownloaded;
                        entry.updated = new Date().getTime();
                        db.insert(mmFilepoolPackagesStore, entry).then(function() {
                            self._triggerPackageStatusChanged(siteId, component, componentId, mmCoreDownloaded);
                        });
                    }
                }
                return entry.status;
            }, function() {
                return mmCoreNotDownloaded;
            });
        });
    };
    self.getPackageRevision = function(siteId, component, componentId) {
        return self.getPackageData(siteId, component, componentId).then(function(entry) {
            return entry.revision;
        });
    };
    self.getPackageTimemodified = function(siteId, component, componentId) {
        return self.getPackageData(siteId, component, componentId).then(function(entry) {
            return entry.timemodified;
        }).catch(function() {
            return -1;
        });
    };
    self._getQueueDeferred = function(siteId, fileId, create) {
        if (typeof create == 'undefined') {
            create = true;
        }
        if (!queueDeferreds[siteId]) {
            if (!create) {
                return;
            }
            queueDeferreds[siteId] = {};
        }
        if (!queueDeferreds[siteId][fileId]) {
            if (!create) {
                return;
            }
            queueDeferreds[siteId][fileId] = $q.defer();
        }
        return queueDeferreds[siteId][fileId];
    };
    self._getQueuePromise = function(siteId, fileId, create) {
        return self._getQueueDeferred(siteId, fileId, create).promise;
    };
    self._hasFileInPool = function(siteId, fileId) {
        return getSiteDb(siteId).then(function(db) {
            return db.get(mmFilepoolStore, fileId).then(function(fileObject) {
                if (typeof fileObject === 'undefined') {
                    return $q.reject();
                }
                return fileObject;
            });
        });
    };
    self._hasFileInQueue = function(siteId, fileId) {
        return $mmApp.getDB().get(mmFilepoolQueueStore, [siteId, fileId]).then(function(fileObject) {
            if (typeof fileObject === 'undefined') {
                return $q.reject();
            }
            return fileObject;
        });
    };
    self.getDirectoryUrlByUrl = function(siteId, fileUrl) {
        if ($mmFS.isAvailable()) {
            return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
                var fileId = self._getFileIdByUrl(fileUrl);
                return $mmFS.getDir(self._getFilePath(siteId, fileId, false)).then(function(dirEntry) {
                    return dirEntry.toURL();
                });
            });
        }
        return $q.reject();
    };
    self._getFileIdByUrl = function(fileUrl) {
        var url = self._removeRevisionFromUrl(fileUrl),
            filename;
        url = $mmText.decodeHTML($mmText.decodeURIComponent(url));
        if (url.indexOf('/webservice/pluginfile') !== -1) {
            angular.forEach(urlAttributes, function(regex) {
                url = url.replace(regex, '');
            });
        }
        filename = self._guessFilenameFromUrl(url);
        return filename + '_' + md5.createHash('url:' + url);
    };
    self._getNonReadableFileIdByUrl = function(fileUrl) {
        var url = self._removeRevisionFromUrl(fileUrl),
            candidate,
            extension = '';
        if (url.indexOf('/webservice/pluginfile') !== -1) {
            angular.forEach(urlAttributes, function(regex) {
                url = url.replace(regex, '');
            });
            candidate = $mmFS.guessExtensionFromUrl(url);
            if (candidate && candidate !== 'php') {
                extension = '.' + candidate;
            }
        }
        return md5.createHash('url:' + url) + extension;
    };
    self._getFileUrlByUrl = function(siteId, fileUrl, mode, component, componentId, timemodified, checkSize, downloadUnknown,
                options) {
        options = options || {};
        var fileId,
            revision;
        if (typeof checkSize == 'undefined') {
            checkSize = true;
        }
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fixedUrl) {
            fileUrl = fixedUrl;
            timemodified = timemodified || 0;
            revision = self.getRevisionFromUrl(fileUrl);
            fileId = self._getFileIdByUrl(fileUrl);
            return self._hasFileInPool(siteId, fileId).then(function(fileObject) {
                var response,
                    fn;
                if (typeof fileObject === 'undefined') {
                    addToQueueIfNeeded();
                    response = fileUrl;
                } else if (self._isFileOutdated(fileObject, revision, timemodified) && $mmApp.isOnline()) {
                    addToQueueIfNeeded();
                    response = fileUrl;
                } else {
                    if (mode === 'src') {
                        fn = self._getInternalSrcById;
                    } else {
                        fn = self._getInternalUrlById;
                    }
                    response = fn(siteId, fileId).then(function(internalUrl) {
                        return internalUrl;
                    }, function() {
                        $log.debug('File ' + fileId + ' not found on disk');
                        self._removeFileById(siteId, fileId);
                        addToQueueIfNeeded();
                        if ($mmApp.isOnline()) {
                            return fileUrl;
                        }
                        return $q.reject();
                    });
                }
                return response;
            }, function() {
                addToQueueIfNeeded();
                return fileUrl;
            });
        });
        function addToQueueIfNeeded() {
            var promise;
            if (checkSize) {
                if (!$mmApp.isOnline()) {
                    return;
                }
                if (typeof sizeCache[fileUrl] != 'undefined') {
                    promise = $q.when(sizeCache[fileUrl]);
                } else {
                    promise = $mmWS.getRemoteFileSize(fileUrl);
                }
                promise.then(function(size) {
                    var isWifi = !$mmApp.isNetworkAccessLimited(),
                        sizeUnknown = size <= 0;
                    if (!sizeUnknown) {
                        sizeCache[fileUrl] = size;
                    }
                    if (sizeUnknown) {
                        if (downloadUnknown && isWifi) {
                            self.addToQueueByUrl(siteId, fileUrl, component, componentId, timemodified, undefined, 0, options);
                        }
                    } else if (size <= mmFilepoolDownloadThreshold || (isWifi && size <= mmFilepoolWifiDownloadThreshold)) {
                        self.addToQueueByUrl(siteId, fileUrl, component, componentId, timemodified, undefined, 0, options);
                    }
                });
            } else {
                self.addToQueueByUrl(siteId, fileUrl, component, componentId, timemodified, undefined, 0, options);
            }
        }
    };
    self.getFilepoolFolderPath = function(siteId) {
        return $mmFS.getSiteFolder(siteId) + '/' + mmFilepoolFolder;
    };
    self._getFilePath = function(siteId, fileId, extension) {
        var path = $mmFS.getSiteFolder(siteId) + '/' + mmFilepoolFolder + '/' + fileId;
        if (typeof extension == 'undefined') {
            return self._hasFileInPool(siteId, fileId).then(function(fileObject) {
                if (fileObject.extension) {
                    path += '.' + fileObject.extension;
                }
                return path;
            }).catch(function() {
                return path;
            });
        } else {
            if (extension) {
                path += '.' + extension;
            }
            return path;
        }
    };
    self.getFilePathByUrl = function(siteId, fileUrl) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            var fileId = self._getFileIdByUrl(fileUrl);
            return self._getFilePath(siteId, fileId);
        });
    };
    function getComponentFiles(db, component, componentId) {
        var fieldName, where;
        if (typeof componentId !== 'undefined') {
            fieldName = 'componentAndId';
            where = [component, self._fixComponentId(componentId)];
        } else {
            fieldName = 'component';
            where = component;
        }
        return db.whereEqual(mmFilepoolLinksStore, fieldName, where);
    }
    self.getFilesByComponent = function(siteId, component, componentId) {
        return getSiteDb(siteId).then(function(db) {
            return getComponentFiles(db, component, componentId).then(function(items) {
                var promises = [],
                    files = [];
                angular.forEach(items, function(item) {
                    promises.push(db.get(mmFilepoolStore, item.fileId).then(function(fileEntry) {
                        if (!fileEntry) {
                            return;
                        }
                        files.push({
                            url: fileEntry.url,
                            path: fileEntry.path,
                            extension: fileEntry.extension,
                            revision: fileEntry.revision,
                            timemodified: fileEntry.timemodified
                        });
                    }));
                });
                return $q.all(promises).then(function() {
                    return files;
                });
            });
        });
    };
    self.getFilesSizeByComponent = function(siteId, component, componentId) {
        return self.getFilesByComponent(siteId, component, componentId).then(function(files) {
            var promises = [],
                size = 0;
            angular.forEach(files, function(file) {
                promises.push($mmFS.getFileSize(file.path).then(function(fs) {
                    size += fs;
                }).catch(function() {
                }));
            });
            return $q.all(promises).then(function() {
                return size;
            });
        });
    };
    self.getFileStateByUrl = function(siteId, fileUrl, timemodified, filePath) {
        var fileId,
            revision;
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fixedUrl) {
            fileUrl = fixedUrl;
            timemodified = timemodified || 0;
            revision = self.getRevisionFromUrl(fileUrl);
            fileId = self._getFileIdByUrl(fileUrl);
            return self._hasFileInQueue(siteId, fileId).then(function() {
                return mmCoreDownloading;
            }, function() {
                var extension = $mmFS.guessExtensionFromUrl(fileUrl),
                    pathPromise = filePath ? filePath : self._getFilePath(siteId, fileId, extension);
                return $q.when(pathPromise).then(function(filePath) {
                    var downloadId = self.getFileDownloadId(fileUrl, filePath);
                    if (filePromises[siteId] && filePromises[siteId][downloadId]) {
                        return mmCoreDownloading;
                    }
                    return self._hasFileInPool(siteId, fileId).then(function(fileObject) {
                        if (self._isFileOutdated(fileObject, revision, timemodified)) {
                            return mmCoreOutdated;
                        } else {
                            return mmCoreDownloaded;
                        }
                    }, function() {
                        return mmCoreNotDownloaded;
                    });
                });
            });
        });
    };
    self._getInternalSrcById = function(siteId, fileId) {
        if ($mmFS.isAvailable()) {
            return self._getFilePath(siteId, fileId).then(function(path) {
                return $mmFS.getFile(path).then(function(fileEntry) {
                    return $mmFS.getInternalURL(fileEntry);
                });
            });
        }
        return $q.reject();
    };
    self._getInternalUrlById = function(siteId, fileId) {
        if ($mmFS.isAvailable()) {
            return self._getFilePath(siteId, fileId).then(function(path) {
                return $mmFS.getFile(path).then(function(fileEntry) {
                    return fileEntry.toURL();
                });
            });
        }
        return $q.reject();
    };
    self._getInternalUrlByPath = function(filePath) {
        if ($mmFS.isAvailable()) {
            return $mmFS.getFile(filePath).then(function(fileEntry) {
                return fileEntry.toURL();
            });
        }
        return $q.reject();
    };
    self.getInternalUrlByUrl = function(siteId, fileUrl) {
        if ($mmFS.isAvailable()) {
            return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
                var fileId = self._getFileIdByUrl(fileUrl);
                return self._getInternalUrlById(siteId, fileId);
            });
        }
        return $q.reject();
    };
    self.getPackageDirPathByUrl = function(siteId, url) {
        return self._fixPluginfileURL(siteId, url).then(function(fixedUrl) {
            var fileId = self._getNonReadableFileIdByUrl(fixedUrl);
            return self._getFilePath(siteId, fileId, false);
        });
    };
    self.getPackageDirUrlByUrl = function(siteId, url) {
        if ($mmFS.isAvailable()) {
            return self._fixPluginfileURL(siteId, url).then(function(fixedUrl) {
                var fileId = self._getNonReadableFileIdByUrl(fixedUrl);
                return $mmFS.getDir(self._getFilePath(siteId, fileId, false)).then(function(dirEntry) {
                    return dirEntry.toURL();
                });
            });
        }
        return $q.reject();
    };
    self.getRevisionFromFileList = function(files) {
        var revision = 0;
        angular.forEach(files, function(file) {
            if (file.url || file.fileurl) {
                var r = self.getRevisionFromUrl(file.url || file.fileurl);
                if (r > revision) {
                    revision = r;
                }
            }
        });
        return revision;
    };
    self.getRevisionFromUrl = function(url) {
        var args = getPluginFileArgs(url);
        if (!args) {
            return 0;
        }
        var revisionRegex = $mmPluginFileDelegate.getComponentRevisionRegExp(args);
        if (!revisionRegex) {
            return 0;
        }
        var matches = url.match(revisionRegex);
        if (matches && typeof matches[1] != 'undefined') {
            return parseInt(matches[1]);
        }
    };
    self.getSrcByUrl = function(siteId, fileUrl, component, componentId, timemodified, checkSize, downloadUnknown, options) {
        return self._getFileUrlByUrl(siteId, fileUrl, 'src', component, componentId,
                timemodified, checkSize, downloadUnknown, options);
    };
    self.getTimemodifiedFromFileList = function(files) {
        var timemod = 0;
        angular.forEach(files, function(file) {
            if (file.timemodified > timemod) {
                timemod = file.timemodified;
            }
        });
        return timemod;
    };
    self.getUrlByUrl = function(siteId, fileUrl, component, componentId, timemodified, checkSize, downloadUnknown, options) {
        return self._getFileUrlByUrl(siteId, fileUrl, 'url', component, componentId,
                timemodified, checkSize, downloadUnknown, options);
    };
    self._guessFilenameFromUrl = function(fileUrl) {
        var filename = '';
        if (fileUrl.indexOf('/webservice/pluginfile') !== -1) {
            var params = $mmUtil.extractUrlParams(fileUrl);
            if (params.file) {
                filename = params.file.substr(params.file.lastIndexOf('/') + 1);
            } else {
                filename = $mmText.getLastFileWithoutParams(fileUrl);
            }
        } else if ($mmUtil.isGravatarUrl(fileUrl)) {
            filename = 'gravatar_' + $mmText.getLastFileWithoutParams(fileUrl);
        } else if ($mmUtil.isThemeImageUrl(fileUrl)) {
            var matches = fileUrl.match(/clean\/core\/([^\/]*)\//);
            if (matches && matches[1]) {
                filename = matches[1];
            }
            filename = 'default_' + filename + '_' + $mmText.getLastFileWithoutParams(fileUrl);
        } else {
            filename = $mmText.getLastFileWithoutParams(fileUrl);
        }
        filename = $mmFS.removeExtension(filename);
        return $mmText.removeSpecialCharactersForFiles(filename);
    };
    self.invalidateAllFiles = function(siteId, onlyUnknown) {
        if (typeof onlyUnknown == 'undefined') {
            onlyUnknown = true;
        }
        return getSiteDb(siteId).then(function(db) {
            return db.getAll(mmFilepoolStore).then(function(items) {
                var promises = [];
                angular.forEach(items, function(item) {
                    if (onlyUnknown && !isFileUpdateUnknown(item)) {
                        return;
                    }
                    item.stale = true;
                    promises.push(db.insert(mmFilepoolStore, item));
                });
                return $q.all(promises);
            });
        });
    };
    self.invalidateFileByUrl = function(siteId, fileUrl) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            var fileId = self._getFileIdByUrl(fileUrl);
            return getSiteDb(siteId).then(function(db) {
                return db.get(mmFilepoolStore, fileId).then(function(fileObject) {
                    if (!fileObject) {
                        return;
                    }
                    fileObject.stale = true;
                    return db.insert(mmFilepoolStore, fileObject);
                });
            });
        });
    };
    self.invalidateFilesByComponent = function(siteId, component, componentId, onlyUnknown) {
        if (typeof onlyUnknown == 'undefined') {
            onlyUnknown = true;
        }
        return getSiteDb(siteId).then(function(db) {
            return getComponentFiles(db, component, componentId).then(function(items) {
                var promise,
                    promises = [];
                angular.forEach(items, function(item) {
                    promise = db.get(mmFilepoolStore, item.fileId).then(function(fileEntry) {
                        if (!fileEntry) {
                            return;
                        }
                        if (onlyUnknown && !isFileUpdateUnknown(fileEntry)) {
                            return;
                        }
                        fileEntry.stale = true;
                        return db.insert(mmFilepoolStore, fileEntry);
                    });
                    promises.push(promise);
                });
                return $q.all(promises);
            });
        });
    };
    self.isFileDownloadingByUrl = function(siteId, fileUrl) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            fileId = self._getFileIdByUrl(fileUrl);
            return self._hasFileInQueue(siteId, fileId);
        });
    };
    self._isFileOutdated = function(fileObject, revision, timemodified) {
        return fileObject.stale || revision > fileObject.revision || timemodified > fileObject.timemodified;
    };
    function isFileUpdateUnknown(entry) {
        return entry.isexternalfile || (!entry.revision && !entry.timemodified);
    }
    self._notifyFileDeleted = function(siteId, fileId) {
        $mmEvents.trigger(self._getFileEventName(siteId, fileId), {action: 'deleted'});
    };
    self._notifyFileDownloaded = function(siteId, fileId) {
        $mmEvents.trigger(self._getFileEventName(siteId, fileId), {action: 'download', success: true});
    };
    self._notifyFileDownloadError = function(siteId, fileId) {
        $mmEvents.trigger(self._getFileEventName(siteId, fileId), {action: 'download', success: false});
    };
    self._notifyFileDownloading = function(siteId, fileId) {
        $mmEvents.trigger(self._getFileEventName(siteId, fileId), {action: 'downloading'});
    };
    self._notifyFileOutdated = function(siteId, fileId) {
        $mmEvents.trigger(self._getFileEventName(siteId, fileId), {action: 'outdated'});
    };
    self.prefetchPackage = function(siteId, fileList, component, componentId, revision, timemodified, dirPath) {
        return self._downloadOrPrefetchPackage(siteId, fileList, true, component, componentId, revision, timemodified, dirPath);
    };
    self._processQueue = function() {
        var deferred = $q.defer(),
            promise;
        if (queueState !== QUEUE_RUNNING) {
            deferred.reject(ERR_QUEUE_ON_PAUSE);
            promise = deferred.promise;
        } else if (!$mmFS.isAvailable() || !$mmApp.isOnline()) {
            deferred.reject(ERR_FS_OR_NETWORK_UNAVAILABLE);
            promise = deferred.promise;
        } else {
            promise = self._processImportantQueueItem();
        }
        promise.then(function() {
            $timeout(self._processQueue, mmFilepoolQueueProcessInterval);
        }, function(error) {
            if (error === ERR_FS_OR_NETWORK_UNAVAILABLE) {
                $log.debug('Filesysem or network unavailable, pausing queue processing.');
            } else if (error === ERR_QUEUE_IS_EMPTY) {
                $log.debug('Queue is empty, pausing queue processing.');
                $mmEvents.trigger(mmCoreEventQueueEmpty);
            }
            queueState = QUEUE_PAUSED;
        });
    };
    self._processImportantQueueItem = function() {
        return $mmApp.getDB().query(mmFilepoolQueueStore, undefined, 'sortorder', undefined, 1)
        .then(function(items) {
            var item = items.pop();
            if (!item) {
                return $q.reject(ERR_QUEUE_IS_EMPTY);
            }
            return self._processQueueItem(item);
        }, function() {
            return $q.reject(ERR_QUEUE_IS_EMPTY);
        });
    };
    self._processQueueItem = function(item) {
        var siteId = item.siteId,
            fileId = item.fileId,
            fileUrl = item.url,
            options = {
                revision: item.revision,
                timemodified: item.timemodified,
                isexternalfile: item.isexternalfile,
                repositorytype: item.repositorytype
            },
            filePath = item.path,
            links = item.links || [];
        $log.debug('Processing queue item: ' + siteId + ', ' + fileId);
        return getSiteDb(siteId).then(function(db) {
            return db.get(mmFilepoolStore, fileId).then(function(fileObject) {
                if (fileObject && !self._isFileOutdated(fileObject, options.revision, options.timemodified)) {
                    $log.debug('Queued file already in store, ignoring...');
                    self._addFileLinks(siteId, fileId, links);
                    self._removeFromQueue(siteId, fileId).finally(function() {
                        self._treatQueueDeferred(siteId, fileId, true);
                    });
                    self._notifyFileDownloaded(siteId, fileId);
                    return;
                }
                return download(siteId, fileUrl, fileObject, links);
            }, function() {
                return download(siteId, fileUrl, undefined, links);
            });
        }, function() {
            $log.debug('Item dropped from queue due to site DB not retrieved: ' + fileUrl);
            return self._removeFromQueue(siteId, fileId).catch(function() {}).finally(function() {
                self._treatQueueDeferred(siteId, fileId, false);
                self._notifyFileDownloadError(siteId, fileId);
            });
        });
        function download(siteId, fileUrl, fileObject, links) {
            return self._downloadForPoolByUrl(siteId, fileUrl, options, filePath, fileObject).then(function() {
                var promise;
                self._addFileLinks(siteId, fileId, links);
                promise = self._removeFromQueue(siteId, fileId);
                self._treatQueueDeferred(siteId, fileId, true);
                self._notifyFileDownloaded(siteId, fileId);
                return promise.catch(function() {});
            }, function(errorObject) {
                var dropFromQueue = false;
                if (typeof errorObject !== 'undefined' && errorObject.source === fileUrl) {
                    if (errorObject.code === 1) { 
                        dropFromQueue = true;
                    } else if (errorObject.code === 2) { 
                        dropFromQueue = true;
                    } else if (errorObject.code === 3) { 
                        dropFromQueue = true;
                    } else if (errorObject.code === 4) { 
                    } else if (errorObject.code === 5) { 
                        dropFromQueue = true;
                    } else {
                        dropFromQueue = true;
                    }
                } else {
                    dropFromQueue = true;
                }
                if (dropFromQueue) {
                    var promise;
                    $log.debug('Item dropped from queue due to error: ' + fileUrl);
                    promise = self._removeFromQueue(siteId, fileId);
                    return promise.catch(function() {}).finally(function() {
                        self._treatQueueDeferred(siteId, fileId, false);
                        self._notifyFileDownloadError(siteId, fileId);
                    });
                } else {
                    self._treatQueueDeferred(siteId, fileId, false);
                    self._notifyFileDownloadError(siteId, fileId);
                    return $q.reject();
                }
            }, function(progress) {
                if (queueDeferreds[siteId] && queueDeferreds[siteId][fileId]) {
                    queueDeferreds[siteId][fileId].notify(progress);
                }
            });
        }
    };
    self._removeFromQueue = function(siteId, fileId) {
        return $mmApp.getDB().remove(mmFilepoolQueueStore, [siteId, fileId]);
    };
    self._removeFileById = function(siteId, fileId) {
        return getSiteDb(siteId).then(function(db) {
            return self._getFilePath(siteId, fileId).then(function(path) {
                var promises = [];
                promises.push(db.remove(mmFilepoolStore, fileId));
                promises.push(db.whereEqual(mmFilepoolLinksStore, 'fileId', fileId).then(function(entries) {
                    return $q.all(entries.map(function(entry) {
                        return db.remove(mmFilepoolLinksStore, [entry.fileId, entry.component, entry.componentId]);
                    }));
                }));
                if ($mmFS.isAvailable()) {
                    promises.push($mmFS.removeFile(path).catch(function(error) {
                        if (error && error.code == 1) {
                        } else {
                            return $q.reject(error);
                        }
                    }));
                }
                return $q.all(promises).then(function() {
                    self._notifyFileDeleted(siteId, fileId);
                });
            });
        });
    };
    self.removeFilesByComponent = function(siteId, component, componentId) {
        return getSiteDb(siteId).then(function(db) {
            return getComponentFiles(db, component, componentId);
        }).then(function(items) {
            return $q.all(items.map(function(item) {
                return self._removeFileById(siteId, item.fileId);
            }));
        });
    };
    self.removeFileByUrl = function(siteId, fileUrl) {
        return self._fixPluginfileURL(siteId, fileUrl).then(function(fileUrl) {
            var fileId = self._getFileIdByUrl(fileUrl);
            return self._removeFileById(siteId, fileId);
        });
    };
    self._removeRevisionFromUrl = function(url) {
        var args = getPluginFileArgs(url);
        if (!args) {
            return url;
        }
        return $mmPluginFileDelegate.removeRevisionFromUrl(url, args);
    };
    self._fillExtensionInFile = function(fileObject, siteId) {
        var extension;
        if (typeof fileObject.extension != 'undefined') {
            return;
        }
        return getSiteDb(siteId).then(function(db) {
            extension = $mmFS.getFileExtension(fileObject.path);
            if (!extension) {
                fileObject.stale = true;
                $log.debug('Staled file with no extension ' + fileObject.fileId);
                return db.insert(mmFilepoolStore, fileObject);
            }
            var fileId = fileObject.fileId;
            fileObject.fileId = $mmFS.removeExtension(fileId);
            fileObject.extension = extension;
            return db.insert(mmFilepoolStore, fileObject).then(function() {
                if (fileObject.fileId == fileId) {
                    $log.debug('Removed extesion ' + extension + ' from file ' + fileObject.fileId);
                    return $q.when();
                }
                return db.whereEqual(mmFilepoolLinksStore, 'fileId', fileId).then(function(entries) {
                    return $q.all(entries.map(function(linkEntry) {
                        linkEntry.fileId = fileObject.fileId;
                        return db.insert(mmFilepoolLinksStore, linkEntry).then(function() {
                            $log.debug('Removed extesion ' + extension + ' from file links ' + linkEntry.fileId);
                            return db.remove(mmFilepoolLinksStore, [fileId, linkEntry.component, linkEntry.componentId]);
                        });
                    }));
                }).finally(function() {
                    $log.debug('Removed extesion ' + extension + ' from file ' + fileObject.fileId);
                    return db.remove(mmFilepoolStore, fileId);
                });
            });
        });
    };
    self.fillMissingExtensionInFiles = function(siteId) {
        $log.debug('Fill missing extensions in files of ' + siteId);
        return getSiteDb(siteId).then(function(db) {
            return db.getAll(mmFilepoolStore).then(function(fileObjects) {
                var promises = [];
                angular.forEach(fileObjects, function(fileObject) {
                    promises.push(self._fillExtensionInFile(fileObject, siteId));
                });
                return $q.all(promises);
            });
        });
    };
    self.treatExtensionInQueue = function() {
        var appDB;
        $log.debug('Treat extensions in queue');
        appDB = $mmApp.getDB();
        return appDB.getAll(mmFilepoolQueueStore).then(function(fileObjects) {
            var promises = [];
            angular.forEach(fileObjects, function(fileObject) {
                var fileId = fileObject.fileId;
                fileObject.fileId = $mmFS.removeExtension(fileId);
                if (fileId == fileObject.fileId) {
                    return;
                }
                promises.push(appDB.insert(mmFilepoolQueueStore, fileObject).then(function() {
                    $log.debug('Removed extesion from queued file ' + fileObject.fileId);
                    return self._removeFromQueue(fileObject.siteId, fileId);
                }));
            });
            return $q.all(promises);
        });
    };
    self._restoreOldFileIfNeeded = function(siteId, fileId, fileUrl, filePath) {
        var fileObject,
            oldFileId = self._getNonReadableFileIdByUrl(fileUrl);
        if (fileId == oldFileId) {
            return $q.when();
        }
        return self._hasFileInPool(siteId, fileId).catch(function() {
            return self._hasFileInPool(siteId, oldFileId).then(function(entry) {
                fileObject = entry;
                if (filePath) {
                    return $q.when();
                } else {
                    return self._getFilePath(siteId, oldFileId).then(function(oldPath) {
                        return self._getFilePath(siteId, fileId).then(function(newPath) {
                            return $mmFS.copyFile(oldPath, newPath);
                        });
                    });
                }
            }).then(function() {
                return self._addFileToPool(siteId, fileId, fileObject);
            }).then(function() {
                return self._getFileLinks(siteId, fileId).then(function(links) {
                    var promises = [];
                    angular.forEach(links, function(link) {
                        promises.push(self._addFileLink(siteId, fileId, link.component, link.componentId));
                    });
                    return $q.all(promises);
                });
            }).then(function() {
                return self._removeFileById(siteId, oldFileId);
            }).catch(function() {
            });
        });
    };
    self.setPackagePreviousStatus = function(siteId, component, componentId) {
        $log.debug('Set previous status for package ' + component + ' ' + componentId);
        componentId = self._fixComponentId(componentId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                packageId = self.getPackageId(component, componentId);
            return db.get(mmFilepoolPackagesStore, packageId).then(function(entry) {
                if (entry.status == mmCoreDownloading) {
                    entry.downloadtime = entry.previousdownloadtime;
                }
                entry.status = entry.previous || mmCoreNotDownloaded;
                entry.updated = new Date().getTime();
                $log.debug('Set status \'' + entry.status + '\' for package ' + component + ' ' + componentId);
                return db.insert(mmFilepoolPackagesStore, entry).then(function() {
                    self._triggerPackageStatusChanged(siteId, component, componentId, entry.status);
                    return entry.status;
                });
            });
        });
    };
    self.shouldDownloadBeforeOpen = function(url, size) {
        if (size >= 0 && size <= mmFilepoolDownloadThreshold) {
            return $q.when();
        }
        if ($mmApp.isDesktop()) {
            return $q.when();
        }
        return $mmUtil.getMimeTypeFromUrl(url).then(function(mimetype) {
            if (mimetype.indexOf('video') != -1 || mimetype.indexOf('audio') != -1) {
                return $q.reject();
            }
        });
    };
    self.storePackageStatus = function(siteId, component, componentId, status, revision, timemodified) {
        $log.debug('Set status \'' + status + '\' for package ' + component + ' ' + componentId);
        componentId = self._fixComponentId(componentId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                packageId = self.getPackageId(component, componentId),
                downloadTime,
                previousDownloadTime;
            if (status == mmCoreDownloading) {
                downloadTime = $mmUtil.timestamp();
            }
            return db.get(mmFilepoolPackagesStore, packageId).then(function(entry) {
                if (typeof revision == 'undefined') {
                    revision = entry.revision;
                }
                if (typeof timemodified == 'undefined') {
                    timemodified = entry.timemodified;
                }
                if (typeof downloadTime == 'undefined') {
                    downloadTime = entry.downloadtime;
                    previousDownloadTime = entry.previousdownloadtime;
                } else {
                    previousDownloadTime = entry.downloadTime;
                }
                return entry.status;
            }).catch(function() {
                return undefined; 
            }).then(function(previousStatus) {
                revision = revision || 0;
                timemodified = timemodified || 0;
                var promise;
                if (previousStatus === status) {
                    promise = $q.when();
                } else {
                    promise = db.insert(mmFilepoolPackagesStore, {
                        id: packageId,
                        component: component,
                        componentId: componentId,
                        status: status,
                        previous: previousStatus,
                        revision: revision,
                        timemodified: timemodified,
                        updated: new Date().getTime(),
                        downloadtime: downloadTime,
                        previousdownloadtime: previousDownloadTime
                    });
                }
                return promise.then(function() {
                    self._triggerPackageStatusChanged(siteId, component, componentId, status);
                });
            });
        });
    };
    self._treatQueueDeferred = function(siteId, fileId, resolve) {
        if (queueDeferreds[siteId] && queueDeferreds[siteId][fileId]) {
            if (resolve) {
                queueDeferreds[siteId][fileId].resolve();
            } else {
                queueDeferreds[siteId][fileId].reject();
            }
            delete queueDeferreds[siteId][fileId];
        }
    };
    self._triggerPackageStatusChanged = function(siteId, component, componentId, status) {
        var data = {
            siteid: siteId,
            component: component,
            componentId: self._fixComponentId(componentId),
            status: status
        };
        $mmEvents.trigger(mmCoreEventPackageStatusChanged, data);
    };
    self.updatePackageDownloadTime = function(siteId, component, componentId) {
        componentId = self._fixComponentId(componentId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                packageId = self.getPackageId(component, componentId);
            return db.get(mmFilepoolPackagesStore, packageId).then(function(entry) {
                entry.downloadtime = $mmUtil.timestamp();
                return db.insert(mmFilepoolPackagesStore, entry);
            });
        });
    };
    function getPluginFileArgs(url) {
        if (!$mmUtil.isPluginFileUrl(url)) {
            return false;
        }
        var relativePath = url.substr(url.indexOf('/pluginfile.php') + 16),
            args = relativePath.split('/');
        if (args.length < 3) {
            return false;
        }
        return args;
    }
    return self;
}])
.run(["$ionicPlatform", "$timeout", "$mmFilepool", "$mmEvents", "mmCoreEventOnlineStatusChanged", function($ionicPlatform, $timeout, $mmFilepool, $mmEvents, mmCoreEventOnlineStatusChanged) {
    $ionicPlatform.ready(function() {
        $timeout($mmFilepool.checkQueueProcessing, 1000);
        $mmEvents.on(mmCoreEventOnlineStatusChanged, function(online) {
            if (online) {
                $mmFilepool.checkQueueProcessing();
            }
        });
    });
}]);

angular.module('mm.core')
.factory('$mmFileSession', ["$mmSite", function($mmSite) {
    var self = {},
        files = {};
    function initFileArea(component, id, siteId) {
        if (!files[siteId]) {
            files[siteId] = {};
        }
        if (!files[siteId][component]) {
            files[siteId][component] = {};
        }
        if (!files[siteId][component][id]) {
            files[siteId][component][id] = [];
        }
    }
    self.addFile = function(component, id, file, siteId) {
        siteId = siteId || $mmSite.getId();
        initFileArea(component, id, siteId);
        files[siteId][component][id].push(file);
    };
    self.clearFiles = function(component, id, siteId) {
        siteId = siteId || $mmSite.getId();
        if (files[siteId] && files[siteId][component] && files[siteId][component][id]) {
            files[siteId][component][id] = [];
        }
    };
    self.getFiles = function(component, id, siteId) {
        siteId = siteId || $mmSite.getId();
        if (files[siteId] && files[siteId][component] && files[siteId][component][id]) {
            return files[siteId][component][id];
        }
        return [];
    };
    self.removeFile = function(component, id, file, siteId) {
        siteId = siteId || $mmSite.getId();
        if (files[siteId] && files[siteId][component] && files[siteId][component][id]) {
            var position = files[siteId][component][id].indexOf(file);
            if (position != -1) {
                files[siteId][component][id].splice(position, 1);
            }
        }
    };
    self.removeFileByIndex = function(component, id, index, siteId) {
        siteId = siteId || $mmSite.getId();
        if (files[siteId] && files[siteId][component] && files[siteId][component][id] && index >= 0 &&
                index < files[siteId][component][id].length) {
            files[siteId][component][id].splice(index, 1);
        }
    };
    self.setFiles = function(component, id, newFiles, siteId) {
        siteId = siteId || $mmSite.getId();
        initFileArea(component, id, siteId);
        files[siteId][component][id] = newFiles;
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmFsSitesFolder', 'sites')
.constant('mmFsTmpFolder', 'tmp')
.factory('$mmFS', ["$ionicPlatform", "$cordovaFile", "$log", "$q", "$http", "$cordovaZip", "$mmText", "mmFsSitesFolder", "mmFsTmpFolder", "$mmApp", "$translate", function($ionicPlatform, $cordovaFile, $log, $q, $http, $cordovaZip, $mmText, mmFsSitesFolder, mmFsTmpFolder,
        $mmApp, $translate) {
    $log = $log.getInstance('$mmFS');
    var self = {},
        initialized = false,
        basePath = '',
        isHTMLAPI = false,
        extToMime = {},
        mimeToExt = {},
        groupsMimeInfo = {},
        extensionRegex = new RegExp('^[a-z0-9]+$');
    $http.get('core/assets/mimetypes.json').then(function(response) {
        extToMime = response.data;
    }, function() {
    });
    $http.get('core/assets/mimetoext.json').then(function(response) {
        mimeToExt = response.data;
    }, function() {
    });
    self.FORMATTEXT         = 0;
    self.FORMATDATAURL      = 1;
    self.FORMATBINARYSTRING = 2;
    self.FORMATARRAYBUFFER  = 3;
    self.setHTMLBasePath = function(path) {
        isHTMLAPI = true;
        basePath = path;
    };
    self.usesHTMLAPI = function() {
        return isHTMLAPI;
    };
    self.init = function() {
        var deferred = $q.defer();
        if (initialized) {
            deferred.resolve();
            return deferred.promise;
        }
        $ionicPlatform.ready(function() {
            if (ionic.Platform.isAndroid()) {
                basePath = cordova.file.externalApplicationStorageDirectory;
            } else if (ionic.Platform.isIOS()) {
                basePath = cordova.file.documentsDirectory;
            } else if (!self.isAvailable() || basePath === '') {
                $log.error('Error getting device OS.');
                deferred.reject();
                return;
            }
            initialized = true;
            $log.debug('FS initialized: '+basePath);
            deferred.resolve();
        });
        return deferred.promise;
    };
    self.isAvailable = function() {
        return typeof window.resolveLocalFileSystemURL !== 'undefined' && typeof FileTransfer !== 'undefined';
    };
    self.getFile = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.init().then(function() {
            $log.debug('Get file: ' + path);
            return $cordovaFile.checkFile(basePath, path);
        });
    };
    self.getDir = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.init().then(function() {
            $log.debug('Get directory: '+path);
            return $cordovaFile.checkDir(basePath, path);
        });
    };
    self.getSiteFolder = function(siteId) {
        return mmFsSitesFolder + '/' + siteId;
    };
    function create(isDirectory, path, failIfExists, base) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.init().then(function() {
            base = base || basePath;
            if (path.indexOf('/') == -1) {
                if (isDirectory) {
                    $log.debug('Create dir ' + path + ' in ' + base);
                    return $cordovaFile.createDir(base, path, !failIfExists);
                } else {
                    $log.debug('Create file ' + path + ' in ' + base);
                    return $cordovaFile.createFile(base, path, !failIfExists);
                }
            } else {
                var firstDir = path.substr(0, path.indexOf('/'));
                var restOfPath = path.substr(path.indexOf('/') + 1);
                $log.debug('Create dir ' + firstDir + ' in ' + base);
                return $cordovaFile.createDir(base, firstDir, true).then(function(newDirEntry) {
                    return create(isDirectory, restOfPath, failIfExists, newDirEntry.toURL());
                }, function(error) {
                    $log.error('Error creating directory ' + firstDir + ' in ' + base);
                    return $q.reject(error);
                });
            }
        });
    }
    self.createDir = function(path, failIfExists) {
        failIfExists = failIfExists || false; 
        return create(true, path, failIfExists);
    };
    self.createFile = function(path, failIfExists) {
        failIfExists = failIfExists || false; 
        return create(false, path, failIfExists);
    };
    self.removeDir = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.init().then(function() {
            $log.debug('Remove directory: ' + path);
            return $cordovaFile.removeRecursively(basePath, path);
        });
    };
    self.removeFile = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.init().then(function() {
            $log.debug('Remove file: ' + path);
            return $cordovaFile.removeFile(basePath, path);
        });
    };
    self.removeFileByFileEntry = function(fileEntry) {
        var deferred = $q.defer();
        fileEntry.remove(deferred.resolve, deferred.reject);
        return deferred.promise;
    };
    self.getDirectoryContents = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        $log.debug('Get contents of dir: ' + path);
        return self.getDir(path).then(function(dirEntry) {
            var deferred = $q.defer();
            var directoryReader = dirEntry.createReader();
            directoryReader.readEntries(deferred.resolve, deferred.reject);
            return deferred.promise;
        });
    };
    function getSize(entry) {
        var deferred = $q.defer();
        if (entry.isDirectory) {
            var directoryReader = entry.createReader();
            directoryReader.readEntries(function(entries) {
                var promises = [];
                for (var i = 0; i < entries.length; i++) {
                    promises.push(getSize(entries[i]));
                }
                $q.all(promises).then(function(sizes) {
                    var directorySize = 0;
                    for (var i = 0; i < sizes.length; i++) {
                        var fileSize = parseInt(sizes[i]);
                        if (isNaN(fileSize)) {
                            deferred.reject();
                            return;
                        }
                        directorySize += fileSize;
                    }
                    deferred.resolve(directorySize);
                }, deferred.reject);
            }, deferred.reject);
        } else if (entry.isFile) {
            entry.file(function(file) {
                deferred.resolve(file.size);
            }, deferred.reject);
        }
        return deferred.promise;
    }
    self.getDirectorySize = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        $log.debug('Get size of dir: ' + path);
        return self.getDir(path).then(function(dirEntry) {
           return getSize(dirEntry);
        });
    };
    self.getFileSize = function(path) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        $log.debug('Get size of file: ' + path);
        return self.getFile(path).then(function(fileEntry) {
           return getSize(fileEntry);
        });
    };
    self.getFileObjectFromFileEntry = function(entry) {
        $log.debug('Get file object of: ' + entry.fullPath);
        var deferred = $q.defer();
        entry.file(function(file) {
            deferred.resolve(file);
        }, deferred.reject);
        return deferred.promise;
    };
    self.calculateFreeSpace = function() {
        if (ionic.Platform.isIOS() || isHTMLAPI) {
            if (window.requestFileSystem) {
                var iterations = 0,
                    maxIterations = 50,
                    deferred = $q.defer();
                function calculateByRequest(size, ratio) {
                    var deferred = $q.defer();
                    window.requestFileSystem(LocalFileSystem.PERSISTENT, size, function() {
                        iterations++;
                        if (iterations > maxIterations) {
                            deferred.resolve(size);
                            return;
                        }
                        calculateByRequest(size * ratio, ratio).then(deferred.resolve);
                    }, function() {
                        deferred.resolve(size / ratio);
                    });
                    return deferred.promise;
                }
                calculateByRequest(1048576, 1.3).then(function(size) {
                    iterations = 0;
                    maxIterations = 10;
                    calculateByRequest(size, 1.1).then(deferred.resolve);
                });
                return deferred.promise;
            } else {
                return $q.reject();
            }
        } else {
            return $cordovaFile.getFreeDiskSpace().then(function(size) {
                return size * 1024; 
            });
        }
    };
    self.normalizeFileName = function(filename) {
        filename = $mmText.decodeURIComponent(filename);
        return filename;
    };
    self.readFile = function(path, format) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        format = format || self.FORMATTEXT;
        $log.debug('Read file ' + path + ' with format '+format);
        switch (format) {
            case self.FORMATDATAURL:
                return $cordovaFile.readAsDataURL(basePath, path);
            case self.FORMATBINARYSTRING:
                return $cordovaFile.readAsBinaryString(basePath, path);
            case self.FORMATARRAYBUFFER:
                return $cordovaFile.readAsArrayBuffer(basePath, path);
            default:
                return $cordovaFile.readAsText(basePath, path);
        }
    };
    self.readFileData = function(fileData, format) {
        format = format || self.FORMATTEXT;
        $log.debug('Read file from file data with format '+format);
        var deferred = $q.defer();
        var reader = new FileReader();
        reader.onloadend = function(evt) {
            if (evt.target.result !== undefined || evt.target.result !== null) {
                deferred.resolve(evt.target.result);
            } else if (evt.target.error !== undefined || evt.target.error !== null) {
                deferred.reject(evt.target.error);
            } else {
                deferred.reject({code: null, message: 'READER_ONLOADEND_ERR'});
            }
        };
        switch (format) {
            case self.FORMATDATAURL:
                reader.readAsDataURL(fileData);
                break;
            case self.FORMATBINARYSTRING:
                reader.readAsBinaryString(fileData);
                break;
            case self.FORMATARRAYBUFFER:
                reader.readAsArrayBuffer(fileData);
                break;
            default:
                reader.readAsText(fileData);
        }
        return deferred.promise;
    };
    self.writeFile = function(path, data) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        $log.debug('Write file: ' + path);
        return self.init().then(function() {
            return self.createFile(path).then(function(fileEntry) {
                if (isHTMLAPI && !$mmApp.isDesktop() && (typeof data == 'string' || data.toString() == '[object ArrayBuffer]')) {
                    var type = self.getMimeType(self.getFileExtension(path));
                    data = new Blob([data], {type: type || 'text/plain'});
                }
                return $cordovaFile.writeFile(basePath, path, data, true).then(function() {
                    return fileEntry;
                });
            });
        });
    };
    self.getExternalFile = function(fullPath) {
        return $cordovaFile.checkFile(fullPath, '');
    };
    self.removeExternalFile = function(fullPath) {
        var directory = fullPath.substring(0, fullPath.lastIndexOf('/') );
        var filename = fullPath.substr(fullPath.lastIndexOf('/') + 1);
        return $cordovaFile.removeFile(directory, filename);
    };
    self.getBasePath = function() {
        return self.init().then(function() {
            if (basePath.slice(-1) == '/') {
                return basePath;
            } else {
                return basePath + '/';
            }
        });
    };
    self.getBasePathToDownload = function() {
        return self.init().then(function() {
            if (ionic.Platform.isIOS()) {
                return $cordovaFile.checkDir(basePath, '').then(function(dirEntry) {
                    return dirEntry.toInternalURL();
                });
            } else {
                return basePath;
            }
        });
    };
    self.getBasePathInstant = function() {
        if (!basePath) {
            return basePath;
        } else if (basePath.slice(-1) == '/') {
            return basePath;
        } else {
            return basePath + '/';
        }
    };
    self.getTmpFolder = function() {
        return mmFsTmpFolder;
    };
    self.moveFile = function(originalPath, newPath) {
        originalPath = self.removeStartingSlash(originalPath.replace(basePath, ''));
        newPath = self.removeStartingSlash(newPath.replace(basePath, ''));
        return self.init().then(function() {
            if (isHTMLAPI) {
                var commonPath = basePath,
                    dirsA = originalPath.split('/'),
                    dirsB = newPath.split('/');
                for (var i = 0; i < dirsA.length; i++) {
                    var dir = dirsA[i];
                    if (dirsB[i] === dir) {
                        dir = dir + '/';
                        commonPath = self.concatenatePaths(commonPath, dir);
                        originalPath = originalPath.replace(dir, '');
                        newPath = newPath.replace(dir, '');
                    } else {
                        break;
                    }
                }
                return $cordovaFile.moveFile(commonPath, originalPath, commonPath, newPath);
            } else {
                return $cordovaFile.moveFile(basePath, originalPath, basePath, newPath);
            }
        });
    };
    self.copyFile = function(from, to) {
        from = self.removeStartingSlash(from.replace(basePath, ''));
        to = self.removeStartingSlash(to.replace(basePath, ''));
        var fromFileAndDir = self.getFileAndDirectoryFromPath(from),
            toFileAndDir = self.getFileAndDirectoryFromPath(to);
        return self.init().then(function() {
            if (toFileAndDir.directory) {
                return self.createDir(toFileAndDir.directory);
            }
        }).then(function() {
            if (isHTMLAPI) {
                var fromDir = self.concatenatePaths(basePath, fromFileAndDir.directory),
                    toDir = self.concatenatePaths(basePath, toFileAndDir.directory);
                return $cordovaFile.copyFile(fromDir, fromFileAndDir.name, toDir, toFileAndDir.name);
            } else {
                return $cordovaFile.copyFile(basePath, from, basePath, to);
            }
        });
    };
    self.getFileAndDirectoryFromPath = function(path) {
        var file = {
            directory: '',
            name: ''
        };
        file.directory = path.substring(0, path.lastIndexOf('/') );
        file.name = path.substr(path.lastIndexOf('/') + 1);
        return file;
    };
    self.concatenatePaths = function(leftPath, rightPath) {
        if (!leftPath) {
            return rightPath;
        } else if (!rightPath) {
            return leftPath;
        }
        var lastCharLeft = leftPath.slice(-1),
            firstCharRight = rightPath.charAt(0);
        if (lastCharLeft === '/' && firstCharRight === '/') {
            return leftPath + rightPath.substr(1);
        } else if(lastCharLeft !== '/' && firstCharRight !== '/') {
            return leftPath + '/' + rightPath;
        } else {
            return leftPath + rightPath;
        }
    };
    self.getInternalURL = function(fileEntry) {
        if (!fileEntry.toInternalURL) {
            return fileEntry.toURL();
        }
        return fileEntry.toInternalURL();
    };
    self.getFileIcon = function(filename) {
        var ext = self.getFileExtension(filename),
            icon = 'unknown';
        if (ext && extToMime[ext]) {
            if (extToMime[ext].icon) {
                icon = extToMime[ext].icon;
            } else {
                var type = extToMime[ext].type.split('/')[0];
                if (type == 'video' || type == 'text' || type == 'image' || type == 'document' || type == 'audio') {
                    icon = type;
                }
            }
        }
        return 'img/files/' + icon + '-64.png';
    };
    self.getFolderIcon = function() {
        return 'img/files/folder-64.png';
    };
    self.getFileExtension = function(filename) {
        var dot = filename.lastIndexOf("."),
            ext;
        if (dot > -1) {
            ext = filename.substr(dot + 1).toLowerCase();
            ext = self.cleanExtension(ext);
            if (typeof self.getMimeType(ext) == 'undefined') {
                $log.debug('Get file extension: Not valid extension ' + ext);
                return;
            }
        }
        return ext;
    };
    self.getMimeType = function(extension) {
        extension = self.cleanExtension(extension);
        if (extToMime[extension] && extToMime[extension].type) {
            return extToMime[extension].type;
        }
    };
    self.getExtensionType = function(extension) {
        extension = self.cleanExtension(extension);
        if (extToMime[extension] && extToMime[extension].string) {
            return extToMime[extension].string;
        }
    };
    self.getMimetypeType = function(mimetype) {
        mimetype = mimetype.split(';')[0]; 
        var extensions = mimeToExt[mimetype];
        if (!extensions) {
            return;
        }
        for (var i = 0; i < extensions.length; i++) {
            var extension = extensions[i];
            if (extToMime[extension] && extToMime[extension].string) {
                return extToMime[extension].string;
            }
        }
    };
    self.guessExtensionFromUrl = function(fileUrl) {
        var split = fileUrl.split('.'),
            candidate,
            extension,
            position;
        if (split.length > 1) {
            candidate = split.pop().toLowerCase();
            position = candidate.indexOf('?');
            if (position > -1) {
                candidate = candidate.substr(0, position);
            }
            if (extensionRegex.test(candidate)) {
                extension = candidate;
            }
        }
        if (extension && typeof self.getMimeType(extension) == 'undefined') {
            $log.debug('Guess file extension: Not valid extension ' + extension);
            return;
        }
        return extension;
    };
    self.getExtension = function(mimetype, url) {
        mimetype = mimetype || '';
        mimetype = mimetype.split(';')[0]; 
        if (mimetype == 'application/x-forcedownload' || mimetype == 'application/forcedownload') {
            return self.guessExtensionFromUrl(url);
        }
        var extensions = mimeToExt[mimetype];
        if (extensions && extensions.length) {
            if (extensions.length > 1 && url) {
                var candidate = self.guessExtensionFromUrl(url);
                if (extensions.indexOf(candidate) != -1) {
                    return candidate;
                }
            }
            return extensions[0];
        }
        return undefined;
    };
    self.getExtensions = function(mimetype) {
        mimetype = mimetype || '';
        mimetype = mimetype.split(';')[0]; 
        return mimeToExt[mimetype] || [];
    };
    self.removeExtension = function(path) {
        var extension,
            position = path.lastIndexOf('.');
        if (position > -1) {
            extension = path.substr(position + 1);
            if (typeof self.getMimeType(extension) != 'undefined') {
                return path.substr(0, position); 
            }
        }
        return path;
    };
    self.addBasePathIfNeeded = function(path) {
        if (path.indexOf(basePath) > -1) {
            return path;
        } else {
            return self.concatenatePaths(basePath, path);
        }
    };
    self.removeBasePath = function(path) {
        if (path.indexOf(basePath) > -1) {
            return path.replace(basePath, '');
        } else {
            return false;
        }
    };
    self.unzipFile = function(path, destFolder) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        return self.getFile(path).then(function(fileEntry) {
            destFolder = self.addBasePathIfNeeded(destFolder || self.removeExtension(path));
            return $cordovaZip.unzip(fileEntry.toURL(), destFolder);
        });
    };
    self.replaceInFile = function(path, search, newValue) {
        return self.readFile(path).then(function(content) {
            if (typeof content == 'undefined' || content === null || !content.replace) {
                return $q.reject();
            }
            if (content.match(search)) {
                content = content.replace(search, newValue);
                return self.writeFile(path, content);
            }
        });
    };
    self.getMetadata = function(fileEntry) {
        if (!fileEntry || !fileEntry.getMetadata) {
            return $q.reject();
        }
        var deferred = $q.defer();
        fileEntry.getMetadata(deferred.resolve, deferred.reject);
        return deferred.promise;
    };
    self.getMetadataFromPath = function(path, isDir) {
        path = self.removeStartingSlash(path.replace(basePath, ''));
        var fn = isDir ? self.getDir : self.getFile;
        return fn(path).then(function(entry) {
            return self.getMetadata(entry);
        });
    };
    self.removeStartingSlash = function(path) {
        if (path[0] == '/') {
            return path.substr(1);
        }
        return path;
    };
    function copyOrMoveExternalFile(from, to, copy) {
        return self.getExternalFile(from).then(function(fileEntry) {
            var dirAndFile = self.getFileAndDirectoryFromPath(to);
            return self.createDir(dirAndFile.directory).then(function(dirEntry) {
                var deferred = $q.defer();
                if (copy) {
                    fileEntry.copyTo(dirEntry, dirAndFile.name, deferred.resolve, deferred.reject);
                } else {
                    fileEntry.moveTo(dirEntry, dirAndFile.name, deferred.resolve, deferred.reject);
                }
                return deferred.promise;
            });
        });
    }
    self.copyExternalFile = function(from, to) {
        return copyOrMoveExternalFile(from, to, true);
    };
    self.moveExternalFile = function(from, to) {
        return copyOrMoveExternalFile(from, to, false);
    };
    self.getUniqueNameInFolder = function(dirPath, fileName, defaultExt) {
        return self.getDirectoryContents(dirPath).then(function(entries) {
            var files = {},
                fileNameWithoutExtension = self.removeExtension(fileName),
                extension = self.getFileExtension(fileName) || defaultExt,
                newName,
                number = 1;
            fileNameWithoutExtension = $mmText.removeSpecialCharactersForFiles($mmText.decodeURIComponent(fileNameWithoutExtension));
            angular.forEach(entries, function(entry) {
                files[entry.name] = entry;
            });
            if (extension) {
                extension = '.' + extension;
            } else {
                extension = '';
            }
            newName = fileNameWithoutExtension + extension;
            if (typeof files[newName] == 'undefined') {
                return newName;
            } else {
                do {
                    newName = fileNameWithoutExtension + '(' + number + ')' + extension;
                    number++;
                } while (typeof files[newName] != 'undefined');
                return newName;
            }
        }).catch(function() {
            return $mmText.removeSpecialCharactersForFiles($mmText.decodeURIComponent(fileName));
        });
    };
    self.clearTmpFolder = function() {
        return self.removeDir(mmFsTmpFolder);
    };
    self.removeUnusedFiles = function(dirPath, files) {
        return self.getDirectoryContents(dirPath).then(function(contents) {
            if (!contents.length) {
                return;
            }
            var filesMap = {},
                promises = [];
            angular.forEach(files, function(file) {
                if (file.fullPath) {
                    filesMap[file.fullPath] = file;
                }
            });
            angular.forEach(contents, function(file) {
                if (!filesMap[file.fullPath]) {
                    promises.push(self.removeFileByFileEntry(file));
                }
            });
            return $q.all(promises);
        }).catch(function() {
        });
    };
    self.isExtensionInGroup = function(extension, groups) {
        extension = self.cleanExtension(extension);
        if (groups && groups.length && extToMime[extension] && extToMime[extension].groups) {
            for (var i = 0; i < extToMime[extension].groups.length; i++) {
                var group = extToMime[extension].groups[i];
                if (groups.indexOf(group) != -1) {
                    return true;
                }
            }
        }
        return false;
    };
    self.canBeEmbedded = function(extension) {
        return self.isExtensionInGroup(extension, ['web_image', 'web_video', 'web_audio']);
    };
    self.getGroupMimeInfo = function(group, field) {
        if (typeof groupsMimeInfo[group] == 'undefined') {
            fillGroupMimeInfo(group);
        }
        if (field) {
            return groupsMimeInfo[group][field];
        }
        return groupsMimeInfo[group];
    };
    function fillGroupMimeInfo(group) {
        var mimetypes = {}, 
            extensions = []; 
        angular.forEach(extToMime, function(data, extension) {
            if (data.type && data.groups && data.groups.indexOf(group) != -1) {
                mimetypes[data.type] = true;
                extensions.push(extension);
            }
        });
        groupsMimeInfo[group] = {
            mimetypes: Object.keys(mimetypes),
            extensions: extensions
        };
    }
    self.getMimetypeDescription = function(obj, capitalise) {
        var filename = '',
            mimetype = '',
            extension = '',
            langPrefix = 'mm.core.mimetype-';
        if (typeof obj == 'object' && angular.isFunction(obj.file)) {
            filename = obj.name;
        } else if (typeof obj == 'object') {
            filename = obj.filename || '';
            mimetype = obj.mimetype || '';
        } else {
            mimetype = obj;
        }
        if (filename) {
            extension = self.getFileExtension(filename);
            if (!mimetype) {
                mimetype = self.getMimeType(extension);
            }
        }
        if (!mimetype) {
            return '';
        }
        if (!extension) {
            extension = self.getExtension(mimetype);
        }
        var mimetypeStr = self.getMimetypeType(mimetype) || '',
            chunks = mimetype.split('/'),
            attr = {
                mimetype: mimetype,
                ext: extension || '',
                mimetype1: chunks[0],
                mimetype2: chunks[1] || '',
            },
            a = {};
        for (var key in attr) {
            var value = attr[key];
            a[key] = value;
            a[key.toUpperCase()] = value.toUpperCase();
            a[$mmText.ucFirst(key)] = $mmText.ucFirst(value);
        }
        var safeMimetype = mimetype.replace(/\+/g, '_'),
            safeMimetypeStr = mimetypeStr.replace(/\+/g, '_'),
            safeMimetypeTrns = $translate.instant(langPrefix + safeMimetype, {$a: a}),
            safeMimetypeStrTrns = $translate.instant(langPrefix + safeMimetypeStr, {$a: a}),
            defaultTrns = $translate.instant(langPrefix + 'default', {$a: a}),
            result = mimetype;
        if (safeMimetypeTrns != langPrefix + safeMimetype) {
            result = safeMimetypeTrns;
        } else if (safeMimetypeStrTrns != langPrefix + safeMimetypeStr) {
            result = safeMimetypeStrTrns;
        } else if (defaultTrns != langPrefix + 'default') {
            result = defaultTrns;
        }
        if (capitalise) {
            result = $mmText.ucFirst(result);
        }
        return result;
    };
    self.getTranslatedGroupName = function(name) {
        var key = 'mm.core.mimetype-group:' + name,
            translated = $translate.instant(key);
        return translated != key ? translated : name;
    };
    self.cleanExtension = function(extension) {
        if (!extension || typeof extension != 'string') {
            return extension;
        }
        var position = extension.indexOf('?');
        if (position > -1) {
            extension = extension.substr(0, position);
        }
        extension = extension.replace(/_.{32}$/, '');
        if (extension && extension[0] == '.') {
            extension = extension.substr(1);
        }
        return extension;
    };
    return self;
}]);

angular.module('mm.core')
.factory('$mmGroups', ["$log", "$q", "$mmSite", "$mmSitesManager", "$translate", function($log, $q, $mmSite, $mmSitesManager, $translate) {
    $log = $log.getInstance('$mmGroups');
    var self = {};
    self.NOGROUPS       = 0;
    self.SEPARATEGROUPS = 1;
    self.VISIBLEGROUPS  = 2;
    self.canGetActivityGroupMode = function() {
        return $mmSite.wsAvailable('core_group_get_activity_groupmode');
    };
    self.getActivityAllowedGroups = function(cmId, userId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            var params = {
                    cmid: cmId,
                    userid: userId
                },
                preSets = {
                    cacheKey: getActivityAllowedGroupsCacheKey(cmId, userId)
                };
            return site.read('core_group_get_activity_allowed_groups', params, preSets).then(function(response) {
                if (!response || !response.groups) {
                    return $q.reject();
                }
                return response.groups;
            });
        });
    };
    function getActivityAllowedGroupsCacheKey(cmId, userId) {
        return 'mmGroups:allowedgroups:' + cmId + ':' + userId;
    }
    self.getActivityGroupInfo = function(cmId, addAllParts, userId, siteId) {
        if (typeof addAllParts == 'undefined') {
            addAllParts = true;
        }
        var groupInfo = {
            groups: []
        };
        return self.getActivityGroupMode(cmId, siteId).then(function(groupMode) {
            groupInfo.separateGroups = groupMode === self.SEPARATEGROUPS;
            groupInfo.visibleGroups = groupMode === self.VISIBLEGROUPS;
            if (groupInfo.separateGroups || groupInfo.visibleGroups) {
                return self.getActivityAllowedGroups(cmId, userId, siteId);
            }
            return [];
        }).then(function (groups) {
            if (groups.length <= 0) {
                groupInfo.separateGroups = false;
                groupInfo.visibleGroups = false;
            } else {
                if (addAllParts || groupInfo.visibleGroups) {
                    groupInfo.groups = [
                        {'id': 0, 'name': $translate.instant('mm.core.allparticipants')}
                    ];
                }
                groupInfo.groups = groupInfo.groups.concat(groups);
            }
            return groupInfo;
        });
    };
    self.getActivityGroupMode = function(cmId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                    cmid: cmId
                },
                preSets = {
                    cacheKey: getActivityGroupModeCacheKey(cmId)
                };
            return site.read('core_group_get_activity_groupmode', params, preSets).then(function(response) {
                if (!response || typeof response.groupmode == 'undefined') {
                    return $q.reject();
                }
                return response.groupmode;
            });
        });
    };
    self.activityHasGroups = function(cmId, siteId) {
        return self.getActivityGroupMode(cmId, siteId).then(function(groupmode) {
            return groupmode === self.SEPARATEGROUPS || groupmode === self.VISIBLEGROUPS;
        }).catch(function() {
            return false;
        });
    };
    self.getActivityAllowedGroupsIfEnabled = function(cmId, userId, siteId) {
        siteId = siteId || $mmSite.getId();
        return self.activityHasGroups(cmId, siteId).then(function(hasGroups) {
            if (hasGroups) {
                return self.getActivityAllowedGroups(cmId, userId, siteId);
            }
            return [];
        });
    };
    function getActivityGroupModeCacheKey(cmid) {
        return 'mmGroups:groupmode:' + cmid;
    }
    self.getUserGroups = function(courses, refresh, siteid, userid) {
        var promises = [],
            groups = [],
            deferred = $q.defer();
        angular.forEach(courses, function(course) {
            var courseid;
            if (typeof course == 'object') { 
                courseid = course.id;
            } else { 
                courseid = course;
            }
            var promise = self.getUserGroupsInCourse(courseid, refresh, siteid, userid).then(function(coursegroups) {
                groups = groups.concat(coursegroups);
            });
            promises.push(promise);
        });
        $q.all(promises).finally(function() {
            deferred.resolve(groups);
        });
        return deferred.promise;
    };
    self.getUserGroupsInCourse = function(courseid, refresh, siteid, userid) {
        return $mmSitesManager.getSite(siteid).then(function(site) {
            var presets = {},
                data = {
                    userid: userid || site.getUserId(),
                    courseid: courseid
                };
            if (refresh) {
                presets.getFromCache = false;
            }
            return site.read('core_group_get_course_user_groups', data, presets).then(function(response) {
                if (response && response.groups) {
                    return response.groups;
                } else {
                    return $q.reject();
                }
            });
        });
    };
    self.invalidateActivityAllowedGroups = function(cmId, userId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            return site.invalidateWsCacheForKey(getActivityAllowedGroupsCacheKey(cmId, userId));
        });
    };
    self.invalidateActivityGroupMode = function(cmId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getActivityGroupModeCacheKey(cmId));
        });
    };
    self.invalidateActivityGroupInfo = function(cmId, userId, siteId) {
        var promises = [];
        promises.push(self.invalidateActivityAllowedGroups(cmId, userId, siteId));
        promises.push(self.invalidateActivityGroupMode(cmId, siteId));
        return $q.all(promises);
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmInitDelegateDefaultPriority', 100)
.constant('mmInitDelegateMaxAddonPriority', 599)
.provider('$mmInitDelegate', ["mmInitDelegateDefaultPriority", function(mmInitDelegateDefaultPriority) {
    var initProcesses = {},
        self = {};
    self.registerProcess = function(name, callable, priority, blocking) {
        priority = typeof priority === 'undefined' ? mmInitDelegateDefaultPriority : priority;
        if (typeof initProcesses[name] !== 'undefined') {
            console.log('$mmInitDelegateProvider: Process \'' + name + '\' already defined.');
            return;
        }
        console.log('$mmInitDelegateProvider: Registered process \'' + name + '\'.');
        initProcesses[name] = {
            blocking: blocking,
            callable: callable,
            name: name,
            priority: priority
        };
    };
    self.$get = ["$q", "$log", "$injector", "$mmUtil", function($q, $log, $injector, $mmUtil) {
        $log = $log.getInstance('$mmInitDelegate');
        var self = {},
            readiness;
        function prepareProcess(data) {
            var promise,
                fn;
            $log.debug('Executing init process \'' + data.name + '\'');
            try {
                fn = $mmUtil.resolveObject(data.callable);
            } catch (e) {
                $log.error('Could not resolve object of init process \'' + data.name + '\'. ' + e);
                return;
            }
            try {
                promise = fn($injector);
            } catch (e) {
                $log.error('Error while calling the init process \'' + data.name + '\'. ' + e);
                return;
            }
            return promise;
        }
        self.executeInitProcesses = function() {
            var ordered = [];
            if (typeof readiness === 'undefined') {
                readiness = $q.defer();
            }
            angular.forEach(initProcesses, function(data) {
                ordered.push(data);
            });
            ordered.sort(function(a, b) {
                return b.priority - a.priority;
            });
            ordered = ordered.map(function (data) {
                return {
                    func: prepareProcess,
                    params: [data],
                    blocking: !!data.blocking
                };
            });
            $mmUtil.executeOrderedPromises(ordered, true).finally(readiness.resolve);
        };
        self.ready = function() {
            if (typeof readiness === 'undefined') {
                readiness = $q.defer();
            }
            return readiness.promise;
        };
        return self;
    }];
    return self;
}]);

angular.module('mm.core')
.factory('$mmLang', ["$translate", "$translatePartialLoader", "$mmConfig", "$cordovaGlobalization", "$q", "mmCoreConfigConstants", function($translate, $translatePartialLoader, $mmConfig, $cordovaGlobalization, $q, mmCoreConfigConstants) {
    var self = {},
        fallbackLanguage = mmCoreConfigConstants.default_lang || 'en',
        currentLanguage, 
        customStrings = {},
        customStringsRaw;
    self.changeCurrentLanguage = function(language) {
        var promises = [];
        promises.push($translate.use(language));
        promises.push($translate.preferredLanguage(language));
        promises.push($mmConfig.set('current_language', language));
        moment.locale(language);
        currentLanguage = language;
        return $q.all(promises);
    };
    self.clearCustomStrings = function() {
        customStrings = {};
        customStringsRaw = '';
    };
    self.getAllCustomStrings = function() {
        return customStrings;
    };
    self.getCurrentLanguage = function() {
        if (typeof currentLanguage != 'undefined') {
            return $q.when(currentLanguage);
        }
        return $mmConfig.get('current_language').then(function(language) {
            return language;
        }, function() {
            if (mmCoreConfigConstants.forcedefaultlanguage && mmCoreConfigConstants.forcedefaultlanguage !== 'false') {
                return mmCoreConfigConstants.default_lang;
            }
            try {
                return $cordovaGlobalization.getPreferredLanguage().then(function(result) {
                    var language = result.value.toLowerCase();
                    if (language.indexOf('-') > -1) {
                        if (mmCoreConfigConstants.languages && typeof mmCoreConfigConstants.languages[language] == 'undefined') {
                            language = language.substr(0, language.indexOf('-'));
                        }
                    }
                    return language;
                }, function() {
                    return fallbackLanguage;
                });
            } catch(err) {
                return fallbackLanguage;
            }
        }).then(function(language) {
            currentLanguage = language; 
            return language;
        });
    };
    self.getCustomStrings = function(lang) {
        lang = lang || currentLanguage;
        return customStrings[lang];
    };
    self.loadCustomStrings = function(strings) {
        if (strings == customStringsRaw) {
            return;
        }
        self.clearCustomStrings();
        if (!strings || typeof strings != 'string') {
            return;
        }
        var list = strings.split(/(?:\r\n|\r|\n)/);
        angular.forEach(list, function(entry) {
            var values = entry.split('|'),
                lang;
            if (values.length < 3) {
                return;
            }
            lang = values[2];
            if (!customStrings[lang]) {
                customStrings[lang] = {};
            }
            customStrings[lang][values[0]] = values[1];
        });
    };
    self.registerLanguageFolder = function(path) {
        $translatePartialLoader.addPart(path);
        return $translate.refresh();
    };
    self.translateAndReject = function(errorkey, translateParams) {
        return $translate(errorkey, translateParams).then(function(errorMessage) {
            return $q.reject(errorMessage);
        }, function() {
            return $q.reject(errorkey);
        });
    };
    self.translateAndRejectDeferred = function(deferred, errorkey) {
        $translate(errorkey).then(function(errorMessage) {
            deferred.reject(errorMessage);
        }, function() {
            deferred.reject(errorkey);
        });
    };
    return self;
}])
.factory('$mmLangErrorHandler', ["$q", function($q) {
    return function() {
        return $q.when({});
    };
}])
.config(["$translateProvider", "$translatePartialLoaderProvider", "mmCoreConfigConstants", function($translateProvider, $translatePartialLoaderProvider, mmCoreConfigConstants) {
    $translateProvider.useLoader('$translatePartialLoader', {
        urlTemplate: '{part}/{lang}.json',
        loadFailureHandler: '$mmLangErrorHandler'
    });
    $translatePartialLoaderProvider.addPart('build/lang');
    var lang = mmCoreConfigConstants.default_lang || 'en';
    $translateProvider.fallbackLanguage('en'); 
    $translateProvider.preferredLanguage(lang);
}])
.config(["$provide", "$translateProvider", function($provide, $translateProvider) {
    $provide.decorator('$translate', ['$delegate', '$q', '$injector', function($delegate, $q, $injector) {
        var $mmLang; 
        var translationsTable = $translateProvider.translations();
        var newTranslate = function(translationId, interpolateParams, interpolationId, defaultTranslationText, forceLanguage) {
            var originalString = null;
            var value = getCustomString(translationId, forceLanguage);
            if (value !== false) {
                language = forceLanguage || $delegate.preferredLanguage();
                originalString = translationsTable[language][translationId]; 
                translationsTable[language][translationId] = value;
            }
            return $delegate(translationId, interpolateParams, interpolationId, defaultTranslationText, forceLanguage)
            .finally(function() {
                if (originalString) {
                    translationsTable[language][translationId] = originalString;
                }
            });
        };
        newTranslate.instant = function(translationId, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy) {
            var originalString = null;
            var value = getCustomString(translationId, forceLanguage);
            if (value !== false) {
                language = forceLanguage || $delegate.preferredLanguage();
                originalString = translationsTable[language][translationId]; 
                translationsTable[language][translationId] = value;
            }
            translation = $delegate.instant(translationId, interpolateParams, interpolationId, forceLanguage, sanitizeStrategy);
            if (originalString) {
                translationsTable[language][translationId] = originalString;
            }
            return translation;
        };
        for (var name in $delegate) {
            if (name != 'instant') {
                newTranslate[name] = $delegate[name];
            }
        }
        return newTranslate;
        function getCustomString(translationId, forceLanguage) {
            if (!$mmLang) {
                $mmLang = $injector.get('$mmLang');
            }
            var customStrings = $mmLang.getCustomStrings(forceLanguage);
            if (customStrings && typeof customStrings[translationId] != 'undefined') {
                return customStrings[translationId];
            }
            return false;
        }
    }]);
}])
.run(["$ionicPlatform", "$translate", "$mmLang", "$mmSite", "$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", function($ionicPlatform, $translate, $mmLang, $mmSite, $mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated,
            mmCoreEventLogout) {
    $ionicPlatform.ready(function() {
        $mmLang.getCurrentLanguage().then(function(language) {
            $translate.use(language);
            $translate.preferredLanguage(language);
            moment.locale(language);
        });
    });
    $mmEvents.on(mmCoreEventLogin, loadCustomStrings);
    $mmEvents.on(mmCoreEventSiteUpdated, function(siteId) {
        if (siteId == $mmSite.getId()) {
            loadCustomStrings();
        }
    });
    $mmEvents.on(mmCoreEventLogout, function() {
        $mmLang.clearCustomStrings();
    });
    function loadCustomStrings() {
        var customStrings = $mmSite.getStoredConfig('tool_mobile_customlangstrings');
        if (typeof customStrings != 'undefined') {
            $mmLang.loadCustomStrings(customStrings);
        }
    }
}]);
angular.module('mm.core')
.constant('mmCoreNotificationsSitesStore', 'notification_sites')
.constant('mmCoreNotificationsComponentsStore', 'notification_components')
.constant('mmCoreNotificationsTriggeredStore', 'notifications_triggered')
.config(["$mmAppProvider", "mmCoreNotificationsSitesStore", "mmCoreNotificationsComponentsStore", "mmCoreNotificationsTriggeredStore", function($mmAppProvider, mmCoreNotificationsSitesStore, mmCoreNotificationsComponentsStore,
        mmCoreNotificationsTriggeredStore) {
    var stores = [
        {
            name: mmCoreNotificationsSitesStore, 
            keyPath: 'id',
            indexes: [
                {
                    name: 'code',
                }
            ]
        },
        {
            name: mmCoreNotificationsComponentsStore, 
            keyPath: 'id',
            indexes: [
                {
                    name: 'code',
                }
            ]
        },
        {
            name: mmCoreNotificationsTriggeredStore, 
            keyPath: 'id',
            indexes: []
        }
    ];
    $mmAppProvider.registerStores(stores);
}])
.factory('$mmLocalNotifications', ["$log", "$cordovaLocalNotification", "$mmApp", "$q", "$rootScope", "$ionicPopover", "$timeout", "$mmConfig", "mmCoreNotificationsSitesStore", "mmCoreNotificationsComponentsStore", "mmCoreNotificationsTriggeredStore", "mmCoreSettingsNotificationSound", function($log, $cordovaLocalNotification, $mmApp, $q, $rootScope, $ionicPopover, $timeout,
        $mmConfig, mmCoreNotificationsSitesStore, mmCoreNotificationsComponentsStore, mmCoreNotificationsTriggeredStore,
        mmCoreSettingsNotificationSound) {
    $log = $log.getInstance('$mmLocalNotifications');
    var self = {},
        observers = {},
        codes = {}, 
        scope,
        hidePopoverTimeout;
    scope = $rootScope.$new();
    $ionicPopover.fromTemplateUrl('core/templates/notificationpopover.html', {
        scope: scope,
    }).then(function(popover) {
        popover.viewType = 'mm-inappnotif-popover';
        angular.element(popover.el).removeClass('popover-backdrop').addClass('mm-inapp-notification-backdrop');
        scope.popover = popover;
        scope.hide = function() {
            scope.popover.hide();
            $timeout.cancel(hidePopoverTimeout);
        };
    });
    var codeRequestsQueue = {};
    function getCode(store, id) {
        var db = $mmApp.getDB(),
            key = store + '#' + id;
        if (typeof codes[key] != 'undefined') {
            return $q.when(codes[key]);
        }
        return db.get(store, id).then(function(entry) {
            var code = parseInt(entry.code, 10);
            codes[key] = code;
            return code;
        }, function() {
            return db.query(store, undefined, 'code', true).then(function(entries) {
                var newCode = 0;
                if (entries.length > 0) {
                    newCode = parseInt(entries[0].code, 10) + 1;
                }
                return db.insert(store, {id: id, code: newCode}).then(function() {
                    codes[key] = newCode;
                    return newCode;
                });
            });
        });
    }
    function getSiteCode(siteid) {
        return requestCode(mmCoreNotificationsSitesStore, siteid);
    }
    function getComponentCode(component) {
        return requestCode(mmCoreNotificationsComponentsStore, component);
    }
    function getUniqueNotificationId(notificationid, component, siteid) {
        if (!siteid || !component) {
            return $q.reject();
        }
        return getSiteCode(siteid).then(function(sitecode) {
            return getComponentCode(component).then(function(componentcode) {
                return (sitecode * 100000000 + componentcode * 10000000 + parseInt(notificationid, 10)) % 2147483647;
            });
        });
    }
    function processNextRequest() {
        var nextKey = Object.keys(codeRequestsQueue)[0],
            request,
            promise;
        if (typeof nextKey == 'undefined') {
            return;
        }
        request = codeRequestsQueue[nextKey];
        if (angular.isObject(request) && typeof request.store != 'undefined' && typeof request.id != 'undefined') {
            promise = getCode(request.store, request.id).then(function(code) {
                angular.forEach(request.promises, function(p) {
                    p.resolve(code);
                });
            }, function(error) {
                angular.forEach(request.promises, function(p) {
                    p.reject(error);
                });
            });
        } else {
            promise = $q.when();
        }
        promise.finally(function() {
            delete codeRequestsQueue[nextKey];
            processNextRequest();
        });
    }
    function requestCode(store, id) {
        var deferred = $q.defer(),
            key = store+'#'+id,
            isQueueEmpty = Object.keys(codeRequestsQueue).length == 0;
        if (typeof codeRequestsQueue[key] != 'undefined') {
            codeRequestsQueue[key].promises.push(deferred);
        } else {
            codeRequestsQueue[key] = {
                store: store,
                id: id,
                promises: [deferred]
            };
        }
        if (isQueueEmpty) {
            processNextRequest();
        }
        return deferred.promise;
    }
    self.cancel = function(id, component, siteid) {
        return getUniqueNotificationId(id, component, siteid).then(function(uniqueId) {
            return $cordovaLocalNotification.cancel(uniqueId);
        });
    };
    self.cancelSiteNotifications = function(siteid) {
        if (!self.isAvailable()) {
            return $q.when();
        } else if (!siteid) {
            return $q.reject();
        }
        return $cordovaLocalNotification.getAllScheduled().then(function(scheduled) {
            var ids = [];
            angular.forEach(scheduled, function(notif) {
                if (typeof notif.data == 'string') {
                    notif.data = JSON.parse(notif.data);
                }
                if (typeof notif.data == 'object' && notif.data.siteid === siteid) {
                    ids.push(notif.id);
                }
            });
            return $cordovaLocalNotification.cancel(ids);
        });
    };
    self.isAvailable = function() {
        return $mmApp.isDesktop() || !!(window.plugin && window.plugin.notification && window.plugin.notification.local);
    };
    self.isTriggered = function(notification) {
        return $mmApp.getDB().get(mmCoreNotificationsTriggeredStore, notification.id).then(function(stored) {
            var notifTime = notification.at.getTime() / 1000;
            return stored.at === notifTime;
        }, function() {
            return false;
        });
    };
    self.notifyClick = function(data) {
        var component = data.component;
        if (component) {
            var callback = observers[component];
            if (typeof callback == 'function') {
                callback(data);
            }
        }
    };
    self.registerClick = function(component, callback) {
        $log.debug("Register observer '"+component+"' for notification click.");
        observers[component] = callback;
    };
    self.removeTriggered = function(id) {
        return $mmApp.getDB().remove(mmCoreNotificationsTriggeredStore, id);
    };
    self.rescheduleAll = function() {
        return $cordovaLocalNotification.getAllScheduled().then(function(notifications) {
            var promises = [];
            angular.forEach(notifications, function(notification) {
                notification.at = new Date(notification.at * 1000);
                notification.data = notification.data ? JSON.parse(notification.data) : {};
                promises.push(scheduleNotification(notification));
            });
            return $q.all(promises);
        });
    };
    self.schedule = function(notification, component, siteid) {
        return getUniqueNotificationId(notification.id, component, siteid).then(function(uniqueId) {
            notification.id = uniqueId;
            notification.data = notification.data || {};
            notification.data.component = component;
            notification.data.siteid = siteid;
            if (ionic.Platform.isAndroid()) {
                notification.icon = notification.icon || 'res://icon';
                notification.smallIcon = notification.smallIcon || 'res://icon';
                notification.led = notification.led || 'FF9900';
                notification.ledOnTime = notification.ledOnTime || 1000;
                notification.ledOffTime = notification.ledOffTime || 1000;
            }
            return scheduleNotification(notification);
        });
    };
    function scheduleNotification(notification) {
        return self.isTriggered(notification).then(function(triggered) {
            if (!triggered) {
                return $mmConfig.get(mmCoreSettingsNotificationSound, true).then(function(soundEnabled) {
                    if (!soundEnabled) {
                        notification.sound = null;
                    } else {
                        delete notification.sound; 
                    }
                    self.removeTriggered(notification.id);
                    return $cordovaLocalNotification.schedule(notification);
                });
            }
        });
    }
    self.showNotificationPopover = function(notification) {
        if (!scope || !scope.popover) {
            return;
        }
        if (!notification || !notification.title || !notification.text) {
            return;
        }
        var isShown = scope.popover.isShown();
        setData(isShown);
        if (isShown) {
            $timeout.cancel(hidePopoverTimeout);
        } else {
            scope.popover.show(document.querySelector('ion-nav-bar'));
        }
        hidePopoverTimeout = $timeout(function() {
            scope.popover.hide();
        }, 4000);
        function setData(isShown) {
            $timeout(function() {
                if (isShown && scope.title == notification.title) {
                    if (scope.ids.indexOf(notification.id) != -1) {
                        return;
                    }
                    scope.texts.push(notification.text);
                    scope.ids.push(notification.id);
                    if (scope.texts.length > 3) {
                        scope.texts.shift();
                        scope.ids.shift();
                    }
                } else {
                    scope.title = notification.title;
                    scope.texts = [notification.text];
                    scope.ids = [notification.id];
                }
            });
        }
    };
    self.trigger = function(notification) {
        if (ionic.Platform.isIOS() && parseInt(ionic.Platform.version(), 10) >= 10) {
            self.showNotificationPopover(notification);
        }
        var id = parseInt(notification.id, 10);
        if (!isNaN(id)) {
            return $mmApp.getDB().insert(mmCoreNotificationsTriggeredStore, {
                id: id,
                at: parseInt(notification.at, 10)
            });
        } else {
            return $q.reject();
        }
    };
    return self;
}])
.run(["$rootScope", "$log", "$mmLocalNotifications", "$mmEvents", "mmCoreEventSiteDeleted", function($rootScope, $log, $mmLocalNotifications, $mmEvents, mmCoreEventSiteDeleted) {
    $log = $log.getInstance('$mmLocalNotifications');
    $rootScope.$on('$cordovaLocalNotification:trigger', function(e, notification, state) {
        $mmLocalNotifications.trigger(notification);
    });
    $rootScope.$on('$cordovaLocalNotification:click', function(e, notification, state) {
        if (notification && notification.data) {
            $log.debug('Notification clicked: '+notification.data);
            var data = JSON.parse(notification.data);
            $mmLocalNotifications.notifyClick(data);
        }
    });
    $mmEvents.on(mmCoreEventSiteDeleted, function(site) {
        if (site) {
            $mmLocalNotifications.cancelSiteNotifications(site.id);
        }
    });
}]);

angular.module('mm.core')
.constant('mmCoreLogEnabledDefault', false)
.constant('mmCoreLogEnabledConfigName', 'debug_enabled')
.provider('$mmLog', ["mmCoreLogEnabledDefault", function(mmCoreLogEnabledDefault) {
    var isEnabled = mmCoreLogEnabledDefault,
        self = this;
    function prepareLogFn(logFn, className) {
        className = className || '';
        var enhancedLogFn = function() {
            if (isEnabled) {
                var args = Array.prototype.slice.call(arguments),
                    now  = moment().format('l LTS');
                args[0] = now + ' ' + className + ': ' + args[0]; 
                logFn.apply(null, args);
            }
        };
        enhancedLogFn.logs = [];
        return enhancedLogFn;
    }
    self.logDecorator = function($log) {
        var _$log = (function($log) {
            return {
                log   : $log.log,
                info  : $log.info,
                warn  : $log.warn,
                debug : $log.debug,
                error : $log.error
            };
        })($log);
        var getInstance = function(className) {
            return {
                log   : prepareLogFn(_$log.log, className),
                info  : prepareLogFn(_$log.info, className),
                warn  : prepareLogFn(_$log.warn, className),
                debug : prepareLogFn(_$log.debug, className),
                error : prepareLogFn(_$log.error, className)
            };
        };
        $log.log   = prepareLogFn($log.log);
        $log.info  = prepareLogFn($log.info);
        $log.warn  = prepareLogFn($log.warn);
        $log.debug = prepareLogFn($log.debug);
        $log.error = prepareLogFn($log.error);
        $log.getInstance = getInstance;
        return $log;
    };
    this.$get = ["$mmConfig", "mmCoreLogEnabledDefault", "mmCoreLogEnabledConfigName", function($mmConfig, mmCoreLogEnabledDefault, mmCoreLogEnabledConfigName) {
        var self = {};
        self.init = function() {
            $mmConfig.get(mmCoreLogEnabledConfigName).then(function(enabled) {
                isEnabled = enabled;
            }, function() {
                isEnabled = mmCoreLogEnabledDefault;
            });
        }
        self.enabled = function(flag) {
            $mmConfig.set(mmCoreLogEnabledConfigName, flag);
            isEnabled = flag;
        };
        self.isEnabled = function() {
            return isEnabled;
        };
        return self;
    }];
}])
.run(["$mmLog", function($mmLog) {
    $mmLog.init();
}]);

angular.module('mm.core')
.provider('$mmPluginFileDelegate', function() {
    var pluginHandlers = {},
        self = {};
    self.registerHandler = function(addon, component, handler) {
        if (typeof pluginHandlers[component] !== 'undefined') {
            console.log("$mmPluginFileDelegateProvider: Addon '" + pluginHandlers[component].addon + "' already registered as handler for '" + component + "'");
            return false;
        }
        console.log("$mmPluginFileDelegateProvider: Registered addon '" + addon + "' as pluginfile handler.");
        pluginHandlers[component] = {
            addon: addon,
            handler: handler,
            instance: undefined
        };
        return true;
    };
    self.$get = ["$log", "$mmSite", "$mmUtil", "$q", function($log, $mmSite, $mmUtil, $q) {
        var self = {},
            enabledHandlers = {},
            lastUpdateHandlersStart;
        $log = $log.getInstance('$mmPluginFileDelegate');
        function getPluginHandler(pluginType) {
            if (typeof enabledHandlers[pluginType] != 'undefined') {
                return enabledHandlers[pluginType];
            }
        }
        self.getComponentRevisionRegExp = function(args) {
            var handler = getPluginHandler(args[1]);
            if (handler && handler.getComponentRevisionRegExp) {
                return handler.getComponentRevisionRegExp(args);
            }
            return false;
        };
        self.removeRevisionFromUrl = function(url, args) {
            var handler = getPluginHandler(args[1]);
            if (handler && handler.getComponentRevisionRegExp && handler.getComponentRevisionReplace) {
                var revisionRegex = handler.getComponentRevisionRegExp(args);
                if (revisionRegex) {
                    replace = handler.getComponentRevisionReplace(args);
                    return url.replace(revisionRegex, replace);
                }
            }
            return url;
        };
        self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
        self.updateHandler = function(pluginType, handlerInfo, time) {
            var siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            var enabled = $mmSite.isLoggedIn();
            if (self.isLastUpdateCall(time) && $mmSite.getId() === siteId) {
                if (enabled) {
                    enabledHandlers[pluginType] = handlerInfo.instance;
                } else {
                    delete enabledHandlers[pluginType];
                }
            }
        };
        self.updateHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(pluginHandlers, function(handlerInfo, pluginType) {
                promises.push(self.updateHandler(pluginType, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        return self;
    }];
    return self;
})
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventRemoteAddonsLoaded", "$mmPluginFileDelegate", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventRemoteAddonsLoaded, $mmPluginFileDelegate) {
    $mmEvents.on(mmCoreEventLogin, $mmPluginFileDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmPluginFileDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmPluginFileDelegate.updateHandlers);
}]);
angular.module('mm.core')
.factory('$mmSite', ["$mmSitesManager", "$mmSitesFactory", function($mmSitesManager, $mmSitesFactory) {
    var self = {},
        siteMethods = $mmSitesFactory.getSiteMethods();
    angular.forEach(siteMethods, function(method) {
        self[method] = function() {
            var currentSite = $mmSitesManager.getCurrentSite();
            if (typeof currentSite == 'undefined') {
                return undefined;
            } else {
                return currentSite[method].apply(currentSite, arguments);
            }
        };
    });
    self.isLoggedIn = function() {
        var currentSite = $mmSitesManager.getCurrentSite();
        return typeof currentSite != 'undefined' && typeof currentSite.token != 'undefined' && currentSite.token != '';
    };
    return self;
}]);

angular.module('mm.core')
.value('mmCoreWSPrefix', 'local_mobile_')
.constant('mmCoreWSCacheStore', 'wscache')
.config(["$mmSitesFactoryProvider", "mmCoreWSCacheStore", function($mmSitesFactoryProvider, mmCoreWSCacheStore) {
    var stores = [
        {
            name: mmCoreWSCacheStore,
            keyPath: 'id',
            indexes: [
                {
                    name: 'key'
                }
            ]
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.provider('$mmSitesFactory', function() {
    var siteSchema = {
            stores: []
        },
        dboptions = {
            autoSchema: true
        },
        supportWhereEqual;
    this.registerStore = function(store) {
        if (typeof(store.name) === 'undefined') {
            console.error('$mmSite: Error: store name is undefined.');
            return;
        } else if (typeof store.keyPath  === 'undefined' || !store.keyPath) {
            console.error('$mmSite: Error: store ' + store.name + ' keyPath is invalid.');
            return;
        } else if (storeExists(store.name)) {
            console.error('$mmSite: Error: store ' + store.name + ' is already defined.');
            return;
        }
        store.indexes = getIndexes(store.indexes);
        siteSchema.stores.push(store);
    };
    function getIndexes(indexes) {
        if (!isWhereEqualSupported()) {
            var neededIndexes = {},
                uniqueIndexes = {};
            angular.forEach(indexes, function(index) {
                if (index.keyPath) {
                    angular.forEach(index.keyPath, function(keyName) {
                        neededIndexes[keyName] = keyName;
                    });
                } else {
                    uniqueIndexes[index.name] = true;
                }
            });
            angular.forEach(neededIndexes, function(index) {
                if (typeof uniqueIndexes[index] == "undefined") {
                    indexes.push({
                        name: index
                    });
                    uniqueIndexes[index] = true;
                }
            });
        } else {
            angular.forEach(indexes, function(index) {
                if (index.keyPath) {
                    var path = index.keyPath;
                    index.generator = function(obj) {
                        var arr = [];
                        angular.forEach(path, function(keyName) {
                            arr.push(obj[keyName]);
                        });
                        return arr;
                    };
                    delete index.keyPath;
                }
            });
        }
        return indexes;
    }
    function isWhereEqualSupported() {
        if (typeof supportWhereEqual != "undefined") {
            return supportWhereEqual;
        }
        if (ionic.Platform.isIOS()) {
            supportWhereEqual = true;
            return true;
        }
        var isSafari = !ionic.Platform.isIOS() && !ionic.Platform.isAndroid() && navigator.userAgent.indexOf('Safari') != -1 &&
                            navigator.userAgent.indexOf('Chrome') == -1 && navigator.userAgent.indexOf('Firefox') == -1;
        supportWhereEqual = typeof IDBObjectStore != 'undefined' && typeof IDBObjectStore.prototype.count != 'undefined' &&
                            !isSafari;
        return supportWhereEqual;
    }
    this.registerStores = function(stores) {
        var self = this;
        angular.forEach(stores, function(store) {
            self.registerStore(store);
        });
    };
    function storeExists(name) {
        var exists = false;
        angular.forEach(siteSchema.stores, function(store) {
            if (store.name === name) {
                exists = true;
            }
        });
        return exists;
    }
    this.$get = ["$http", "$q", "$mmWS", "$mmDB", "$log", "md5", "$mmApp", "$mmLang", "$mmUtil", "$mmFS", "mmCoreWSCacheStore", "mmCoreWSPrefix", "mmCoreSessionExpired", "$mmEvents", "mmCoreEventSessionExpired", "mmCoreUserDeleted", "mmCoreEventUserDeleted", "$mmText", "$translate", "mmCoreConfigConstants", "mmCoreUserPasswordChangeForced", "mmCoreEventPasswordChangeForced", "mmCoreLoginTokenChangePassword", "mmCoreSecondsMinute", "mmCoreUserNotFullySetup", "mmCoreEventUserNotFullySetup", "mmCoreSitePolicyNotAgreed", "mmCoreEventSitePolicyNotAgreed", "mmCoreUnicodeNotSupported", function($http, $q, $mmWS, $mmDB, $log, md5, $mmApp, $mmLang, $mmUtil, $mmFS, mmCoreWSCacheStore,
            mmCoreWSPrefix, mmCoreSessionExpired, $mmEvents, mmCoreEventSessionExpired, mmCoreUserDeleted, mmCoreEventUserDeleted,
            $mmText, $translate, mmCoreConfigConstants, mmCoreUserPasswordChangeForced, mmCoreEventPasswordChangeForced,
            mmCoreLoginTokenChangePassword, mmCoreSecondsMinute, mmCoreUserNotFullySetup, mmCoreEventUserNotFullySetup,
            mmCoreSitePolicyNotAgreed, mmCoreEventSitePolicyNotAgreed, mmCoreUnicodeNotSupported) {
        $log = $log.getInstance('$mmSite');
        var deprecatedFunctions = {
            "core_grade_get_definitions": "core_grading_get_definitions",
            "moodle_course_create_courses": "core_course_create_courses",
            "moodle_course_get_courses": "core_course_get_courses",
            "moodle_enrol_get_users_courses": "core_enrol_get_users_courses",
            "moodle_file_get_files": "core_files_get_files",
            "moodle_file_upload": "core_files_upload",
            "moodle_group_add_groupmembers": "core_group_add_group_members",
            "moodle_group_create_groups": "core_group_create_groups",
            "moodle_group_delete_groupmembers": "core_group_delete_group_members",
            "moodle_group_delete_groups": "core_group_delete_groups",
            "moodle_group_get_course_groups": "core_group_get_course_groups",
            "moodle_group_get_groupmembers": "core_group_get_group_members",
            "moodle_group_get_groups": "core_group_get_groups",
            "moodle_message_send_instantmessages": "core_message_send_instant_messages",
            "moodle_notes_create_notes": "core_notes_create_notes",
            "moodle_role_assign": "core_role_assign_role",
            "moodle_role_unassign": "core_role_unassign_role",
            "moodle_user_create_users": "core_user_create_users",
            "moodle_user_delete_users": "core_user_delete_users",
            "moodle_user_get_course_participants_by_id": "core_user_get_course_user_profiles",
            "moodle_user_get_users_by_courseid": "core_enrol_get_enrolled_users",
            "moodle_user_get_users_by_id": "core_user_get_users_by_id",
            "moodle_user_update_users": "core_user_update_users",
            "moodle_webservice_get_siteinfo": "core_webservice_get_site_info",
        };
        var self = {},
            moodleReleases = {
                '2.4': 2012120300,
                '2.5': 2013051400,
                '2.6': 2013111800,
                '2.7': 2014051200,
                '2.8': 2014111000,
                '2.9': 2015051100,
                '3.0': 2015111600,
                '3.1': 2016052300,
                '3.2': 2016120500,
                '3.3': 2017051500,
                '3.4': 2017111300,
                '3.5': 2018051200 
            };
        function Site(id, siteurl, token, infos, privateToken, config, loggedOut) {
            this.id = id;
            this.siteurl = siteurl;
            this.token = token;
            this.infos = infos;
            this.privateToken = privateToken;
            this.config = config;
            this.loggedOut = !!loggedOut;
            this.cleanUnicode = false;
            if (this.id) {
                this.db = $mmDB.getDB('Site-' + this.id, siteSchema, dboptions);
            }
        }
        Site.prototype.getId = function() {
            return this.id;
        };
        Site.prototype.getURL = function() {
            return this.siteurl;
        };
        Site.prototype.getToken = function() {
            return this.token;
        };
        Site.prototype.getInfo = function() {
            return this.infos;
        };
        Site.prototype.getPrivateToken = function() {
            return this.privateToken;
        };
        Site.prototype.getDb = function() {
            return this.db;
        };
        Site.prototype.reloadDb = function() {
            if (this.db) {
                this.db = $mmDB.getDB('Site-' + this.id, siteSchema, dboptions, true);
            }
        };
        Site.prototype.getUserId = function() {
            if (typeof this.infos != 'undefined' && typeof this.infos.userid != 'undefined') {
                return this.infos.userid;
            } else {
                return undefined;
            }
        };
        Site.prototype.getSiteHomeId = function() {
            return this.infos && this.infos.siteid || 1;
        };
        Site.prototype.setId = function(id) {
            this.id = id;
            this.db = $mmDB.getDB('Site-' + this.id, siteSchema, dboptions);
        };
        Site.prototype.setToken = function(token) {
            this.token = token;
        };
        Site.prototype.setPrivateToken = function(privateToken) {
            this.privateToken = privateToken;
        };
        Site.prototype.isTokenExpired = function() {
            return this.token == mmCoreLoginTokenChangePassword;
        };
        Site.prototype.isLoggedOut = function() {
            return !!this.loggedOut;
        };
        Site.prototype.setInfo = function(infos) {
            this.infos = infos;
        };
        Site.prototype.setConfig = function(config) {
            this.config = config;
        };
        Site.prototype.setLoggedOut = function(loggedOut) {
            this.loggedOut = !!loggedOut;
        };
        Site.prototype.canAccessMyFiles = function() {
            var infos = this.getInfo();
            return infos && (typeof infos.usercanmanageownfiles === 'undefined' || infos.usercanmanageownfiles);
        };
        Site.prototype.canDownloadFiles = function() {
            var infos = this.getInfo();
            return infos && infos.downloadfiles;
        };
        Site.prototype.canUseAdvancedFeature = function(feature, whenUndefined) {
            var infos = this.getInfo(),
                canUse = true;
            whenUndefined = (typeof whenUndefined === 'undefined') ? true : whenUndefined;
            if (typeof infos.advancedfeatures === 'undefined') {
                canUse = whenUndefined;
            } else {
                angular.forEach(infos.advancedfeatures, function(item) {
                    if (item.name === feature && parseInt(item.value, 10) === 0) {
                        canUse = false;
                    }
                });
            }
            return canUse;
        };
        Site.prototype.canUploadFiles = function() {
            var infos = this.getInfo();
            return infos && infos.uploadfiles;
        };
        Site.prototype.fetchSiteInfo = function() {
            var deferred = $q.defer(),
                site = this;
            var preSets = {
                getFromCache: 0,
                saveToCache: 0
            };
            site.cleanUnicode = false;
            site.read('core_webservice_get_site_info', {}, preSets).then(deferred.resolve, function(error) {
                site.read('moodle_webservice_get_siteinfo', {}, preSets).then(deferred.resolve, function(error) {
                    deferred.reject(error);
                });
            });
            return deferred.promise;
        };
        Site.prototype.read = function(method, data, preSets) {
            preSets = preSets || {};
            if (typeof(preSets.getFromCache) === 'undefined') {
                preSets.getFromCache = 1;
            }
            if (typeof(preSets.saveToCache) === 'undefined') {
                preSets.saveToCache = 1;
            }
            if (typeof(preSets.sync) === 'undefined') {
                preSets.sync = 0;
            }
            return this.request(method, data, preSets);
        };
        Site.prototype.write = function(method, data, preSets) {
            preSets = preSets || {};
            if (typeof(preSets.getFromCache) === 'undefined') {
                preSets.getFromCache = 0;
            }
            if (typeof(preSets.saveToCache) === 'undefined') {
                preSets.saveToCache = 0;
            }
            if (typeof(preSets.sync) === 'undefined') {
                preSets.sync = 0;
            }
            if (typeof(preSets.emergencyCache) === 'undefined') {
                preSets.emergencyCache = 0;
            }
            return this.request(method, data, preSets);
        };
        Site.prototype.request = function(method, data, preSets, retrying) {
            var site = this,
                initialToken = site.token;
            data = data || {};
            method = site.getCompatibleFunction(method);
            if (site.getInfo() && !site.wsAvailable(method, false)) {
                if (site.wsAvailable(mmCoreWSPrefix + method, false)) {
                    $log.info("Using compatibility WS method '" + mmCoreWSPrefix + method + "'");
                    method = mmCoreWSPrefix + method;
                } else {
                    $log.error("WS function '" + method + "' is not available, even in compatibility mode.");
                    return $mmLang.translateAndReject('mm.core.wsfunctionnotavailable');
                }
            }
            preSets = angular.copy(preSets) || {};
            preSets.wstoken = site.token;
            preSets.siteurl = site.siteurl;
            preSets.cleanUnicode = site.cleanUnicode;
            if (preSets.cleanUnicode && $mmText.hasUnicodeData(data)) {
                $mmUtil.showToast('mm.core.unicodenotsupported', true, 3000);
            } else {
                preSets.cleanUnicode = false;
            }
            data.moodlewssettingfilter = preSets.filter === false ? false : true;
            data.moodlewssettingfileurl = preSets.rewriteurls === false ? false : true;
            return getFromCache(site, method, data, preSets).catch(function() {
                var wsPreSets = angular.copy(preSets);
                delete wsPreSets.getFromCache;
                delete wsPreSets.saveToCache;
                delete wsPreSets.omitExpires;
                delete wsPreSets.cacheKey;
                delete wsPreSets.emergencyCache;
                delete wsPreSets.getCacheUsingCacheKey;
                delete wsPreSets.getEmergencyCacheUsingCacheKey;
                delete wsPreSets.uniqueCacheKey;
                return $mmWS.call(method, data, wsPreSets).then(function(response) {
                    if (preSets.saveToCache) {
                        saveToCache(site, method, data, response, preSets);
                    }
                    return angular.copy(response);
                }).catch(function(error) {
                    if (error === mmCoreSessionExpired) {
                        if (initialToken !== site.token && !retrying) {
                            return site.request(method, data, preSets, true);
                        } else if ($mmApp.isSSOAuthenticationOngoing()) {
                            return $mmApp.waitForSSOAuthentication().then(function() {
                                return site.request(method, data, preSets, true);
                            });
                        }
                        $mmEvents.trigger(mmCoreEventSessionExpired, {siteid: site.id});
                        error = $translate.instant('mm.core.lostconnection');
                    } else if (error === mmCoreUserDeleted) {
                        $mmEvents.trigger(mmCoreEventUserDeleted, {siteid: site.id, params: data});
                        return $mmLang.translateAndReject('mm.core.userdeleted');
                    } else if (error === mmCoreUserPasswordChangeForced) {
                        $mmEvents.trigger(mmCoreEventPasswordChangeForced, site.id);
                        return $mmLang.translateAndReject('mm.core.forcepasswordchangenotice');
                    } else if (error === mmCoreUserNotFullySetup) {
                        $mmEvents.trigger(mmCoreEventUserNotFullySetup, site.id);
                        return $mmLang.translateAndReject('mm.core.usernotfullysetup');
                    } else if (error === mmCoreSitePolicyNotAgreed) {
                        $mmEvents.trigger(mmCoreEventSitePolicyNotAgreed, site.id);
                        return $mmLang.translateAndReject('mm.login.sitepolicynotagreederror');
                    } else if (error === mmCoreUnicodeNotSupported) {
                        if (!site.cleanUnicode) {
                            site.cleanUnicode = true;
                            return site.request(method, data, preSets);
                        }
                        return $mmLang.translateAndReject('mm.core.unicodenotsupported');
                    } else if (typeof preSets.emergencyCache !== 'undefined' && !preSets.emergencyCache) {
                        $log.debug('WS call ' + method + ' failed. Emergency cache is forbidden, rejecting.');
                        return $q.reject(error);
                    }
                    $log.debug('WS call ' + method + ' failed. Trying to use the emergency cache.');
                    preSets.omitExpires = true;
                    preSets.getFromCache = true;
                    return getFromCache(site, method, data, preSets, true).catch(function() {
                        return $q.reject(error);
                    });
                });
            });
        };
        Site.prototype.wsAvailable = function(method, checkPrefix) {
            checkPrefix = (typeof checkPrefix === 'undefined') ? true : checkPrefix;
            if (typeof this.infos == 'undefined') {
                return false;
            }
            for (var i = 0; i < this.infos.functions.length; i++) {
                var f = this.infos.functions[i];
                if (f.name == method) {
                    return true;
                }
            }
            if (checkPrefix) {
                return this.wsAvailable(mmCoreWSPrefix + method, false);
            }
            return false;
        };
        Site.prototype.uploadFile = function(uri, options) {
            if (!options.fileArea) {
                if (this.isVersionGreaterEqualThan('3.1')) {
                    options.fileArea = 'draft';
                } else {
                    options.fileArea = 'private';
                }
            }
            return $mmWS.uploadFile(uri, options, {
                siteurl: this.siteurl,
                token: this.token
            });
        };
        Site.prototype.invalidateWsCache = function() {
            var db = this.db;
            if (!db) {
                return $q.reject();
            }
            $log.debug('Invalidate all the cache for site: '+ this.id);
            return db.getAll(mmCoreWSCacheStore).then(function(entries) {
                if (entries && entries.length > 0) {
                    return invalidateWsCacheEntries(db, entries);
                }
            });
        };
        Site.prototype.invalidateWsCacheForKey = function(key) {
            var db = this.db;
            if (!db || !key) {
                return $q.reject();
            }
            $log.debug('Invalidate cache for key: '+key);
            return db.whereEqual(mmCoreWSCacheStore, 'key', key).then(function(entries) {
                if (entries && entries.length > 0) {
                    return invalidateWsCacheEntries(db, entries);
                }
            });
        };
        Site.prototype.invalidateMultipleWsCacheForKey = function(keys) {
            var db = this.db;
            if (!db) {
                return $q.reject();
            }
            var allEntries = [],
                promises = [];
            $log.debug('Invalidating multiple cache keys');
            angular.forEach(keys, function(key) {
                if (key) {
                    promises.push(db.whereEqual(mmCoreWSCacheStore, 'key', key).then(function(entries) {
                        if (entries && entries.length > 0) {
                            allEntries.concat(entries);
                        }
                    }));
                }
            });
            return $q.all(promises).then(function() {
                return invalidateWsCacheEntries(db, allEntries);
            });
        };
        Site.prototype.invalidateWsCacheForKeyStartingWith = function(key) {
            var db = this.db;
            if (!db || !key) {
                return $q.reject();
            }
            $log.debug('Invalidate cache for key starting with: '+key);
            return db.where(mmCoreWSCacheStore, 'key', '^', key).then(function(entries) {
                if (entries && entries.length > 0) {
                    return invalidateWsCacheEntries(db, entries);
                }
            });
        };
        Site.prototype.fixPluginfileURL = function(url) {
            return $mmUtil.fixPluginfileURL(url, this.token);
        };
        Site.prototype.deleteDB = function() {
            return $mmDB.deleteDB('Site-' + this.id);
        };
        Site.prototype.deleteFolder = function() {
            if ($mmFS.isAvailable()) {
                var siteFolder = $mmFS.getSiteFolder(this.id);
                return $mmFS.removeDir(siteFolder).catch(function() {
                });
            } else {
                return $q.when();
            }
        };
        Site.prototype.getSpaceUsage = function() {
            if ($mmFS.isAvailable()) {
                var siteFolderPath = $mmFS.getSiteFolder(this.id);
                return $mmFS.getDirectorySize(siteFolderPath).catch(function() {
                    return 0;
                });
            } else {
                return $q.when(0);
            }
        };
        Site.prototype.getDocsUrl = function(page) {
            var release = this.infos.release ? this.infos.release : undefined;
            return $mmUtil.getDocsUrl(release, page);
        };
        Site.prototype.checkLocalMobilePlugin = function(retrying) {
            var siteurl = this.siteurl,
                self = this,
                service = mmCoreConfigConstants.wsextservice;
            if (!service) {
                return $q.when({code: 0});
            }
            return $http.post(siteurl + '/local/mobile/check.php', {service: service}).then(function(response) {
                var data = response.data;
                if (typeof data != 'undefined' && data.errorcode === 'requirecorrectaccess') {
                    if (!retrying) {
                        self.siteurl = $mmText.addOrRemoveWWW(siteurl);
                        return self.checkLocalMobilePlugin(true);
                    } else {
                        return $q.reject(data.error);
                    }
                } else if (typeof data == 'undefined' || typeof data.code == 'undefined') {
                    return {code: 0, warning: 'mm.login.localmobileunexpectedresponse'};
                }
                var code = parseInt(data.code, 10);
                if (data.error) {
                    switch (code) {
                        case 1:
                            return $mmLang.translateAndReject('mm.login.siteinmaintenance');
                        case 2:
                            return $mmLang.translateAndReject('mm.login.webservicesnotenabled');
                        case 3:
                            return {code: 0};
                        case 4:
                            return $mmLang.translateAndReject('mm.login.mobileservicesnotenabled');
                        default:
                            return $mmLang.translateAndReject('mm.core.unexpectederror');
                    }
                } else {
                    return {code: code, service: service, coresupported: !!data.coresupported};
                }
            }, function() {
                return {code: 0};
            });
        };
        Site.prototype.checkIfAppUsesLocalMobile = function() {
            var appUsesLocalMobile = false;
            angular.forEach(this.infos.functions, function(func) {
                if (func.name.indexOf(mmCoreWSPrefix) != -1) {
                    appUsesLocalMobile = true;
                }
            });
            return appUsesLocalMobile;
        };
        Site.prototype.checkIfLocalMobileInstalledAndNotUsed = function() {
            var appUsesLocalMobile = this.checkIfAppUsesLocalMobile();
            if (appUsesLocalMobile) {
                return $q.reject();
            }
            return this.checkLocalMobilePlugin().then(function(data) {
                if (typeof data.service == 'undefined') {
                    return $q.reject();
                }
                return data;
            });
        };
        Site.prototype.containsUrl = function(url) {
            if (!url) {
                return false;
            }
            var siteurl = $mmText.removeProtocolAndWWW(this.siteurl);
            url = $mmText.removeProtocolAndWWW(url);
            return url.indexOf(siteurl) == 0;
        };
        Site.prototype.getPublicConfig = function() {
            var that = this;
            return $mmWS.callAjax('tool_mobile_get_public_config', {}, {siteurl: this.siteurl}).then(function(config) {
                if (config.httpswwwroot) {
                    that.siteurl = config.httpswwwroot;
                }
                return config;
            });
        };
        Site.prototype.openInBrowserWithAutoLogin = function(url, alertMessage) {
            return this.openWithAutoLogin(false, url, undefined, alertMessage);
        };
        Site.prototype.openInBrowserWithAutoLoginIfSameSite = function(url, alertMessage) {
            return this.openWithAutoLoginIfSameSite(false, url, undefined, alertMessage);
        };
        Site.prototype.openInAppWithAutoLogin = function(url, options, alertMessage) {
            return this.openWithAutoLogin(true, url, options, alertMessage);
        };
        Site.prototype.openInAppWithAutoLoginIfSameSite = function(url, options, alertMessage) {
            return this.openWithAutoLoginIfSameSite(true, url, options, alertMessage);
        };
        Site.prototype.openWithAutoLogin = function(inApp, url, options, alertMessage) {
            if (!this.privateToken || !this.wsAvailable('tool_mobile_get_autologin_key') ||
                    (this.lastAutoLogin && $mmUtil.timestamp() - this.lastAutoLogin < 6 * mmCoreSecondsMinute)) {
                return open(url);
            }
            var that = this,
                userId = that.getUserId(),
                params = {
                    privatetoken: that.privateToken
                },
                modal = $mmUtil.showModalLoading();
            return that.write('tool_mobile_get_autologin_key', params).then(function(data) {
                if (!data.autologinurl || !data.key) {
                    return open(url);
                }
                that.lastAutoLogin = $mmUtil.timestamp();
                return open(data.autologinurl + '?userid=' + userId + '&key=' + data.key + '&urltogo=' + url);
            }).catch(function() {
                return open(url);
            });
            function open(url) {
                if (modal) {
                    modal.dismiss();
                }
                var promise;
                if (alertMessage) {
                    promise = $mmUtil.showModal('mm.core.notice', alertMessage, 3000);
                } else {
                    promise = $q.when();
                }
                return promise.finally(function() {
                    if (inApp) {
                        $mmUtil.openInApp(url, options);
                    } else {
                        $mmUtil.openInBrowser(url);
                    }
                });
            }
        };
        Site.prototype.openWithAutoLoginIfSameSite = function(inApp, url, options, alertMessage) {
            if (this.containsUrl(url)) {
                return this.openWithAutoLogin(inApp, url, options, alertMessage);
            } else {
                if (inApp) {
                    $mmUtil.openInApp(url, options);
                } else {
                    $mmUtil.openInBrowser(url);
                }
                return $q.when();
            }
        };
        Site.prototype.getConfig = function(name, ignoreCache) {
            var site = this;
            var preSets = {
                cacheKey: getConfigCacheKey()
            };
            if (ignoreCache) {
                preSets.getFromCache = 0;
                preSets.emergencyCache = 0;
            }
            return site.read('tool_mobile_get_config', {}, preSets).then(function(config) {
                if (name) {
                    for (var x in config.settings) {
                        if (config.settings[x].name == name) {
                            return config.settings[x].value;
                        }
                    }
                    return $q.reject();
                } else {
                    var settings = {};
                    angular.forEach(config.settings, function(setting) {
                        settings[setting.name] = setting.value;
                    });
                    return settings;
                }
            });
        };
        Site.prototype.invalidateConfig = function() {
            var site = this;
            return site.invalidateWsCacheForKey(getConfigCacheKey());
        };
        function getConfigCacheKey() {
            return 'tool_mobile_get_config';
        }
        Site.prototype.getStoredConfig = function(name) {
            if (!this.config) {
                return;
            }
            if (name) {
                return this.config[name];
            } else {
                return this.config;
            }
        };
        Site.prototype.isFeatureDisabled = function(name) {
            var disabledFeatures = this.getStoredConfig('tool_mobile_disabledfeatures');
            if (!disabledFeatures) {
                return false;
            }
            var regEx = new RegExp('(,|^)' + $mmText.escapeForRegex(name) + '(,|$)', 'g');
            return !!disabledFeatures.match(regEx);
        };
        function invalidateWsCacheEntries(db, entries) {
            var promises = [];
            angular.forEach(entries, function(entry) {
                if (entry.expirationtime > 0) {
                    entry.expirationtime = 0;
                    promises.push(db.insert(mmCoreWSCacheStore, entry));
                }
            });
            return $q.all(promises);
        }
        Site.prototype.getCompatibleFunction = function(method) {
            if (typeof deprecatedFunctions[method] !== "undefined") {
                if (this.wsAvailable(deprecatedFunctions[method])) {
                    $log.warn("You are using deprecated Web Services: " + method +
                        " you must replace it with the newer function: " + deprecatedFunctions[method]);
                    return deprecatedFunctions[method];
                } else {
                    $log.warn("You are using deprecated Web Services. " +
                        "Your remote site seems to be outdated, consider upgrade it to the latest Moodle version.");
                }
            } else if (!this.wsAvailable(method)) {
                for (var oldFunc in deprecatedFunctions) {
                    if (deprecatedFunctions[oldFunc] === method && this.wsAvailable(oldFunc)) {
                        $log.warn("Your remote site doesn't support the function " + method +
                            ", it seems to be outdated, consider upgrade it to the latest Moodle version.");
                        return oldFunc; 
                    }
                }
            }
            return method;
        };
        Site.prototype.isVersionGreaterEqualThan = function(versions) {
            var siteVersion = parseInt(this.getInfo().version, 10);
            if (angular.isArray(versions)) {
                if (!versions.length) {
                    return false;
                }
                for (var i = 0; i < versions.length; i++) {
                    var versionNumber = getVersionNumber(versions[i]);
                    if (i == versions.length - 1) {
                        return siteVersion >= versionNumber;
                    } else {
                        if (siteVersion >= versionNumber && siteVersion < getNextMajorVersionNumber(versions[i])) {
                            return true;
                        }
                    }
                }
            } else if (typeof versions == 'string') {
                return siteVersion >= getVersionNumber(versions);
            }
            return false;
        };
        function getVersionNumber(version) {
            var data = getMajorAndMinor(version);
            if (!data) {
                return 0;
            }
            if (typeof moodleReleases[data.major] == 'undefined') {
                data.major = Object.keys(moodleReleases).slice(-1);
            }
            return moodleReleases[data.major] + data.minor;
        }
        function getMajorAndMinor(version) {
            var match = version.match(/(\d)+(?:\.(\d)+)?(?:\.(\d)+)?/);
            if (!match || !match[1]) {
                return false;
            }
            return {
                major: match[1] + '.' + (match[2] || '0'),
                minor: parseInt(match[3] || 0, 10)
            };
        }
        function getNextMajorVersionNumber(version) {
            var data = getMajorAndMinor(version),
                position,
                releases = Object.keys(moodleReleases);
            if (!data) {
                return 0;
            }
            position = releases.indexOf(data.major);
            if (position == -1 || position == releases.length -1) {
                return moodleReleases[releases[position]];
            }
            return moodleReleases[releases[position + 1]];
        }
        function getCacheId(method, data) {
            return md5.createHash(method + ':' + JSON.stringify(data));
        }
        function getFromCache(site, method, data, preSets, emergency) {
            var db = site.db,
                id = getCacheId(method, data),
                promise;
            if (!db || !preSets.getFromCache) {
                return $q.reject();
            }
            if (preSets.getCacheUsingCacheKey || (emergency && preSets.getEmergencyCacheUsingCacheKey)) {
                promise = db.whereEqual(mmCoreWSCacheStore, 'key', preSets.cacheKey).then(function(entries) {
                    if (!entries.length) {
                        return db.get(mmCoreWSCacheStore, id);
                    } else if (entries.length > 1) {
                        for (var i = 0, len = entries.length; i < len; i++) {
                            var entry = entries[i];
                            if (entry.id == id) {
                                return entry;
                            }
                        }
                    }
                    return entries[0];
                });
            } else {
                promise = db.get(mmCoreWSCacheStore, id);
            }
            return promise.then(function(entry) {
                var now = new Date().getTime();
                preSets.omitExpires = preSets.omitExpires || !$mmApp.isOnline();
                if (!preSets.omitExpires) {
                    if (now > entry.expirationtime) {
                        $log.debug('Cached element found, but it is expired');
                        return $q.reject();
                    }
                }
                if (typeof entry != 'undefined' && typeof entry.data != 'undefined') {
                    var expires = (entry.expirationtime - now) / 1000;
                    $log.info('Cached element found, id: ' + id + ' expires in ' + expires + ' seconds');
                    return entry.data;
                }
                return $q.reject();
            });
        }
        function saveToCache(site, method, data, response, preSets) {
            var db = site.db,
                id = getCacheId(method, data),
                cacheExpirationTime = mmCoreConfigConstants.cache_expiration_time,
                promise,
                entry = {
                    id: id,
                    data: response
                };
            if (!db) {
                return $q.reject();
            } else {
                if (preSets.uniqueCacheKey) {
                    promise = deleteFromCache(site, method, data, preSets, true).catch(function() {
                    });
                } else {
                    promise = $q.when();
                }
                return promise.then(function() {
                    cacheExpirationTime = isNaN(cacheExpirationTime) ? 300000 : cacheExpirationTime;
                    entry.expirationtime = new Date().getTime() + cacheExpirationTime;
                    if (preSets.cacheKey) {
                        entry.key = preSets.cacheKey;
                    }
                    return db.insert(mmCoreWSCacheStore, entry);
                });
            }
        }
        function deleteFromCache(site, method, data, preSets, allCacheKey) {
            var db = site.db,
                id = getCacheId(method, data);
            if (!db) {
                return $q.reject();
            } else {
                if (allCacheKey) {
                    return db.whereEqual(mmCoreWSCacheStore, 'key', preSets.cacheKey).then(function(entries) {
                        var promises = [];
                        angular.forEach(entries, function(entry) {
                            promises.push(db.remove(mmCoreWSCacheStore, entry.id));
                        });
                        return $q.all(promises);
                    });
                } else {
                    return db.remove(mmCoreWSCacheStore, id);
                }
            }
        }
        self.makeSite = function(id, siteurl, token, infos, privateToken, config, loggedOut) {
            return new Site(id, siteurl, token, infos, privateToken, config, loggedOut);
        };
        self.getSiteMethods = function() {
            var methods = [];
            for (var name in Site.prototype) {
                methods.push(name);
            }
            return methods;
        };
        return self;
    }];
});

angular.module('mm.core')
.constant('mmCoreSitesStore', 'sites')
.constant('mmCoreCurrentSiteStore', 'current_site')
.config(["$mmAppProvider", "mmCoreSitesStore", "mmCoreCurrentSiteStore", function($mmAppProvider, mmCoreSitesStore, mmCoreCurrentSiteStore) {
    var stores = [
        {
            name: mmCoreSitesStore,
            keyPath: 'id'
        },
        {
            name: mmCoreCurrentSiteStore,
            keyPath: 'id'
        }
    ];
    $mmAppProvider.registerStores(stores);
}])
.factory('$mmSitesManager', ["$http", "$q", "$mmSitesFactory", "md5", "$mmLang", "$mmApp", "$mmUtil", "$mmEvents", "$translate", "mmCoreSitesStore", "mmCoreCurrentSiteStore", "mmCoreEventLogin", "mmCoreEventLogout", "$log", "mmCoreWSPrefix", "mmCoreEventSiteUpdated", "mmCoreEventSiteAdded", "mmCoreEventSessionExpired", "mmCoreEventSiteDeleted", "$mmText", "mmCoreConfigConstants", "mmLoginSSOCode", "mmLoginSSOInAppCode", function($http, $q, $mmSitesFactory, md5, $mmLang, $mmApp, $mmUtil, $mmEvents,
            $translate, mmCoreSitesStore, mmCoreCurrentSiteStore, mmCoreEventLogin, mmCoreEventLogout, $log, mmCoreWSPrefix,
            mmCoreEventSiteUpdated, mmCoreEventSiteAdded, mmCoreEventSessionExpired, mmCoreEventSiteDeleted, $mmText,
            mmCoreConfigConstants, mmLoginSSOCode, mmLoginSSOInAppCode) {
    $log = $log.getInstance('$mmSitesManager');
    var self = {},
        services = {},
        sessionRestored = false,
        currentSite,
        sites = {};
    self.getDemoSiteData = function(siteurl) {
        var demoSites = mmCoreConfigConstants.demo_sites;
        if (typeof demoSites != 'undefined' && typeof demoSites[siteurl] != 'undefined') {
            return demoSites[siteurl];
        }
    };
    self.checkSite = function(siteurl, protocol) {
        siteurl = $mmUtil.formatURL(siteurl);
        if (!$mmUtil.isValidURL(siteurl)) {
            return $mmLang.translateAndReject('mm.login.invalidsite');
        } else if (!$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.core.networkerrormsg');
        } else {
            protocol = protocol || 'https://';
            return checkSite(siteurl, protocol).catch(function(error) {
                if (error.critical) {
                    return $q.reject(error.error);
                }
                protocol = protocol == 'https://' ? 'http://' : 'https://';
                return checkSite(siteurl, protocol).catch(function(secondError){
                    if (secondError.error) {
                        return $q.reject(secondError.error);
                    } else if (error.error) {
                        return $q.reject(error.error);
                    }
                    return $mmLang.translateAndReject('mm.login.checksiteversion');
                });
            });
        }
    };
    function checkSite(siteurl, protocol) {
        siteurl = siteurl.replace(/^http(s)?\:\/\//i, protocol);
        return self.siteExists(siteurl).catch(function(error) {
            if (error.errorcode && error.errorcode == 'enablewsdescription') {
                return rejectWithCriticalError(error.error, error.errorcode);
            }
            var treatedUrl = $mmText.addOrRemoveWWW(siteurl);
            return self.siteExists(treatedUrl).then(function() {
                siteurl = treatedUrl;
            }).catch(function(secondError) {
                if (secondError.errorcode && secondError.errorcode == 'enablewsdescription') {
                    return rejectWithCriticalError(secondError.error, secondError.errorcode);
                }
                error = secondError || error;
                return $q.reject({error: typeof error == 'object' ? error.error : error});
            });
        }).then(function() {
            var temporarySite = $mmSitesFactory.makeSite(undefined, siteurl);
            return temporarySite.checkLocalMobilePlugin().then(function(data) {
                data.service = data.service || mmCoreConfigConstants.wsservice;
                services[siteurl] = data.service; 
                if (data.coresupported || (data.code != mmLoginSSOCode && data.code != mmLoginSSOInAppCode)) {
                    return temporarySite.getPublicConfig().then(function(config) {
                        if (!config.enablewebservices) {
                            return rejectWithCriticalError($translate.instant('mm.login.webservicesnotenabled'));
                        } else if (!config.enablemobilewebservice) {
                            return rejectWithCriticalError($translate.instant('mm.login.mobileservicesnotenabled'));
                        } else if (config.maintenanceenabled) {
                            var message = $translate.instant('mm.core.sitemaintenance');
                            if (config.maintenancemessage) {
                                message += config.maintenancemessage;
                            }
                            return rejectWithCriticalError(message);
                        }
                        if (data.code === 0) {
                            data.code = config.typeoflogin;
                        }
                        data.config = config;
                        return data;
                    }, function(error) {
                        if (error.available === 1) {
                            return $q.reject({error: error.error});
                        }
                        return data;
                    });
                }
                return data;
            }).then(function(data) {
                siteurl = temporarySite.getURL();
                return {siteurl: siteurl, code: data.code, warning: data.warning, service: data.service, config: data.config};
            });
        });
        function rejectWithCriticalError(message, errorCode) {
            return $q.reject({
                error: message,
                errorcode: errorCode,
                critical: true
            });
        }
    }
    self.siteExists = function(siteurl) {
        var data = {};
        if (!ionic.Platform.isWebView()) {
            data.username = 'a';
            data.password = 'b';
            data.service = 'c';
        }
        return $http.post(siteurl + '/login/token.php', data, {timeout: 30000, responseType: 'json'}).then(function(data) {
            data = data.data;
            if (data.errorcode && (data.errorcode == 'enablewsdescription' || data.errorcode == 'requirecorrectaccess')) {
                return $q.reject({errorcode: data.errorcode, error: data.error});
            } else if (data.error && data.error == 'Web services must be enabled in Advanced features.') {
                return $q.reject({errorcode: 'enablewsdescription', error: data.error});
            }
            return $q.when();
        });
    };
    self.getUserToken = function(siteurl, username, password, service, retry) {
        retry = retry || false;
        if (!$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.core.networkerrormsg');
        }
        if (!service) {
            service = self.determineService(siteurl);
        }
        var loginurl = siteurl + '/login/token.php';
        var data = {
            username: username,
            password: password,
            service: service
        };
        return $http.post(loginurl, data).then(function(response) {
            var data = response.data;
            if (typeof data == 'undefined') {
                return $mmLang.translateAndReject('mm.core.cannotconnect');
            } else {
                if (typeof data.token != 'undefined') {
                    return {token: data.token, siteurl: siteurl, privatetoken: data.privatetoken};
                } else {
                    if (typeof data.error != 'undefined') {
                        if (!retry && data.errorcode == "requirecorrectaccess") {
                            siteurl = $mmText.addOrRemoveWWW(siteurl);
                            return self.getUserToken(siteurl, username, password, service, true);
                        } else if (typeof data.errorcode != 'undefined') {
                            return $q.reject({error: data.error, errorcode: data.errorcode});
                        } else {
                            return $q.reject(data.error);
                        }
                    } else {
                        return $mmLang.translateAndReject('mm.login.invalidaccount');
                    }
                }
            }
        }, function() {
            return $mmLang.translateAndReject('mm.core.cannotconnect');
        });
    };
    self.newSite = function(siteurl, token, privateToken) {
        privateToken = privateToken || '';
        var candidateSite = $mmSitesFactory.makeSite(undefined, siteurl, token, undefined, privateToken);
        return candidateSite.fetchSiteInfo().then(function(infos) {
            if (isValidMoodleVersion(infos)) {
                var siteId = self.createSiteID(infos.siteurl, infos.username);
                candidateSite.setId(siteId);
                candidateSite.setInfo(infos);
                return getSiteConfig(candidateSite).then(function(config) {
                    candidateSite.setConfig(config);
                    self.addSite(siteId, siteurl, token, infos, privateToken, config);
                    currentSite = candidateSite;
                    self.login(siteId);
                    $mmEvents.trigger(mmCoreEventSiteAdded, siteId);
                    return siteId;
                });
            } else {
                return $mmLang.translateAndReject('mm.login.invalidmoodleversion');
            }
        });
    };
    self.createSiteID = function(siteurl, username) {
        return md5.createHash(siteurl + username);
    };
    self.determineService = function(siteurl) {
        siteurl = siteurl.replace("https://", "http://");
        if (services[siteurl]) {
            return services[siteurl];
        }
        siteurl = siteurl.replace("http://", "https://");
        if (services[siteurl]) {
            return services[siteurl];
        }
        return mmCoreConfigConstants.wsservice;
    };
    function isValidMoodleVersion(infos) {
        if (!infos) {
            return false;
        }
        var minVersion = 2012120300, 
            minRelease = "2.4";
        if (infos.version) {
            var version = parseInt(infos.version);
            if (!isNaN(version)) {
                return version >= minVersion;
            }
        }
        if (infos.release) {
            var matches = infos.release.match(/^([\d|\.]*)/);
            if (matches && matches.length > 1) {
                return matches[1] >= minRelease;
            }
        }
        var appUsesLocalMobile = false;
        angular.forEach(infos.functions, function(func) {
            if (func.name.indexOf(mmCoreWSPrefix) != -1) {
                appUsesLocalMobile = true;
            }
        });
        return appUsesLocalMobile;
    }
    function validateSiteInfo(infos) {
        if (!infos.firstname || !infos.lastname) {
            var moodleLink = '<a mm-link href="' + infos.siteurl + '">' + infos.siteurl + '</a>';
            return {error: 'mm.core.requireduserdatamissing', params: {'$a': moodleLink}};
        }
        return true;
    }
    self.addSite = function(id, siteurl, token, infos, privateToken, config) {
        privateToken = privateToken || '';
        return $mmApp.getDB().insert(mmCoreSitesStore, {
            id: id,
            siteurl: siteurl,
            token: token,
            infos: infos,
            privatetoken: privateToken,
            config: config,
            loggedout: 0
        });
    };
    self.loadSite = function(siteId) {
        $log.debug('Load site ' + siteId);
        return self.getSite(siteId).then(function(site) {
            currentSite = site;
            self.login(siteId);
            if (site.isLoggedOut()) {
                return;
            }
            return site.checkIfLocalMobileInstalledAndNotUsed().then(function() {
                $mmEvents.trigger(mmCoreEventSessionExpired, {siteid: siteId});
            }, function() {
                self.updateSiteInfo(siteId);
            });
        });
    };
    self.getCurrentSite = function() {
        return currentSite;
    };
    self.deleteSite = function(siteid) {
        $log.debug('Delete site '+siteid);
        if (typeof currentSite != 'undefined' && currentSite.id == siteid) {
            self.logout();
        }
        return self.getSite(siteid).then(function(site) {
            return site.deleteDB().then(function() {
                delete sites[siteid];
                return $mmApp.getDB().remove(mmCoreSitesStore, siteid).then(function() {
                    return site.deleteFolder();
                }, function() {
                    return site.deleteFolder();
                }).then(function() {
                    $mmEvents.trigger(mmCoreEventSiteDeleted, site);
                });
            });
        });
    };
    self.hasNoSites = function() {
        return $mmApp.getDB().count(mmCoreSitesStore).then(function(count) {
            if (count > 0) {
                return $q.reject();
            }
        });
    };
    self.hasSites = function() {
        return $mmApp.getDB().count(mmCoreSitesStore).then(function(count) {
            if (count == 0) {
                return $q.reject();
            }
        });
    };
    self.getSite = function(siteId) {
        if (!siteId) {
            return currentSite ? $q.when(currentSite) : $q.reject();
        } else if (currentSite && currentSite.getId() === siteId) {
            return $q.when(currentSite);
        } else if (typeof sites[siteId] != 'undefined') {
            return $q.when(sites[siteId]);
        } else {
            return $mmApp.getDB().get(mmCoreSitesStore, siteId).then(function(data) {
                var site = $mmSitesFactory.makeSite(siteId, data.siteurl, data.token,
                        data.infos, data.privatetoken, data.config, data.loggedout);
                sites[siteId] = site;
                return site;
            });
        }
    };
    self.isCurrentSite = function(site) {
        if (!site || !currentSite) {
            return !!currentSite;
        }
        var siteId = typeof site == 'object' ? site.getId() : site;
        return currentSite.getId() === siteId;
    };
    self.getSiteDb = function(siteId) {
        return self.getSite(siteId).then(function(site) {
            return site.getDb();
        });
    };
    self.getSiteHomeId = function(siteId) {
        return self.getSite(siteId).then(function(site) {
            return site.getSiteHomeId();
        });
    };
    self.getSites = function(ids) {
        return $mmApp.getDB().getAll(mmCoreSitesStore).then(function(sites) {
            var formattedSites = [];
            angular.forEach(sites, function(site) {
                if (!ids || ids.indexOf(site.id) > -1) {
                    formattedSites.push({
                        id: site.id,
                        siteurl: site.siteurl,
                        fullname: site.infos.fullname,
                        sitename: site.infos.sitename,
                        avatar: site.infos.userpictureurl
                    });
                }
            });
            return formattedSites;
        });
    };
    self.sortSites = function(sites) {
        return sites.sort(function(a, b) {
            var compareA = a.siteurl.toLowerCase(),
                compareB = b.siteurl.toLowerCase(),
                compare = compareA.localeCompare(compareB);
            if (compare !== 0) {
                return compare;
            }
            compareA = a.fullname.toLowerCase().trim();
            compareB = b.fullname.toLowerCase().trim();
            return compareA.localeCompare(compareB);
        });
    };
    self.getSitesIds = function() {
        return $mmApp.getDB().getAll(mmCoreSitesStore).then(function(sites) {
            var ids = [];
            angular.forEach(sites, function(site) {
                ids.push(site.id);
            });
            return ids;
        });
    };
    self.login = function(siteid) {
        return $mmApp.getDB().insert(mmCoreCurrentSiteStore, {
            id: 1,
            siteid: siteid
        }).then(function() {
            $mmEvents.trigger(mmCoreEventLogin);
        });
    };
    self.logout = function() {
        if (!currentSite) {
            return $q.when();
        }
        var siteId = currentSite.getId(),
            siteConfig = currentSite.getStoredConfig(),
            promises = [];
        currentSite = undefined;
        if (siteConfig && siteConfig.tool_mobile_forcelogout == "1") {
            promises.push(self.setSiteLoggedOut(siteId, true));
        }
        promises.push($mmApp.getDB().remove(mmCoreCurrentSiteStore, 1));
        return $q.all(promises).finally(function() {
            $mmEvents.trigger(mmCoreEventLogout, siteId);
        });
    };
    self.restoreSession = function() {
        if (sessionRestored) {
            return $q.reject();
        }
        sessionRestored = true;
        return $mmApp.getDB().get(mmCoreCurrentSiteStore, 1).then(function(current_site) {
            var siteid = current_site.siteid;
            $log.debug('Restore session in site '+siteid);
            return self.loadSite(siteid);
        }, function() {
            return $q.reject(); 
        });
    };
    self.setSiteLoggedOut = function(siteId, loggedOut) {
        return self.getSite(siteId).then(function(site) {
            site.setLoggedOut(loggedOut);
            return $mmApp.getDB().insert(mmCoreSitesStore, {
                id: siteId,
                siteurl: site.getURL(),
                token: site.getToken(),
                infos: site.getInfo(),
                privatetoken: site.getPrivateToken(),
                config: site.getStoredConfig(),
                loggedout: loggedOut ? 1 : 0
            });
        });
    };
    self.updateSiteToken = function(siteUrl, username, token, privateToken) {
        var siteId = self.createSiteID(siteUrl, username);
        return self.updateSiteTokenBySiteId(siteId, token, privateToken);
    };
    self.updateSiteTokenBySiteId = function(siteId, token, privateToken) {
        privateToken = privateToken || '';
        return self.getSite(siteId).then(function(site) {
            site.token = token;
            site.privateToken = privateToken;
            site.setLoggedOut(false); 
            return $mmApp.getDB().insert(mmCoreSitesStore, {
                id: siteId,
                siteurl: site.getURL(),
                token: token,
                infos: site.getInfo(),
                privatetoken: privateToken,
                config: site.getStoredConfig(),
                loggedout: 0
            });
        });
    };
    self.updateSiteInfo = function(siteid) {
        return self.getSite(siteid).then(function(site) {
            return site.fetchSiteInfo().then(function(infos) {
                site.setInfo(infos);
                return getSiteConfig(site).catch(function() {
                    return site.getStoredConfig();
                }).then(function(config) {
                    site.setConfig(config);
                    return $mmApp.getDB().insert(mmCoreSitesStore, {
                        id: siteid,
                        siteurl: site.getURL(),
                        token: site.getToken(),
                        infos: infos,
                        privatetoken: site.getPrivateToken(),
                        config: config,
                        loggedout: site.isLoggedOut() ? 1 : 0
                    }).finally(function() {
                        $mmEvents.trigger(mmCoreEventSiteUpdated, siteid);
                    });
                });
            });
        });
    };
    self.updateSiteInfoByUrl = function(siteurl, username) {
        var siteid = self.createSiteID(siteurl, username);
        return self.updateSiteInfo(siteid);
    };
    self.getSiteIdsFromUrl = function(url, prioritize, username) {
        if (prioritize && currentSite && currentSite.containsUrl(url)) {
            if (!username || currentSite.getInfo().username == username) {
                return $q.when([currentSite.getId()]);
            }
        }
        if (!url.match(/^https?:\/\//i)) {
            if ($mmUtil.isAbsoluteURL(url)) {
                return $q.when([]);
            } else {
                if (currentSite) {
                    return $q.when([currentSite.getId()]);
                } else {
                    return $q.when([]);
                }
            }
        }
        return $mmApp.getDB().getAll(mmCoreSitesStore).then(function(sites) {
            var ids = [];
            angular.forEach(sites, function(site) {
                if (!sites[site.id]) {
                    sites[site.id] = $mmSitesFactory.makeSite(
                            site.id, site.siteurl, site.token, site.infos, site.privatetoken, site.config, site.loggedout);
                }
                if (sites[site.id].containsUrl(url)) {
                    if (!username || sites[site.id].getInfo().username == username) {
                        ids.push(site.id);
                    }
                }
            });
            return ids;
        }).catch(function() {
            return [];
        });
    };
    self.getStoredCurrentSiteId = function() {
        return $mmApp.getDB().get(mmCoreCurrentSiteStore, 1).then(function(current_site) {
            return current_site.siteid;
        });
    };
    self.getSitePublicConfig = function(siteUrl) {
        var temporarySite = $mmSitesFactory.makeSite(undefined, siteUrl);
        return temporarySite.getPublicConfig();
    };
    function getSiteConfig(site) {
        if (!site.wsAvailable('tool_mobile_get_config')) {
            return $q.when();
        }
        return site.getConfig(false, true);
    }
    self.isFeatureDisabled = function(name, siteId) {
        return self.getSite(siteId).then(function(site) {
            return site.isFeatureDisabled(name);
        });
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmCoreSynchronizationStore', 'sync')
.constant('mmCoreSynchronizationWarningsStore', 'sync_warnings')
.config(["$mmSitesFactoryProvider", "mmCoreSynchronizationStore", "mmCoreSynchronizationWarningsStore", function($mmSitesFactoryProvider, mmCoreSynchronizationStore, mmCoreSynchronizationWarningsStore) {
    var stores = [
        {
            name: mmCoreSynchronizationStore,
            keyPath: ['component', 'id'],
            indexes: []
        },
        {
            name: mmCoreSynchronizationWarningsStore,
            keyPath: ['component', 'id'],
            indexes: []
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.factory('$mmSync', ["$q", "$log", "$mmSitesManager", "$mmSite", "mmCoreSynchronizationStore", "mmCoreSynchronizationWarningsStore", function($q, $log, $mmSitesManager, $mmSite, mmCoreSynchronizationStore, mmCoreSynchronizationWarningsStore) {
    $log = $log.getInstance('$mmSync');
    var self = {},
        mmSync = (function () {
            var syncPromises = {}; 
            this.component = 'core';
            this.syncInterval = 300000;
            this.getSyncTime = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                var that = this;
                return $mmSitesManager.getSiteDb(siteId).then(function(db) {
                    return db.get(mmCoreSynchronizationStore, [that.component, id]).then(function(entry) {
                        return entry.time;
                    }).catch(function() {
                        return 0;
                    });
                });
            };
            this.setSyncTime = function(id, siteId, time) {
                siteId = siteId || $mmSite.getId();
                var that = this;
                return $mmSitesManager.getSiteDb(siteId).then(function(db) {
                    var entry = {
                            id: id,
                            component: that.component,
                            time: typeof time != 'undefined' ? time : new Date().getTime()
                        };
                    return db.insert(mmCoreSynchronizationStore, entry);
                });
            };
            this.isSyncNeeded = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                var that = this;
                return this.getSyncTime(id, siteId).then(function(time) {
                    return new Date().getTime() - that.syncInterval >= time;
                });
            };
            this.isSyncing = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                var uniqueId = this.getUniqueSyncId(id);
                return !!(syncPromises[siteId] && syncPromises[siteId][uniqueId]);
            };
            this.waitForSync = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                if (this.isSyncing(id, siteId)) {
                    var uniqueId = this.getUniqueSyncId(id);
                    return syncPromises[siteId][uniqueId].catch(function() {});
                }
                return $q.when();
            };
            this.getOngoingSync = function (id, siteId) {
                siteId = siteId || $mmSite.getId();
                if (this.isSyncing(id, siteId)) {
                    var uniqueId = this.getUniqueSyncId(id);
                    return syncPromises[siteId][uniqueId];
                }
                return false;
            };
            this.addOngoingSync = function (id, promise, siteId) {
                var uniqueId = this.getUniqueSyncId(id);
                siteId = siteId || $mmSite.getId();
                if (!syncPromises[siteId]) {
                    syncPromises[siteId] = {};
                }
                syncPromises[siteId][uniqueId] = promise;
                return promise.finally(function() {
                    delete syncPromises[siteId][uniqueId];
                });
            };
            this.getUniqueSyncId = function(id) {
                return this.component + '#' + id;
            };
            this.getSyncWarnings = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                var that = this;
                return $mmSitesManager.getSiteDb(siteId).then(function(db) {
                    return db.get(mmCoreSynchronizationWarningsStore, [that.component, id]).then(function(entry) {
                        return entry.warnings;
                    }).catch(function() {
                        return [];
                    });
                });
            };
            this.setSyncWarnings = function(id, warnings, siteId) {
                siteId = siteId || $mmSite.getId();
                var that = this;
                return $mmSitesManager.getSiteDb(siteId).then(function(db) {
                    var entry = {
                        id: id,
                        component: that.component,
                        warnings: typeof warnings != 'undefined' ? warnings : []
                    };
                    return db.insert(mmCoreSynchronizationWarningsStore, entry);
                });
            };
            return this;
        }());
    self.createChild = function(component, syncInterval) {
        var child = Object.create(mmSync);
        child.component = component;
        if (typeof syncInterval != 'undefined') {
            child.syncInterval = syncInterval;
        }
        return child;
    };
    return self;
}]);
angular.module('mm.core')
.factory('$mmSyncBlock', ["$log", "$mmSite", function($log, $mmSite) {
    $log = $log.getInstance('$mmSyncBlock');
    var self = {
        blockedItems: {} 
    };
    self.isBlocked = function(component, id, siteId) {
        siteId = siteId || $mmSite.getId();
        var uniqueId = getUniqueSyncBlockId(component, id);
        if (!self.blockedItems[siteId]) {
            return false;
        }
        if (!self.blockedItems[siteId][uniqueId]) {
            return false;
        }
        return Object.keys(self.blockedItems[siteId][uniqueId]).length > 0;
    };
    self.blockOperation = function(component, id, operation, siteId) {
        siteId = siteId || $mmSite.getId();
        var uniqueId = getUniqueSyncBlockId(component, id);
        if (!self.blockedItems[siteId]) {
            self.blockedItems[siteId] = {};
        }
        if (!self.blockedItems[siteId][uniqueId]) {
            self.blockedItems[siteId][uniqueId] = {};
        }
        operation = operation || '-';
        self.blockedItems[siteId][uniqueId][operation] = true;
    };
    self.unblockOperation = function(component, id, operation, siteId) {
        siteId = siteId || $mmSite.getId();
        var uniqueId = getUniqueSyncBlockId(component, id);
        if (self.blockedItems[siteId]) {
            if (self.blockedItems[siteId][uniqueId]) {
                operation = operation || '-';
                delete self.blockedItems[siteId][uniqueId][operation];
            }
        }
    };
    self.clearBlock = function(component, id, iteId) {
        siteId = siteId || $mmSite.getId();
        var uniqueId = getUniqueSyncBlockId(component, id);
        if (self.blockedItems[siteId]) {
            delete self.blockedItems[siteId][uniqueId];
        }
    };
    self.clearAllBlocks = function(siteId) {
        if (siteId) {
            delete self.blockedItems[siteId];
        } else {
            self.blockedItems = {};
        }
    };
    function getUniqueSyncBlockId(component, id) {
        return component + '#' + id;
    }
    return self;
}])
.run(["$mmSyncBlock", "$mmEvents", "mmCoreEventLogout", function($mmSyncBlock, $mmEvents, mmCoreEventLogout) {
    $mmEvents.on(mmCoreEventLogout, function(siteId) {
        $mmSyncBlock.clearAllBlocks(siteId);
    });
}]);
angular.module('mm.core')
.factory('$mmText', ["$q", "$mmLang", "$translate", "$state", function($q, $mmLang, $translate, $state) {
    var self = {},
        element = document.createElement('div'); 
    self.buildMessage = function(messages) {
        var result = '';
        angular.forEach(messages, function(message) {
            if (message) {
                result = result + '<p>' + message + '</p>';
            }
        });
        return result;
    };
    self.bytesToSize = function(bytes, precision) {
        if (typeof bytes == 'undefined' || bytes < 0) {
            return $translate.instant('mm.core.notapplicable');
        }
        if (typeof precision == 'undefined' || precision < 0) {
            precision = 2;
        }
        var keys = ['mm.core.sizeb', 'mm.core.sizekb', 'mm.core.sizemb', 'mm.core.sizegb', 'mm.core.sizetb'];
        var units = $translate.instant(keys);
        var posttxt = 0;
        if (bytes >= 1024) {
            while (bytes >= 1024) {
                posttxt++;
                bytes = bytes / 1024;
            }
            bytes = Number(Math.round(bytes+'e+'+precision) + 'e-'+precision); 
        }
        return $translate.instant('mm.core.humanreadablesize', {size: Number(bytes), unit: units[keys[posttxt]]});
    };
    self.cleanTags = function(text, singleLine) {
        if (!text) {
            return '';
        }
        if (!text.replace) {
            return text;
        }
        text = text.replace(/(<([^>]+)>)/ig,"");
        text = angular.element('<p>').html(text).text(); 
        text = self.replaceNewLines(text, singleLine ? ' ' : '<br>');
        return text;
    };
    self.replaceNewLines = function(text, newValue) {
        return text.replace(/(?:\r\n|\r|\n)/g, newValue);
    };
    self.formatText = function(text, clean, singleLine, shortenLength) {
        return self.treatMultilangTags(text).then(function(formatted) {
            if (clean) {
                formatted = self.cleanTags(formatted, singleLine);
            }
            if (shortenLength && parseInt(shortenLength) > 0) {
                formatted = self.shortenText(formatted, parseInt(shortenLength));
            }
            return formatted;
        });
    };
    self.formatHtmlLines = function(text) {
        var hasHTMLTags = self.hasHTMLTags(text);
        if (text.indexOf('<p>') == -1) {
            text = '<p>' + text + '</p>';
        }
        if (!hasHTMLTags) {
            return self.replaceNewLines(text, '<br>');
        }
        return text;
    };
    self.shortenText = function(text, length) {
        if (text.length > length) {
            text = text.substr(0, length);
            var lastWordPos = text.lastIndexOf(' ');
            if (lastWordPos > 0) {
                text = text.substr(0, lastWordPos);
            }
            text += '&hellip;';
        }
        return text;
    };
    self.expandText = function(title, text, replaceLineBreaks, component, componentId) {
        if (text.length > 0) {
            $state.go('site.mm_textviewer', {
                title: title,
                content: text,
                replacelinebreaks: replaceLineBreaks,
                component: component,
                componentId: componentId
            });
        }
    };
    self.treatMultilangTags = function(text) {
        if (!text) {
            return $q.when('');
        }
        return $mmLang.getCurrentLanguage().then(function(language) {
            var currentLangRe = new RegExp('<(?:lang|span)[^>]+lang="' + language + '"[^>]*>(.*?)<\/(?:lang|span)>', 'g'),
                anyLangRE = /<(?:lang|span)[^>]+lang="[a-zA-Z0-9_-]+"[^>]*>(.*?)<\/(?:lang|span)>/g;
            if (!text.match(currentLangRe)) {
                var matches = text.match(anyLangRE);
                if (matches && matches[0]) {
                    language = matches[0].match(/lang="([a-zA-Z0-9_-]+)"/)[1];
                    currentLangRe = new RegExp('<(?:lang|span)[^>]+lang="' + language + '"[^>]*>(.*?)<\/(?:lang|span)>', 'g');
                } else {
                    return text;
                }
            }
            text = text.replace(currentLangRe, '$1');
            text = text.replace(anyLangRE, '');
            return text;
        });
    };
    self.escapeHTML = function(text) {
        if (typeof text == 'undefined' || text === null || (typeof text == 'number' && isNaN(text))) {
            return '';
        } else if (typeof text != 'string') {
            return '' + text;
        }
        return text
            .replace(/&/g, "&amp;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#039;");
    };
    self.decodeHTML = function(text) {
        if (typeof text == 'undefined' || text === null || (typeof text == 'number' && isNaN(text))) {
            return '';
        } else if (typeof text != 'string') {
            return '' + text;
        }
        return text
            .replace(/&amp;/g, '&')
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>')
            .replace(/&quot;/g, '"')
            .replace(/&#039;/g, "'")
            .replace(/&nbsp;/g, ' ');
    };
    self.decodeHTMLEntities = function(text) {
        if (text && typeof text === 'string') {
            element.innerHTML = text;
            text = element.textContent;
            element.textContent = '';
        }
        return text;
    };
    self.addOrRemoveWWW = function(url) {
        if (typeof url == 'string') {
            if (url.match(/http(s)?:\/\/www\./)) {
                url = url.replace('www.', '');
            } else {
                url = url.replace('https://', 'https://www.');
                url = url.replace('http://', 'http://www.');
            }
        }
        return url;
    };
    self.removeProtocolAndWWW = function(url) {
        url = url.replace(/.*?:\/\//g, '');
        url = url.replace(/^www./, '');
        return url;
    };
    self.getUsernameFromUrl = function(url) {
        if (url.indexOf('@') > -1) {
            var withoutProtocol = url.replace(/.*?:\/\//, ''),
                matches = withoutProtocol.match(/[^@]*/);
            if (matches && matches.length && !matches[0].match(/[\/|?]/)) {
                return matches[0];
            }
        }
    };
    self.removeSpecialCharactersForFiles = function(text) {
        return text.replace(/[#:\/\?\\]+/g, '_');
    };
    self.getLastFileWithoutParams = function(url) {
        var filename = url.substr(url.lastIndexOf('/') + 1);
        if (filename.indexOf('?') != -1) {
            filename = filename.substr(0, filename.indexOf('?'));
        }
        return filename;
    };
    self.twoDigits = function(num) {
        if (num < 10) {
            return '0' + num;
        } else {
            return '' + num; 
        }
    };
    self.escapeForRegex = function(text) {
        if (!text || !text.replace) {
            return '';
        }
        return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    };
    self.countWords = function(text) {
        text = text.replace(/<script[^>]*>([\S\s]*?)<\/script>/gmi, '');
        text = text.replace(/<\/?(?!\!)[^>]*>/gi, '');
        text = self.decodeHTMLEntities(text);
        text = text.replace(/_/gi, " ");
        return text.match(/\S+/gi).length;
    };
    self.getTextPluginfileUrl = function(files) {
        if (files && files.length) {
            var fileURL = files[0].url || files[0].fileurl;
            return fileURL.substr(0, Math.max(fileURL.lastIndexOf('/'), fileURL.lastIndexOf('%2F')));
        }
        return false;
    };
    self.replacePluginfileUrls = function(text, files) {
        if (text) {
            var fileURL = self.getTextPluginfileUrl(files);
            if (fileURL) {
                return text.replace(/@@PLUGINFILE@@/g, fileURL);
            }
        }
        return text;
    };
    self.restorePluginfileUrls = function(text, files) {
        if (text) {
            var fileURL = self.getTextPluginfileUrl(files);
            if (fileURL) {
                return text.replace(new RegExp(self.escapeForRegex(fileURL), 'g'), '@@PLUGINFILE@@');
            }
        }
        return text;
    };
    self.getUrlProtocol = function(url) {
        if (!url) {
            return;
        }
        var matches = url.match(/^([^\/:\.\?]*):\/\//);
        if (matches && matches[1]) {
            return matches[1];
        }
    };
    self.getUrlScheme = function(url) {
        if (!url) {
            return;
        }
        var matches = url.match(/^([a-z][a-z0-9+\-.]*):/);
        if (matches && matches[1]) {
            return matches[1];
        }
    };
    self.hasHTMLTags = function(text) {
        return /<[a-z][\s\S]*>/i.test(text);
    };
    self.hasUnicode = function(text) {
        for (var x = 0; x < text.length; x++) {
            if (text.charCodeAt(x) > 55295) {
                return true;
            }
        }
        return false;
    };
    self.hasUnicodeData = function(data) {
        for (var el in data) {
            if (angular.isObject(data[el])) {
                if (self.hasUnicodeData(data[el])) {
                    return true;
                }
            } else if (typeof data[el] == "string" && self.hasUnicode(data[el])) {
                return true;
            }
        }
        return false;
    };
    self.stripUnicode = function(text) {
        var stripped = "";
        for (var x = 0; x < text.length; x++) {
            if (text.charCodeAt(x) <= 55295){
                stripped += text.charAt(x);
            }
        }
        return stripped;
    };
    self.decodeURI = function(uri) {
        try {
            return decodeURI(uri);
        } catch(ex) {
        }
        return uri;
    };
    self.decodeURIComponent = function(uri) {
        try {
            return decodeURIComponent(uri);
        } catch(ex) {
        }
        return uri;
    };
    self.parseJSON = function(json) {
        try {
            return JSON.parse(json);
        } catch(ex) {
        }
        return json;
    };
    self.s = function(text) {
        if (!text && text !== '') {
            return '0';
        }
        return self.escapeHTML(text).replace(/&amp;#(\d+|x[0-9a-f]+);/i, '&#$1;');
    };
    self.ucFirst = function(text) {
        return text.charAt(0).toUpperCase() + text.slice(1);
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmCoreVersionApplied', 'version_applied')
.factory('$mmUpdateManager', ["$log", "$q", "$mmConfig", "$mmSitesManager", "$mmFS", "$cordovaLocalNotification", "$mmLocalNotifications", "$mmApp", "$mmEvents", "mmCoreSitesStore", "mmCoreVersionApplied", "mmCoreEventSiteAdded", "mmCoreEventSiteUpdated", "mmCoreEventSiteDeleted", "$injector", "$mmFilepool", "mmCoreCourseModulesStore", "mmFilepoolLinksStore", "$mmAddonManager", "mmFilepoolPackagesStore", "mmCoreConfigConstants", function($log, $q, $mmConfig, $mmSitesManager, $mmFS, $cordovaLocalNotification, $mmLocalNotifications,
            $mmApp, $mmEvents, mmCoreSitesStore, mmCoreVersionApplied, mmCoreEventSiteAdded, mmCoreEventSiteUpdated,
            mmCoreEventSiteDeleted, $injector, $mmFilepool, mmCoreCourseModulesStore, mmFilepoolLinksStore, $mmAddonManager,
            mmFilepoolPackagesStore, mmCoreConfigConstants) {
    $log = $log.getInstance('$mmUpdateManager');
    var self = {},
        sitesFilePath = 'migration/sites.json';
    self.check = function() {
        var promises = [],
            versionCode = mmCoreConfigConstants.versioncode;
        return $mmConfig.get(mmCoreVersionApplied, 0).then(function(versionApplied) {
            if (versionCode >= 391 && versionApplied < 391) {
                promises.push(migrateMM1Sites());
                promises.push(clearAppFolder().catch(function() {}));
            }
            if (versionCode >= 2003 && versionApplied < 2003) {
                promises.push(cancelAndroidNotifications());
            }
            if (versionCode >= 2003) {
                setStoreSitesInFile();
            }
            if (versionCode >= 2007 && versionApplied < 2007) {
                promises.push(migrateModulesStatus());
            }
            if (versionCode >= 2013 && versionApplied < 2013) {
                promises.push(migrateFileExtensions());
            }
            if (versionCode >= 2017 && versionApplied < 2017) {
                promises.push(setCalendarDefaultNotifTime());
                promises.push(setSitesConfig());
                promises.push(migrateWikiNewPagesStore());
            }
            if (versionCode >= 2018 && versionApplied < 2018) {
                promises.push(adaptForumOfflineStores());
            }
            return $q.all(promises).then(function() {
                return $mmConfig.set(mmCoreVersionApplied, versionCode);
            }).catch(function() {
                $log.error('Error applying update from ' + versionApplied + ' to ' + versionCode);
            });
        });
    };
    function clearAppFolder() {
        if ($mmFS.isAvailable()) {
            return $mmFS.getDirectoryContents('').then(function(entries) {
                var promises = [];
                angular.forEach(entries, function(entry) {
                    var canDeleteAndroid = ionic.Platform.isAndroid() && entry.name !== 'cache' && entry.name !== 'files';
                    var canDeleteIOS = ionic.Platform.isIOS() && entry.name !== 'NoCloud';
                    if (canDeleteIOS || canDeleteAndroid) {
                        promises.push($mmFS.removeDir(entry.name));
                    }
                });
                return $q.all(promises);
            });
        } else {
            return $q.when();
        }
    }
    function migrateMM1Sites() {
        var sites = localStorage.getItem('sites'),
            promises = [];
        if (sites) {
            sites = sites.split(',');
            angular.forEach(sites, function(siteid) {
                if (!siteid) {
                    return;
                }
                $log.debug('Migrating site from MoodleMobile 1: ' + siteid);
                var site = localStorage.getItem('sites-'+siteid),
                    infos;
                if (site) {
                    try {
                        site = JSON.parse(site);
                    } catch(ex) {
                        $log.warn('Site ' + siteid + ' data is invalid. Ignoring.');
                        return;
                    }
                    infos = angular.copy(site);
                    delete infos.id;
                    delete infos.token;
                    promises.push($mmSitesManager.addSite(site.id, site.siteurl, site.token, infos));
                } else {
                    $log.warn('Site ' + siteid + ' not found in local storage. Ignoring.');
                }
            });
        }
        return $q.all(promises).then(function() {
            if (sites) {
                localStorage.clear();
            }
        });
    }
    function cancelAndroidNotifications() {
        if ($mmLocalNotifications.isAvailable() && ionic.Platform.isAndroid()) {
            return $cordovaLocalNotification.cancelAll().catch(function() {
                $log.error('Error cancelling Android notifications.');
            });
        }
        return $q.when();
    }
    function setStoreSitesInFile() {
        $mmEvents.on(mmCoreEventSiteAdded, storeSitesInFile);
        $mmEvents.on(mmCoreEventSiteUpdated, storeSitesInFile);
        $mmEvents.on(mmCoreEventSiteDeleted, storeSitesInFile);
        storeSitesInFile();
    }
    function getSitesStoredInFile() {
        if ($mmFS.isAvailable()) {
            return $mmFS.readFile(sitesFilePath).then(function(sites) {
                try {
                    sites = JSON.parse(sites);
                } catch (ex) {
                    sites = [];
                }
                return sites;
            }).catch(function() {
                return [];
            });
        } else {
            return $q.when([]);
        }
    }
    function storeSitesInFile() {
        if ($mmFS.isAvailable()) {
            return $mmApp.getDB().getAll(mmCoreSitesStore).then(function(sites) {
                angular.forEach(sites, function(site) {
                    site.token = 'private'; 
                });
                return $mmFS.writeFile(sitesFilePath, JSON.stringify(sites));
            });
        } else {
            return $q.when();
        }
    }
    function deleteSitesFile() {
        if ($mmFS.isAvailable()) {
            return $mmFS.removeFile(sitesFilePath);
        } else {
            return $q.when();
        }
    }
    function migrateModulesStatus() {
        var components = [];
        components.push($injector.get('mmaModBookComponent'));
        components.push($injector.get('mmaModImscpComponent'));
        components.push($injector.get('mmaModPageComponent'));
        components.push($injector.get('mmaModResourceComponent'));
        return $mmSitesManager.getSitesIds().then(function(sites) {
            var promises = [];
            angular.forEach(sites, function(siteId) {
                promises.push(migrateSiteModulesStatus(siteId, components));
            });
            return $q.all(promises);
        });
    }
    function migrateSiteModulesStatus(siteId, components) {
        $log.debug('Migrate site modules status from site ' + siteId);
        return $mmSitesManager.getSiteDb(siteId).then(function(db) {
            return db.getAll(mmCoreCourseModulesStore).then(function(entries) {
                var promises = [];
                angular.forEach(entries, function(entry) {
                    if (!parseInt(entry.id)) {
                        return; 
                    }
                    promises.push(determineComponent(db, entry.id, components).then(function(component) {
                        if (component) {
                            entry.component = component;
                            entry.componentId = entry.id;
                            entry.id = $mmFilepool.getPackageId(component, entry.id);
                            promises.push(db.insert(mmFilepoolPackagesStore, entry));
                        }
                    }));
                });
                return $q.all(promises).then(function() {
                    return db.removeAll(mmCoreCourseModulesStore).catch(function() {
                    });
                });
            });
        });
    }
    function migrateFileExtensions() {
        return $mmSitesManager.getSitesIds().then(function(sites) {
            var promises = [];
            angular.forEach(sites, function(siteId) {
                promises.push($mmFilepool.fillMissingExtensionInFiles(siteId));
            });
            promises.push($mmFilepool.treatExtensionInQueue());
            return $q.all(promises);
        });
    }
    function determineComponent(db, componentId, components) {
        var promises = [],
            component;
        angular.forEach(components, function(c) {
            if (c) {
                promises.push(db.whereEqual(mmFilepoolLinksStore, 'componentAndId', [c, componentId]).then(function(items) {
                    if (items.length) {
                        component = c;
                    }
                }).catch(function() {
                }));
            }
        });
        return $q.all(promises).then(function() {
            return component;
        });
    }
    function setCalendarDefaultNotifTime() {
        if (!$mmLocalNotifications.isAvailable()) {
            return $q.when();
        }
        var $mmaCalendar = $mmAddonManager.get('$mmaCalendar'),
            mmaCalendarDefaultNotifTime = $mmAddonManager.get('mmaCalendarDefaultNotifTime');
        if (!$mmaCalendar || typeof mmaCalendarDefaultNotifTime == 'undefined') {
            return $q.when();
        }
        return $mmSitesManager.getSitesIds().then(function(siteIds) {
            var promises = [];
            angular.forEach(siteIds, function(siteId) {
                promises.push($mmaCalendar.getAllEventsFromLocalDb(siteId).then(function(events) {
                    var eventPromises = [];
                    angular.forEach(events, function(event) {
                        if (event.notificationtime == mmaCalendarDefaultNotifTime) {
                            event.notificationtime = -1;
                            eventPromises.push($mmaCalendar.storeEventInLocalDb(event, siteId));
                        }
                    });
                    return $q.all(eventPromises);
                }));
            });
            return $q.all(promises);
        });
    }
    function setSitesConfig() {
        return $mmSitesManager.getSitesIds().then(function(siteIds) {
            return $mmSitesManager.getStoredCurrentSiteId().catch(function() {
            }).then(function(currentSiteId) {
                var promise;
                if (currentSiteId) {
                    promise = setSiteConfig(currentSiteId);
                } else {
                    promise = $q.when();
                }
                angular.forEach(siteIds, function(siteId) {
                    if (siteId != currentSiteId) {
                        setSiteConfig(siteId);
                    }
                });
                return promise;
            });
        });
    }
    function setSiteConfig(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            if (site.getStoredConfig() || !site.wsAvailable('tool_mobile_get_config')) {
                return;
            }
            return site.getConfig().then(function(config) {
                return $mmSitesManager.addSite(site.getId(), site.getURL(),
                        site.getToken(), site.getInfo(), site.getPrivateToken(), config);
            }).catch(function() {
            });
        });
    }
    function migrateWikiNewPagesStore() {
        return $mmSitesManager.getSitesIds().then(function(siteIds) {
            return $mmSitesManager.getStoredCurrentSiteId().catch(function() {
            }).then(function(currentSiteId) {
                var promise;
                if (currentSiteId) {
                    promise = migrateWikiNewPagesSiteStore(currentSiteId);
                } else {
                    promise = $q.when();
                }
                angular.forEach(siteIds, function(siteId) {
                    if (siteId != currentSiteId) {
                        migrateWikiNewPagesSiteStore(siteId);
                    }
                });
                return promise;
            });
        });
    }
    function migrateWikiNewPagesSiteStore(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var $mmaModWikiOffline = $injector.get('$mmaModWikiOffline'),
                oldStorageName = 'mma_mod_wiki_new_pages', 
                db = site.getDb();
            try {
                return db.getAll(oldStorageName).then(function(pages) {
                    if (pages.length > 0) {
                        $log.debug('Found ' + pages.length + ' new wiki pages from old store to migrate on site' + siteId);
                        var promises = [];
                        angular.forEach(pages, function(page) {
                            if (page.subwikiid > 0) {
                                promises.push($mmaModWikiOffline.saveNewPage(page.title, page.cachedcontent, page.subwikiid, 0, 0,
                                    0, siteId));
                            }
                        });
                        return $q.all(promises).finally(function() {
                            db.removeAll(oldStorageName);
                        });
                    }
                }).catch(function() {
                    return $q.when();
                });
            } catch (e) {
            }
            return $q.when();
        });
    }
    function adaptForumOfflineStores() {
        return $mmSitesManager.getSitesIds().then(function(siteIds) {
            return $mmSitesManager.getStoredCurrentSiteId().catch(function() {
            }).then(function(currentSiteId) {
                var promise;
                if (currentSiteId) {
                    promise = adaptForumOfflineSiteStores(currentSiteId);
                } else {
                    promise = $q.when();
                }
                angular.forEach(siteIds, function(siteId) {
                    if (siteId != currentSiteId) {
                        adaptForumOfflineSiteStores(siteId);
                    }
                });
                return promise;
            });
        });
    }
    function adaptForumOfflineSiteStores(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var promises = [],
                $mmaModForumOffline = $injector.get('$mmaModForumOffline'),
                mmaModForumOfflineDiscussionsStore = $injector.get('mmaModForumOfflineDiscussionsStore'),
                mmaModForumOfflineRepliesStore = $injector.get('mmaModForumOfflineRepliesStore');
            promises.push($mmaModForumOffline.getAllNewDiscussions(siteId).then(function(discs) {
                var subPromises = [];
                angular.forEach(discs, function(disc) {
                    disc.options = {
                        discussionsubscribe: disc.subscribe
                    };
                    if (disc.attachments) {
                        disc.options.attachmentsid = disc.attachments;
                    }
                    delete disc.subscribe;
                    delete disc.attachments;
                    subPromises.push(site.getDb().insert(mmaModForumOfflineDiscussionsStore, disc));
                });
                return $q.all(subPromises);
            }));
            promises.push($mmaModForumOffline.getAllReplies(siteId).then(function(replies) {
                var subPromises = [];
                angular.forEach(replies, function(reply) {
                    reply.options = {};
                    if (reply.attachments) {
                        reply.options.attachmentsid = reply.attachments;
                    }
                    delete reply.attachments;
                    subPromises.push(site.getDb().insert(mmaModForumOfflineRepliesStore, reply));
                });
                return $q.all(subPromises);
            }));
            return $q.all(promises);
        });
    }
    return self;
}]);

angular.module('mm.core')
.factory('$mmURLDelegate', ["$log", function($log) {
    $log = $log.getInstance('$mmURLDelegate');
    var observers = {},
        self = {},
        lastUrls = {};
    self.register = function(name, callback) {
        $log.debug("Register observer '"+name+"' for custom URL.");
        observers[name] = callback;
    };
    self.notify = function(url) {
        var treated = false; 
        if (lastUrls[url] && Date.now() - lastUrls[url] < 3000) {
            return;
        }
        lastUrls[url] = Date.now();
        angular.forEach(observers, function(callback) {
            if (!treated && typeof(callback) === 'function') {
                treated = callback(url);
            }
        });
    };
    return self;
}])
.run(["$mmURLDelegate", "$log", function($mmURLDelegate, $log) {
    window.handleOpenURL = function(url) {
        $log.debug('App launched by URL. ' + url);
        $mmURLDelegate.notify(url);
    };
}]);

angular.module('mm.core')
.provider('$mmUtil', ["mmCoreSecondsYear", "mmCoreSecondsDay", "mmCoreSecondsHour", "mmCoreSecondsMinute", function(mmCoreSecondsYear, mmCoreSecondsDay, mmCoreSecondsHour, mmCoreSecondsMinute) {
    var self = this, 
        provider = this; 
    self.param = function(obj, addNull) {
        var query = '', name, value, fullSubName, subName, subValue, innerObj, i;
        for (name in obj) {
            value = obj[name];
            if (value instanceof Array) {
                for (i = 0; i < value.length; ++i) {
                    subValue = value[i];
                    fullSubName = name + '[' + i + ']';
                    innerObj = {};
                    innerObj[fullSubName] = subValue;
                    query += self.param(innerObj) + '&';
                }
            } else if (value instanceof Object) {
                for (subName in value) {
                    subValue = value[subName];
                    fullSubName = name + '[' + subName + ']';
                    innerObj = {};
                    innerObj[fullSubName] = subValue;
                    query += self.param(innerObj) + '&';
                }
            } else if (addNull || (value !== undefined && value !== null)) {
                query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
            }
        }
        return query.length ? query.substr(0, query.length - 1) : query;
    };
    this.$get = ["$ionicLoading", "$ionicPopup", "$injector", "$translate", "$http", "$log", "$q", "$mmLang", "$mmFS", "$timeout", "$mmApp", "$mmText", "mmCoreWifiDownloadThreshold", "mmCoreDownloadThreshold", "$ionicScrollDelegate", "$mmWS", "$cordovaInAppBrowser", "$mmConfig", "mmCoreSettingsRichTextEditor", "$rootScope", "$ionicPlatform", "$ionicHistory", "mmCoreSplitViewBlock", "$state", "$window", "$cordovaClipboard", "mmCoreDontShowError", function($ionicLoading, $ionicPopup, $injector, $translate, $http, $log, $q, $mmLang, $mmFS, $timeout, $mmApp,
                $mmText, mmCoreWifiDownloadThreshold, mmCoreDownloadThreshold, $ionicScrollDelegate, $mmWS, $cordovaInAppBrowser,
                $mmConfig, mmCoreSettingsRichTextEditor, $rootScope, $ionicPlatform, $ionicHistory, mmCoreSplitViewBlock, $state,
                $window, $cordovaClipboard, mmCoreDontShowError) {
        $log = $log.getInstance('$mmUtil');
        var self = {}, 
            matchesFn,
            inputSupportKeyboard = ['date', 'datetime', 'datetime-local', 'email', 'month', 'number', 'password',
                'search', 'tel', 'text', 'time', 'url', 'week'],
            originalBackFunction = $rootScope.$ionicGoBack,
            backFunctionsStack = [originalBackFunction],
            toastPromise;
        self.formatURL = function(url) {
            url = url.trim();
            if (! /^http(s)?\:\/\/.*/i.test(url)) {
                url = "https://" + url;
            }
            url = url.replace(/^http/i, 'http');
            url = url.replace(/^https/i, 'https');
            url = url.replace(/\/$/, "");
            return url;
        };
        self.resolveObject = function(object, instantiate) {
            var toInject,
                resolved;
            instantiate = angular.isUndefined(instantiate) ? false : instantiate;
            if (angular.isFunction(object) || angular.isObject(object)) {
                resolved = object;
            } else if (angular.isString(object)) {
                toInject = object.split('.');
                resolved = $injector.get(toInject[0]);
                if (toInject.length > 1) {
                    resolved = resolved[toInject[1]];
                }
            }
            if (angular.isFunction(resolved) && instantiate) {
                resolved = resolved();
            }
            if (typeof resolved === 'undefined') {
                throw new Error('Unexpected argument object passed');
            }
            return resolved;
        };
        self.isDownloadableUrl = function(url) {
            return self.isPluginFileUrl(url) || self.isThemeImageUrl(url) || self.isGravatarUrl(url);
        };
        self.isGravatarUrl = function(url) {
            return url && url.indexOf('gravatar.com/avatar') !== -1;
        };
        self.isPluginFileUrl = function(url) {
            return url && url.indexOf('/pluginfile.php') !== -1;
        };
        self.isAbsoluteURL = function(url) {
            return /^[^:]{2,}:\/\//i.test(url) || /^(tel:|mailto:|geo:)/.test(url);
        };
        self.isThemeImageUrl = function(url) {
            return url && url.indexOf('/theme/image.php') !== -1;
        };
        self.isValidURL = function(url) {
            return /^http(s)?\:\/\/.+/i.test(url);
        };
        self.fixPluginfileURL = function(url, token) {
            if (!url) {
                return '';
            }
            if (url.indexOf('token=') != -1) {
                return url;
            }
            if (url.indexOf('pluginfile') == -1) {
                return url;
            }
            if (!token) {
                return '';
            }
            if (url.indexOf('?file=') != -1 || url.indexOf('?forcedownload=') != -1 || url.indexOf('?rev=') != -1) {
                url += '&';
            } else {
                url += '?';
            }
            url += 'token=' + token + '&offline=1';
            if (url.indexOf('/webservice/pluginfile') == -1) {
                url = url.replace('/pluginfile', '/webservice/pluginfile');
            }
            return url;
        };
        self.openFile = function(path) {
            var deferred = $q.defer();
            if ($mmApp.isDesktop()) {
                if (require('electron').ipcRenderer.sendSync('openItem', path)) {
                    deferred.resolve();
                } else {
                    $mmLang.translateAndRejectDeferred(deferred, 'mm.core.erroropenfilenoapp');
                }
            } else if (window.plugins) {
                var extension = $mmFS.getFileExtension(path),
                    mimetype = $mmFS.getMimeType(extension);
                if (ionic.Platform.isAndroid() && window.plugins.webintent) {
                    var iParams = {
                        action: "android.intent.action.VIEW",
                        url: path,
                        type: mimetype
                    };
                    window.plugins.webintent.startActivity(
                        iParams,
                        function() {
                            $log.debug('Intent launched');
                            deferred.resolve();
                        },
                        function() {
                            $log.debug('Intent launching failed.');
                            $log.debug('action: ' + iParams.action);
                            $log.debug('url: ' + iParams.url);
                            $log.debug('type: ' + iParams.type);
                            if (!extension || extension.indexOf('/') > -1 || extension.indexOf('\\') > -1) {
                                $mmLang.translateAndRejectDeferred(deferred, 'mm.core.erroropenfilenoextension');
                            } else {
                                $mmLang.translateAndRejectDeferred(deferred, 'mm.core.erroropenfilenoapp');
                            }
                        }
                    );
                } else if (ionic.Platform.isIOS() && typeof handleDocumentWithURL == 'function') {
                    $mmFS.getBasePath().then(function(fsRoot) {
                        if (path.indexOf(fsRoot > -1)) {
                            path = path.replace(fsRoot, "");
                            path = encodeURIComponent($mmText.decodeURIComponent(path));
                            path = fsRoot + path;
                        }
                        handleDocumentWithURL(
                            function() {
                                $log.debug('File opened with handleDocumentWithURL' + path);
                                deferred.resolve();
                            },
                            function(error) {
                                $log.debug('Error opening with handleDocumentWithURL' + path);
                                if(error == 53) {
                                    $log.error('No app that handles this file type.');
                                }
                                self.openInBrowser(path);
                                deferred.resolve();
                            },
                            path
                        );
                    }, deferred.reject);
                } else {
                    self.openInBrowser(path);
                    deferred.resolve();
                }
            } else {
                $log.debug('Opening external file using window.open()');
                window.open(path, '_blank');
                deferred.resolve();
            }
            return deferred.promise;
        };
        self.openInBrowser = function(url) {
            if ($mmApp.isDesktop()) {
                var shell = require('electron').shell;
                if (!shell.openExternal(url)) {
                    window.open(url, '_system');
                }
            } else {
                window.open(url, '_system');
            }
        };
        self.openInApp = function(url, options) {
            if (!url) {
                return;
            }
            options = options || {};
            if (!options.enableViewPortScale) {
                options.enableViewPortScale = 'yes'; 
            }
            if (!options.location && ionic.Platform.isIOS() && url.indexOf('file://') === 0) {
                options.location = 'no';
            }
            $cordovaInAppBrowser.open(url, '_blank', options);
        };
        self.closeInAppBrowser = function(closeAll) {
            try {
                $cordovaInAppBrowser.close();
                if (closeAll && $mmApp.isDesktop()) {
                    require('electron').ipcRenderer.send('closeSecondaryWindows');
                }
            } catch(ex) {}
        };
        self.openOnlineFile = function(url) {
            var deferred = $q.defer();
            if (ionic.Platform.isAndroid() && window.plugins && window.plugins.webintent) {
                var iParams;
                self.getMimeTypeFromUrl(url).catch(function() {
                }).then(function(mimetype) {
                    if (!mimetype) {
                        $mmLang.translateAndRejectDeferred(deferred, 'mm.core.erroropenfilenoextension');
                        return;
                    }
                    iParams = {
                        action: "android.intent.action.VIEW",
                        url: url,
                        type: mimetype
                    };
                    window.plugins.webintent.startActivity(
                        iParams,
                        function() {
                            $log.debug('Intent launched');
                            deferred.resolve();
                        },
                        function() {
                            $log.debug('Intent launching failed.');
                            $log.debug('action: ' + iParams.action);
                            $log.debug('url: ' + iParams.url);
                            $log.debug('type: ' + iParams.type);
                            $mmLang.translateAndRejectDeferred(deferred, 'mm.core.erroropenfilenoapp');
                        }
                    );
                });
            } else {
                $log.debug('Opening remote file using window.open()');
                window.open(url, '_blank');
                deferred.resolve();
            }
            return deferred.promise;
        };
        self.getMimeType = function(url) {
            $log.warn('$mmUtil#getMimeType is deprecated. Use $mmUtil#getMimeTypeFromUrl instead');
            return self.getMimeTypeFromUrl(url);
        };
        self.getMimeTypeFromUrl = function(url) {
            var extension = $mmFS.guessExtensionFromUrl(url),
                mimetype = $mmFS.getMimeType(extension);
            if (mimetype) {
                return $q.when(mimetype);
            }
            return $mmWS.getRemoteFileMimeType(url).then(function(mimetype) {
                return mimetype || '';
            });
        };
        self.showModalLoading = function(text, needsTranslate) {
            var modalClosed = false,
                modalShown = false,
                showModalPromise;
            if (!modalClosed) {
                if (!text) {
                    text = $translate.instant('mm.core.loading');
                } else if (needsTranslate) {
                    text = $translate.instant(text);
                }
                showModalPromise = $ionicLoading.show({
                    template:   '<ion-spinner></ion-spinner>' +
                                '<p>' + addFormatTextIfNeeded(text) + '</p>'
                }).then(function() {
                    showModalPromise = null;
                    if (!modalClosed) {
                        modalShown = true;
                    }
                });
            }
            return {
                dismiss: function() {
                    modalClosed = true;
                    if (showModalPromise) {
                        showModalPromise.finally(function() {
                            $ionicLoading.hide();
                        });
                    } else if (modalShown) {
                        $ionicLoading.hide();
                    }
                }
            };
        };
        self.showToast = function(text, needsTranslate, duration) {
            duration = duration || 2000;
            if (needsTranslate) {
                text = $translate.instant(text);
            }
            return $ionicLoading.show({
                template: text,
                duration: duration,
                noBackdrop: true,
                hideOnStateChange: true
            }).then(function() {
                var container = angular.element(document.querySelector(".loading-container.visible")).addClass('mm-toast');
                $timeout.cancel(toastPromise);
                toastPromise = $timeout(function() {
                    container.removeClass('mm-toast');
                }, duration);
            });
        };
        self.copyToClipboard = function(text) {
            return $cordovaClipboard.copy(text).then(function() {
                return self.showToast('mm.core.copiedtoclipboard', true);
            }).catch(function () {
            });
        };
        self.showModalLoadingWithTemplate = function(template, options) {
            options = options || {};
            if (!template) {
                template = "<ion-spinner></ion-spinner><p>{{'mm.core.loading' | translate}}</p>";
            }
            options.template = addFormatTextIfNeeded(template); 
            $ionicLoading.show(options);
            return {
                dismiss: function() {
                    $ionicLoading.hide();
                }
            };
        };
        self.showErrorModal = function(errorMessage, needsTranslate, autocloseTime) {
            if (angular.isObject(errorMessage)) {
                if (typeof errorMessage.content != 'undefined') {
                    errorMessage = errorMessage.content;
                } else if (typeof errorMessage.body != 'undefined') {
                    errorMessage = errorMessage.body;
                } else if (typeof errorMessage.message != 'undefined') {
                    errorMessage = errorMessage.message;
                } else if (typeof errorMessage.error != 'undefined') {
                    errorMessage = errorMessage.error;
                } else {
                    errorMessage = JSON.stringify(errorMessage);
                }
                var matches = errorMessage.match(/token"?[=|:]"?(\w*)/, '');
                if (matches && matches[1]) {
                    errorMessage = errorMessage.replace(new RegExp(matches[1], 'g'), 'secret');
                }
            }
            var message = $mmText.decodeHTML(needsTranslate ? $translate.instant(errorMessage) : errorMessage),
                popup = $ionicPopup.alert({
                    title: getErrorTitle(message),
                    template: addFormatTextIfNeeded(message) 
                });
            if (typeof autocloseTime != 'undefined' && !isNaN(parseInt(autocloseTime))) {
                $timeout(function() {
                    popup.close();
                }, parseInt(autocloseTime));
            }
        };
        function getErrorTitle(message) {
            if (message == $translate.instant('mm.core.networkerrormsg') ||
                    message == $translate.instant('mm.fileuploader.errormustbeonlinetoupload')) {
                return '<span class="mm-icon-with-badge"><i class="icon ion-wifi"></i>\
                    <i class="icon ion-alert-circled mm-icon-badge"></i></span>';
            }
            return $mmText.decodeHTML($translate.instant('mm.core.error'));
        }
        self.showErrorModalDefault = function(errorMessage, defaultError, needsTranslate, autocloseTime) {
            if (errorMessage != mmCoreDontShowError) {
                errorMessage = typeof errorMessage == 'string' ? errorMessage : defaultError;
                return self.showErrorModal(errorMessage, needsTranslate, autocloseTime);
            }
        };
        self.showModal = function(title, message, autocloseTime) {
            title = $translate.instant(title);
            message = $translate.instant(message);
            autocloseTime = parseInt(autocloseTime);
            var popup = $ionicPopup.alert({
                title: title,
                template: addFormatTextIfNeeded(message) 
            });
            if (autocloseTime > 0) {
                $timeout(function() {
                    popup.close();
                }, autocloseTime);
            }
            return popup;
        };
        self.showConfirm = function(template, title, options) {
            options = options || {};
            options.template = addFormatTextIfNeeded(template); 
            options.title = title;
            if (!title) {
                options.cssClass = 'mm-nohead';
            }
            return $ionicPopup.confirm(options).then(function(confirmed) {
                if (!confirmed) {
                    return $q.reject();
                }
            });
        };
        self.showPrompt = function(body, title, inputPlaceholder, inputType) {
            inputType = inputType || 'password';
            var options = {
                template: addFormatTextIfNeeded(body), 
                title: title,
                inputPlaceholder: inputPlaceholder,
                inputType: inputType
            };
            return $ionicPopup.prompt(options).then(function(data) {
                if (typeof data == 'undefined') {
                    return $q.reject();
                }
                return data;
            });
        };
        function addFormatTextIfNeeded(message) {
            if ($mmText.hasHTMLTags(message)) {
                return '<mm-format-text watch="true">' + message + '</mm-format-text>';
            }
            return message;
        }
        self.readJSONFile = function(path) {
            return $http.get(path).then(function(response) {
                return response.data;
            });
        };
        self.getCountryName = function(code) {
            var countryKey = 'mm.core.country-' + code,
                countryName = $translate.instant(countryKey);
            return countryName !== countryKey ? countryName : code;
        };
        self.getCountryList = function() {
            var table = $translate.getTranslationTable(),
                countries = {};
            angular.forEach(table, function(value, name) {
                if (name.indexOf('mm.core.country-') === 0) {
                    name = name.replace('mm.core.country-', '');
                    countries[name] = value;
                }
            });
            return countries;
        };
        self.getDocsUrl = function(release, page) {
            page = page || 'Mobile_app';
            var docsurl = 'https://docs.moodle.org/en/' + page;
            if (typeof release != 'undefined') {
                var version = release.substr(0, 3).replace(".", "");
                if (parseInt(version) >= 24) {
                    docsurl = docsurl.replace('https://docs.moodle.org/', 'https://docs.moodle.org/' + version + '/');
                }
            }
            return $mmLang.getCurrentLanguage().then(function(lang) {
                return docsurl.replace('/en/', '/' + lang + '/');
            }, function() {
                return docsurl;
            });
        };
        self.timestamp = function() {
            return Math.round(Date.now() / 1000);
        };
        self.readableTimestamp = function() {
            return moment(Date.now()).format('YYYYMMDDHHmmSS');
        };
        self.isFalseOrZero = function(value) {
            return typeof value != 'undefined' && (value === false || value === "false" || parseInt(value) === 0);
        };
        self.isTrueOrOne = function(value) {
            return typeof value != 'undefined' && (value === true || value === "true" || parseInt(value) === 1);
        };
        self.formatTime = function(seconds) {
            return $q.when(self.formatTimeInstant(seconds));
        };
        self.formatTimeInstant = function(seconds) {
            var totalSecs = Math.abs(seconds);
            var years     = Math.floor(totalSecs / mmCoreSecondsYear);
            var remainder = totalSecs - (years * mmCoreSecondsYear);
            var days      = Math.floor(remainder / mmCoreSecondsDay);
            remainder = totalSecs - (days * mmCoreSecondsDay);
            var hours     = Math.floor(remainder / mmCoreSecondsHour);
            remainder = remainder - (hours * mmCoreSecondsHour);
            var mins      = Math.floor(remainder / mmCoreSecondsMinute);
            var secs      = remainder - (mins * mmCoreSecondsMinute);
            var ss = $translate.instant('mm.core.' + (secs == 1 ? 'sec' : 'secs'));
            var sm = $translate.instant('mm.core.' + (mins == 1 ? 'min' : 'mins'));
            var sh = $translate.instant('mm.core.' + (hours == 1 ? 'hour' : 'hours'));
            var sd = $translate.instant('mm.core.' + (days == 1 ? 'day' : 'days'));
            var sy = $translate.instant('mm.core.' + (years == 1 ? 'year' : 'years'));
            var oyears = '',
                odays = '',
                ohours = '',
                omins = '',
                osecs = '';
            if (years) {
                oyears  = years + ' ' + sy;
            }
            if (days) {
                odays  = days + ' ' + sd;
            }
            if (hours) {
                ohours = hours + ' ' + sh;
            }
            if (mins) {
                omins  = mins + ' ' + sm;
            }
            if (secs) {
                osecs  = secs + ' ' + ss;
            }
            if (years) {
                return oyears + ' ' + odays;
            }
            if (days) {
                return odays + ' ' + ohours;
            }
            if (hours) {
                return ohours + ' ' + omins;
            }
            if (mins) {
                return omins + ' ' + osecs;
            }
            if (secs) {
                return osecs;
            }
            return $translate.instant('mm.core.now');
        };
        self.formatDuration = function(duration, precission) {
            eventDuration = moment.duration(duration, 'seconds');
            if (!precission) {
                precission = 5;
            }
            durationString = "";
            if (precission && eventDuration.years() > 0) {
                durationString += " " + moment.duration(eventDuration.years(), 'years').humanize();
                precission--;
            }
            if (precission && eventDuration.months() > 0) {
                durationString += " " + moment.duration(eventDuration.months(), 'months').humanize();
                precission--;
            }
            if (precission && eventDuration.days() > 0) {
                durationString += " " + moment.duration(eventDuration.days(), 'days').humanize();
                precission--;
            }
            if (precission && eventDuration.hours() > 0) {
                durationString += " " + moment.duration(eventDuration.hours(), 'hours').humanize();
                precission--;
            }
            if (precission && eventDuration.minutes() > 0) {
                durationString += " " + moment.duration(eventDuration.minutes(), 'minutes').humanize();
                precission--;
            }
            return durationString.trim();
        };
        self.formatTree = function(list, parentFieldName, idFieldName, rootParentId, maxDepth) {
            var map = {},
                mapDepth = {},
                parent, id,
                tree = [];
            parentFieldName = parentFieldName || 'parent';
            idFieldName = idFieldName || 'id';
            rootParentId = rootParentId || 0;
            maxDepth = maxDepth || 5;
            angular.forEach(list, function(node, index) {
                id = node[idFieldName];
                parent = node[parentFieldName];
                node.children = [];
                map[id] = index;
                if (parent != rootParentId) {
                    var parentNode = list[map[parent]];
                    if (parentNode) {
                        if (mapDepth[parent] == maxDepth) {
                            var parentOfParent = parentNode[parentFieldName];
                            if (parentOfParent) {
                                list[map[parentOfParent]].children.push(node);
                                mapDepth[id] = mapDepth[parent];
                                node.parent = parentOfParent;
                            }
                        } else {
                            parentNode.children.push(node);
                            mapDepth[id] = mapDepth[parent] + 1;
                        }
                    }
                } else {
                    tree.push(node);
                    mapDepth[id] = 1;
                }
            });
            return tree;
        };
        self.emptyArray = function(array) {
            array.length = 0; 
        };
        self.emptyObject = function(object) {
            for (var key in object) {
                if (object.hasOwnProperty(key)) {
                    delete object[key];
                }
            }
        };
        self.allPromises = function(promises) {
            if (!promises || !promises.length) {
                return $q.when();
            }
            var count = 0,
                failed = false,
                error,
                deferred = $q.defer();
            angular.forEach(promises, function(promise) {
                promise.catch(function(err) {
                    failed = true;
                    error = err;
                }).finally(function() {
                    count++;
                    if (count === promises.length) {
                        if (failed) {
                            deferred.reject(error);
                        } else {
                            deferred.resolve($q.all(promises));
                        }
                    }
                });
            });
            return deferred.promise;
        };
        self.executeOrderedPromises = function(orderedPromisesData) {
            var promises = [],
                dependency = $q.when();
            angular.forEach(orderedPromisesData, function(data) {
                var promise;
                promise = dependency.finally(function() {
                    var prom, fn;
                    try {
                        fn = self.resolveObject(data.func);
                        prom = fn.apply(prom, data.params || []);
                    } catch (e) {
                        $log.error(e.message);
                        return;
                    }
                    return prom;
                });
                promises.push(promise);
                if (data.blocking) {
                    dependency = promise;
                }
            });
            return self.allPromises(promises);
        };
        self.promiseWorks = function(promise) {
            return promise.then(function() {
                return true;
            }).catch(function() {
                return false;
            });
        };
        self.promiseFails = function(promise) {
            return promise.then(function() {
                return false;
            }).catch(function() {
                return true;
            });
        };
        self.basicLeftCompare = function(itemA, itemB, maxLevels, level, undefinedIsNull) {
            level = level || 0;
            maxLevels = maxLevels || 0;
            undefinedIsNull = typeof undefinedIsNull == 'undefined' ? true : undefinedIsNull;
            if (angular.isFunction(itemA) || angular.isFunction(itemB)) {
                return true; 
            } else if (angular.isObject(itemA) && angular.isObject(itemB)) {
                if (level >= maxLevels) {
                    return true; 
                }
                var equal = true;
                angular.forEach(itemA, function(value, name) {
                    if (name == '$$hashKey') {
                        return;
                    }
                    if (!self.basicLeftCompare(value, itemB[name], maxLevels, level + 1)) {
                        equal = false;
                    }
                });
                return equal;
            } else {
                if (undefinedIsNull && (
                        (typeof itemA == 'undefined' && itemB === null) || (itemA === null && typeof itemB == 'undefined'))) {
                    return true;
                }
                var floatA = parseFloat(itemA),
                    floatB = parseFloat(itemB);
                if (!isNaN(floatA) && !isNaN(floatB)) {
                    return floatA == floatB;
                }
                return itemA === itemB;
            }
        };
        self.confirmDownloadSize = function(sizeCalc, message, unknownsizemessage, wifiThreshold, limitedThreshold, alwaysConfirm) {
            wifiThreshold = typeof wifiThreshold == 'undefined' ? mmCoreWifiDownloadThreshold : wifiThreshold;
            limitedThreshold = typeof limitedThreshold == 'undefined' ? mmCoreDownloadThreshold : limitedThreshold;
            if (typeof sizeCalc == 'number') {
                sizeCalc = {size: sizeCalc, total: false};
            }
            if (sizeCalc.size < 0 || (sizeCalc.size == 0 && !sizeCalc.total)) {
                unknownsizemessage = unknownsizemessage || 'mm.course.confirmdownloadunknownsize';
                return self.showConfirm($translate(unknownsizemessage));
            } else if (!sizeCalc.total) {
                var readableSize = $mmText.bytesToSize(sizeCalc.size, 2);
                return self.showConfirm($translate('mm.course.confirmpartialdownloadsize', {size: readableSize}));
            } else if (sizeCalc.size >= wifiThreshold || ($mmApp.isNetworkAccessLimited() && sizeCalc.size >= limitedThreshold)) {
                message = message || 'mm.course.confirmdownload';
                var readableSize = $mmText.bytesToSize(sizeCalc.size, 2);
                return self.showConfirm($translate(message, {size: readableSize}));
            } else if (alwaysConfirm) {
                return self.showConfirm($translate('mm.core.areyousure'));
            }
            return $q.when();
        };
        self.sumFileSizes = function(files) {
            var results = {
                size: 0,
                total: true
            };
            angular.forEach(files, function(file) {
                if (typeof file.filesize == 'undefined') {
                    results.total = false;
                } else {
                    results.size += file.filesize;
                }
            });
            return results;
        };
        self.formatPixelsSize = function(size) {
            if (typeof size == 'string' && (size.indexOf('px') > -1 || size.indexOf('%') > -1)) {
                return size;
            }
            size = parseInt(size, 10);
            if (!isNaN(size)) {
                return size + 'px';
            }
            return '';
        };
        self.formatFloat = function(float) {
            if (typeof float == "undefined") {
                return '';
            }
            var localeSeparator = $translate.instant('mm.core.decsep');
            float += '';
            return float.replace('.', localeSeparator);
        };
        self.unformatFloat = function(localeFloat) {
            if (typeof localeFloat == "undefined") {
                return false;
            }
            if (localeFloat == null) {
                return "";
            }
            localeFloat += '';
            localeFloat = localeFloat.trim();
            if (localeFloat == "") {
                return "";
            }
            var localeSeparator = $translate.instant('mm.core.decsep');
            localeFloat = localeFloat.replace(' ', ''); 
            localeFloat = localeFloat.replace(localeSeparator, '.');
            localeFloat = parseFloat(localeFloat);
            if (isNaN(localeFloat)) {
                return false;
            }
            return localeFloat;
        };
        self.param = function(obj) {
            return provider.param(obj);
        };
        self.roundToDecimals = function(number, decimals) {
            if (typeof decimals == 'undefined') {
                decimals = 2;
            }
            var multiplier = Math.pow(10, decimals);
            return Math.round(parseFloat(number) * multiplier) / multiplier;
        };
        self.extractUrlParams = function(url) {
            var regex = /[?&]+([^=&]+)=?([^&]*)?/gi,
                params = {};
            url.replace(regex, function(match, key, value) {
                params[key] = value !== undefined ? value : '';
            });
            return params;
        };
        self.removeUrlParams = function(url) {
            var matches = url.match(/^[^\?]+/);
            return matches && matches[0];
        };
        self.restoreSourcesInHtml = function(html, paths, anchorFn) {
            var div = angular.element('<div>'),
                media;
            div.html(html);
            media = div[0].querySelectorAll('img, video, audio, source, track');
            angular.forEach(media, function(el) {
                var src = paths[$mmText.decodeURIComponent(el.getAttribute('src'))];
                if (typeof src !== 'undefined') {
                    el.setAttribute('src', src);
                }
                if (el.tagName == 'VIDEO' && el.getAttribute('poster')) {
                    src = paths[$mmText.decodeURIComponent(el.getAttribute('poster'))];
                    if (typeof src !== 'undefined') {
                        el.setAttribute('poster', src);
                    }
                }
            });
            angular.forEach(div.find('a'), function(anchor) {
                var href = $mmText.decodeURIComponent(anchor.getAttribute('href')),
                    url = paths[href];
                if (typeof url !== 'undefined') {
                    anchor.setAttribute('href', url);
                    if (angular.isFunction(anchorFn)) {
                        anchorFn(anchor, href);
                    }
                }
            });
            return div.html();
        };
        self.scrollToElement = function(container, selector, scrollDelegate, scrollParentClass) {
            var position;
            if (!scrollDelegate) {
                scrollDelegate = $ionicScrollDelegate;
            }
            position = self.getElementXY(container, selector, scrollParentClass);
            if (!position) {
                return false;
            }
            scrollDelegate.scrollTo(position[0], position[1]);
            return true;
        };
        self.scrollToInputError = function(container, scrollDelegate, scrollParentClass) {
            return $timeout(function() {
                if (!scrollDelegate) {
                    scrollDelegate = $ionicScrollDelegate;
                }
                scrollDelegate.resize();
                return self.scrollToElement(container, '.mm-input-has-errors', scrollDelegate, scrollParentClass);
            }, 100);
        };
        self.getElementXY = function(container, selector, positionParentClass) {
            var element = selector ? container.querySelector(selector) : container,
                offsetElement,
                positionTop = 0,
                positionLeft = 0;
            if (!positionParentClass) {
                positionParentClass = 'scroll-content';
            }
            if (!element) {
                return false;
            }
            while (element) {
                positionLeft += (element.offsetLeft - element.scrollLeft + element.clientLeft);
                positionTop += (element.offsetTop - element.scrollTop + element.clientTop);
                offsetElement = element.offsetParent;
                element = element.parentElement;
                while (offsetElement != element && element) {
                    if (angular.element(element).hasClass(positionParentClass)) {
                        element = false;
                    } else {
                        element = element.parentElement;
                    }
                }
                if (angular.element(element).hasClass(positionParentClass)) {
                    element = false;
                }
            }
            return [positionLeft, positionTop];
        };
        self.extractUrlsFromCSS = function(code) {
            var urls = [],
                matches = code.match(/url\(\s*["']?(?!data:)([^)]+)\)/igm);
            angular.forEach(matches, function(match) {
                var submatches = match.match(/url\(\s*['"]?([^'"]*)['"]?\s*\)/im);
                if (submatches && submatches[1]) {
                    urls.push(submatches[1]);
                }
            });
            return urls;
        };
        self.getContentsOfElement = function(element, selector) {
            if (element) {
                var el = element[0] || element, 
                    selected = el.querySelector(selector);
                if (selected) {
                    return selected.innerHTML;
                }
            }
        };
        self.removeElement = function(element, selector) {
            if (element) {
                var el = element[0] || element, 
                    selected = el.querySelector(selector);
                if (selected) {
                    angular.element(selected).remove();
                }
            }
        };
        self.removeElementFromHtml = function(html, selector, removeAll) {
            var div = document.createElement('div'),
                selected;
            div.innerHTML = html;
            if (removeAll) {
                selected = div.querySelectorAll(selector);
                angular.forEach(selected, function(el) {
                    angular.element(el).remove();
                });
            } else {
                selected = div.querySelector(selector);
                if (selected) {
                    angular.element(selected).remove();
                }
            }
            return div.innerHTML;
        };
        self.replaceClassesInElement = function(element, map) {
            element = element[0] || element; 
            angular.forEach(map, function(newValue, toReplace) {
                var matches = element.querySelectorAll('.' + toReplace);
                angular.forEach(matches, function(element) {
                    element.className = element.className.replace(toReplace, newValue);
                });
            });
        };
        self.closest = function(element, selector) {
            if (typeof element.closest == 'function') {
                return element.closest(selector);
            }
            if (!matchesFn) {
                ['matches','webkitMatchesSelector','mozMatchesSelector','msMatchesSelector','oMatchesSelector'].some(function(fn) {
                    if (typeof document.body[fn] == 'function') {
                        matchesFn = fn;
                        return true;
                    }
                    return false;
                });
                if (!matchesFn) {
                    return;
                }
            }
            while (element) {
                if (element[matchesFn](selector)) {
                    return element;
                }
                element = element.parentElement;
            }
        };
        self.extractDownloadableFilesFromHtml = function(html) {
            var div = document.createElement('div'),
                elements,
                urls = [];
            div.innerHTML = html;
            elements = div.querySelectorAll('a, img, audio, video, source, track');
            angular.forEach(elements, function(element) {
                var url = element.tagName === 'A' ? element.href : element.src;
                if (url && self.isDownloadableUrl(url) && urls.indexOf(url) == -1) {
                    urls.push(url);
                }
                if (element.tagName == 'VIDEO' && element.getAttribute('poster')) {
                    url = element.getAttribute('poster');
                    if (url && self.isDownloadableUrl(url) && urls.indexOf(url) == -1) {
                        urls.push(url);
                    }
                }
            });
            return urls;
        };
        self.extractDownloadableFilesFromHtmlAsFakeFileObjects = function(html) {
            var urls = self.extractDownloadableFilesFromHtml(html);
            return urls.map(function(url) {
                return {
                    fileurl: url
                };
            });
        };
        self.makeMenuFromList = function(list, defaultLabel, separator, defaultValue) {
            separator = separator || ',';
            list = list.split(separator);
            list = list.map(function (label, index) {
                return {
                    label: label.trim(),
                    value: index + 1
                };
            });
            if (defaultLabel) {
                list.unshift({
                    label: defaultLabel,
                    value: defaultValue || 0
                });
            }
            return list;
        };
        self.objectToArrayOfObjects = function(obj, keyName, valueName, sort) {
            var entries = getEntries('', obj);
            if (sort) {
                return entries.sort(function(a, b) {
                    return a.name >= b.name ? 1 : -1;
                });
            }
            return entries;
            function getEntries(elKey, value) {
                if (typeof value == 'object') {
                    var keys = Object.keys(value),
                        entries = [];
                    angular.forEach(keys, function(key) {
                        var newElKey = elKey ? elKey + '[' + key + ']' : key;
                        entries = entries.concat(getEntries(newElKey, value[key]));
                    });
                    return entries;
                } else {
                    var entry = {};
                    entry[keyName] = elKey;
                    entry[valueName] = value;
                    return entry;
                }
            }
        };
        self.objectToArray = function(obj) {
            return Object.keys(obj).map(function(key) {
                return obj[key];
            });
        };
        self.objectToKeyValueMap = function(obj, keyName, valueName, keyPrefix) {
            var prefixSubstr = keyPrefix ? keyPrefix.length : 0,
                mapped = {};
            angular.forEach(obj, function(item) {
                var key = prefixSubstr > 0 ? item[keyName].substr(prefixSubstr) : item[keyName];
                mapped[key] = item[valueName];
            });
            return mapped;
        };
        self.sameAtKeyMissingIsBlank = function(obj1, obj2, key) {
            var value1 = typeof obj1[key] != 'undefined' ? obj1[key] : '',
                value2 = typeof obj2[key] != 'undefined' ? obj2[key] : '';
            if (typeof value1 == 'number' || typeof value1 == 'boolean') {
                value1 = '' + value1;
            }
            if (typeof value2 == 'number' || typeof value2 == 'boolean') {
                value2 = '' + value2;
            }
            return value1 === value2;
        };
        self.mergeArraysWithoutDuplicates = function(array1, array2, key) {
            return self.uniqueArray(array1.concat(array2), key);
        };
        self.uniqueArray = function(array, key) {
            var filtered = [],
                unique = [],
                len = array.length;
            for (var i = 0; i < len; i++) {
                var entry = array[i],
                    value = key ? entry[key] : entry;
                if (unique.indexOf(value) == -1) {
                    unique.push(value);
                    filtered.push(entry);
                }
            }
            return filtered;
        };
        self.isWebServiceError = function(error) {
            var localErrors = [
                $translate.instant('mm.core.wsfunctionnotavailable'),
                $translate.instant('mm.core.lostconnection'),
                $translate.instant('mm.core.userdeleted'),
                $translate.instant('mm.core.unexpectederror'),
                $translate.instant('mm.core.networkerrormsg'),
                $translate.instant('mm.core.serverconnection'),
                $translate.instant('mm.core.errorinvalidresponse'),
                $translate.instant('mm.core.sitemaintenance'),
                $translate.instant('mm.core.upgraderunning'),
                $translate.instant('mm.core.nopasswordchangeforced'),
                $translate.instant('mm.core.unicodenotsupported')
            ];
            return error && localErrors.indexOf(error) == -1;
        };
        self.focusElement = function(el) {
            if (el && el.focus) {
                el.focus();
                if (ionic.Platform.isAndroid() && self.supportsInputKeyboard(el)) {
                    $mmApp.openKeyboard();
                }
            }
        };
        self.supportsInputKeyboard = function(el) {
            return el && !el.disabled && (el.tagName.toLowerCase() == 'textarea' ||
                (el.tagName.toLowerCase() == 'input' && inputSupportKeyboard.indexOf(el.type) != -1));
        };
        self.isRichTextEditorSupported = function() {
            if (!ionic.Platform.isIOS() && !ionic.Platform.isAndroid()) {
                return true;
            }
            if (ionic.Platform.isAndroid() && ionic.Platform.version() >= 4.4) {
                return true;
            }
            return false;
        };
        self.isRichTextEditorEnabled = function() {
            if (self.isRichTextEditorSupported()) {
                return $mmConfig.get(mmCoreSettingsRichTextEditor, true);
            }
            return $q.when(false);
        };
        self.hasRepeatedFilenames = function(files) {
            if (!files || !files.length) {
                return false;
            }
            var names = [];
            for (var i = 0; i < files.length; i++) {
                var name = files[i].filename || files[i].name;
                if (names.indexOf(name) > -1) {
                    return $translate.instant('mm.core.filenameexist', {$a: name});
                } else {
                    names.push(name);
                }
            }
            return false;
        };
        self.blockLeaveView = function(scope, canLeaveFn, currentView) {
            currentView = currentView || $ionicHistory.currentView();
            var unregisterHardwareBack,
                leaving = false,
                hasSplitView = $ionicPlatform.isTablet() && $state.current.name.split('.').length == 3,
                skipSplitViewLeave = false;
            $rootScope.$ionicGoBack = goBack;
            unregisterHardwareBack = $ionicPlatform.registerBackButtonAction(goBack, 101);
            backFunctionsStack.push(goBack);
            if (hasSplitView) {
                blockSplitView(true);
            }
            scope.$on('$destroy', unblock);
            return {
                back: originalBackFunction,
                unblock: unblock
            };
            function goBack() {
                if ($ionicHistory.currentView() !== currentView) {
                    originalBackFunction();
                    return;
                }
                if (leaving) {
                    return;
                }
                leaving = true;
                canLeaveFn().then(function() {
                    skipSplitViewLeave = hasSplitView;
                    originalBackFunction();
                }).finally(function() {
                    leaving = false;
                });
            }
            function leaveViewInSplitView() {
                if (skipSplitViewLeave) {
                    skipSplitViewLeave = false;
                    return $q.when();
                }
                return canLeaveFn();
            }
            function unblock() {
                unregisterHardwareBack();
                if (hasSplitView) {
                    blockSplitView(false);
                }
                var position = backFunctionsStack.indexOf(goBack);
                if (position > -1) {
                    backFunctionsStack.splice(position, 1);
                }
                if ($rootScope.$ionicGoBack === goBack) {
                    if (!backFunctionsStack.length) {
                        backFunctionsStack = [originalBackFunction];
                        $rootScope.$ionicGoBack = originalBackFunction;
                    } else {
                        $rootScope.$ionicGoBack = backFunctionsStack[backFunctionsStack.length - 1];
                    }
                }
            }
            function blockSplitView(block) {
                $rootScope.$broadcast(mmCoreSplitViewBlock, {
                    block: block,
                    blockFunction: leaveViewInSplitView,
                    state: currentView.stateName,
                    stateParams: currentView.stateParams
                });
            }
        };
        self.isElementOutsideOfScreen = function(element, scrollSelector) {
            scrollSelector = scrollSelector || '.scroll-content';
            var elementRect = element.getBoundingClientRect(),
                elementMidPoint,
                scrollEl = self.closest(element, scrollSelector),
                scrollElRect,
                scrollTopPos = 0;
            if (!elementRect) {
                return false;
            }
            elementMidPoint = Math.round((elementRect.bottom + elementRect.top) / 2);
            if (scrollEl) {
                scrollElRect = scrollEl.getBoundingClientRect();
                scrollTopPos = (scrollElRect && scrollElRect.top) || 0;
            }
            return elementMidPoint > $window.innerHeight || elementMidPoint < scrollTopPos;
        };
        self.copyProperties = function(from, to) {
            angular.forEach(from, function(value, name) {
                to[name] = angular.copy(value);
            });
        };
        self.filterEnabledSites = function(siteIds, isEnabledFn, checkAll) {
            var promises = [],
                enabledSites = [],
                extraParams = Array.prototype.slice.call(arguments, 3); 
            angular.forEach(siteIds, function(siteId) {
                if (checkAll || !promises.length) {
                    promises.push($q.when(isEnabledFn.apply(isEnabledFn, [siteId].concat(extraParams))).then(function(enabled) {
                        if (enabled) {
                            enabledSites.push(siteId);
                        }
                    }));
                }
            });
            return self.allPromises(promises).catch(function() {
            }).then(function() {
                if (!checkAll) {
                    return enabledSites.length ? siteIds : [];
                } else {
                    return enabledSites;
                }
            });
        };
        self.getElementHeight = function(element, usePadding, useMargin, useBorder, innerMeasure) {
            var measure = element.offsetHeight || element.height || element.clientHeight || 0;
            if (measure <= 0) {
                var angElement = angular.element(element);
                if (angElement.css('display') == '') {
                    angElement.css('display', 'inline-block');
                    measure = element.offsetHeight || element.height || element.clientHeight || 0;
                    angElement.css('display', '');
                }
            }
            if (usePadding || useMargin || useBorder) {
                var surround = 0,
                    cs = getComputedStyle(element);
                if (usePadding) {
                    surround += parseInt(cs.paddingTop, 10) + parseInt(cs.paddingBottom, 10);
                }
                if (useMargin) {
                    surround += parseInt(cs.marginTop, 10) + parseInt(cs.marginBottom, 10);
                }
                if (useBorder) {
                    surround += parseInt(cs.borderTop, 10) + parseInt(cs.borderBottom, 10);
                }
                if (innerMeasure) {
                    measure = measure > surround ? measure - surround : 0;
                } else {
                    measure += surround;
                }
            }
            return measure;
        };
        self.getElementWidth = function(element, usePadding, useMargin, useBorder, innerMeasure) {
            var measure = element.offsetWidth || element.width || element.clientWidth || 0;
            if (measure <= 0) {
                var angElement = angular.element(element);
                if (angElement.css('display') == '') {
                    angElement.css('display', 'inline-block');
                    measure = element.offsetWidth || element.width || element.clientWidth || 0;
                    angElement.css('display', '');
                }
            }
            if (usePadding || useMargin || useBorder) {
                var surround = 0,
                    cs = getComputedStyle(element);
                if (usePadding) {
                    surround += parseInt(cs.paddingLeft, 10) + parseInt(cs.paddingRight, 10);
                }
                if (useMargin) {
                    surround += parseInt(cs.marginLeft, 10) + parseInt(cs.marginRight, 10);
                }
                if (useBorder) {
                    surround += parseInt(cs.borderLeft, 10) + parseInt(cs.borderRight, 10);
                }
                if (innerMeasure) {
                    measure = measure > surround ? measure - surround : 0;
                } else {
                    measure += surround;
                }
            }
            return measure;
        };
        self.indexOfRegexp = function(array, regex) {
            if (!array || !array.length) {
                return -1;
            }
            for (var i = 0; i < array.length; i++) {
                var entry = array[i],
                    matches = entry.match(regex);
                if (matches && matches.length) {
                    return i;
                }
            }
            return -1;
        };
        self.filterByRegexp = function(array, regex) {
            if (!array || !array.length) {
                return [];
            }
            return array.filter(function(entry) {
                var matches = entry.match(regex);
                return matches && matches.length;
            });
        };
        self.filterUndefinedItemsInArray = function(items) {
            return items.filter(function(item) {
                return typeof item != "undefined";
            });
        };
        self.getInfoValuesFromForm = function(form) {
            if (!form || !form.elements) {
                return {};
            }
            var formData = {},
                simpleCheckboxes = {};
            angular.forEach(form.elements, function(element) {
                var name = element.name || '';
                if (element.type == 'submit' || element.tagName == 'BUTTON') {
                    return;
                }
                if (!name) {
                    $log.debug('Form element without name.', element);
                    return;
                }
                switch (element.type) {
                    case 'checkbox':
                        if (typeof simpleCheckboxes[name] == "undefined") {
                           simpleCheckboxes[name] = {};
                        }
                        simpleCheckboxes[name][element.value] = !!element.checked;
                        break;
                    case 'radio':
                        if (element.checked) {
                            formData[name] = element.value;
                        }
                        break;
                    default:
                        formData[name] = element.value;
                }
            });
            angular.forEach(simpleCheckboxes, function(checkbox, name) {
                var keys = Object.keys(checkbox);
                if (keys.length == 1 && keys[0] == "on") {
                    formData[name] = checkbox.on;
                } else {
                    formData[name] = checkbox;
                }
            });
            return formData;
        };
        return self;
    }];
}]);

angular.module('mm.core')
.factory('$mmWebWorkers', ["$injector", "$q", "$log", "$window", "md5", function($injector, $q, $log, $window, md5) {
    $log = $log.getInstance('$mmWebWorkers');
    var self = {},
        workers = {};
    function createWorker(name, path) {
        try {
            if (typeof workers[name] == 'undefined') {
                workers[name] = {
                    path: path,
                    worker: new Worker(path)
                };
            } else {
                $log.warn('There\'s already a worker with this name: ' + name);
            }
            return true;
        } catch(ex) {
            return false;
        }
    }
    self.isSupportedByDevice = function() {
        return !!$window.Worker && !!$window.URL;
    };
    self.isSupportedInSite = function(site) {
        if (!site) {
            site = $injector.get('$mmSite');
            if (!site || !site.isLoggedIn()) {
                return false;
            }
        }
        return site.isVersionGreaterEqualThan('2.8');
    };
    self.startWorker = function(name, path, params) {
        if (typeof workers[name] == 'undefined') {
            if (!createWorker(name, path)) {
                return $q.reject();
            }
        } else if (workers[name].path != path) {
            $log.warn('The path of the worker to call doesn\t match the path passed as parameter: ', name, path);
            return $q.reject();
        }
        var deferred = $q.defer(),
            id = md5.createHash(JSON.stringify(params)),
            worker = workers[name].worker;
        worker.addEventListener('message', onMessage, false);
        worker.addEventListener('error', onError, false);
        params.workerId = id;
        worker.postMessage(params);
        return deferred.promise;
        function onMessage(e) {
            if (e && e.data) {
                if (e.data.workerId == id) {
                    delete e.data.workerId;
                    if (e.data.notify) {
                        deferred.notify(e.data);
                    } else {
                        worker.removeEventListener('message', onMessage, false);
                        worker.removeEventListener('error', onError, false);
                        deferred.resolve(e.data);
                    }
                }
            } else {
                deferred.reject();
            }
        }
        function onError() {
            worker.removeEventListener('message', onMessage, false);
            worker.removeEventListener('error', onError, false);
            delete workers[name];
            deferred.reject();
        }
    };
    return self;
}]);

angular.module('mm.core')
.constant('mmWSTimeout', 30000)
.factory('$mmWS', ["$http", "$q", "$log", "$mmLang", "$cordovaFileTransfer", "$mmApp", "$mmFS", "mmCoreSessionExpired", "$translate", "$window", "mmCoreUserDeleted", "md5", "$timeout", "mmWSTimeout", "mmCoreUserPasswordChangeForced", "mmCoreUserNotFullySetup", "$mmText", "mmCoreSitePolicyNotAgreed", "mmCoreUnicodeNotSupported", function($http, $q, $log, $mmLang, $cordovaFileTransfer, $mmApp, $mmFS, mmCoreSessionExpired, $translate, $window,
            mmCoreUserDeleted, md5, $timeout, mmWSTimeout, mmCoreUserPasswordChangeForced, mmCoreUserNotFullySetup, $mmText,
            mmCoreSitePolicyNotAgreed, mmCoreUnicodeNotSupported) {
    $log = $log.getInstance('$mmWS');
    var self = {},
        mimeTypeCache = {}, 
        ongoingCalls = {},
        retryCalls = [],
        retryTimeout = 0;
    self.call = function(method, data, preSets) {
        var siteurl;
        if (typeof preSets == 'undefined' || preSets === null ||
                typeof preSets.wstoken == 'undefined' || typeof preSets.siteurl == 'undefined') {
            return $mmLang.translateAndReject('mm.core.unexpectederror');
        } else if (!$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.core.networkerrormsg');
        }
        preSets.typeExpected = preSets.typeExpected || 'object';
        if (typeof preSets.responseExpected == 'undefined') {
            preSets.responseExpected = true;
        }
        try {
            data = convertValuesToString(data, preSets.cleanUnicode);
        } catch (e) {
           return $mmLang.translateAndReject('mm.core.unicodenotsupportedcleanerror');
        }
        data.wsfunction = method;
        data.wstoken = preSets.wstoken;
        siteurl = preSets.siteurl + '/webservice/rest/server.php?moodlewsrestformat=json';
        var ajaxData = data;
        var promise = getPromiseHttp('post', preSets.siteurl, ajaxData);
        if (!promise) {
            if (retryCalls.length > 0) {
                $log.warn('Calls locked, trying later...');
                promise = addToRetryQueue(method, siteurl, ajaxData, preSets);
            } else {
                promise = performPost(method, siteurl, ajaxData, preSets);
            }
        }
        return promise;
    };
    function performPost(method, siteurl, ajaxData, preSets) {
        var promise = $http.post(siteurl, ajaxData, {timeout: mmWSTimeout}).then(function(data) {
            if ((!data || !data.data) && !preSets.responseExpected) {
                data = {};
            } else {
                data = data.data;
            }
            if (!data) {
                return $mmLang.translateAndReject('mm.core.serverconnection');
            } else if (typeof data != preSets.typeExpected) {
                $log.warn('Response of type "' + typeof data + '" received, expecting "' + preSets.typeExpected + '"');
                return $mmLang.translateAndReject('mm.core.errorinvalidresponse');
            }
            if (typeof(data.exception) !== 'undefined') {
                if (data.errorcode == 'invalidtoken' ||
                        (data.errorcode == 'accessexception' && data.message.indexOf('Invalid token - token expired') > -1)) {
                    $log.error("Critical error: " + JSON.stringify(data));
                    return $q.reject(mmCoreSessionExpired);
                } else if (data.errorcode === 'userdeleted') {
                    return $q.reject(mmCoreUserDeleted);
                } else if (data.errorcode === 'sitemaintenance' || data.errorcode === 'upgraderunning') {
                    return $mmLang.translateAndReject('mm.core.' + data.errorcode);
                } else if (data.errorcode === 'forcepasswordchangenotice') {
                    return $q.reject(mmCoreUserPasswordChangeForced);
                } else if (data.errorcode === 'usernotfullysetup') {
                    return $q.reject(mmCoreUserNotFullySetup);
                } else if (data.errorcode === 'sitepolicynotagreed') {
                    return $q.reject(mmCoreSitePolicyNotAgreed);
                } else if (data.errorcode === 'dmlwriteexception' && $mmText.hasUnicodeData(ajaxData)) {
                    return $q.reject(mmCoreUnicodeNotSupported);
                } else {
                    return $q.reject(data.message);
                }
            }
            if (typeof(data.debuginfo) != 'undefined') {
                return $q.reject('Error. ' + data.message);
            }
            $log.info('WS: Data received from WS ' + typeof(data));
            if (typeof(data) == 'object' && typeof(data.length) != 'undefined') {
                $log.info('WS: Data number of elements '+ data.length);
            }
            return data;
        }, function(data) {
            if (data.status == 429) {
                var retryPromise = addToRetryQueue(method, siteurl, ajaxData, preSets);
                if (retryTimeout == 0) {
                    retryTimeout = parseInt(data.headers('Retry-After'), 10) || 5;
                    $log.warn(data.statusText + '. Retrying in ' + retryTimeout + ' seconds. ' + retryCalls.length + ' calls left.');
                    $timeout(function() {
                        $log.warn('Retrying now with ' + retryCalls.length + ' calls to process.');
                        retryTimeout = 0;
                        processRetryQueue();
                    }, retryTimeout * 1000);
                } else {
                    $log.warn('Calls locked, trying later...');
                }
                return retryPromise;
            }
            return $mmLang.translateAndReject('mm.core.serverconnection');
        });
        setPromiseHttp(promise, 'post', preSets.siteurl, ajaxData);
        return promise;
    }
    function processRetryQueue() {
        if (retryCalls.length > 0 && retryTimeout == 0) {
            var call = retryCalls.shift();
            $timeout(function() {
                call.deferred.resolve(performPost(call.method, call.siteurl, call.ajaxData, call.preSets));
                processRetryQueue();
            }, 200);
        } else {
            $log.warn('Retry queue has stopped with ' + retryCalls.length + ' calls and ' + retryTimeout + ' timeout seconds.');
        }
    }
    function addToRetryQueue(method, siteurl, ajaxData, preSets) {
        var call = {
            method: method,
            siteurl: siteurl,
            ajaxData: ajaxData,
            preSets: preSets,
            deferred: $q.defer()
        };
        retryCalls.push(call);
        return call.deferred.promise;
    }
    function setPromiseHttp(promise, method, url, params) {
        var deletePromise,
            queueItemId = getQueueItemId(method, url, params);
        ongoingCalls[queueItemId] = promise;
        deletePromise = $timeout(function() {
            delete ongoingCalls[queueItemId];
        }, mmWSTimeout);
        ongoingCalls[queueItemId].finally(function() {
            delete ongoingCalls[queueItemId];
            $timeout.cancel(deletePromise);
        });
    }
    function getPromiseHttp(method, url, params) {
        var queueItemId = getQueueItemId(method, url, params);
        if (typeof ongoingCalls[queueItemId] != 'undefined') {
            return ongoingCalls[queueItemId];
        }
        return false;
    }
    function getQueueItemId(method, url, params) {
        if (params) {
            url += '###' + serializeParams(params);
        }
        return method + '#' + md5.createHash(url);
    }
    function convertValuesToString(data, stripUnicode) {
        var result = [];
        if (!angular.isArray(data) && angular.isObject(data)) {
            result = {};
        }
        for (var el in data) {
            if (angular.isObject(data[el])) {
                result[el] = convertValuesToString(data[el], stripUnicode);
            } else {
                if (typeof data[el] == "string") {
                    result[el] = stripUnicode ? $mmText.stripUnicode(data[el]) : data[el];
                    if (stripUnicode && data[el] != result[el] && result[el].trim().length == 0) {
                        throw new Exception();
                    }
                } else {
                    result[el] = data[el] + '';
                }
            }
        }
        return result;
    }
    self.downloadFile = function(url, path, addExtension) {
        $log.debug('Downloading file', url, path, addExtension);
        if (!$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.core.networkerrormsg');
        }
        var tmpPath = path + '.tmp';
        return $mmFS.createFile(tmpPath).then(function(fileEntry) {
            return $cordovaFileTransfer.download(url, fileEntry.toURL(), { encodeURI: false }, true).then(function() {
                var promise;
                if (addExtension) {
                    ext = $mmFS.getFileExtension(path);
                    if (!ext || ext == 'gdoc' || ext == 'gsheet' || ext == 'gslides' || ext == 'gdraw') {
                        promise = self.getRemoteFileMimeType(url).then(function(mime) {
                            var remoteExt;
                            if (mime) {
                                remoteExt = $mmFS.getExtension(mime, url);
                                if (remoteExt && (!ext || mime != 'application/json')) {
                                    if (ext) {
                                        path = $mmFS.removeExtension(path);
                                    }
                                    path += '.' + remoteExt;
                                    return remoteExt;
                                }
                            }
                            return ext;
                        });
                    } else {
                        promise = $q.when(ext);
                    }
                } else {
                    promise = $q.when("");
                }
                return promise.then(function(extension) {
                    return $mmFS.moveFile(tmpPath, path).then(function(movedEntry) {
                        movedEntry.extension = extension;
                        movedEntry.path = path;
                        $log.debug('Success downloading file ' + url + ' to ' + path + ' with extension ' + extension);
                        return movedEntry;
                    });
                });
            });
        }).catch(function(err) {
            $log.error('Error downloading ' + url + ' to ' + path);
            $log.error(JSON.stringify(err));
            return $q.reject(err);
        });
    };
    self.uploadFile = function(uri, options, preSets) {
        $log.debug('Trying to upload file: ' + uri);
        if (!uri || !options || !preSets) {
            return $q.reject();
        }
        if (!$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.core.networkerrormsg');
        }
        var ftOptions = {},
            uploadUrl = preSets.siteurl + '/webservice/upload.php';
        ftOptions.fileKey = options.fileKey;
        ftOptions.fileName = options.fileName;
        ftOptions.httpMethod = 'POST';
        ftOptions.mimeType = options.mimeType;
        ftOptions.params = {
            token: preSets.token,
            filearea: options.fileArea || 'draft',
            itemid: options.itemId || 0
        };
        ftOptions.chunkedMode = false;
        ftOptions.headers = {
            Connection: "close"
        };
        $log.debug('Initializing upload');
        return $cordovaFileTransfer.upload(uploadUrl, uri, ftOptions, true).then(function(success) {
            var data = success.response;
            try {
                data = JSON.parse(data);
            } catch(err) {
                $log.error('Error parsing response:', err, data);
                return $mmLang.translateAndReject('mm.core.errorinvalidresponse');
            }
            if (!data) {
                return $mmLang.translateAndReject('mm.core.serverconnection');
            } else if (typeof data != 'object') {
                $log.warn('Upload file: Response of type "' + typeof data + '" received, expecting "object"');
                return $mmLang.translateAndReject('mm.core.errorinvalidresponse');
            }
            if (typeof data.exception !== 'undefined') {
                return $q.reject(data.message);
            } else if (data && typeof data.error !== 'undefined') {
                return $q.reject(data.error);
            } else if (data[0] && typeof data[0].error !== 'undefined') {
                return $q.reject(data[0].error);
            }
            $log.debug('Successfully uploaded file');
            return data[0];
        }, function(error) {
            $log.error('Error while uploading file', error.exception);
            return $mmLang.translateAndReject('mm.core.serverconnection');
        });
    };
    self.getRemoteFileSize = function(url) {
        var promise = getPromiseHttp('head', url);
        if (!promise) {
            promise = $http.head(url, {timeout: mmWSTimeout}).then(function(data) {
                var size = parseInt(data.headers('Content-Length'), 10);
                if (size) {
                    return size;
                }
                return -1;
            }).catch(function() {
                return -1;
            });
            setPromiseHttp(promise, 'head', url);
        }
        return promise;
    };
    self.getRemoteFileMimeType = function(url, ignoreCache) {
        if (mimeTypeCache[url] && !ignoreCache) {
            return $q.when(mimeTypeCache[url]);
        }
        var promise = getPromiseHttp('head', url);
        if (!promise) {
            promise = $http.head(url, {timeout: mmWSTimeout}).then(function(data) {
                var mimeType = data.headers('Content-Type');
                if (mimeType) {
                    mimeType = mimeType.split(';')[0];
                }
                mimeTypeCache[url] = mimeType;
                return mimeType || '';
            }).catch(function() {
                return '';
            });
            setPromiseHttp(promise, 'head', url);
        }
        return promise;
    };
    self.syncCall = function(method, data, preSets) {
        var siteurl,
            xhr,
            errorResponse = {
                error: true,
                message: ''
            };
        data = convertValuesToString(data);
        if (typeof preSets == 'undefined' || preSets === null ||
                typeof preSets.wstoken == 'undefined' || typeof preSets.siteurl == 'undefined') {
            errorResponse.message = $translate.instant('mm.core.unexpectederror');
            return errorResponse;
        } else if (!$mmApp.isOnline()) {
            errorResponse.message = $translate.instant('mm.core.networkerrormsg');
            return errorResponse;
        }
        preSets.typeExpected = preSets.typeExpected || 'object';
        if (typeof preSets.responseExpected == 'undefined') {
            preSets.responseExpected = true;
        }
        data.wsfunction = method;
        data.wstoken = preSets.wstoken;
        siteurl = preSets.siteurl + '/webservice/rest/server.php?moodlewsrestformat=json';
        data = serializeParams(data);
        xhr = new $window.XMLHttpRequest();
        xhr.open('post', siteurl, false);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded;charset=utf-8');
        xhr.send(data);
        data = ('response' in xhr) ? xhr.response : xhr.responseText;
        xhr.status = Math.max(xhr.status === 1223 ? 204 : xhr.status, 0);
        if (xhr.status < 200 || xhr.status >= 300) {
            errorResponse.message = data;
            return errorResponse;
        }
        try {
            data = JSON.parse(data);
        } catch(ex) {}
        if ((!data || !data.data) && !preSets.responseExpected) {
            data = {};
        }
        if (!data) {
            errorResponse.message = $translate.instant('mm.core.serverconnection');
        } else if (typeof data != preSets.typeExpected) {
            $log.warn('Response of type "' + typeof data + '" received, expecting "' + preSets.typeExpected + '"');
            errorResponse.message = $translate.instant('mm.core.errorinvalidresponse');
        }
        if (typeof data.exception != 'undefined' || typeof data.debuginfo != 'undefined') {
            errorResponse.message = data.message;
        }
        if (errorResponse.message !== '') {
            return errorResponse;
        }
        $log.info('Synchronous: Data received from WS ' + typeof data);
        if (typeof(data) == 'object' && typeof(data.length) != 'undefined') {
            $log.info('Synchronous: Data number of elements '+ data.length);
        }
        return data;
    };
    function serializeParams(obj) {
        var query = '', name, value, fullSubName, subName, subValue, innerObj, i;
        for (name in obj) {
            value = obj[name];
            if (value instanceof Array) {
                for (i = 0; i < value.length; ++i) {
                    subValue = value[i];
                    fullSubName = name + '[' + i + ']';
                    innerObj = {};
                    innerObj[fullSubName] = subValue;
                    query += serializeParams(innerObj) + '&';
                }
            }
            else if (value instanceof Object) {
                for (subName in value) {
                    subValue = value[subName];
                    fullSubName = name + '[' + subName + ']';
                    innerObj = {};
                    innerObj[fullSubName] = subValue;
                    query += serializeParams(innerObj) + '&';
                }
            }
            else if (value !== undefined && value !== null) query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
        }
        return query.length ? query.substr(0, query.length - 1) : query;
    }
    self.callAjax = function(method, data, preSets) {
        var siteurl,
            ajaxData;
        if (typeof preSets.siteurl == 'undefined') {
            return rejectWithError($translate.instant('mm.core.unexpectederror'));
        } else if (!$mmApp.isOnline()) {
            return rejectWithError($translate.instant('mm.core.networkerrormsg'));
        }
        if (typeof preSets.responseExpected == 'undefined') {
            preSets.responseExpected = true;
        }
        ajaxData = [{
            index: 0,
            methodname: method,
            args: convertValuesToString(data)
        }];
        siteurl = preSets.siteurl + '/lib/ajax/service.php';
        return $http.post(siteurl, JSON.stringify(ajaxData), {timeout: mmWSTimeout}).then(function(data) {
            if ((!data || !data.data) && !preSets.responseExpected) {
                data = [{}];
            } else {
                data = data.data;
            }
            if (!data || typeof data != 'object') {
                return rejectWithError($translate.instant('mm.core.serverconnection'));
            } else if (data.error) {
                return rejectWithError(data.error, data.errorcode);
            }
            data = data[0];
            if (data.error) {
                return rejectWithError(data.exception.message, data.exception.errorcode);
            }
            return data.data;
        }, function(data) {
            var available = data.status == 404 ? -1 : 0;
            return rejectWithError($translate.instant('mm.core.serverconnection'), '', available);
        });
        function rejectWithError(message, code, available) {
            if (typeof available == 'undefined') {
                if (code) {
                    available = code == 'invalidrecord' ? -1 : 1;
                } else {
                    available = 0;
                }
            }
            return $q.reject({
                error: message,
                errorcode: code,
                available: available
            });
        }
    };
    return self;
}]);

angular.module('mm.core')
.filter('mmBytesToSize', ["$mmText", function($mmText) {
    return function(text) {
        return $mmText.bytesToSize(text);
    };
}]);
angular.module('mm.core')
.filter('mmCreateLinks', function() {
    var replacePattern = /(\b(https?|ftp):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|])(?![^<]*>|[^<>]*<\/)/gim;
    return function(text) {
        return text.replace(replacePattern, '<a href="$1">$1</a>');
    };
});
angular.module('mm.core')
.filter('mmDateDayOrTime', ["$translate", function($translate) {
    return function(timestamp) {
        return moment(timestamp * 1000).calendar(null, {
            sameDay: $translate.instant('mm.core.dftimedate'),
            lastDay: $translate.instant('mm.core.dflastweekdate'),
            lastWeek: $translate.instant('mm.core.dflastweekdate')
        });
    };
}]);

angular.module('mm.core')
.filter('mmDuration', function() {
    return function(timestamp) {
        return moment.duration(timestamp * 1000).humanize();
    };
});

angular.module('mm.core')
.filter('mmFormatDate', ["$translate", function($translate) {
    return function(timestamp, format) {
        if (format.indexOf('.') == -1) {
            format = 'mm.core.' + format;
        }
        return moment(timestamp).format($translate.instant(format));
    };
}]);

angular.module('mm.core')
.filter('mmNoTags', function() {
    return function(text) {
        return String(text).replace(/(<([^>]+)>)/ig, '');
    }
});
angular.module('mm.core')
.filter('mmSecondsToHMS', ["$mmText", "mmCoreSecondsHour", "mmCoreSecondsMinute", function($mmText, mmCoreSecondsHour, mmCoreSecondsMinute) {
    return function(seconds) {
        var hours,
            minutes;
        if (typeof seconds == 'undefined' || seconds < 0) {
            seconds = 0;
        } else {
            seconds = Math.floor(seconds);
        }
        hours = Math.floor(seconds / mmCoreSecondsHour);
        seconds -= hours * mmCoreSecondsHour;
        minutes = Math.floor(seconds / mmCoreSecondsMinute);
        seconds -= minutes * mmCoreSecondsMinute;
        return $mmText.twoDigits(hours) + ':' + $mmText.twoDigits(minutes) + ':' + $mmText.twoDigits(seconds);
    };
}]);

angular.module('mm.core')
.filter('mmTimeAgo', function() {
    return function(timestamp) {
        return moment(timestamp * 1000).fromNow(true);
    };
});

angular.module('mm.core')
.filter('mmToLocaleString', function() {
    return function(text) {
        var timestamp = parseInt(text);
        if (isNaN(timestamp) || timestamp < 0) {
            return '';
        }
        if (timestamp < 100000000000) {
            timestamp = timestamp * 1000;
        }
        return new Date(timestamp).toLocaleString();
    };
});

angular.module('mm.core')
.directive('mmAttachments', ["$mmText", "$translate", "$ionicScrollDelegate", "$mmUtil", "$mmApp", "$mmFileUploaderHelper", "$q", function($mmText, $translate, $ionicScrollDelegate, $mmUtil, $mmApp, $mmFileUploaderHelper, $q) {
    return {
        restrict: 'E',
        priority: 100,
        templateUrl: 'core/templates/attachments.html',
        scope: {
            files: '=',
            maxSize: '@?',
            maxSubmissions: '@?',
            component: '@?',
            componentId: '@?',
            allowOffline: '@?',
            acceptedTypes: '=?',
            mimetypes: '=?',
        },
        link: function(scope) {
            var allowOffline = scope.allowOffline && scope.allowOffline !== 'false';
                maxSize = parseInt(scope.maxSize, 10);
            maxSize = !isNaN(maxSize) && maxSize > 0 ? maxSize : -1;
            if (maxSize == -1) {
                scope.maxSizeReadable = $translate.instant('mm.core.unknown');
            } else {
                scope.maxSizeReadable = $mmText.bytesToSize(maxSize, 2);
            }
            if (typeof scope.maxSubmissions == 'undefined' || scope.maxSubmissions < 0) {
                scope.maxSubmissions = $translate.instant('mm.core.unknown');
                scope.unlimitedFiles = true;
            }
            if (scope.acceptedTypes && scope.acceptedTypes.trim()) {
                scope.filetypes = $mmFileUploaderHelper.prepareFiletypeList(scope.acceptedTypes);
            }
            scope.add = function() {
                if (!allowOffline && !$mmApp.isOnline()) {
                    $mmUtil.showErrorModal('mm.fileuploader.errormustbeonlinetoupload', true);
                } else {
                    var mimetypes = scope.filetypes && scope.filetypes.mimetypes || scope.mimetypes;
                    return $mmFileUploaderHelper.selectFile(maxSize, allowOffline, undefined, undefined, mimetypes)
                            .then(function(result) {
                        scope.files.push(result);
                    });
                }
            };
            scope.delete = function(index, askConfirm) {
                var promise;
                if (askConfirm) {
                    promise = $mmUtil.showConfirm($translate.instant('mm.core.confirmdeletefile'));
                } else {
                    promise = $q.when();
                }
                promise.then(function() {
                    scope.files.splice(index, 1);
                    $ionicScrollDelegate.resize(); 
                });
            };
            scope.renamed = function(index, file) {
                scope.files[index] = file;
            };
        }
    };
}]);

angular.module('mm.core')
.directive('mmAutoFocus', ["$mmUtil", "$timeout", function($mmUtil, $timeout) {
    return {
        restrict: 'A',
        link: function(scope, el, attrs) {
            var unregister = scope.$watch(function() {
                return ionic.transition.isActive;
            }, function(isActive) {
                var showKeyboard = typeof attrs.mmAutoFocus == 'undefined' ||
                    (attrs.mmAutoFocus !== false && attrs.mmAutoFocus !== 'false' && attrs.mmAutoFocus !== '0');
                if (!isActive && showKeyboard) {
                    ionic.keyboard.enable();
                    unregister(); 
                    $timeout(function() {
                        $mmUtil.focusElement(el[0]);
                    }, 400);
                }
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmAutoRows', ["$mmUtil", function($mmUtil) {
    function calculateRows(element, attrs) {
        var currentRows = parseInt(element.attr('rows'), 10) || 1,
            maxRows = parseInt(attrs.mmMaxRows, 10) || 5,
            computedStyle = getComputedStyle(element[0]),
            padding = (parseInt(computedStyle.paddingBottom, 10) || 0) + (parseInt(computedStyle.paddingTop, 10) || 0),
            height = $mmUtil.getElementHeight(element[0]) - padding,
            scrollHeight,
            rows;
        if (height <= 0) {
            return 1;
        }
        element.css('height', '1px');
        scrollHeight = element[0].scrollHeight;
        rows = Math.ceil((scrollHeight - padding) / (height / currentRows));
        element.css('height', '');
        if (maxRows && rows >= maxRows) {
            return maxRows;
        } else {
            return rows;
        }
    }
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var lastModelChange;
            if (attrs.ngModel) {
                scope.$watch(attrs.ngModel, function(newValue) {
                    if (typeof newValue != 'undefined') {
                        lastModelChange = Date.now();
                        valueChanged();
                    }
                });
            }
            element.on('input propertychange', function() {
                if (lastModelChange && Date.now() - lastModelChange <= 20) {
                    lastModelChange = 0;
                } else {
                    valueChanged();
                }
            });
            function valueChanged() {
                var currentRows = element.attr('rows'),
                    rows = calculateRows(element, attrs);
                if (rows != currentRows) {
                    element.attr('rows', rows);
                }
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmChrono', ["$interval", function($interval) {
    function isCurrentChrono(scope, data) {
        if (!scope.id && (!data || !data.id)) {
            return true;
        } else if (scope.id && data && data.id == scope.id) {
            return true;
        }
        return false;
    }
    function reset(scope) {
        stop(scope);
        scope.time = scope.startTime || 0;
    }
    function start(scope) {
        if (scope.isRunning) {
            return;
        }
        var lastExecTime = Date.now();
        scope.isRunning = true;
        scope.interval = $interval(function() {
            scope.time += Date.now() - lastExecTime;
            lastExecTime = Date.now();
            if (typeof scope.endTime != 'undefined' && scope.time > scope.endTime) {
                stop(scope);
                if (scope.onEnd) {
                    scope.onEnd();
                }
            }
        }, 200);
    }
    function stop(scope) {
        scope.isRunning = false;
        $interval.cancel(scope.interval);
    }
    return {
        restrict: 'E',
        scope: {
            id: '=?',
            startTime: '=?',
            endTime: '=?',
            autoPlay: '=?',
            onEnd: '&?'
        },
        template: '<span>{{ time / 1000 | mmSecondsToHMS }}</span>',
        link: function(scope) {
            scope.time = scope.startTime || 0;
            scope.$on('mm-chrono-start', function (e, data) {
                if (isCurrentChrono(scope, data)) {
                    start(scope);
                }
            });
            scope.$on('mm-chrono-stop', function (e, data) {
                if (isCurrentChrono(scope, data)) {
                    stop(scope);
                }
            });
            scope.$on('mm-chrono-reset', function (e, data) {
                if (isCurrentChrono(scope, data)) {
                    reset(scope);
                    if (data && data.play) {
                        start(scope);
                    }
                }
            });
            scope.$watch('startTime', function() {
                var wasRunning = scope.isRunning;
                reset(scope);
                if (wasRunning) {
                    start(scope);
                }
            });
            if (scope.autoPlay && scope.autoPlay !== 'false') {
                start(scope);
            }
            scope.$on('$destroy', function() {
                stop(scope);
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmCompletion', ["$mmSite", "$mmUtil", "$mmText", "$translate", "$q", "$mmUser", function($mmSite, $mmUtil, $mmText, $translate, $q, $mmUser) {
    function showStatus(scope) {
        var langKey,
            moduleName = scope.moduleName || '',
            image = false;
        if (scope.completion.tracking === 1 && scope.completion.state === 0) {
            image = 'completion-manual-n';
            langKey = 'mm.core.completion-alt-manual-n';
        } else if(scope.completion.tracking === 1 && scope.completion.state === 1) {
            image = 'completion-manual-y';
            langKey = 'mm.core.completion-alt-manual-y';
        } else if(scope.completion.tracking === 2 && scope.completion.state === 0) {
            image = 'completion-auto-n';
            langKey = 'mm.core.completion-alt-auto-n';
        } else if(scope.completion.tracking === 2 && scope.completion.state === 1) {
            image = 'completion-auto-y';
            langKey = 'mm.core.completion-alt-auto-y';
        } else if(scope.completion.tracking === 2 && scope.completion.state === 2) {
            image = 'completion-auto-pass';
            langKey = 'mm.core.completion-alt-auto-pass';
        } else if(scope.completion.tracking === 2 && scope.completion.state === 3) {
            image = 'completion-auto-fail';
            langKey = 'mm.core.completion-alt-auto-fail';
        }
        if (image) {
            if (scope.completion.overrideby > 0) {
                image += '-override';
            }
            scope.completionImage = 'img/completion/' + image + '.svg';
        }
        if (moduleName) {
            $mmText.formatText(moduleName, true, true, 50).then(function(modNameFormatted) {
                var promise;
                if (scope.completion.overrideby > 0) {
                    langKey += '-override';
                    promise = $mmUser.getProfile(scope.completion.overrideby, scope.completion.courseId, true).then(function(profile) {
                        return {
                            overrideuser: profile.fullname,
                            modname: modNameFormatted
                        };
                    });
                } else {
                    promise = $q.when(modNameFormatted);
                }
                return promise.then(function(translateParams) {
                    $translate(langKey, {$a: translateParams}).then(function(translated) {
                        scope.completionDescription = translated;
                    });
                });
            });
        }
    }
    return {
        restrict: 'E',
        priority: 100,
        scope: {
            completion: '=',
            afterChange: '=',
            moduleName: '=?'
        },
        templateUrl: 'core/templates/completion.html',
        link: function(scope) {
            if (scope.completion) {
                showStatus(scope);
            }
            scope.completionClicked = function (e) {
                if (scope.completion) {
                    if (typeof scope.completion.cmid == 'undefined' || scope.completion.tracking !== 1) {
                        return;
                    }
                    e.preventDefault();
                    e.stopPropagation();
                    var modal = $mmUtil.showModalLoading(),
                        params = {
                            cmid: scope.completion.cmid,
                            completed: scope.completion.state === 1 ? 0 : 1
                        };
                    $mmSite.write('core_completion_update_activity_completion_status_manually', params).then(function(response) {
                        if (!response.status) {
                            return $q.reject();
                        }
                        if (angular.isFunction(scope.afterChange)) {
                            scope.afterChange();
                        }
                    }).catch(function(error) {
                        $mmUtil.showErrorModalDefault(error, 'mm.core.errorchangecompletion', true);
                    }).finally(function() {
                        modal.dismiss();
                    });
                    return false;
                }
            };
        }
    };
}]);

angular.module('mm.core')
.controller('mmContextMenu', ["$scope", "$ionicPopover", "$q", "$timeout", function($scope, $ionicPopover, $q, $timeout) {
    var items = $scope.ctxtMenuItems = [];
    this.addContextMenuItem = function(item) {
        if (!item.$$destroyed) {
            items.push(item);
            item.$on('$destroy', function() {
                var index = items.indexOf(item);
                items.splice(index, 1);
            });
        }
    };
    this.shouldMerge = function() {
        return !!($scope.merge && $scope.merge !== 'false');
    };
    $scope.contextMenuItemClicked = function($event, item) {
        if (typeof item.action == 'function') {
            $event.preventDefault();
            $event.stopPropagation();
            if (!item.iconAction || item.iconAction == 'spinner') {
                return false;
            }
            hideContextMenu(item.closeOnClick);
            return $q.when(item.action()).finally(function() {
                if (!item.closeOnClick) {
                    hideContextMenu(item.closeWhenDone);
                }
            });
        } else if (item.href) {
            hideContextMenu(item.closeOnClick);
        }
        return true;
    };
    $scope.showContextMenu = function($event) {
        $scope.contextMenuPopover.show($event);
    };
    function hideContextMenu(close) {
        if (close) {
            $scope.contextMenuPopover.hide();
            $timeout(function() {
                if (!document.querySelector('.popover-backdrop.active')) {
                    angular.element(document.body).removeClass('popover-open');
                }
            }, 1); 
        }
    }
    $ionicPopover.fromTemplateUrl('core/templates/contextmenu.html', {
        scope: $scope
    }).then(function(popover) {
        $scope.contextMenuPopover = popover;
    });
    $scope.$on('$destroy', function() {
        if ($scope.contextMenuPopover) {
            hideContextMenu(true);
            $scope.contextMenuPopover.remove();
        } else {
            $timeout(function() {
                if ($scope.contextMenuPopover) {
                    hideContextMenu(true);
                    $scope.contextMenuPopover.remove();
                }
            }, 200);
        }
    });
}])
.directive('mmContextMenu', ["$translate", function($translate) {
    return {
        restrict: 'E',
        scope: {
            icon: '@?',
            title: '@?',
            merge: '@?'
        },
        transclude: true,
        templateUrl: 'core/templates/contextmenuicon.html',
        controller: 'mmContextMenu',
        link: function(scope, element) {
            scope.contextMenuIcon = scope.icon || 'ion-android-more-vertical';
            scope.contextMenuAria = scope.title || $translate.instant('mm.core.info');
            scope.filterNgShow = function(value) {
                return value && value.ngShow;
            };
            var div = element[0].querySelector('div[ng-transclude]');
            if (div && div.removeAttribute) {
                div.removeAttribute('ng-transclude');
            }
        }
    };
}])
.directive('mmContextMenuItem', ["$mmUtil", "$timeout", "$ionicPlatform", function($mmUtil, $timeout, $ionicPlatform) {
    function getBooleanValue(value, defaultValue) {
        if (typeof value == 'undefined') {
            return defaultValue;
        }
        return !!(value && value !== "false");
    }
    function getOuterContextMenuController() {
        var menus = document.querySelectorAll('ion-header-bar mm-context-menu'),
            outerContextMenu;
        angular.forEach(menus, function(menu) {
            var div = $mmUtil.closest(menu, '.buttons-left, .buttons-right');
            if (div && angular.element(div).css('opacity') !== '0') {
                outerContextMenu = menu;
            }
        });
        if (outerContextMenu) {
            return angular.element(outerContextMenu).controller('mmContextMenu');
        }
    }
    return {
        require: '^^mmContextMenu',
        restrict: 'E',
        scope: {
            content: '=',
            iconAction: '=?',
            iconDescription: '=?',
            ariaAction: '=?',
            ariaDescription: '=?',
            action: '&?',
            href: '=?',
            captureLink: '=?',
            autoLogin: '=?',
            closeOnClick: '=?',
            closeWhenDone: '=?',
            priority: '=?',
            ngShow: '=?',
            badge: '=?',
            badgeClass: '=?'
        },
        link: function(scope, element, attrs, CtxtMenuCtrl) {
            scope.priority = scope.priority || 1;
            scope.closeOnClick = getBooleanValue(scope.closeOnClick, true);
            scope.closeWhenDone = getBooleanValue(scope.closeWhenDone, false);
            if (typeof attrs.ngShow == 'undefined') {
                scope.ngShow = true;
            }
            if (scope.action) {
                scope.href = "";
            } else if (scope.href) {
                scope.action = false;
            }
            scope.captureLink = scope.href && scope.captureLink ? scope.captureLink : "false";
            scope.autoLogin = scope.autoLogin || 'check';
            if (CtxtMenuCtrl.shouldMerge() && $ionicPlatform.isTablet()) {
                $timeout(function() {
                    if (!scope.$$destroyed) {
                        var ctrl = getOuterContextMenuController();
                        if (ctrl) {
                            CtxtMenuCtrl = ctrl;
                        }
                        CtxtMenuCtrl.addContextMenuItem(scope);
                    }
                });
            } else {
                CtxtMenuCtrl.addContextMenuItem(scope);
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmEmptyBox', ["$translate", function($translate) {
    return {
        restrict: 'E',
        templateUrl: 'core/templates/emptybox.html',
        transclude: true,
        scope: {
            message: '@',
            icon: '@?',
            image: '@?'
        },
        link: function(scope) {
            if (scope.icon && scope.icon != "") {
                scope.image = false;
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmExternalContent', ["$log", "$mmFilepool", "$mmSite", "$mmSitesManager", "$mmUtil", "$q", "$mmApp", "$ionicPlatform", function($log, $mmFilepool, $mmSite, $mmSitesManager, $mmUtil, $q, $mmApp, $ionicPlatform) {
    $log = $log.getInstance('mmExternalContent');
    function addSource(dom, url) {
        if (dom.tagName !== 'SOURCE') {
            return;
        }
        var e = document.createElement('source'),
            type = dom.getAttribute('type');
        e.setAttribute('src', url);
        if (type) {
            if (ionic.Platform.isAndroid() && type == 'video/quicktime') {
                e.setAttribute('type', 'video/mp4');
            } else {
                e.setAttribute('type', type);
            }
        }
        dom.parentNode.insertBefore(e, dom);
    }
    function handleExternalContent(siteId, dom, targetAttr, url, component, componentId) {
        if (dom.tagName == 'VIDEO' && dom.textTracks && targetAttr != 'poster') {
            dom.textTracks.onaddtrack = function(event) {
                if (event.track) {
                    event.track.oncuechange = function() {
                        var line = $ionicPlatform.isTablet() || ionic.Platform.isAndroid() ? 90 : 80;
                        angular.forEach(event.track.cues, function(cue) {
                            cue.snapToLines = false;
                            cue.line = line;
                            cue.size = 100; 
                        });
                        event.track.oncuechange = null;
                    };
                }
            };
        }
        if (!url || !url.match(/^https?:\/\//i) || (dom.tagName === 'A' && !$mmUtil.isDownloadableUrl(url))) {
            $log.debug('Ignoring non-downloadable URL: ' + url);
            if (dom.tagName === 'SOURCE') {
                addSource(dom, url);
            }
            return $q.reject();
        }
        return $mmSitesManager.getSite(siteId).then(function(site) {
            if (!site.canDownloadFiles() && $mmUtil.isPluginFileUrl(url)) {
                angular.element(dom).remove(); 
                return $q.reject();
            }
            var fn,
                downloadUnknown = dom.tagName == 'IMG' || dom.tagName == 'TRACK' || targetAttr == 'poster';
            if (targetAttr === 'src' && dom.tagName !== 'SOURCE' && dom.tagName !== 'TRACK') {
                fn = $mmFilepool.getSrcByUrl;
            } else {
                fn = $mmFilepool.getUrlByUrl;
            }
            return fn(siteId, url, component, componentId, 0, true, downloadUnknown).then(function(finalUrl) {
                $log.debug('Using URL ' + finalUrl + ' for ' + url);
                if (dom.tagName === 'SOURCE') {
                    addSource(dom, finalUrl);
                } else {
                    dom.setAttribute(targetAttr, finalUrl);
                }
                if (finalUrl.indexOf('http') === 0 && targetAttr != 'poster' &&
                            (dom.tagName == 'VIDEO' || dom.tagName == 'AUDIO' || dom.tagName == 'A' || dom.tagName == 'SOURCE')) {
                    var eventName = dom.tagName == 'A' ? 'click' : 'play';
                    if (dom.tagName == 'SOURCE') {
                        dom = $mmUtil.closest(dom, 'video,audio');
                        if (!dom) {
                            return;
                        }
                    }
                    angular.element(dom).on(eventName, function() {
                        if (!$mmApp.isNetworkAccessLimited()) {
                            fn(siteId, url, component, componentId, undefined, false);
                        }
                    });
                }
            });
        });
    }
    return {
        restrict: 'A',
        scope: {
            siteid: '='
        },
        link: function(scope, element, attrs) {
            var dom = element[0],
                siteid = scope.siteid || $mmSite.getId(),
                component = attrs.component,
                componentId = attrs.componentId,
                targetAttr,
                sourceAttr,
                observe = false;
            if (dom.tagName === 'A') {
                targetAttr = 'href';
                sourceAttr = 'href';
                if (attrs.hasOwnProperty('ngHref')) {
                    observe = true;
                }
            } else if (dom.tagName === 'IMG') {
                targetAttr = 'src';
                sourceAttr = 'src';
                if (attrs.hasOwnProperty('ngSrc')) {
                    observe = true;
                }
            } else if (dom.tagName === 'AUDIO' || dom.tagName === 'VIDEO' || dom.tagName === 'SOURCE' || dom.tagName === 'TRACK') {
                targetAttr = 'src';
                sourceAttr = 'targetSrc';
                if (attrs.hasOwnProperty('ngSrc')) {
                    observe = true;
                }
                if (dom.tagName === 'VIDEO' && attrs.poster) {
                    handleExternalContent(siteid, dom, 'poster', attrs.poster, component, componentId);
                }
            } else {
                $log.warn('Directive attached to non-supported tag: ' + dom.tagName);
                return;
            }
            if (observe) {
                attrs.$observe(targetAttr, function(url) {
                    if (!url) {
                        return;
                    }
                    handleExternalContent(siteid, dom, targetAttr, url, component, componentId);
                });
            } else {
                handleExternalContent(siteid, dom, targetAttr, attrs[sourceAttr] || attrs[targetAttr], component, componentId);
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmFile', ["$q", "$mmUtil", "$mmFilepool", "$mmSite", "$mmApp", "$mmEvents", "$mmFS", "mmCoreDownloaded", "mmCoreDownloading", "mmCoreNotDownloaded", "mmCoreOutdated", "$mmLang", function($q, $mmUtil, $mmFilepool, $mmSite, $mmApp, $mmEvents, $mmFS, mmCoreDownloaded, mmCoreDownloading,
            mmCoreNotDownloaded, mmCoreOutdated, $mmLang) {
    function getState(scope, siteId, fileUrl, timeModified, alwaysDownload) {
        return $mmFilepool.getFileStateByUrl(siteId, fileUrl, timeModified).then(function(state) {
            var canDownload = $mmSite.canDownloadFiles();
            scope.isDownloaded = state === mmCoreDownloaded || state === mmCoreOutdated;
            scope.isDownloading = canDownload && state === mmCoreDownloading;
            scope.showDownload = canDownload && (state === mmCoreNotDownloaded || state === mmCoreOutdated ||
                    (alwaysDownload && state === mmCoreDownloaded));
        });
    }
    function downloadFile(scope, siteId, fileUrl, component, componentId, timeModified, alwaysDownload) {
        if (!$mmSite.canDownloadFiles()) {
            $mmUtil.showErrorModal('mm.core.cannotdownloadfiles', true);
            return $q.reject();
        }
        scope.isDownloading = true;
        return $mmFilepool.downloadUrl(siteId, fileUrl, false, component, componentId, timeModified, undefined, scope.file)
                .then(function(localUrl) {
            return localUrl;
        }).catch(function() {
            return getState(scope, siteId, fileUrl, timeModified, alwaysDownload).then(function() {
                if (scope.isDownloaded) {
                    return $mmFilepool.getInternalUrlByUrl(siteId, fileUrl);
                } else {
                    return $q.reject();
                }
            });
        });
    }
    function openFile(scope, siteId, fileUrl, fileSize, component, componentId, timeModified, alwaysDownload) {
        var fixedUrl = $mmSite.fixPluginfileURL(fileUrl),
            promise;
        if ($mmFS.isAvailable()) {
            promise = $q.when().then(function() {
                var isWifi = !$mmApp.isNetworkAccessLimited(),
                    isOnline = $mmApp.isOnline();
                if (scope.isDownloaded && !scope.showDownload) {
                    return $mmFilepool.getUrlByUrl(siteId, fileUrl, component, componentId, timeModified, false, false, scope.file);
                } else {
                    if (!isOnline && !scope.isDownloaded) {
                        return $q.reject();
                    }
                    var isDownloading = scope.isDownloading;
                    scope.isDownloading = true; 
                    return $mmFilepool.shouldDownloadBeforeOpen(fixedUrl, fileSize).then(function() {
                        if (isDownloading) {
                            return;
                        }
                        return downloadFile(scope, siteId, fileUrl, component, componentId, timeModified, alwaysDownload);
                    }, function() {
                        if (isWifi && isOnline) {
                            downloadFile(scope, siteId, fileUrl, component, componentId, timeModified, alwaysDownload);
                        }
                        if (isDownloading || !scope.isDownloaded || isOnline) {
                            return fixedUrl;
                        } else {
                            return $mmFilepool.getUrlByUrl(siteId, fileUrl, component, componentId, timeModified,
                                    false, false, scope.file);
                        }
                    });
                }
            });
        } else {
            promise = $q.when(fixedUrl);
        }
        return promise.then(function(url) {
            if (!url) {
                return;
            }
            if (url.indexOf('http') === 0) {
                return $mmUtil.openOnlineFile(url).catch(function(error) {
                    if (!$mmFS.isAvailable()) {
                        return $q.reject(error);
                    }
                    var subPromise;
                    if (scope.isDownloading) {
                        subPromise = $mmLang.translateAndReject('mm.core.erroropenfiledownloading');
                    } else if (status === mmCoreNotDownloaded) {
                        subPromise = downloadFile(scope, siteId, fileUrl, component, componentId, timeModified, alwaysDownload);
                    } else {
                        subPromise = $mmFilepool.getInternalUrlByUrl(siteId, fileUrl);
                    }
                    return subPromise.then(function(url) {
                        return $mmUtil.openFile(url);
                    });
                });
            } else {
                return $mmUtil.openFile(url);
            }
        });
    }
    return {
        restrict: 'E',
        templateUrl: 'core/templates/file.html',
        scope: {
            file: '=',
            canDelete: '@?',
            onDelete: '&?',
            canDownload: '@?',
            noBorder : '@?'
        },
        link: function(scope, element, attrs) {
            var fileUrl = scope.file.fileurl || scope.file.url,
                fileName = scope.file.filename,
                fileSize = scope.file.filesize,
                timeModified = attrs.timemodified || 0,
                siteId = $mmSite.getId(),
                component = attrs.component,
                componentId = attrs.componentId,
                alwaysDownload = attrs.alwaysDownload && attrs.alwaysDownload !== 'false',
                canDownload = scope.canDownload !== false && scope.canDownload !== 'false',
                observer;
            if (!fileName) {
                return;
            }
            if (scope.file.isexternalfile) {
                alwaysDownload = true; 
            }
            scope.filename = fileName;
            scope.fileicon = $mmFS.getFileIcon(fileName);
            if (canDownload) {
                getState(scope, siteId, fileUrl, timeModified, alwaysDownload);
                $mmFilepool.getFileEventNameByUrl(siteId, fileUrl).then(function(eventName) {
                    observer = $mmEvents.on(eventName, function() {
                        getState(scope, siteId, fileUrl, timeModified, alwaysDownload);
                    });
                });
            }
            scope.download = function(e, openAfterDownload) {
                e.preventDefault();
                e.stopPropagation();
                var promise;
                if (scope.isDownloading && !openAfterDownload) {
                    return;
                }
                if (!$mmApp.isOnline() && (!openAfterDownload || (openAfterDownload && !scope.isDownloaded))) {
                    $mmUtil.showErrorModal('mm.core.networkerrormsg', true);
                    return;
                }
                if (openAfterDownload) {
                    openFile(scope, siteId, fileUrl, fileSize, component, componentId, timeModified, alwaysDownload)
                            .catch(function(error) {
                        $mmUtil.showErrorModalDefault(error, 'mm.core.errordownloading', true);
                    });
                } else {
                    promise = fileSize ? $mmUtil.confirmDownloadSize({size: fileSize, total: true}) : $q.when();
                    promise.then(function() {
                        $mmFilepool.invalidateFileByUrl(siteId, fileUrl).finally(function() {
                            scope.isDownloading = true;
                            $mmFilepool.addToQueueByUrl(siteId, fileUrl, component, componentId, timeModified,
                                    undefined, 0, scope.file).catch(function(error) {
                                $mmUtil.showErrorModalDefault(error, 'mm.core.errordownloading', true);
                            });
                        });
                    });
                }
            };
            if (scope.canDelete) {
                scope.delete = function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    if (scope.onDelete) {
                        scope.onDelete();
                    }
                };
            }
            scope.$on('$destroy', function() {
                if (observer && observer.off) {
                    observer.off();
                }
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmFormatText', ["$interpolate", "$mmText", "$compile", "$translate", "$mmUtil", "$mmSitesManager", "$mmFS", "$window", function($interpolate, $mmText, $compile, $translate, $mmUtil, $mmSitesManager, $mmFS, $window) {
    var extractVariableRegex = new RegExp('{{([^|]+)(|.*)?}}', 'i'),
        tagsToIgnore = ['AUDIO', 'VIDEO', 'BUTTON', 'INPUT', 'SELECT', 'TEXTAREA', 'A'];
    function addExternalContent(el, component, componentId, siteId) {
        el.setAttribute('mm-external-content', '');
        if (component) {
            el.setAttribute('component', component);
            if (componentId) {
                el.setAttribute('component-id', componentId);
            }
        }
        if (siteId) {
            el.setAttribute('siteid', siteId);
        }
    }
    function addMediaAdaptClass(el) {
        angular.element(el).addClass('mm-media-adapt-width');
    }
    function getElementWidth(element) {
        var width = $mmUtil.getElementWidth(element);
        if (!width) {
            var angElement = angular.element(element),
                parentWidth = $mmUtil.getElementWidth(element.parentNode, true, false, false, true),
                previousDisplay = angElement.css('display');
            angElement.css('display', 'inline-block');
            width = $mmUtil.getElementWidth(element);
            if (parentWidth > 0 && (!width || width > parentWidth)) {
                width = parentWidth;
            }
            angElement.css('display', previousDisplay);
        }
        return parseInt(width, 10);
    }
    function getElementHeight(elementAng) {
        var element = elementAng[0],
            height;
        elementAng.removeClass('mm-enabled-media-adapt');
        height = $mmUtil.getElementHeight(element);
        elementAng.addClass('mm-enabled-media-adapt');
        return parseInt(height, 10) || false;
    }
    function formatAndRenderContents(scope, element, attrs, text) {
        var maxHeight = false;
        if (typeof text == 'undefined') {
            element.removeClass('opacity-hide');
            return;
        }
        text = $interpolate(text)(scope); 
        text = text.trim();
        if (typeof attrs.maxHeight != "undefined") {
            maxHeight = parseInt(attrs.maxHeight || 0, 10) || false;
        } else if (typeof attrs.shorten != "undefined") {
            console.warn("mm-format-text: shorten attribute is deprecated please use max-height and expand-in-fullview instead.");
            maxHeight = 100;
        }
        formatContents(scope, element, attrs, text).then(function(fullText) {
            if (maxHeight && fullText != "") {
                renderText(scope, element, fullText);
                var height = element.css('max-height') ? false : getElementHeight(element);
                if (!height || height > maxHeight) {
                    var expandInFullview = $mmUtil.isTrueOrOne(attrs.fullviewOnClick) || false;
                    fullText += '<div class="mm-show-more">' + $translate.instant('mm.core.showmore') + '</div>';
                    if (expandInFullview) {
                        element.addClass('mm-expand-in-fullview');
                    }
                    element.addClass('mm-text-formatted mm-shortened');
                    element.css('max-height', maxHeight + 'px');
                    element.on('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        var target = e.target;
                        if (tagsToIgnore.indexOf(target.tagName) === -1 || (target.tagName === 'A' &&
                                !target.getAttribute('href'))) {
                            if (!expandInFullview) {
                                element.toggleClass('mm-shortened');
                            } else {
                                $mmText.expandText(attrs.expandTitle || $translate.instant('mm.core.description'), text,
                                    attrs.newlinesOnFullview, attrs.component, attrs.componentId);
                            }
                        } else {
                            $mmText.expandText(attrs.expandTitle || $translate.instant('mm.core.description'), text,
                                attrs.newlinesOnFullview, attrs.component, attrs.componentId);
                        }
                    });
                }
            }
            element.addClass('mm-enabled-media-adapt');
            renderText(scope, element, fullText, attrs.afterRender);
        });
    }
    function formatContents(scope, element, attrs, text) {
        var siteId = attrs.siteid,
            component = attrs.component,
            componentId = attrs.componentId,
            site;
        return $mmSitesManager.getSite(siteId).catch(function() {
        }).then(function(siteInstance) {
            site = siteInstance;
            return $mmText.formatText(text, attrs.clean, attrs.singleline);
        }).then(function(formatted) {
            var el = element[0],
                dom = angular.element('<div>').html(formatted), 
                images = dom.find('img'),
                canTreatVimeo = site && site.isVersionGreaterEqualThan(['3.3.4', '3.4']);
            angular.forEach(dom.find('a'), function(anchor) {
                anchor.setAttribute('mm-link', '');
                anchor.setAttribute('capture-link', true);
                addExternalContent(anchor, component, componentId, siteId);
            });
            if (images && images.length > 0) {
                var elWidth = getElementWidth(el) || 100;
                angular.forEach(images, function(img) {
                    addMediaAdaptClass(img);
                    addExternalContent(img, component, componentId, siteId);
                    if (!attrs.notAdaptImg) {
                        var imgWidth = getElementWidth(img),
                            container = angular.element('<span class="mm-adapted-img-container"></span>'),
                            jqImg = angular.element(img);
                        container.css('float', img.style.float); 
                        if (jqImg.hasClass('atto_image_button_right')) {
                            container.addClass('atto_image_button_right');
                        } else if (jqImg.hasClass('atto_image_button_left')) {
                            container.addClass('atto_image_button_left');
                        }
                        jqImg.wrap(container);
                        if (imgWidth > elWidth) {
                            var label = $mmText.escapeHTML($translate.instant('mm.core.openfullimage')),
                                imgSrc = $mmText.escapeHTML(img.getAttribute('src'));
                            jqImg.after('<a href="#" class="mm-image-viewer-icon" mm-image-viewer img="' + imgSrc +
                                            '" aria-label="' + label + '"><i class="icon ion-ios-search-strong"></i></a>');
                        }
                    }
                });
            }
            angular.forEach(dom.find('audio'), function(el) {
                treatMedia(el, component, componentId, siteId);
                if (ionic.Platform.isIOS()) {
                    el.setAttribute('data-tap-disabled', true);
                }
            });
            angular.forEach(dom.find('video'), function(el) {
                treatVideoFilters(el);
                treatMedia(el, component, componentId, siteId);
                el.setAttribute('data-tap-disabled', true);
            });
            angular.forEach(dom.find('iframe'), function(el) {
                treatIframe(el, site, canTreatVimeo);
            });
            if (ionic.Platform.isIOS()) {
                angular.forEach(dom.find('select'), function(select) {
                    select.setAttribute('mm-ios-select-fix', '');
                });
            }
            angular.forEach(dom[0].querySelectorAll('.button'), function(button) {
                if (button.querySelector('a')) {
                    angular.element(button).addClass('mm-button-with-inner-link');
                }
            });
            return dom.html();
        });
    }
    function renderText(scope, element, text, afterRender) {
        element.html(text);
        element.removeClass('opacity-hide');
        $compile(element.contents())(scope);
        if (afterRender && scope[afterRender]) {
            scope[afterRender](scope);
        }
    }
    function youtubeGetId(url) {
        var regExp = /^.*(?:(?:youtu.be\/)|(?:v\/)|(?:\/u\/\w\/)|(?:embed\/)|(?:watch\?))\??v?=?([^#\&\?]*).*/;
        var match = url.match(regExp);
        return (match && match[1].length == 11)? match[1] : false;
    }
    function treatVideoFilters(el) {
        if (!angular.element(el).hasClass('video-js')) {
            return;
        }
        var data = JSON.parse(el.getAttribute('data-setup') || el.getAttribute('data-setup-lazy') || '{}'),
            youtubeId = data.techOrder && data.techOrder[0] && data.techOrder[0] == 'youtube' && data.sources && data.sources[0] &&
                data.sources[0].src && youtubeGetId(data.sources[0].src);
        if (!youtubeId) {
            return;
        }
        var iframe = document.createElement('iframe');
        iframe.id = el.id;
        iframe.src = 'https://www.youtube.com/embed/' + youtubeId;
        iframe.setAttribute('frameborder', 0);
        iframe.width = '100%';
        iframe.height = 300;
        el.parentNode.insertBefore(iframe, el);
        el.parentNode.removeChild(el);
    }
    function treatMedia(el, component, componentId, siteId) {
        addMediaAdaptClass(el);
        addExternalContent(el, component, componentId, siteId);
        angular.forEach(angular.element(el).find('source'), function(source) {
            source.setAttribute('target-src', source.getAttribute('src'));
            source.removeAttribute('src');
            addExternalContent(source, component, componentId, siteId);
        });
        angular.forEach(angular.element(el).find('track'), function(track) {
            addExternalContent(track, component, componentId, siteId);
        });
    }
    function treatIframe(el, site, canTreatVimeo) {
        addMediaAdaptClass(el);
        if (el.src && canTreatVimeo) {
            var matches = el.src.match(/https?:\/\/player\.vimeo\.com\/video\/([0-9]+)/);
            if (matches && matches[1]) {
                var newUrl = $mmFS.concatenatePaths(site.getURL(), '/media/player/vimeo/wsplayer.php?video=') +
                        matches[1] + '&token=' + site.getToken();
                if (el.width) {
                    width = el.width;
                } else {
                    width = getElementWidth(el);
                    if (!width) {
                        width = $window.innerWidth;
                    }
                }
                if (el.height) {
                    height = el.height;
                } else {
                    height = getElementHeight(angular.element(el));
                    if (!height) {
                        height = width;
                    }
                }
                el.src = newUrl + '&width=' + width + '&height=' + height;
                if (!el.width) {
                    el.width = width;
                }
                if (!el.height) {
                    el.height = height;
                }
            }
        }
    }
    return {
        restrict: 'EA',
        scope: true,
        link: function(scope, element, attrs) {
            element.addClass('opacity-hide'); 
            var content = element.html(); 
            if (attrs.watch) {
                var matches = content.match(extractVariableRegex);
                if (matches && typeof matches[1] == 'string') {
                    var variable = matches[1].trim();
                    scope.$watch(variable, function() {
                        formatAndRenderContents(scope, element, attrs, content);
                    });
                } else {
                    formatAndRenderContents(scope, element, attrs, content);
                }
            } else {
                formatAndRenderContents(scope, element, attrs, content);
            }
        }
    };
}]);

angular.module('mm.core')
.constant('mmCoreIframeTimeout', 15000)
.directive('mmIframe', ["$log", "$mmUtil", "$mmText", "$mmSite", "$mmFS", "$timeout", "mmCoreIframeTimeout", function($log, $mmUtil, $mmText, $mmSite, $mmFS, $timeout, mmCoreIframeTimeout) {
    $log = $log.getInstance('mmIframe');
    var tags = ['iframe', 'frame', 'object', 'embed'];
    function treatFrame(element) {
        if (element) {
            redefineWindowOpen(element);
            treatLinks(element);
            element.on('load', function() {
                redefineWindowOpen(element);
                treatLinks(element);
            });
        }
    }
    function redefineWindowOpen(element) {
        var el = element[0],
            contentWindow = element.contentWindow || el.contentWindow;
        if (!contentWindow && el && el.contentDocument) {
            contentWindow = el.contentDocument.defaultView;
        }
        if (!contentWindow && el && el.getSVGDocument) {
            try {
                var svgDoc = el.getSVGDocument();
                if (svgDoc && svgDoc.defaultView) {
                    contents = angular.element(svgdoc);
                    contentWindow = svgdoc.defaultView;
                } else if (el.window) {
                    contentWindow = el.window;
                } else if (el.getWindow) {
                    contentWindow = el.getWindow();
                }
            } catch (ex) {
            }
        }
        if (contentWindow) {
            contentWindow.open = function (url) {
                var scheme = $mmText.getUrlScheme(url);
                if (!scheme) {
                    var src = element[0] && (element[0].src || element[0].data);
                    if (src) {
                        var dirAndFile = $mmFS.getFileAndDirectoryFromPath(src);
                        if (dirAndFile.directory) {
                            url = $mmFS.concatenatePaths(dirAndFile.directory, url);
                        } else {
                            $log.warn('Cannot get iframe dir path to open relative url', url, element);
                            return {}; 
                        }
                    } else {
                        $log.warn('Cannot get iframe src to open relative url', url, element);
                        return {}; 
                    }
                }
                if (url.indexOf('cdvfile://') === 0 || url.indexOf('file://') === 0) {
                    $mmUtil.openFile(url).catch(function(error) {
                        $mmUtil.showErrorModal(error);
                    });
                } else {
                    if (!$mmSite.isLoggedIn()) {
                        $mmUtil.openInBrowser(url);
                    } else {
                        $mmSite.openInBrowserWithAutoLoginIfSameSite(url);
                    }
                }
                return {}; 
            };
        }
        try {
            var contents = element.contents();
            angular.forEach(tags, function(tag) {
                angular.forEach(contents.find(tag), function(subelement) {
                    treatFrame(angular.element(subelement));
                });
            });
        } catch (ex) {
        }
    }
    function treatLinks(element) {
        var links;
        try {
            links = element.contents().find('a');
        } catch (ex) {
        }
        angular.forEach(links, function(el) {
            var href = el.href;
            if (href) {
                var scheme = $mmText.getUrlScheme(href);
                if (scheme && scheme == 'javascript') {
                    return;
                } else if (scheme && scheme != 'file' && scheme != 'filesystem') {
                    angular.element(el).on('click', function(e) {
                        if (!e.defaultPrevented) {
                            e.preventDefault();
                            if (!$mmSite.isLoggedIn()) {
                                $mmUtil.openInBrowser(href);
                            } else {
                                $mmSite.openInBrowserWithAutoLoginIfSameSite(href);
                            }
                        }
                    });
                } else if (el.target == '_parent' || el.target == '_top' || el.target == '_blank') {
                    angular.element(el).on('click', function(e) {
                        if (!e.defaultPrevented) {
                            e.preventDefault();
                            $mmUtil.openFile(href).catch(function(error) {
                                $mmUtil.showErrorModal(error);
                            });
                        }
                    });
                } else if (ionic.Platform.isIOS() && (!el.target || el.target == '_self')) {
                    angular.element(el).on('click', function(e) {
                        if (!e.defaultPrevented) {
                            if (element[0].tagName.toLowerCase() == 'object') {
                                e.preventDefault();
                                element.attr('data', href);
                            } else {
                                e.preventDefault();
                                element.attr('src', href);
                            }
                        }
                    });
                }
            }
        });
    }
    return {
        restrict: 'E',
        templateUrl: 'core/templates/iframe.html',
        scope: {
            src: '=',
            loaded: '&?'
        },
        link: function(scope, element, attrs) {
            var url = (scope.src && scope.src.toString()) || '',  
                iframe = angular.element(element.find('iframe')[0]);
            scope.width = $mmUtil.formatPixelsSize(attrs.iframeWidth) || '100%';
            scope.height = $mmUtil.formatPixelsSize(attrs.iframeHeight) || '100%';
            scope.loading = !!url.match(/^https?:\/\//i);
            treatFrame(iframe);
            if (scope.loading) {
                iframe.on('load', function() {
                    scope.loading = false;
                    scope.loaded && scope.loaded(); 
                    $timeout(); 
                });
                iframe.on('error', function() {
                    scope.loading = false;
                    $mmUtil.showErrorModal('mm.core.errorloadingcontent', true);
                    $timeout(); 
                });
                $timeout(function() {
                    scope.loading = false;
                }, mmCoreIframeTimeout);
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmImageViewer', ["$ionicModal", function($ionicModal) {
    return {
        restrict: 'A',
        priority: 500,
        scope: true,
        link: function(scope, element, attrs) {
            if (attrs.img) {
                scope.img = attrs.img;
                scope.closeModal = function(){
                    scope.modal.hide();
                };
                element.on('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    if (!scope.modal) {
                        $ionicModal.fromTemplateUrl('core/templates/imageviewer.html', {
                            scope: scope,
                            animation: 'slide-in-up'
                        }).then(function(m) {
                            scope.modal = m;
                            scope.modal.show();
                        });
                    } else {
                        scope.modal.show();
                    }
                });
                scope.$on('$destroy', function() {
                    if (scope.modal) {
                        scope.modal.remove();
                    }
                });
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmInputErrors', ["$translate", "$compile", function($translate, $compile) {
    var errorContainerTemplate =
        '<div class="mm-input-error-container" ng-show="form[fieldName].$error && form.$submitted" ' +
                    'ng-messages="form[fieldName].$error" role="alert">' +
            '<div ng-repeat="(type, text) in errorMessages">' +
                '<div class="mm-input-error" ng-message-exp="type">{{text}}</div>' +
            '</div>' +
        '</div>';
    function initErrorMessages(scope, input) {
        scope.errorMessages = scope.errorMessages || {};
        scope.errorMessages.required = scope.errorMessages.required || $translate.instant('mm.core.required');
        scope.errorMessages.email = scope.errorMessages.email || $translate.instant('mm.login.invalidemail');
        scope.errorMessages.date = scope.errorMessages.date || $translate.instant('mm.login.invaliddate');
        scope.errorMessages.datetime = scope.errorMessages.datetime || $translate.instant('mm.login.invaliddate');
        scope.errorMessages.datetimelocal = scope.errorMessages.datetimelocal || $translate.instant('mm.login.invaliddate');
        scope.errorMessages.time = scope.errorMessages.time || $translate.instant('mm.login.invalidtime');
        scope.errorMessages.url = scope.errorMessages.url || $translate.instant('mm.login.invalidurl');
        angular.forEach(['min', 'max'], function(type) {
            if (!scope.errorMessages[type]) {
                if (input && typeof input[type] != 'undefined' && input[type] !== '') {
                    var value = input[type];
                    if (input.type == 'date' || input.type == 'datetime' || input.type == 'datetime-local') {
                        var date = moment(value);
                        if (date.isValid()) {
                            value = moment(value).format($translate.instant('mm.core.dfdaymonthyear'));
                        }
                    }
                    scope.errorMessages[type] = $translate.instant('mm.login.invalidvalue' + type, {$a: value});
                } else {
                    scope.errorMessages[type] = $translate.instant('mm.login.profileinvaliddata');
                }
            }
        });
    }
    return {
        restrict: 'A',
        require: '^form',
        scope: {
            fieldName: '@?',
            errorMessages: '=?'
        },
        link: function(scope, element, attrs, FormController) {
            var input;
            scope.form = FormController;
            if (!scope.fieldName) {
                input = element[0].querySelector('input, select, textarea');
                if (!input || !input.name) {
                    return;
                }
                scope.fieldName = input.name;
            }
            if (input) {
                initErrorMessages(scope, input);
            }
            var errorContainer = $compile(errorContainerTemplate)(scope);
            element.append(errorContainer);
            scope.$watch('form[fieldName].$invalid && form.$submitted', function(newValue) {
                if (!input) {
                    input = element[0].querySelector('*[name="' + scope.fieldName + '"]');
                    if (input) {
                        initErrorMessages(scope, input);
                    }
                }
                if (newValue) {
                    element.addClass('mm-input-has-errors');
                } else {
                    element.removeClass('mm-input-has-errors');
                }
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmIosSelectFix', function() {
    return {
        restrict: 'A',
        priority: 100,
        scope: false,
        require: 'select',
        link: function(scope, element) {
            if (ionic.Platform.isIOS()) {
                scope.$watch(function() {
                    return element.html();
                }, function() {
                    if (!element[0].querySelector('optgroup')) {
                        element.append('<optgroup label=""></optgroup>');
                    }
                });
            }
        }
    };
});

angular.module('mm.core')
.directive('mmKeepKeyboard', ["$mmUtil", "$timeout", "$mmApp", function($mmUtil, $timeout, $mmApp) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var selector = attrs.mmKeepKeyboard,
                keepInButton = attrs.keepInButton && attrs.keepInButton !== 'false',
                lastFocusOut = 0,
                candidateEls,
                selectedEl,
                button,
                input;
            if (typeof selector != 'string' || !selector) {
                return;
            }
            candidateEls = document.querySelectorAll(selector);
            selectedEl = candidateEls[candidateEls.length - 1];
            if (!selectedEl) {
                return;
            }
            if (keepInButton) {
                button = element[0];
                input = selectedEl;
            } else {
                button = selectedEl;
                input = element[0];
            }
            input.addEventListener('focusout', focusOut);
            button.addEventListener('click', buttonClicked);
            scope.$on('$destroy', function() {
                button.removeEventListener('click', buttonClicked);
                input.removeEventListener('focusout', focusOut);
            });
            function focusOut() {
                lastFocusOut = Date.now();
            }
            function buttonClicked() {
                if (document.activeElement == input) {
                    input.addEventListener('focusout', focusElementAgain);
                    $timeout(focusElementAgain);
                } else if (document.activeElement == button && Date.now() - lastFocusOut < 200) {
                    $timeout(focusElementAgain);
                }
            }
            function focusElementAgain() {
                if ($mmApp.isKeyboardVisible()) {
                    $mmUtil.focusElement(input);
                    input.removeEventListener('focusout', focusElementAgain);
                }
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmLink', ["$mmUtil", "$mmContentLinksHelper", "$location", "$mmSite", "mmCoreConfigConstants", function($mmUtil, $mmContentLinksHelper, $location, $mmSite, mmCoreConfigConstants) {
    function navigate(href, inApp, autoLogin) {
        inApp = inApp && inApp !== 'false';
        autoLogin = autoLogin || 'check';
        var contentLinksScheme = mmCoreConfigConstants.customurlscheme + '://link=';
        if (href.indexOf('cdvfile://') === 0 || href.indexOf('file://') === 0) {
            $mmUtil.openFile(href).catch(function(error) {
                $mmUtil.showErrorModal(error);
            });
        } else if (href.charAt(0) == '#') {
            href = href.substr(1);
            if (href.charAt(0) == '/') {
                $location.url(href);
            } else {
                $mmUtil.scrollToElement(document, "#" + href + ", [name='" + href + "']");
            }
        } else if (href.indexOf(contentLinksScheme) === 0) {
            href = contentLinksScheme + encodeURIComponent(href.replace(contentLinksScheme, ''));
            $mmUtil.openInBrowser(href);
        } else {
            if (!$mmSite.isLoggedIn()) {
                if (inApp) {
                    $mmUtil.openInApp(href);
                } else {
                    $mmUtil.openInBrowser(href);
                }
            } else {
                if (!$mmUtil.isAbsoluteURL(href)) {
                    if (href.charAt(0) == '/') {
                        href = $mmSite.getURL() + href;
                    } else {
                        href = $mmSite.getURL() + '/' + href;
                    }
                }
                if (autoLogin == 'yes') {
                    if (inApp) {
                        $mmSite.openInAppWithAutoLogin(href);
                    } else {
                        $mmSite.openInBrowserWithAutoLogin(href);
                    }
                } else if (autoLogin == 'no') {
                    if (inApp) {
                        $mmUtil.openInApp(href);
                    } else {
                        $mmUtil.openInBrowser(href);
                    }
                } else {
                    if (inApp) {
                        $mmSite.openInAppWithAutoLoginIfSameSite(href);
                    } else {
                        $mmSite.openInBrowserWithAutoLoginIfSameSite(href);
                    }
                }
            }
        }
    }
    return {
        restrict: 'A',
        priority: 100,
        link: function(scope, element, attrs) {
            element.on('click', function(event) {
                if (!event.defaultPrevented) {
                    var href = element[0].getAttribute('href');
                    if (href) {
                        event.preventDefault();
                        event.stopPropagation();
                        if (attrs.captureLink && attrs.captureLink !== 'false') {
                            $mmContentLinksHelper.handleLink(href).then(function(treated) {
                                if (!treated) {
                                   navigate(href, attrs.inApp, attrs.autoLogin);
                                }
                            });
                        } else {
                            navigate(href, attrs.inApp, attrs.autoLogin);
                        }
                    }
                }
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmLoading', ["$translate", function($translate) {
    return {
        restrict: 'E',
        templateUrl: 'core/templates/loading.html',
        transclude: true,
        scope: {
            hideUntil: '=?',
            message: '@?',
            dynMessage: '=?'
        },
        link: function(scope, element, attrs) {
            if (!attrs.message) {
                $translate('mm.core.loading').then(function(loadingString) {
                    scope.message = loadingString;
                });
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmLocalFile', ["$mmFS", "$mmText", "$mmUtil", "$timeout", "$translate", function($mmFS, $mmText, $mmUtil, $timeout, $translate) {
    function loadFileBasicData(scope, file) {
        scope.fileName = file.name;
        scope.fileIcon = $mmFS.getFileIcon(file.name);
        scope.fileExtension = $mmFS.getFileExtension(file.name);
    }
    return {
        restrict: 'E',
        templateUrl: 'core/templates/localfile.html',
        scope: {
            file: '=',
            manage: '=?',
            fileDeleted: '&?',
            fileRenamed: '&?',
            overrideClick: '=?',
            fileClicked: '&?',
            noBorder: '@?'
        },
        link: function(scope, element) {
            var file = scope.file,
                relativePath;
            if (!file || !file.name) {
                return;
            }
            relativePath = $mmFS.removeBasePath(file.toURL());
            if (!relativePath) {
                relativePath = file.fullPath;
            }
            loadFileBasicData(scope, file);
            scope.data = {};
            $mmFS.getMetadata(file).then(function(metadata) {
                if (metadata.size >= 0) {
                    scope.size = $mmText.bytesToSize(metadata.size, 2);
                }
                scope.timeModified = moment(metadata.modificationTime).format('LLL');
            });
            scope.open = function(e) {
                e.preventDefault();
                e.stopPropagation();
                if (scope.overrideClick && scope.fileClicked) {
                    scope.fileClicked();
                } else {
                    $mmUtil.openFile(file.toURL());
                }
            };
            scope.activateEdit = function(e) {
                e.preventDefault();
                e.stopPropagation();
                scope.editMode = true;
                scope.data.filename = file.name;
                $timeout(function() {
                    $mmUtil.focusElement(element[0].querySelector('input'));
                });
            };
            scope.changeName = function(e, newName) {
                e.preventDefault();
                e.stopPropagation();
                if (newName == file.name) {
                    scope.editMode = false;
                    return;
                }
                var modal = $mmUtil.showModalLoading(),
                    fileAndDir = $mmFS.getFileAndDirectoryFromPath(relativePath),
                    newPath = $mmFS.concatenatePaths(fileAndDir.directory, newName);
                $mmFS.getFile(newPath).then(function() {
                    $mmUtil.showErrorModal('mm.core.errorfileexistssamename', true);
                }).catch(function() {
                    return $mmFS.moveFile(relativePath, newPath).then(function(fileEntry) {
                        scope.editMode = false;
                        scope.file = file = fileEntry;
                        loadFileBasicData(scope, file);
                        scope.fileRenamed && scope.fileRenamed({file: file});
                    }).catch(function() {
                        $mmUtil.showErrorModal('mm.core.errorrenamefile', true);
                    });
                }).finally(function() {
                    modal.dismiss();
                });
            };
            scope.deleteFile = function(e) {
                e.preventDefault();
                e.stopPropagation();
                $mmUtil.showConfirm($translate.instant('mm.core.confirmdeletefile')).then(function() {
                    var modal = $mmUtil.showModalLoading();
                    $mmFS.removeFile(relativePath).then(function() {
                        scope.fileDeleted && scope.fileDeleted();
                    }).catch(function() {
                        $mmUtil.showErrorModal('mm.core.errordeletefile', true);
                    }).finally(function() {
                        modal.dismiss();
                    });
                });
            };
        }
    };
}]);

angular.module('mm.core')
.directive('mmMarkRequired', ["$translate", "$timeout", "$mmText", function($translate, $timeout, $mmText) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var mark = attrs.mmMarkRequired && attrs.mmMarkRequired !== 'false' && attrs.mmMarkRequired !== '0',
                requiredLabel = $translate.instant('mm.core.required');
            if (mark) {
                element.append('<i class="icon ion-asterisk mm-input-required-asterisk" title="' + requiredLabel + '"></i>');
                $timeout(function() {
                    var ariaLabel = element.attr('aria-label') || $mmText.cleanTags(element.html(), true);
                    if (ariaLabel) {
                        element.attr('aria-label', ariaLabel + ' ' + requiredLabel);
                    }
                });
            } else {
                var asterisk = element[0].querySelector('.mm-input-required-asterisk');
                if (asterisk) {
                    angular.element(asterisk).remove();
                    $timeout(function() {
                        var ariaLabel = element.attr('aria-label');
                        if (ariaLabel) {
                            element.attr('aria-label', ariaLabel.replace(' ' + requiredLabel, ''));
                        }
                    });
                }
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmMultipleSelect', ["$ionicModal", "$translate", function($ionicModal, $translate) {
    return {
        restrict: 'E',
        priority: 100,
        scope: {
            title: '@',
            options: '=',
            name: '@?'
        },
        templateUrl: 'core/templates/multipleselect.html',
        link: function(scope, element, attrs) {
            var keyProperty = attrs.keyProperty || "key",
                valueProperty = attrs.valueProperty || "value",
                selectedProperty = attrs.selectedProperty || "selected",
                strSeparator = $translate.instant('mm.core.listsep') + " ";
            scope.optionsRender = [];
            scope.selectedOptions = getSelectedOptionsText();
            if (scope.name) {
                scope.selectedValues = getSelectedOptionsValues();
            }
            element.on('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                if (!scope.modal) {
                    $ionicModal.fromTemplateUrl('core/templates/multipleselectpopover.html', {
                        scope: scope,
                        animation: 'slide-in-up'
                    }).then(function(m) {
                        scope.modal = m;
                        scope.optionsRender = scope.options.map(function(option) {
                            return {
                                key: option[keyProperty],
                                value: option[valueProperty],
                                selected: option[selectedProperty] || false
                            };
                        });
                        scope.modal.show();
                    });
                } else {
                    scope.modal.show();
                }
            });
            scope.saveOptions = function() {
                angular.forEach(scope.optionsRender, function (tempOption){
                    for (var j = 0; j < scope.options.length; j++) {
                        var option = scope.options[j];
                        if (option[keyProperty] == tempOption.key) {
                            option[selectedProperty] = tempOption.selected;
                            return;
                        }
                    }
                });
                scope.selectedOptions = getSelectedOptionsText();
                if (scope.name) {
                    scope.selectedValues = getSelectedOptionsValues();
                }
                scope.closeModal();
            };
            function getSelectedOptionsText() {
                var selected = scope.options.filter(function(option) {
                    return !!option[selectedProperty];
                }).map(function(option) {
                    return option[valueProperty];
                });
                return selected.join(strSeparator);
            }
            function getSelectedOptionsValues() {
                var selected = scope.options.filter(function(option) {
                    return !!option[selectedProperty];
                }).map(function(option) {
                    return option[keyProperty];
                });
                return selected.join('###');
            }
            scope.closeModal = function(){
                scope.modal.hide();
            };
            scope.$on('$destroy', function () {
                if (scope.modal){
                    scope.modal.remove();
                }
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmNavButtons', ["$document", "$mmUtil", "$compile", "$timeout", function($document, $mmUtil, $compile, $timeout) {
    function callBeforeEnter(controller, eventData, $scope) {
        var data = angular.copy(eventData);
        delete data.navBarItems;
        data.viewNotified = false;
        data.shouldAnimate = false;
        var previousTitles = document.querySelectorAll('ion-header-bar .back-button .back-text .previous-title'),
            modifiedTitles = [];
        angular.forEach(previousTitles, function(title, index) {
            if (title.innerHTML == 'undefined') {
                angular.element(title).css('display', 'none');
                modifiedTitles.push(title);
            }
        });
        controller.beforeEnter(undefined, data);
        $timeout(function() {
            angular.forEach($scope.$$watchers, function(watcher) {
                var value = watcher.get($scope);
                if (typeof value != 'undefined') {
                    watcher.last = value;
                    watcher.fn(value, undefined, $scope);
                }
            });
        });
        $timeout(function() {
            angular.forEach(modifiedTitles, function(title) {
                angular.element(title).css('display', '');
            });
        }, 1000);
    }
    return {
        restrict: 'E',
        require: '^ionNavBar',
        priority: 100,
        compile: function(tElement, tAttrs) {
            var side = 'left';
            if (/^primary|secondary|right$/i.test(tAttrs.side || '')) {
                side = tAttrs.side.toLowerCase();
            }
            var spanEle = $document[0].createElement('span');
            spanEle.className = side + '-buttons';
            spanEle.innerHTML = tElement.html();
            var navElementType = side + 'Buttons';
            tElement.attr('class', 'hide');
            tElement.empty();
            return {
                pre: function($scope, $element, $attrs, navBarCtrl) {
                    var splitView = $mmUtil.closest($element[0], 'mm-split-view'),
                        ionView,
                        unregisterViewListener,
                        parentViewCtrl;
                    if (splitView) {
                        ionView = $mmUtil.closest(splitView, 'ion-view');
                    } else {
                        ionView = $mmUtil.closest($element[0], 'ion-view');
                    }
                    if (!ionView) {
                        return;
                    }
                    parentViewCtrl = angular.element(ionView).data('$ionViewController');
                    if (parentViewCtrl) {
                        if (splitView) {
                            var svController = angular.element(splitView).controller('mmSplitView'),
                                eventData,
                                leftPaneButtons,
                                leftPaneButtonsHtml,
                                timeToWait;
                            if (!svController) {
                                return;
                            }
                            timeToWait = 1000 - (new Date().getTime() - svController.getStartTime());
                            $timeout(function() {
                                eventData = svController.getIonicViewEventData();
                                leftPaneButtonsHtml = svController.getHeaderBarButtonsHtml(spanEle.className);
                                if (leftPaneButtonsHtml && leftPaneButtonsHtml.trim()) {
                                    leftPaneButtons = angular.element(leftPaneButtonsHtml);
                                }
                                spanEle = $compile(spanEle.outerHTML)($scope);
                                var contextMenus = spanEle[0].querySelectorAll('mm-context-menu');
                                if (contextMenus.length) {
                                    angular.element(contextMenus).remove();
                                }
                                if (leftPaneButtons && leftPaneButtons.length) {
                                    if (side == 'secondary' || side == 'right') {
                                        spanEle.prepend(leftPaneButtons);
                                    } else {
                                        spanEle.append(leftPaneButtons);
                                    }
                                }
                                parentViewCtrl.navElement(navElementType, spanEle);
                                callBeforeEnter(parentViewCtrl, eventData, $scope);
                                unregisterViewListener = svController.onViewEvent(function(eventData) {
                                    callBeforeEnter(parentViewCtrl, eventData, $scope);
                                });
                                spanEle = null;
                            }, timeToWait);
                        } else {
                            parentViewCtrl.navElement(navElementType, spanEle.outerHTML);
                            spanEle = null;
                        }
                    } else {
                        navBarCtrl.navElement(navElementType, spanEle.outerHTML);
                        spanEle = null;
                    }
                    $scope.$on('$destroy', function() {
                        if (unregisterViewListener) {
                            unregisterViewListener();
                        }
                    });
                }
            };
        }
    };
}]);

angular.module('mm.core')
.directive('mmNavigationBar', ["$state", "$translate", function($state, $translate) {
    return {
        restrict: 'E',
        scope: {
            previous: '=?',
            next: '=?',
            action: '=?',
            info: '=?',
            component: '@?',
            componentId: '@?'
        },
        templateUrl: 'core/templates/navigationbar.html',
        link: function(scope, element, attrs) {
            scope.title = attrs.title || $translate.instant('mm.core.info');
            scope.showInfo = function() {
                $state.go('site.mm_textviewer', {
                    title: scope.title,
                    content: scope.info,
                    component: attrs.component,
                    componentId: attrs.componentId
                });
            };
        }
    };
}]);

angular.module('mm.core')
.directive('mmNoInputValidation', function() {
    return {
        restrict: 'A',
        priority: 500,
        compile: function(el, attrs) {
            attrs.$set('type',
                null,                
                false                
            );
        }
    }
});

angular.module('mm.core')
.directive('mmProgressBar', function() {
    return {
        restrict: 'E',
        scope: {
            progress: '=',
            text: '=?'
        },
        templateUrl: 'core/templates/progressbar.html',
        link: function(scope) {
            scope.progress = parseInt(scope.progress, 10);
            if (scope.progress < 0 || isNaN(scope.progress)) {
                scope.progress = false;
            } else if (!scope.text) {
                scope.text = scope.progress;
            }
        }
    };
});

angular.module('mm.core')
.directive('mmRecaptcha', ["$log", "$mmLang", "$mmSite", "$mmFS", "$sce", "$ionicModal", "$timeout", function($log, $mmLang, $mmSite, $mmFS, $sce, $ionicModal, $timeout) {
    $log = $log.getInstance('mmIframe');
    function setupCaptcha(scope) {
        scope.recaptchaV1Enabled = !!(scope.publickey && scope.challengehash && scope.challengeimage);
        scope.recaptchaV2Enabled = !!(scope.publickey && !scope.challengehash && !scope.challengeimage);
        if (scope.recaptchaV2Enabled && !scope.initializedV2) {
            scope.initializedV2 = true;
            $mmLang.getCurrentLanguage().then(function(lang) {
                var untrustedUrl = $mmFS.concatenatePaths(scope.siteurl, 'webservice/recaptcha.php?lang=' + lang);
                scope.iframeSrc = $sce.trustAsResourceUrl(untrustedUrl);
            });
            $ionicModal.fromTemplateUrl('core/templates/recaptchamodal.html', {
                scope: scope,
                animation: 'slide-in-up'
            }).then(function(m) {
                scope.modal = m;
            });
            scope.closeModal = function(){
                scope.modal.hide();
            };
            scope.answerRecaptchaV2 = function() {
                scope.modal.show();
            };
            scope.iframeLoaded = function() {
                var iframe = scope.modal.modalEl.querySelector('iframe'),
                    contentWindow = iframe && iframe.contentWindow;
                if (contentWindow) {
                    contentWindow.recaptchacallback = function(value) {
                        scope.expired = false;
                        scope.model[scope.modelValueName] = value;
                        scope.closeModal();
                    };
                    contentWindow.recaptchaexpiredcallback = function() {
                        scope.expired = true;
                        scope.model[scope.modelValueName] = '';
                        $timeout(); 
                    };
                }
            };
        } else if (scope.recaptchaV1Enabled && !scope.initializedV1) {
            scope.initializedV1 = true;
            scope.requestCaptchaV1 = function() {
                scope.requestCaptcha && scope.requestCaptcha();
            };
        }
        scope.$on('$destroy', function() {
            scope.modal && scope.modal.remove();
        });
    }
    return {
        restrict: 'E',
        templateUrl: 'core/templates/recaptcha.html',
        scope: {
            model: '=',
            publickey: '@',
            modelValueName: '@?',
            siteurl: '@?',
            challengehash: '@?',
            challengeimage: '@?',
            requestCaptcha: '&?'
        },
        link: function(scope) {
            scope.siteurl = scope.siteurl || $mmSite.getURL();
            scope.modelValueName = scope.modelValueName || 'recaptcharesponse';
            scope.initializedV2 = false;
            scope.initializedV1 = false;
            setupCaptcha(scope);
            scope.$watchGroup(['publickey', 'challengehash', 'challengeimage'], function() {
                setupCaptcha(scope);
            });
            scope.$on('mmCore:ResetRecaptchaV2', function() {
                scope.model.recaptcharesponse = '';
                var currentSrc = scope.iframeSrc;
                scope.iframeSrc = '';
                $timeout(function() {
                    scope.iframeSrc = currentSrc;
                });
            });
        }
    };
}]);

angular.module('mm.core')
.directive('mmRichTextEditor', ["$ionicPlatform", "$mmLang", "$timeout", "$q", "$window", "$ionicScrollDelegate", "$mmUtil", "$mmSite", "$mmFilepool", function($ionicPlatform, $mmLang, $timeout, $q, $window, $ionicScrollDelegate, $mmUtil,
            $mmSite, $mmFilepool) {
    var editorInitialHeightDefault = 300,
        adjustHeightDefault = true,
        frameTags = ['iframe', 'frame', 'object', 'embed'];
    function calculateFixedBarsHeight(editorEl) {
        var ionContentEl = editorEl.parentElement;
        while (ionContentEl && ionContentEl.nodeName != 'ION-CONTENT') {
            ionContentEl = ionContentEl.parentElement;
        }
        if (ionContentEl.nodeName == 'ION-CONTENT') {
            return $window.innerHeight - $mmUtil.getElementHeight(ionContentEl);
        } else {
            return 0;
        }
    }
    function changeLanguageCode(lang) {
        var split = lang.split('-');
        if (split.length > 1) {
            split[1] = split[1].toUpperCase();
            return split.join('_');
        } else {
            return lang;
        }
    }
    function getCKEditorController(element) {
        var ckeditorEl = element.querySelector('textarea[ckeditor]');
        if (ckeditorEl) {
            return angular.element(ckeditorEl).controller('ckeditor');
        }
    }
    function getSurroundingHeight(element, top) {
        var height = 0;
        while (element.parentNode && element.parentNode.tagName != "ION-CONTENT" && (!top || element != top)) {
            var parent = element.parentNode;
            angular.forEach(parent.childNodes, function(child) {
                if (child.tagName && element.tagName && element.tagName != 'MM-LOADING' && child != element) {
                    height += $mmUtil.getElementHeight(child, false, true, true);
                }
            });
            element = parent;
        }
        var cs = getComputedStyle(element);
        height += (parseInt(cs.paddingTop, 10) + parseInt(cs.paddingBottom, 10));
        return height;
    }
    function searchAndFormatWysiwyg(element, component, componentId, tries) {
        if (typeof tries == 'undefined') {
            tries = 0;
        }
        var wysiwygIframe = element.querySelector('.cke_wysiwyg_frame');
        if (wysiwygIframe) {
            treatFrame(wysiwygIframe, component, componentId);
            return $q.when(wysiwygIframe);
        } else if (tries < 5) {
            return $timeout(function() {
                return searchAndFormatWysiwyg(element, component, componentId, tries+1);
            }, 100);
        }
    }
    function treatFrame(element, component, componentId) {
        if (element) {
            var loaded = false;
            element = angular.element(element);
            element.on('load', function() {
                if (!loaded) {
                    loaded = true;
                    treatExternalContent(element, component, componentId);
                    treatSubframes(element, component, componentId);
                }
            });
            $timeout(function() {
                if (!loaded) {
                    loaded = true;
                    treatExternalContent(element, component, componentId);
                    treatSubframes(element, component, componentId);
                }
            }, 1000);
        }
    }
    function treatSubframes(element, component, componentId) {
        var el = element[0],
            contentWindow = element.contentWindow || el.contentWindow,
            contents = element.contents();
        if (!contentWindow && el && el.contentDocument) {
            contentWindow = el.contentDocument.defaultView;
        }
        if (!contentWindow && el && el.getSVGDocument) {
            var svgDoc = el.getSVGDocument();
            if (svgDoc && svgDoc.defaultView) {
                contents = angular.element(svgdoc);
            }
        }
        angular.forEach(frameTags, function(tag) {
            angular.forEach(contents.find(tag), function(subelement) {
                treatFrame(angular.element(subelement), component, componentId);
            });
        });
    }
    function treatExternalContent(element, component, componentId) {
        var elements = element.contents().find('img');
        angular.forEach(elements, function(el) {
            var url = el.src,
                siteId = $mmSite.getId();
            if (!url || !$mmUtil.isDownloadableUrl(url) || (!$mmSite.canDownloadFiles() && $mmUtil.isPluginFileUrl(url))) {
                return;
            }
            return $mmFilepool.getSrcByUrl(siteId, url, component, componentId).then(function(finalUrl) {
                el.setAttribute('src', finalUrl);
            });
        });
    }
    return {
        restrict: 'E',
        templateUrl: 'core/templates/richtexteditor.html',
        scope: {
            model: '=',
            property: '@?',
            placeholder: '@?',
            options: '=?',
            tabletOptions: '=?',
            phoneOptions: '=?',
            scrollHandle: '@?',
            name: '@?',
            textChange: '&?',
            firstRender: '&?',
            component: '@?',
            componentId: '@?',
            required: '@?'
        },
        link: function(scope, element) {
            element = element[0];
            var defaultOptions = {
                    allowedContent: true,
                    defaultLanguage: 'en',
                    height: editorInitialHeightDefault,
                    adjustHeight: adjustHeightDefault,
                    toolbarCanCollapse: true,
                    toolbarStartupExpanded: false,
                    toolbar: [
                        {name: 'basicstyles', items: ['Bold', 'Italic']},
                        {name: 'styles', items: ['Format']},
                        {name: 'links', items: ['Link', 'Unlink']},
                        {name: 'lists', items: ['NumberedList', 'BulletedList']},
                        '/',
                        {name: 'document', items: ['Source', 'RemoveFormat']},
                        {name: 'tools', items: [ 'Maximize' ]}
                    ],
                    toolbarLocation: 'bottom',
                    removePlugins: 'elementspath,resize,pastetext,pastefromword,clipboard,image',
                    removeButtons: ''
                },
                scrollView,
                resized = false,
                fixedBarsHeight,
                component = scope.component,
                componentId = scope.componentId,
                firstChange = true,
                renderTime,
                editorInitialHeight = editorInitialHeightDefault,
                adjustHeight = adjustHeightDefault;
            scope.property = typeof scope.property == 'string' ? scope.property : 'text';
            if (scope.scrollHandle) {
                scrollView = $ionicScrollDelegate.$getByHandle(scope.scrollHandle);
            }
            $mmUtil.isRichTextEditorEnabled().then(function(enabled) {
                var promise;
                scope.richTextEditor = !!enabled;
                renderTime = new Date().getTime();
                if (enabled) {
                    promise = $mmLang.getCurrentLanguage().then(function(lang) {
                        defaultOptions.language = changeLanguageCode(lang);
                    });
                } else {
                    promise = $q.when();
                }
                promise.then(function() {
                    if ($ionicPlatform.isTablet()) {
                        scope.editorOptions = angular.extend(defaultOptions, scope.options, scope.tabletOptions);
                    } else {
                        scope.editorOptions = angular.extend(defaultOptions, scope.options, scope.phoneOptions);
                    }
                    editorInitialHeight = scope.editorOptions.height;
                    adjustHeight = scope.editorOptions.adjustHeight;
                    if (!enabled) {
                        textareaReady();
                    }
                });
            });
            function textareaReady() {
                var editorEl;
                $timeout(function() {
                    if (firstChange) {
                        firstChange = false;
                        editorEl = element.querySelector('.mm-textarea');
                        resizeContentTextarea(editorEl);
                        ionic.on('resize', onResize, window);
                    }
                }, 1000);
                scope.$on('$destroy', function() {
                    ionic.off('resize', onResize, window);
                });
                function onResize() {
                    resizeContentTextarea(editorEl);
                }
            }
            scope.editorReady = function() {
                var collapser = element.querySelector('.cke_toolbox_collapser'),
                    firstButton = element.querySelector('.cke_toolbox_main .cke_toolbar:first-child'),
                    lastButton = element.querySelector('.cke_toolbox_main .cke_toolbar:last-child'),
                    toolbar = element.querySelector('.cke_bottom'),
                    editorEl = element.querySelector('.cke'),
                    contentsEl = element.querySelector('.cke_contents'),
                    sourceCodeButton = element.querySelector('.cke_button__source'),
                    seeingSourceCode = false,
                    wysiwygIframe,
                    unregisterDialogListener,
                    editorController;
                searchAndFormatWysiwyg(element, component, componentId).then(function(iframe) {
                    wysiwygIframe = iframe;
                });
                if (firstButton && lastButton && collapser && toolbar) {
                    if (firstButton.offsetTop == lastButton.offsetTop) {
                        angular.element(collapser).css('display', 'none');
                    }
                    angular.element(collapser).on('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        angular.element(toolbar).toggleClass('cke_expanded');
                        if (resized) {
                            resizeContent(editorEl, contentsEl, toolbar);
                        }
                    });
                }
                if (sourceCodeButton) {
                    angular.element(sourceCodeButton).on('click', function() {
                        $timeout(function() {
                            seeingSourceCode = !seeingSourceCode;
                            if (!seeingSourceCode) {
                                searchAndFormatWysiwyg(element, component, componentId).then(function(iframe) {
                                    wysiwygIframe = iframe;
                                });
                            }
                        });
                    });
                }
                if (scope.richTextEditor) {
                    $timeout(function() {
                        if (firstChange) {
                            if (scope.firstRender) {
                                scope.firstRender();
                            }
                            firstChange = false;
                            resizeContent(editorEl, contentsEl, toolbar);
                        }
                    }, 1000);
                }
                editorController = getCKEditorController(element);
                ionic.on('resize', onResize, window);
                scope.$on('$destroy', function() {
                    if (editorController && editorController.instance) {
                        editorController.instance.destroy(false);
                    }
                    ionic.off('resize', onResize, window);
                    if (unregisterDialogListener) {
                        unregisterDialogListener();
                    }
                });
                function onResize() {
                    resizeContent(editorEl, contentsEl, toolbar);
                    if (firstButton.offsetTop == lastButton.offsetTop) {
                        angular.element(collapser).css('display', 'none');
                    } else {
                        angular.element(collapser).css('display', 'block');
                    }
                }
            };
            scope.onChange = function() {
                if (scope.richTextEditor && firstChange && scope.firstRender && new Date().getTime() - renderTime < 1000) {
                    scope.firstRender();
                }
                firstChange = false;
                if (scope.textChange) {
                    scope.textChange();
                }
            };
            function resizeContentTextarea(editorEl) {
                var editorHeight = editorInitialHeight,
                    contentVisibleHeight,
                    screenSmallerThanEditor;
                if (typeof fixedBarsHeight == 'undefined') {
                    fixedBarsHeight = calculateFixedBarsHeight(editorEl);
                }
                contentVisibleHeight = $window.innerHeight - fixedBarsHeight;
                if (adjustHeight && contentVisibleHeight > 0) {
                    var topElement,
                        height;
                    if (adjustHeight !== true) {
                        topElement = document.getElementById(adjustHeight);
                        contentVisibleHeight = $mmUtil.getElementHeight(topElement) || contentVisibleHeight;
                    }
                    height = getSurroundingHeight(element, topElement);
                    if (contentVisibleHeight > height) {
                        editorHeight = contentVisibleHeight - height;
                        editorInitialHeight = editorHeight;
                    }
                }
                screenSmallerThanEditor = contentVisibleHeight > 0 && contentVisibleHeight < editorHeight;
                if (resized && !screenSmallerThanEditor) {
                    undoResize(editorEl);
                } else if (editorHeight > 60 && (resized || screenSmallerThanEditor || adjustHeight)) {
                    angular.element(editorEl).css('height', editorHeight + 'px');
                    resized = true;
                }
            }
            function resizeContent(editorEl, contentsEl, toolbar) {
                var toolbarHeight = $mmUtil.getElementHeight(toolbar),
                    editorWithToolbarHeight = editorInitialHeight + toolbarHeight,
                    contentVisibleHeight,
                    editorContentNewHeight,
                    screenSmallerThanEditor,
                    editorMaximized;
                if (typeof fixedBarsHeight == 'undefined') {
                    fixedBarsHeight = calculateFixedBarsHeight(editorEl);
                }
                editorMaximized = !!editorEl.querySelector('.cke_maximized');
                contentVisibleHeight = $window.innerHeight - fixedBarsHeight;
                if (adjustHeight && !editorMaximized && contentVisibleHeight > 0) {
                    var topElement,
                        height;
                    if (adjustHeight !== true) {
                        topElement = document.getElementById(adjustHeight);
                        contentVisibleHeight = $mmUtil.getElementHeight(topElement) || contentVisibleHeight;
                    }
                    height = getSurroundingHeight(element, topElement);
                    if (contentVisibleHeight > height) {
                        editorWithToolbarHeight = contentVisibleHeight - height;
                        editorInitialHeight = editorWithToolbarHeight - toolbarHeight;
                    }
                }
                screenSmallerThanEditor = !editorMaximized && contentVisibleHeight > 0 &&
                    contentVisibleHeight < editorWithToolbarHeight;
                editorContentNewHeight = editorWithToolbarHeight - toolbarHeight;
                if (resized && !screenSmallerThanEditor) {
                    undoResize(editorEl, contentsEl);
                } else if (editorContentNewHeight > 60 && (resized || screenSmallerThanEditor || adjustHeight)) {
                    angular.element(editorEl).css('height', editorWithToolbarHeight + 'px');
                    angular.element(contentsEl).css('height', editorContentNewHeight + 'px');
                    resized = true;
                    if (scrollView) {
                        var focused = document.activeElement;
                        if (focused) {
                            var parentEditor = $mmUtil.closest(focused, '.cke');
                            if (parentEditor == editorEl) {
                                $mmUtil.scrollToElement(editorEl, undefined, scrollView);
                            }
                        }
                    }
                }
            }
            function undoResize(editorEl, contentsEl) {
                if (contentsEl) {
                    angular.element(editorEl).css('height', '');
                    angular.element(contentsEl).css('height', editorInitialHeight + 'px');
                } else {
                    angular.element(editorEl).css('height', editorInitialHeight + 'px');
                }
                resized = false;
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmSearchbox', ["$translate", "$mmUtil", function($translate, $mmUtil) {
    return {
        restrict: 'E',
        scope: {
            submitAction: '=',
            initialValue: '@?',
            searchLabel: '@?',
            placeholder: '@?',
            autocorrect: '@?',
            spellcheck: '@?',
            autofocus: '@?',
            lengthCheck: '@?'
        },
        templateUrl: 'core/templates/searchbox.html',
        link: function(scope, element) {
            scope.data = {
                value : scope.initialValue ? scope.initialValue : "",
                placeholder: scope.placeholder ? scope.placeholder : $translate.instant('mm.core.search'),
                autocorrect: scope.autocorrect ? scope.autocorrect : 'on',
                spellcheck: scope.spellcheck ? scope.spellcheck : 'true',
                searchLabel: scope.searchLabel ? scope.searchLabel : $translate.instant('mm.core.search'),
                autofocus: scope.autofocus && scope.autofocus != "false",
                lengthCheck: scope.lengthCheck ? scope.lengthCheck : 3
            };
            scope.seachBoxSubmit = function() {
                if (scope.data.value.length < scope.data.lengthCheck) {
                    return;
                }
                return scope.submitAction(scope.data.value);
            };
        }
    };
}]);

angular.module('mm.core')
.directive('mmShowPassword', ["$compile", function($compile) {
    var buttonHtml = '<a class="button button-clear icon" aria-label="{{ label | translate }}" ' +
                        'ng-class="{\'ion-eye\': !shown, \'ion-eye-disabled\': shown}" ng-click="toggle()" ' +
                        'mm-keep-keyboard="{{selector}}" keep-in-button="true"></a>';
    return {
        restrict: 'A',
        scope: true,
        link: function(scope, element, attrs) {
            var button;
            if (element[0].id) {
                scope.selector = '#' + element[0].id;
            } else if (element[0].name) {
                scope.selector = element[0].tagName.toLowerCase() + '[name="' + elm[0].name + '"]';
            } else {
                scope.selector = '';
            }
            button = $compile(angular.element(buttonHtml))(scope);
            element.wrap('<div class="item-input-inset mm-show-password-container">');
            element.after(button);
            if (!element.attr('autocorrect')) {
                element.attr('autocorrect', 'off');
            }
            if (!element.attr('autocapitalize')) {
                element.attr('autocapitalize', 'none');
            }
            scope.shown = attrs.initialShown && attrs.initialShown !== 'false';
            setData();
            scope.toggle = function() {
                scope.shown = !scope.shown;
                setData();
            };
            function setData() {
                scope.label = scope.shown ? 'mm.core.hide' : 'mm.core.show';
                element[0].type = scope.shown ? 'text' : 'password';
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmSitePicker', ["$mmSitesManager", "$mmSite", "$translate", "$mmText", "$q", function($mmSitesManager, $mmSite, $translate, $mmText, $q) {
    return {
        restrict: 'E',
        templateUrl: 'core/templates/sitepicker.html',
        scope: {
            siteSelected: '&',
            initialSite: '@?'
        },
        link: function(scope) {
            scope.selectedSite = scope.initialSite || $mmSite.getId();
            $mmSitesManager.getSites().then(function(sites) {
                var promises = [];
                sites.forEach(function(site) {
                    promises.push($mmText.formatText(site.sitename, true, true).catch(function() {
                        return site.sitename;
                    }).then(function(formatted) {
                        site.fullnameandsitename = $translate.instant('mm.core.fullnameandsitename',
                                {fullname: site.fullname, sitename: formatted});
                    }));
                });
                return $q.all(promises).then(function() {
                    scope.sites = sites;
                });
            });
        }
    };
}]);

angular.module('mm.core')
.constant('mmCoreSplitViewLoad', 'mmSplitView:load')
.constant('mmCoreSplitViewBlock', 'mmSplitView:block')
.controller('mmSplitView', ["$state", "$ionicPlatform", "$timeout", "$interpolate", function($state, $ionicPlatform, $timeout, $interpolate) {
    var self = this,
        element,
        menuState,
        linkToLoad,
        candidateLink,
        component,
        ionicViewEventData,
        viewEventListeners = [],
        headerBarButtons = {},
        headerButtonTypes = ['primary-buttons', 'secondary-buttons', 'left-buttons', 'right-buttons'],
        startTime = new Date().getTime();
    this.clearMarkedLinks = function() {
        angular.element(element.querySelectorAll('[mm-split-view-link]')).removeClass('mm-split-item-selected');
    };
    this.getCandidateLink = function() {
        return candidateLink;
    };
    this.getComponent = function() {
        return component;
    };
    this.getHeaderBarButtons = function(type) {
        if (!type) {
            return headerBarButtons;
        } else {
            return headerBarButtons[type];
        }
    };
    this.getHeaderBarButtonsHtml = function(type) {
        if (headerBarButtons[type]) {
            return headerBarButtons[type].innerHTML;
        }
    };
    this.getHeaderBarWithState = function(state) {
        var bars = document.querySelectorAll('ion-header-bar');
        for (var i = 0; i < bars.length; i++) {
            var bar = bars[i],
                barState = bar.parentElement && bar.parentElement.getAttribute('nav-bar');
            if (barState == state) {
                return bar;
            }
        }
    };
    this.getIonicViewEventData = function() {
        return ionicViewEventData || {};
    };
    this.getMenuState = function() {
        return menuState || $state.current.name;
    };
    this.getInactiveHeaderBar = function() {
        var bars = document.querySelectorAll('ion-header-bar'),
            activePosition = -1;
        for (var i = 0; i < bars.length; i++) {
            var bar = bars[i],
                barState = bar.parentElement && bar.parentElement.getAttribute('nav-bar');
            if (barState == 'active') {
                activePosition = i;
            }
        }
        if (activePosition === 0) {
            return bars[1];
        } else if (activePosition > 0) {
            return bars[0];
        }
    };
    this.getStartTime = function() {
        return startTime;
    };
    this.loadLink = function(scope, loadAttr, retrying) {
        if ($ionicPlatform.isTablet()) {
            if (!linkToLoad) {
                if (typeof loadAttr != 'undefined') {
                    var position = parseInt(loadAttr);
                    if (!position) {
                        position = parseInt($interpolate(loadAttr)(scope), 10); 
                    }
                    if (position) {
                        var links = element.querySelectorAll('[mm-split-view-link]');
                        position = position > links.length ? 0 : position - 1;
                        linkToLoad = angular.element(links[position]);
                    } else {
                        linkToLoad = angular.element(element.querySelector('[mm-split-view-link]'));
                    }
                } else {
                    linkToLoad = angular.element(element.querySelector('[mm-split-view-link]'));
                }
            }
            if (!this.triggerClick(linkToLoad)) {
                if (!retrying) {
                    linkToLoad = undefined;
                    $timeout(function() {
                        self.loadLink(scope, loadAttr, true);
                    });
                }
            }
        }
    };
    self.onViewEvent = function(callBack) {
        if (!angular.isFunction(callBack)) {
            return;
        }
        viewEventListeners.push(callBack);
        return function() {
          var position = viewEventListeners.indexOf(callBack);
          if (position !== -1) {
            viewEventListeners.splice(position, 1);
          }
        };
    };
    self.saveHeaderBarButtons = function() {
        var headerBar = this.getHeaderBarWithState('entering');
        if (!headerBar) {
            headerBar = this.getInactiveHeaderBar();
            if (!headerBar) {
                return;
            }
        }
        headerButtonTypes.forEach(function(type) {
            headerBarButtons[type] = headerBar.querySelector('.' + type);
        });
    };
    this.setCandidateLink = function(link) {
        candidateLink = link;
    };
    this.setComponent = function(cmp) {
        component = cmp;
    };
    this.setElement = function(el) {
        element = el;
    };
    this.setLink = function(link) {
        linkToLoad = link;
        this.setCandidateLink(null);
    };
    this.setMenuState = function(state) {
        menuState = state;
    };
    this.setIonicViewEventData = function(data) {
        ionicViewEventData = data;
        angular.forEach(viewEventListeners, function(listener) {
            if (angular.isFunction(listener)) {
                listener(data);
            }
        });
    };
    this.triggerClick = function(link) {
        if (link && link.length && link.triggerHandler) {
            link.triggerHandler('click');
            return true;
        }
        return false;
    };
}])
.directive('mmSplitView', ["$log", "$state", "$ionicPlatform", "$mmUtil", "mmCoreSplitViewLoad", "mmCoreSplitViewBlock", function($log, $state, $ionicPlatform, $mmUtil, mmCoreSplitViewLoad, mmCoreSplitViewBlock) {
    $log = $log.getInstance('mmSplitView');
    return {
        restrict: 'E',
        templateUrl: 'core/templates/splitview.html',
        transclude: true,
        controller: 'mmSplitView',
        link: function(scope, element, attrs, controller) {
            var el = element[0],
                menu = angular.element(el.querySelector('.mm-split-pane-menu')),
                menuState = attrs.menuState || $state.$current.name,
                menuParams = $state.params,
                menuWidth = attrs.menuWidth,
                component = attrs.component || 'tablet',
                stateChangeListener,
                currentBlockFunction,
                leaving = false;
            controller.saveHeaderBarButtons();
            scope.component = component;
            controller.setComponent(component);
            controller.setElement(el);
            controller.setMenuState(menuState);
            if (menuWidth && $ionicPlatform.isTablet()) {
                menu.css('width', menuWidth);
                menu.css('-webkit-flex-basis', menuWidth);
                menu.css('-moz-flex-basis', menuWidth);
                menu.css('-ms-flex-basis', menuWidth);
                menu.css('flex-basis', menuWidth);
            }
            if (attrs.loadWhen) {
                scope.$watch(attrs.loadWhen, function(newValue) {
                    if (newValue) {
                        controller.loadLink(scope, attrs.load);
                    }
                });
            } else {
                controller.loadLink(scope, attrs.load);
            }
            scope.$on('$stateChangeSuccess', function(event, toState, toParams, fromState, fromParams) {
                if (toState.name === menuState && $mmUtil.basicLeftCompare(toParams, menuParams, 1)) {
                    controller.loadLink(); 
                }
            });
            scope.$on(mmCoreSplitViewLoad, function(e, data) {
                if (data && data.load) {
                    controller.loadLink(scope, data.load);
                } else {
                    controller.loadLink(scope, attrs.load);
                }
            });
            scope.$on('$ionicView.beforeEnter', eventReceived);
            scope.$on('$ionicView.afterEnter', eventReceived);
            scope.$on(mmCoreSplitViewBlock, blockEventReceived);
            function eventReceived(e, data) {
                if (controller.getIonicViewEventData().transitionId != data.transitionId) {
                    controller.setIonicViewEventData(data);
                }
            }
            function blockEventReceived(e, data) {
                if (!data || data.state != menuState || !$mmUtil.basicLeftCompare(data.stateParams, menuParams, 1)) {
                    return;
                }
                if (data.block && data.blockFunction) {
                    stateChangeListener && stateChangeListener();
                    stateChangeListener = scope.$on('$stateChangeStart', function(event, toState, toParams) {
                        event.preventDefault();
                        if (leaving) {
                            return;
                        }
                        leaving = true;
                        data.blockFunction().then(function() {
                            var candidateLink = controller.getCandidateLink();
                            stateChangeListener && stateChangeListener();
                            if (!controller.triggerClick(candidateLink)) {
                                return $state.go(toState.name, toParams);
                            }
                        }).finally(function() {
                            leaving = false;
                            controller.setCandidateLink(null);
                        });
                    });
                } else if (!data.block && currentBlockFunction && currentBlockFunction === data.blockFunction) {
                    stateChangeListener && stateChangeListener();
                }
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmSplitViewLink', ["$log", "$ionicPlatform", "$state", "$mmApp", function($log, $ionicPlatform, $state, $mmApp) {
    $log = $log.getInstance('mmSplitViewLink');
    function createTabletState(stateName, tabletStateName, newViewName) {
        var targetState = $state.get(stateName),
            newConfig,
            viewName;
        if (targetState) {
            newConfig = angular.copy(targetState);
            viewName = Object.keys(newConfig.views)[0];
            newConfig.views[newViewName] = newConfig.views[viewName];
            delete newConfig.views[viewName];
            delete newConfig['name'];
            $mmApp.createState(tabletStateName, newConfig);
            return true;
        } else {
            $log.error('State doesn\'t exist: '+stateName);
            return false;
        }
    }
    function scopeEval(scope, value) {
        if (typeof value == 'string') {
            try {
                return angular.copy(scope.$eval(value));
            } catch(ex) {
                $log.error('Error evaluating string: ' + param);
            }
        }
    }
    function parseStateRef(ref, current) {
      var preparsed = ref.match(/^\s*({[^}]*})\s*$/), parsed;
      if (preparsed) ref = current + '(' + preparsed[1] + ')';
      parsed = ref.replace(/\n/g, " ").match(/^([^(]+?)\s*(\((.*)\))?$/);
      if (!parsed || parsed.length !== 4) return false;
      return { state: parsed[1], paramExpr: parsed[3] || null };
    }
    function fillStateParams(stateParams, state) {
        if (!stateParams || !state || !state.params) {
            return;
        }
        angular.forEach(state.params, function(defaultValue, name) {
            if (typeof stateParams[name] == 'undefined') {
                stateParams[name] = defaultValue;
            }
        });
    }
    return {
        restrict: 'A',
        require: '^mmSplitView',
        link: function(scope, element, attrs, splitViewController) {
            var sref = attrs.mmSplitViewLink ? parseStateRef(attrs.mmSplitViewLink, $state.current.name) : false,
                menuState = splitViewController.getMenuState(),
                stateName,
                stateParams,
                stateParamsString,
                tabletStateName,
                stateParamsFilled = false;
            if (sref) {
                stateName = sref.state; 
                tabletStateName = menuState + '.' + stateName.substr(stateName.lastIndexOf('.') + 1);
                stateParamsString = sref.paramExpr; 
                stateParams = scopeEval(scope, stateParamsString);
                scope.$watch(stateParamsString, function(newVal) {
                    stateParams = angular.copy(newVal);
                    fillStateParams(stateParams, $state.get(tabletStateName));
                }, true);
                element.on('click', function(event) {
                    event.stopPropagation();
                    event.preventDefault();
                    if (!stateParamsFilled) {
                        fillStateParams(stateParams, $state.get(tabletStateName));
                        stateParamsFilled = true;
                    }
                    if ($ionicPlatform.isTablet()) {
                        if (!$state.get(tabletStateName)) {
                            if (!createTabletState(stateName, tabletStateName, splitViewController.getComponent())) {
                                return;
                            }
                        }
                        splitViewController.setCandidateLink(element);
                        $state.go(tabletStateName, stateParams, {location:'replace'}).then(function() {
                            splitViewController.setLink(element);
                            splitViewController.clearMarkedLinks();
                            element.addClass('mm-split-item-selected');
                        });
                    } else {
                        $state.go(stateName, stateParams);
                    }
                });
            } else {
                $log.error('Invalid sref ' + attrs.mmSplitViewLink + '.');
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmStateClass', ["$state", function($state) {
    return {
        restrict: 'A',
        link: function(scope, el) {
            var current = $state.$current.name,
                split,
                className = 'mm-';
            if (typeof current == 'string') {
                split = current.split('.');
                className += split.shift();
                if (split.length) {
                    className += '_' + split.pop();
                }
                el.addClass(className);
            }
        }
    };
}]);

angular.module('mm.core')
.directive('mmTimer', ["$interval", "$mmUtil", function($interval, $mmUtil) {
    return {
        restrict: 'E',
        scope: {
            endTime: '=',
            finished: '&'
        },
        templateUrl: 'core/templates/timer.html',
        link: function(scope, element, attrs) {
            if (!scope.endTime || !scope.finished) {
                return;
            }
            var timeLeftClass = attrs.timeLeftClass || 'mm-timer-timeleft-',
                timeInterval;
            element.addClass('mm-timer item item-icon-left');
            scope.text = attrs.timerText || '';
            timeInterval = $interval(function() {
                scope.timeLeft = scope.endTime - $mmUtil.timestamp();
                if (scope.timeLeft < 0) {
                    $interval.cancel(timeInterval);
                    scope.finished();
                    return;
                }
                if (scope.timeLeft < 100 && !element.hasClass(timeLeftClass + scope.timeLeft)) {
                    element.removeClass(timeLeftClass + (scope.timeLeft + 1));
                    element.removeClass(timeLeftClass + (scope.timeLeft + 2));
                    element.addClass(timeLeftClass + scope.timeLeft);
                }
            }, 200);
            scope.$on('$destroy', function() {
                if (timeInterval) {
                    $interval.cancel(timeInterval);
                }
            });
        }
    };
}]);

angular.module('mm.core.comments', [])
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mm_commentviewer', {
        url: '/mm_commentviewer',
        params : {
            contextLevel: null,
            instanceId: null,
            component: null,
            itemId: null,
            area: null,
            page: null,
            title: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/comments/templates/commentviewer.html',
                controller: 'mmCommentViewerCtrl'
            }
        }
    });
}]);

angular.module('mm.core.contentlinks', [])
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('mm_contentlinks', {
        url: '/mm_contentlinks',
        abstract: true,
        templateUrl: 'core/components/contentlinks/templates/base.html',
        cache: false,   
    })
    .state('mm_contentlinks.choosesite', {
        url: '/choosesite',
        templateUrl: 'core/components/contentlinks/templates/choosesite.html',
        controller: 'mmContentLinksChooseSiteCtrl',
        params: {
            url: null
        }
    });
}])
.run(["$log", "$mmURLDelegate", "$mmContentLinksHelper", function($log, $mmURLDelegate, $mmContentLinksHelper) {
    $log = $log.getInstance('mmContentLinks');
    $mmURLDelegate.register('mmContentLinks', $mmContentLinksHelper.handleCustomUrl);
}]);

angular.module('mm.core.course', ['mm.core.courses'])
.constant('mmCoreCoursePriority', 800)
.constant('mmCoreCourseAllSectionsId', -1)
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mm_course', {
        url: '/mm_course',
        params: {
            courseid: null,
            sid: null, 
            sectionnumber: null, 
            moduleid: null, 
            course: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/course/templates/sections.html',
                controller: 'mmCourseSectionsCtrl'
            }
        }
    })
    .state('site.mm_course-section', {
        url: '/mm_course-section',
        params: {
            sectionid: null,
            cid: null, 
            mid: null 
        },
        views: {
            'site': {
                templateUrl: 'core/components/course/templates/section.html',
                controller: 'mmCourseSectionCtrl'
            }
        }
    })
    .state('site.mm_course-modcontent', {
        url: '/mm_course-modcontent',
        params: {
            module: null
        },
        views: {
            site: {
                templateUrl: 'core/components/course/templates/modcontent.html',
                controller: 'mmCourseModContentCtrl'
            }
        }
    });
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "$mmCourseDelegate", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, $mmCourseDelegate, mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmCourseDelegate.updateContentHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmCourseDelegate.updateContentHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmCourseDelegate.updateContentHandlers);
}]);

angular.module('mm.core.courses', ['mm.core.contentlinks', 'mm.core.sidemenu'])
.constant('mmCoursesSearchComponent', 'mmCoursesSearch')
.constant('mmCoursesSearchPerPage', 20) 
.constant('mmCoursesEnrolInvalidKey', 'mmCoursesEnrolInvalidKey')
.constant('mmCoursesEventMyCoursesUpdated', 'my_courses_updated')
.constant('mmCoursesEventMyCoursesRefreshed', 'my_courses_refreshed') 
.constant('mmCoursesEventCourseOptionsInvalidated', 'course_options_invalidated') 
.constant('mmCoursesAccessMethods', {
     guest: 'guest',
     default: 'default'
})
.constant('mmaMyCoursesSideMenuPriority', 1100)
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mm_courses', {
        url: '/mm_courses',
        views: {
            'site': {
                templateUrl: 'core/components/courses/templates/list.html',
                controller: 'mmCoursesListCtrl'
            }
        }
    })
    .state('site.mm_searchcourses', {
        url: '/mm_searchcourses',
        views: {
            'site': {
                templateUrl: 'core/components/courses/templates/search.html',
                controller: 'mmCoursesSearchCtrl'
            }
        }
    })
    .state('site.mm_viewresult', {
        url: '/mm_viewresult',
        params: {
            course: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/courses/templates/viewresult.html',
                controller: 'mmCoursesViewResultCtrl'
            }
        }
    })
    .state('site.mm_coursescategories', {
        url: '/mm_coursescategories',
        params: {
            categoryid: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/courses/templates/coursecategories.html',
                controller: 'mmCourseCategoriesCtrl'
            }
        }
    })
    .state('site.mm_availablecourses', {
        url: '/mm_availablecourses',
        views: {
            'site': {
                templateUrl: 'core/components/courses/templates/availablecourses.html',
                controller: 'mmCoursesAvailableCtrl'
            }
        }
    });
}])
.config(["$mmContentLinksDelegateProvider", "$mmSideMenuDelegateProvider", "mmaMyCoursesSideMenuPriority", function($mmContentLinksDelegateProvider, $mmSideMenuDelegateProvider, mmaMyCoursesSideMenuPriority) {
    $mmContentLinksDelegateProvider.registerLinkHandler('mmCourses:courses', '$mmCoursesHandlers.coursesLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmCourses:course', '$mmCoursesHandlers.courseLinksHandler');
    $mmContentLinksDelegateProvider.registerLinkHandler('mmCourses:dashboard', '$mmCoursesHandlers.dashboardLinksHandler');
    $mmSideMenuDelegateProvider.registerNavHandler('mmCourses', '$mmCoursesHandlers.sideMenuNav', mmaMyCoursesSideMenuPriority);
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", "$mmCoursesDelegate", "$mmCourses", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventLogout, $mmCoursesDelegate, $mmCourses,
            mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmCoursesDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmCoursesDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmCoursesDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventLogout, function() {
        $mmCoursesDelegate.clearCoursesHandlers();
        $mmCourses.clearCurrentCourses();
    });
}]);

angular.module('mm.core.emulator', ['mm.core'])
.config(["$mmInitDelegateProvider", "mmInitDelegateMaxAddonPriority", function($mmInitDelegateProvider, mmInitDelegateMaxAddonPriority) {
    if (!ionic.Platform.isWebView()) {
        $mmInitDelegateProvider.registerProcess('mmEmulator', '$mmEmulatorManager.loadHTMLAPI',
                mmInitDelegateMaxAddonPriority + 500, true);
    }
}]);

angular.module('mm.core.fileuploader', ['mm.core'])
.constant('mmFileUploaderAlbumPriority', 2000)
.constant('mmFileUploaderCameraPriority', 1800)
.constant('mmFileUploaderAudioPriority', 1600)
.constant('mmFileUploaderVideoPriority', 1400)
.constant('mmFileUploaderFilePriority', 1200)
.config(["$mmFileUploaderDelegateProvider", "mmFileUploaderAlbumPriority", "mmFileUploaderCameraPriority", "mmFileUploaderAudioPriority", "mmFileUploaderVideoPriority", "mmFileUploaderFilePriority", function($mmFileUploaderDelegateProvider, mmFileUploaderAlbumPriority, mmFileUploaderCameraPriority,
            mmFileUploaderAudioPriority, mmFileUploaderVideoPriority, mmFileUploaderFilePriority) {
    $mmFileUploaderDelegateProvider.registerHandler('mmFileUploaderAlbum',
                '$mmFileUploaderHandlers.albumFilePicker', mmFileUploaderAlbumPriority);
    $mmFileUploaderDelegateProvider.registerHandler('mmFileUploaderCamera',
                '$mmFileUploaderHandlers.cameraFilePicker', mmFileUploaderCameraPriority);
    $mmFileUploaderDelegateProvider.registerHandler('mmFileUploaderAudio',
                '$mmFileUploaderHandlers.audioFilePicker', mmFileUploaderAudioPriority);
    $mmFileUploaderDelegateProvider.registerHandler('mmFileUploaderVideo',
                '$mmFileUploaderHandlers.videoFilePicker', mmFileUploaderVideoPriority);
    $mmFileUploaderDelegateProvider.registerHandler('mmFileUploaderFile',
                '$mmFileUploaderHandlers.filePicker', mmFileUploaderFilePriority);
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", "$mmFileUploaderDelegate", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventLogout, $mmFileUploaderDelegate,
            mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmFileUploaderDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmFileUploaderDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmFileUploaderDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventLogout, $mmFileUploaderDelegate.clearSiteHandlers);
}]);

angular.module('mm.core.grades', [])
.constant('mmCoreGradeTypeNone', 0) 
.constant('mmCoreGradeTypeValue', 1) 
.constant('mmCoreGradeTypeScale', 2) 
.constant('mmCoreGradeTypeText', 3) 
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.grades', {
        url: '/grades',
        views: {
            'site': {
                templateUrl: 'core/components/grades/templates/table.html',
                controller: 'mmGradesTableCtrl'
            }
        },
        params: {
            course: null,
            userid: null,
            courseid: null,
            forcephoneview: null
        }
    })
    .state('site.grade', {
        url: '/grade',
        views: {
            'site': {
                templateUrl: 'core/components/grades/templates/grade.html',
                controller: 'mmGradesGradeCtrl'
            }
        },
        params: {
            courseid: null,
            userid: null,
            gradeid: null
        }
    });
}]);

angular.module('mm.core.login', [])
.constant('mmCoreLoginTokenChangePassword', '*changepassword*') 
.constant('mmCoreLoginSiteCheckedEvent', 'mm_login_site_checked')
.constant('mmCoreLoginSiteUncheckedEvent', 'mm_login_site_unchecked')
.config(["$stateProvider", "$urlRouterProvider", "$mmInitDelegateProvider", "mmInitDelegateMaxAddonPriority", function($stateProvider, $urlRouterProvider, $mmInitDelegateProvider, mmInitDelegateMaxAddonPriority) {
    $stateProvider
    .state('mm_login', {
        url: '/mm_login',
        abstract: true,
        templateUrl: 'core/components/login/templates/base.html',
        cache: false,   
        onEnter: ["$ionicHistory", function($ionicHistory) {
            $ionicHistory.clearHistory();
        }],
        controller: ["$scope", function($scope) {
            $scope.$on('$ionicView.afterEnter', function(ev) {
                ev.stopPropagation();
            });
        }]
    })
    .state('mm_login.init', {
        url: '/init',
        templateUrl: 'core/components/login/templates/init.html',
        controller: 'mmLoginInitCtrl',
        cache: false 
    })
    .state('mm_login.sites', {
        url: '/sites',
        templateUrl: 'core/components/login/templates/sites.html',
        controller: 'mmLoginSitesCtrl',
        onEnter: ["$mmLoginHelper", "$mmSitesManager", function($mmLoginHelper, $mmSitesManager) {
            $mmSitesManager.hasNoSites().then(function() {
                $mmLoginHelper.goToAddSite();
            });
        }]
    })
    .state('mm_login.site', {
        url: '/site',
        templateUrl: 'core/components/login/templates/site.html',
        controller: 'mmLoginSiteCtrl'
    })
    .state('mm_login.credentials', {
        url: '/cred',
        templateUrl: 'core/components/login/templates/credentials.html',
        controller: 'mmLoginCredentialsCtrl',
        params: {
            siteurl: '',
            username: '',
            urltoopen: '', 
            siteconfig: null
        },
        onEnter: ["$state", "$stateParams", function($state, $stateParams) {
            if (!$stateParams.siteurl) {
              $state.go('mm_login.init');
            }
        }]
    })
    .state('mm_login.reconnect', {
        url: '/reconnect',
        templateUrl: 'core/components/login/templates/reconnect.html',
        controller: 'mmLoginReconnectCtrl',
        cache: false,
        params: {
            siteurl: '',
            username: '',
            infositeurl: '',
            siteid: '',
            statename: null, 
            stateparams: null,
            siteconfig: null
        }
    })
    .state('mm_login.email_signup', {
        url: '/email_signup',
        templateUrl: 'core/components/login/templates/emailsignup.html',
        controller: 'mmLoginEmailSignupCtrl',
        cache: false,
        params: {
            siteurl: ''
        }
    })
    .state('mm_login.sitepolicy', {
        url: '/sitepolicy',
        templateUrl: 'core/components/login/templates/sitepolicy.html',
        controller: 'mmLoginSitePolicyCtrl',
        cache: false,
        params: {
            siteid: ''
        }
    })
    .state('mm_login.forgottenpassword', {
        url: '/forgottenpassword',
        templateUrl: 'core/components/login/templates/forgottenpassword.html',
        controller: 'mmLoginForgottenPasswordCtrl',
        params: {
            siteurl: '',
            username: ''
        }
    });
    $urlRouterProvider.otherwise(function($injector) {
        var $state = $injector.get('$state');
        return $state.href('mm_login.init').replace('#', '');
    });
    $mmInitDelegateProvider.registerProcess('mmLogin', '$mmSitesManager.restoreSession', mmInitDelegateMaxAddonPriority + 200);
}])
.run(["$log", "$state", "$mmUtil", "$translate", "$mmSitesManager", "$rootScope", "$mmSite", "$mmURLDelegate", "$ionicHistory", "$timeout", "$mmEvents", "$mmLoginHelper", "mmCoreEventSessionExpired", "$mmApp", "$ionicPlatform", "mmCoreConfigConstants", "$mmText", "mmCoreEventPasswordChangeForced", "mmCoreEventUserNotFullySetup", "mmCoreEventSitePolicyNotAgreed", "$q", function($log, $state, $mmUtil, $translate, $mmSitesManager, $rootScope, $mmSite, $mmURLDelegate, $ionicHistory, $timeout,
                $mmEvents, $mmLoginHelper, mmCoreEventSessionExpired, $mmApp, $ionicPlatform, mmCoreConfigConstants, $mmText,
                mmCoreEventPasswordChangeForced, mmCoreEventUserNotFullySetup, mmCoreEventSitePolicyNotAgreed, $q) {
    $log = $log.getInstance('mmLogin');
    var isSSOConfirmShown = false,
        isOpenEditAlertShown = false,
        waitingForBrowser = false,
        lastInAppUrl;
    $mmEvents.on(mmCoreEventSessionExpired, sessionExpired);
    $mmEvents.on(mmCoreEventPasswordChangeForced, function(siteId) {
        openInAppForEdit(siteId, '/login/change_password.php', 'mm.core.forcepasswordchangenotice');
    });
    $mmEvents.on(mmCoreEventUserNotFullySetup, function(siteId) {
        openInAppForEdit(siteId, '/user/edit.php', 'mm.core.usernotfullysetup');
    });
    $mmEvents.on(mmCoreEventSitePolicyNotAgreed, function(siteId) {
        siteId = siteId || $mmSite.getId();
        if (!siteId || siteId != $mmSite.getId()) {
            return;
        }
        if (!$mmSite.wsAvailable('core_user_agree_site_policy')) {
            return;
        }
        $ionicHistory.nextViewOptions({disableBack: true});
        $state.go('mm_login.sitepolicy', {
            siteid: siteId
        });
    });
    $mmURLDelegate.register('mmLoginSSO', appLaunchedByURL);
    $rootScope.$on('$cordovaInAppBrowser:loadstart', function(e, event) {
        var url = event.url.replace(/^https?:\/\//, '');
        if (appLaunchedByURL(url)) {
            $mmUtil.closeInAppBrowser();
        } else if (ionic.Platform.isAndroid()) {
            var urlScheme = $mmText.getUrlProtocol(url);
            if (urlScheme && urlScheme !== 'file' && urlScheme !== 'cdvfile') {
                $mmUtil.openInBrowser(url);
                if (lastInAppUrl) {
                    $mmUtil.openInApp(lastInAppUrl);
                } else {
                    $mmUtil.closeInAppBrowser();
                }
            } else {
                lastInAppUrl = event.url;
            }
        }
    });
    $rootScope.$on('$cordovaInAppBrowser:exit', function() {
        waitingForBrowser = false;
        lastInAppUrl = false;
        checkLogout();
    });
    $ionicPlatform.on('resume', function() {
        $timeout(function() {
            waitingForBrowser = false;
            checkLogout();
        }, 1000);
    });
    $rootScope.$on('$stateChangeStart', function(event, toState, toParams, fromState, fromParams) {
        if (!$mmApp.isReady() && toState.name !== 'mm_login.init') {
            event.preventDefault();
            $state.transitionTo('mm_login.init');
            $log.warn('Forbidding state change to \'' + toState.name + '\'. App is not ready yet.');
            return;
        }
        var isLoginStateWithSession = toState.name === 'mm_login.reconnect' || toState.name === 'mm_login.sitepolicy';
        if (toState.name.substr(0, 8) === 'redirect' || toState.name.substr(0, 15) === 'mm_contentlinks') {
            return;
        } else if ((toState.name.substr(0, 8) !== 'mm_login' || isLoginStateWithSession) && !$mmSite.isLoggedIn()) {
            event.preventDefault();
            $log.debug('Redirect to login page, request was: ' + toState.name);
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $state.transitionTo('mm_login.init');
        } else if (toState.name.substr(0, 8) === 'mm_login' && !isLoginStateWithSession && $mmSite.isLoggedIn()) {
            event.preventDefault();
            $log.debug('Redirect to course page, request was: ' + toState.name);
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $mmLoginHelper.goToSiteInitialPage();
        }
    });
    function sessionExpired(data) {
        var siteId = data && data.siteid,
            siteUrl = $mmSite.getURL(),
            promise;
        if (typeof(siteUrl) === 'undefined') {
            return;
        }
        if (siteId && siteId !== $mmSite.getId()) {
            return; 
        }
        $mmSitesManager.checkSite(siteUrl).then(function(result) {
            if (result.warning) {
                $mmUtil.showErrorModal(result.warning, true, 4000);
            }
            if ($mmLoginHelper.isSSOLoginNeeded(result.code)) {
                if (!$mmApp.isSSOAuthenticationOngoing() && !isSSOConfirmShown && !waitingForBrowser) {
                    isSSOConfirmShown = true;
                    if ($mmLoginHelper.shouldShowSSOConfirm(result.code)) {
                        promise = $mmUtil.showConfirm($translate.instant(
                                'mm.login.' + ($mmSite.isLoggedOut() ? 'loggedoutssodescription' : 'reconnectssodescription')));
                    } else {
                        promise = $q.when();
                    }
                    promise.then(function() {
                        waitingForBrowser = true;
                        $mmLoginHelper.openBrowserForSSOLogin(result.siteurl, result.code, result.service,
                                result.config && result.config.launchurl, data.statename, data.stateparams);
                    }).catch(function() {
                        logout();
                    }).finally(function() {
                        isSSOConfirmShown = false;
                    });
                }
            } else {
                var info = $mmSite.getInfo();
                if (typeof info != 'undefined' && typeof info.username != 'undefined') {
                    $ionicHistory.nextViewOptions({disableBack: true});
                    $state.go('mm_login.reconnect', {
                        siteurl: result.siteurl,
                        username: info.username,
                        infositeurl: info.siteurl,
                        siteid: siteId,
                        statename: data.statename,
                        stateparams: data.stateparams,
                        siteconfig: result.config
                    });
                }
            }
        }).catch(function(error) {
            if ($mmSite.isLoggedOut()) {
                $mmUtil.showErrorModalDefault(error, 'mm.core.networkerrormsg', true);
                logout();
            }
        });
    }
    function openInAppForEdit(siteId, path, alertMessage) {
        if (!siteId || siteId !== $mmSite.getId()) {
            return;
        }
        var siteUrl = $mmSite.getURL();
        if (!siteUrl) {
            return;
        }
        if (!isOpenEditAlertShown && !waitingForBrowser) {
            isOpenEditAlertShown = true;
            $mmSite.invalidateWsCache();
            alertMessage = $translate.instant(alertMessage) + '<br>' + $translate.instant('mm.core.redirectingtosite');
            return $mmSite.openInAppWithAutoLogin(siteUrl + path, undefined, alertMessage).then(function() {
                waitingForBrowser = true;
            }).finally(function() {
                isOpenEditAlertShown = false;
            });
        }
    }
    function appLaunchedByURL(url) {
        var ssoScheme = mmCoreConfigConstants.customurlscheme + '://token=';
        if (url.indexOf(ssoScheme) == -1) {
            return false;
        }
        if ($mmApp.isSSOAuthenticationOngoing()) {
            return true;
        }
        if ($mmApp.isDesktop()) {
            $mmUtil.closeInAppBrowser(true);
        }
        $mmApp.startSSOAuthentication();
        $log.debug('App launched by URL');
        url = url.replace(ssoScheme, '');
        url = url.replace(/\/?#?\/?$/, '');
        try {
            url = atob(url);
        } catch(err) {
            $log.error('Error decoding parameter received for login SSO');
            return false;
        }
        var modal = $mmUtil.showModalLoading('mm.login.authenticating', true),
            siteData;
        $mmApp.ready().then(function() {
            return $mmLoginHelper.validateBrowserSSOLogin(url);
        }).then(function(data) {
            siteData = data;
            return $mmLoginHelper.handleSSOLoginAuthentication(siteData.siteurl, siteData.token, siteData.privateToken);
        }).then(function() {
            if (siteData.statename) {
                $state.go(siteData.statename, siteData.stateparams);
            } else {
                $mmLoginHelper.goToSiteInitialPage();
            }
        }).catch(function(errorMessage) {
            if (typeof errorMessage === 'string' && errorMessage !== '') {
                $mmUtil.showErrorModal(errorMessage);
            }
        }).finally(function() {
            modal.dismiss();
            $mmApp.finishSSOAuthentication();
        });
        return true;
    }
    function checkLogout() {
        if (!$mmApp.isSSOAuthenticationOngoing() && $mmSite.isLoggedIn() && $mmSite.isLoggedOut() &&
                $state.current.name != 'mm_login.reconnect') {
            logout();
        }
    }
    function logout() {
        $mmSitesManager.logout().then(function() {
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $state.go('mm_login.sites');
        });
    }
}]);

angular.module('mm.core.question', [])
.constant('mmQuestionComponent', 'mmQuestion')
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "$mmQuestionDelegate", "$mmQuestionBehaviourDelegate", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, $mmQuestionDelegate, $mmQuestionBehaviourDelegate,
			mmCoreEventRemoteAddonsLoaded) {
	function updateHandlers() {
		$mmQuestionDelegate.updateQuestionHandlers();
		$mmQuestionBehaviourDelegate.updateQuestionBehaviourHandlers();
	}
	$mmEvents.on(mmCoreEventLogin, updateHandlers);
	$mmEvents.on(mmCoreEventSiteUpdated, updateHandlers);
	$mmEvents.on(mmCoreEventRemoteAddonsLoaded, updateHandlers);
}]);

angular.module('mm.core.settings', [])
.constant('mmCoreSettingsReportInBackground', 'mmCoreReportInBackground')
.constant('mmCoreSettingsRichTextEditor', 'mmCoreSettingsRichTextEditor')
.constant('mmCoreSettingsSyncOnlyOnWifi', 'mmCoreSyncOnlyOnWifi')
.constant('mmCoreSettingsNotificationSound', 'mmCoreNotificationSound')
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mm_settings', {
        url: '/mm_settings',
        views: {
            'site': {
                templateUrl: 'core/components/settings/templates/list.html',
                controller: 'mmSettingsListCtrl'
            }
        }
    })
    .state('site.mm_settings-about', {
        url: '/mm_settings-about',
        views: {
            'site': {
                templateUrl: 'core/components/settings/templates/about.html',
                controller: 'mmSettingsAboutCtrl'
            }
        }
    })
    .state('site.mm_settings-general', {
        url: '/mm_settings-general',
        views: {
            'site': {
                templateUrl: 'core/components/settings/templates/general.html',
                controller: 'mmSettingsGeneralCtrl'
            }
        }
    })
    .state('site.mm_settings-spaceusage', {
        url: '/mm_settings-spaceusage',
        views: {
            'site': {
                templateUrl: 'core/components/settings/templates/space-usage.html',
                controller: 'mmSettingsSpaceUsageCtrl'
            }
        }
    })
    .state('site.mm_settings-synchronization', {
        url: '/mm_settings-synchronization',
        views: {
            'site': {
                templateUrl: 'core/components/settings/templates/synchronization.html',
                controller: 'mmSettingsSynchronizationCtrl'
            }
        }
    });
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", "$mmSettingsDelegate", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventLogout, $mmSettingsDelegate,
            mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmSettingsDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmSettingsDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmSettingsDelegate.updateHandlers);
    $mmEvents.on(mmCoreEventLogout, $mmSettingsDelegate.clearSiteHandlers);
}]);

angular.module('mm.core.sharedfiles', ['mm.core'])
.constant('mmSharedFilesFolder', 'sharedfiles')
.constant('mmSharedFilesStore', 'shared_files')
.constant('mmSharedFilesEventFileShared', 'file_shared')
.constant('mmSharedFilesPickerPriority', 1300)
.config(["$stateProvider", "$mmFileUploaderDelegateProvider", "mmSharedFilesPickerPriority", function($stateProvider, $mmFileUploaderDelegateProvider, mmSharedFilesPickerPriority) {
    var chooseSiteState = {
            url: '/sharedfiles-choose-site',
            params: {
                filepath: null 
            }
        },
        chooseSiteView = {
            controller: 'mmSharedFilesChooseSiteCtrl',
            templateUrl: 'core/components/sharedfiles/templates/choosesite.html'
        };
    $stateProvider
    .state('site.sharedfiles-choose-site', angular.extend(angular.copy(chooseSiteState), {
        views: {
            'site': chooseSiteView
        }
    }))
    .state('mm_login.sharedfiles-choose-site', angular.extend(angular.copy(chooseSiteState), chooseSiteView))
    .state('site.sharedfiles-list', {
        url: '/sharedfiles-list',
        params: {
            path: null,
            manage: false,
            pick: false
        },
        views: {
            'site': {
                templateUrl: 'core/components/sharedfiles/templates/list.html',
                controller: 'mmSharedFilesListCtrl'
            }
        }
    });
    $mmFileUploaderDelegateProvider.registerHandler('mmSharedFiles',
                '$mmSharedFilesHandlers.filePicker', mmSharedFilesPickerPriority);
}])
.run(["$mmSharedFilesHelper", "$ionicPlatform", function($mmSharedFilesHelper, $ionicPlatform) {
    if (ionic.Platform.isIOS()) {
        $ionicPlatform.on('resume', $mmSharedFilesHelper.searchIOSNewSharedFiles);
        $mmSharedFilesHelper.searchIOSNewSharedFiles();
    }
}]);

angular.module('mm.core.sidemenu', [])
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site', {
        url: '/site',
        templateUrl: 'core/components/sidemenu/templates/menu.html',
        controller: 'mmSideMenuCtrl',
        abstract: true,
        cache: false,
        onEnter: ["$ionicHistory", "$state", "$mmSite", function($ionicHistory, $state, $mmSite) {
            $ionicHistory.clearHistory();
            if (!$mmSite.isLoggedIn()) {
                $state.go('mm_login.init');
            }
        }]
    })
    .state('site.iframe-view', {
        url: '/iframe-view',
        params: {
            title: null,
            url: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/sidemenu/templates/iframe.html',
                controller: 'mmSideMenuIframeViewCtrl'
            }
        }
    });
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", "$mmSideMenuDelegate", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventLogout, $mmSideMenuDelegate,
            mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmSideMenuDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmSideMenuDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmSideMenuDelegate.updateNavHandlers);
    $mmEvents.on(mmCoreEventLogout, $mmSideMenuDelegate.clearSiteHandlers);
}]);

angular.module('mm.core.textviewer', [])
.config(["$stateProvider", function($stateProvider) {
    $stateProvider
    .state('site.mm_textviewer', {
        url: '/mm_textviewer',
        params: {
            title: null,
            content: null,
            replacelinebreaks: null,
            component: null,
            componentId: null
        },
        views: {
            'site': {
                templateUrl: 'core/components/textviewer/templates/textviewer.html',
                controller: 'mmTextViewerIndexCtrl'
            }
        }
    });
}]);

angular.module('mm.core.user', ['mm.core.contentlinks'])
.constant('mmUserEventProfileRefreshed', 'user_profile_refreshed') 
.constant('mmUserProfilePictureUpdated', 'user_profile_picture_updated') 
.constant('mmUserProfileHandlersTypeNewPage', 'newpage') 
.constant('mmUserProfileHandlersTypeCommunication', 'communication') 
.constant('mmUserProfileHandlersTypeAction', 'action') 
.constant('mmUserPriority', 700)
.value('mmUserProfileState', 'site.mm_user-profile')
.config(["$stateProvider", "$mmContentLinksDelegateProvider", "$mmUserDelegateProvider", "mmUserPriority", function($stateProvider, $mmContentLinksDelegateProvider, $mmUserDelegateProvider, mmUserPriority) {
    $stateProvider
        .state('site.mm_user-profile', {
            url: '/mm_user-profile',
            views: {
                'site': {
                    controller: 'mmUserProfileCtrl',
                    templateUrl: 'core/components/user/templates/profile.html'
                }
            },
            params: {
                courseid: 0,
                userid: 0
            }
        })
        .state('site.mm_user-about', {
            url: '/mm_user-about',
            views: {
                'site': {
                    controller: 'mmUserAboutCtrl',
                    templateUrl: 'core/components/user/templates/about.html'
                }
            },
            params: {
                courseid: 0,
                userid: 0
            }
        });
    $mmContentLinksDelegateProvider.registerLinkHandler('mmUser', '$mmUserHandlers.linksHandler');
    $mmUserDelegateProvider.registerProfileHandler('mmUser', '$mmUserHandlers.userEmail', mmUserPriority);
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "$mmUserDelegate", "$mmSite", "mmCoreEventUserDeleted", "$mmUser", "mmCoreEventRemoteAddonsLoaded", "$mmUserProfileFieldsDelegate", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, $mmUserDelegate, $mmSite, mmCoreEventUserDeleted, $mmUser,
            mmCoreEventRemoteAddonsLoaded, $mmUserProfileFieldsDelegate) {
    function updateHandlers() {
        $mmUserDelegate.updateProfileHandlers();
        $mmUserProfileFieldsDelegate.updateFieldHandlers();
    }
    $mmEvents.on(mmCoreEventLogin, updateHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, updateHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, updateHandlers);
    $mmEvents.on(mmCoreEventUserDeleted, function(data) {
        if (data.siteid && data.siteid === $mmSite.getId() && data.params) {
            var params = data.params,
                userid = 0;
            if (params.userid) {
                userid = params.userid;
            } else if (params.userids) {
                userid = params.userids[0];
            } else if (params.field === 'id' && params.values && params.values.length) {
                userid = params.values[0];
            } else if (params.userlist && params.userlist.length) {
                userid = params.userlist[0].userid;
            }
            userid = parseInt(userid);
            if (userid > 0) {
                $mmUser.deleteStoredUser(userid);
            }
        }
    });
}]);

angular.module('mm.core.comments')
.directive('mmComments', ["$mmComments", "$state", function($mmComments, $state) {
    return {
        restrict: 'E',
        priority: 100,
        scope: {
            contextLevel: '@',
            instanceId: '@',
            component: '@',
            itemId: '@',
            area: '@?',
            page: '@?',
            title: '@?'
        },
        templateUrl: 'core/components/comments/templates/comments.html',
        link: function(scope, el, attr) {
            var params;
            scope.commentsCount = -1;
            scope.commentsLoaded = false;
            scope.showComments = function() {
                if (scope.commentsCount > 0) {
                    $state.go('site.mm_commentviewer', params);
                }
            };
            $mmComments.getComments(attr.contextLevel, attr.instanceId, attr.component, attr.itemId, attr.area, attr.page)
                    .then(function(comments) {
                params = {
                    contextLevel: attr.contextLevel,
                    instanceId: attr.instanceId,
                    component: attr.component,
                    itemId: attr.itemId,
                    area: attr.area,
                    page: attr.page,
                    title: attr.title
                };
                scope.commentsCount = comments && comments.length ? comments.length : 0;
                scope.commentsLoaded = true;
            }).catch(function() {
                scope.commentsLoaded = true;
            });
        }
    };
}]);

angular.module('mm.core.comments')
.controller('mmCommentViewerCtrl', ["$stateParams", "$scope", "$translate", "$mmComments", "$mmUtil", "$mmUser", "$q", function($stateParams, $scope, $translate, $mmComments, $mmUtil, $mmUser, $q) {
    var contextLevel = $stateParams.contextLevel,
        instanceId = $stateParams.instanceId,
        component = $stateParams.component,
        itemId = $stateParams.itemId,
        area = $stateParams.area,
        page = $stateParams.page || 0;
    $scope.title = $stateParams.title || $translate.instant('mm.core.comments');
    function fetchComments() {
        return $mmComments.getComments(contextLevel, instanceId, component, itemId, area, page).then(function(comments) {
            $scope.comments = comments;
            angular.forEach(comments, function(comment) {
                $mmUser.getProfile(comment.userid, undefined, true).then(function(user) {
                    comment.profileimageurl = user.profileimageurl || true;
                });
            });
        }).catch(function(error) {
            if (error) {
                if (component == 'assignsubmission_comments') {
                    $mmUtil.showModal('mm.core.notice', 'mm.core.commentsnotworking');
                } else {
                    $mmUtil.showErrorModal(error);
                }
            } else {
                $translate('mm.core.error').then(function(error) {
                    $mmUtil.showErrorModal(error + ': get_comments');
                });
            }
            return $q.reject();
        });
    }
    fetchComments().finally(function() {
        $scope.commentsLoaded = true;
    });
    $scope.refreshComments = function() {
        return $mmComments.invalidateCommentsData(contextLevel, instanceId, component, itemId, area, page).finally(function() {
            return fetchComments().finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);
angular.module('mm.core.comments')
.factory('$mmComments', ["$log", "$mmSitesManager", "$mmSite", "$q", function($log, $mmSitesManager, $mmSite, $q) {
    $log = $log.getInstance('$mmComments');
    var self = {};
    function getCommentsCacheKey(contextLevel, instanceId, component, itemId, area, page) {
        page = page || 0;
        area = area || "";
        return getCommentsPrefixCacheKey(contextLevel, instanceId) + ':' + component + ':' + itemId + ':' + area + ':' + page;
    }
    function getCommentsPrefixCacheKey(contextLevel, instanceId) {
        return 'mmComments:comments:' + contextLevel + ':' + instanceId;
    }
    self.getComments = function(contextLevel, instanceId, component, itemId, area, page, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                "contextlevel": contextLevel,
                "instanceid": parseInt(instanceId, 10),
                "component": component,
                "itemid": parseInt(itemId, 10)
            },
            preSets = {};
            if (area) {
                params.area = area;
            }
            if (page) {
                params.page = page;
            }
            preSets.cacheKey = getCommentsCacheKey(contextLevel, instanceId, component, itemId, area, page);
            return site.read('core_comment_get_comments', params, preSets).then(function(response) {
                if (response.comments) {
                    return response.comments;
                }
                return $q.reject();
            });
        });
    };
    self.invalidateCommentsData = function(contextLevel, instanceId, component, itemId, area, page, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getCommentsCacheKey(contextLevel, instanceId, component, itemId, area, page));
        });
    };
    self.invalidateCommentsByInstance = function(contextLevel, instanceId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKeyStartingWith(getCommentsPrefixCacheKey(contextLevel, instanceId));
        });
    };
    self.isPluginEnabled = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return  site.wsAvailable('core_comment_get_comments');
        });
    };
    return self;
}]);

angular.module('mm.core.contentlinks')
.controller('mmContentLinksChooseSiteCtrl', ["$scope", "$stateParams", "$mmSitesManager", "$mmUtil", "$ionicHistory", "$state", "$q", "$mmContentLinksDelegate", "$mmContentLinksHelper", function($scope, $stateParams, $mmSitesManager, $mmUtil, $ionicHistory, $state, $q,
            $mmContentLinksDelegate, $mmContentLinksHelper) {
    $scope.url = $stateParams.url || '';
    var action;
    function leaveView() {
        $mmSitesManager.logout().finally(function() {
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $state.go('mm_login.sites');
        });
    }
    if (!$scope.url) {
        leaveView();
        return;
    }
    $mmContentLinksDelegate.getActionsFor($scope.url).then(function(actions) {
        action = $mmContentLinksHelper.getFirstValidAction(actions);
        if (!action) {
            return $q.reject();
        }
        $mmSitesManager.getSites(action.sites).then(function(sites) {
            $scope.sites = sites;
        });
    }).catch(function() {
        $mmUtil.showErrorModal('mm.contentlinks.errornosites', true);
        leaveView();
    });
    $scope.siteClicked = function(siteId) {
        action.action(siteId);
    };
    $scope.cancel = function() {
        leaveView();
    };
}]);

angular.module('mm.core.contentlinks')
.provider('$mmContentLinksDelegate', function() {
    var linkHandlers = {},
        self = {};
    self.registerLinkHandler = function(name, handler, priority) {
        if (typeof linkHandlers[name] !== 'undefined') {
            console.log("$mmContentLinksDelegateProvider: Handler '" + linkHandlers[name].name +
                        "' already registered as link handler");
            return false;
        }
        console.log("$mmContentLinksDelegateProvider: Registered handler '" + name + "' as link handler.");
        linkHandlers[name] = {
            name: name,
            handler: handler,
            instance: undefined,
            priority: typeof priority === 'undefined' ? 100 : priority
        };
        return true;
    };
    self.$get = ["$mmUtil", "$log", "$q", "$mmSitesManager", function($mmUtil, $log, $q, $mmSitesManager) {
        var self = {};
        $log = $log.getInstance('$mmContentLinksDelegate');
        self.getActionsFor = function(url, courseId, username) {
            if (!url) {
                return $q.when([]);
            }
            return $mmSitesManager.getSiteIdsFromUrl(url, true, username).then(function(siteIds) {
                var linkActions = [],
                    promises = [],
                    params = $mmUtil.extractUrlParams(url);
                angular.forEach(linkHandlers, function(handler) {
                    if (typeof handler.instance === 'undefined') {
                        handler.instance = $mmUtil.resolveObject(handler.handler, true);
                    }
                    if (!handler.instance || !handler.instance.handles(url)) {
                        return;
                    }
                    var checkAll = handler.instance.checkAllSites;
                    promises.push($mmUtil.filterEnabledSites(siteIds, isEnabled, checkAll).then(function(siteIds) {
                        if (!siteIds.length) {
                            return;
                        }
                        return $q.when(handler.instance.getActions(siteIds, url, params, courseId)).then(function(actions) {
                            if (actions && actions.length) {
                                angular.forEach(actions, function(action) {
                                    action.message = action.message || 'mm.core.view';
                                    action.icon = action.icon || 'ion-eye';
                                    action.sites = action.sites || siteIds;
                                });
                                linkActions.push({
                                    priority: handler.priority,
                                    actions: actions
                                });
                            }
                        });
                    }));
                    function isEnabled(siteId) {
                        var promise;
                        if (handler.instance.featureName) {
                            promise = $mmSitesManager.isFeatureDisabled(handler.instance.featureName, siteId);
                        } else {
                            promise = $q.when(false);
                        }
                        return promise.then(function(disabled) {
                            if (disabled) {
                                return false;
                            }
                            if (!handler.instance.isEnabled) {
                                return true;
                            }
                            return handler.instance.isEnabled(siteId, url, params, courseId);
                        });
                    }
                });
                return $mmUtil.allPromises(promises).catch(function() {}).then(function() {
                    return sortActionsByPriority(linkActions);
                });
            });
        };
        self.getSiteUrl = function(url) {
            if (!url) {
                return;
            }
            for (var name in linkHandlers) {
                var handler = linkHandlers[name];
                if (typeof handler.instance === 'undefined') {
                    handler.instance = $mmUtil.resolveObject(handler.handler, true);
                }
                if (handler.instance && handler.instance.handles) {
                    var siteUrl = handler.instance.getHandlerUrl(url);
                    if (siteUrl) {
                        return siteUrl;
                    }
                }
            }
        };
        function sortActionsByPriority(actions) {
            var sorted = [];
            actions = actions.sort(function(a, b) {
                return a.priority >= b.priority ? 1 : -1;
            });
            actions.forEach(function(entry) {
                sorted = sorted.concat(entry.actions);
            });
            return sorted;
        }
        return self;
    }];
    return self;
});

angular.module('mm.core')
.factory('$mmContentLinkHandlerFactory', ["$log", function($log) {
    $log = $log.getInstance('$mmContentLinkHandlerFactory');
    var self = {},
        contentLinkHandler = (function () {
            this.pattern = false;
            this.featureName = '';
            this.checkAllSites = false;
            this.getActions = function(siteIds, url, params, courseId) {
                return [];
            };
            this.handles = function(url) {
                return this.pattern && url.search(this.pattern) >= 0;
            };
            this.getHandlerUrl = function(url) {
                if (this.pattern) {
                    var position = url.search(this.pattern);
                    if (position > -1) {
                        return url.substr(0, position);
                    }
                }
            };
            this.isEnabled = function(siteId, url, params, courseId) {
                return true;
            };
            return this;
        }());
    self.createChild = function(pattern, featureName, checkAllSites) {
        var child = Object.create(contentLinkHandler);
        child.pattern = pattern;
        child.featureName = featureName;
        child.checkAllSites = !!checkAllSites;
        return child;
    };
    return self;
}]);
angular.module('mm.core.contentlinks')
.factory('$mmContentLinksHelper', ["$log", "$ionicHistory", "$state", "$mmSite", "$mmContentLinksDelegate", "$mmUtil", "$translate", "$mmCourseHelper", "$mmSitesManager", "$q", "$mmLoginHelper", "$mmText", "mmCoreConfigConstants", "$mmCourse", "$mmApp", "$mmContentLinkHandlerFactory", "$mmAddonManager", "mmCoreNoSiteId", function($log, $ionicHistory, $state, $mmSite, $mmContentLinksDelegate, $mmUtil, $translate,
            $mmCourseHelper, $mmSitesManager, $q, $mmLoginHelper, $mmText, mmCoreConfigConstants, $mmCourse, $mmApp,
            $mmContentLinkHandlerFactory, $mmAddonManager, mmCoreNoSiteId) {
    $log = $log.getInstance('$mmContentLinksHelper');
    var self = {};
    self.createModuleGradeLinkHandler = function(addon, modName, service, gotoReview) {
        var regex = new RegExp('\/mod\/' + modName + '\/grade\.php.*([\&\?]id=\\d+)'),
            handler = $mmContentLinkHandlerFactory.createChild(regex, '$mmCourseDelegate_' + addon);
        handler.isEnabled = function(siteId, url, params, courseId) {
            courseId = courseId || params.courseid || params.cid;
            return self.isModuleIndexEnabled(service, siteId, courseId);
        };
        handler.getActions = function(siteIds, url, params, courseId) {
            courseId = courseId || params.courseid || params.cid;
            return self.treatModuleGradeUrl(siteIds, url, params, courseId, gotoReview);
        };
        return handler;
    };
    self.createModuleIndexLinkHandler = function(addon, modName, service) {
        var regex = new RegExp('\/mod\/' + modName + '\/view\.php.*([\&\?]id=\\d+)'),
            handler = $mmContentLinkHandlerFactory.createChild(regex, '$mmCourseDelegate_' + addon);
        handler.isEnabled = function(siteId, url, params, courseId) {
            courseId = courseId || params.courseid || params.cid;
            return self.isModuleIndexEnabled(service, siteId, courseId);
        };
        handler.getActions = self.treatModuleIndexUrl;
        return handler;
    };
    self.filterSupportedSites = $mmUtil.filterEnabledSites;
    self.getFirstValidAction = function(actions) {
        if (actions) {
            for (var i = 0; i < actions.length; i++) {
                var action = actions[i];
                if (action && action.sites && action.sites.length && angular.isFunction(action.action)) {
                    return action;
                }
            }
        }
    };
    self.goInSite = function(stateName, stateParams, siteId) {
        siteId = siteId || $mmSite.getId();
        if (siteId == $mmSite.getId()) {
            return $state.go(stateName, stateParams);
        } else {
            return $state.go('redirect', {
                siteid: siteId,
                state: stateName,
                params: stateParams
            });
        }
    };
    self.goToChooseSite = function(url) {
        $ionicHistory.nextViewOptions({
            disableBack: true
        });
        return $state.go('mm_contentlinks.choosesite', {url: url});
    };
    self.handleCustomUrl = function(url) {
        var contentLinksScheme = mmCoreConfigConstants.customurlscheme + '://link';
        if (url.indexOf(contentLinksScheme) == -1) {
            return false;
        }
        url = decodeURIComponent(url);
        $log.debug('Treating custom URL scheme: ' + url);
        var modal = $mmUtil.showModalLoading(),
            username;
        url = url.replace(contentLinksScheme + '=', '');
        username = $mmText.getUsernameFromUrl(url);
        if (username) {
            url = url.replace(username + '@', ''); 
        }
        $mmApp.ready().then(function() {
            return $mmSitesManager.getSiteIdsFromUrl(url, false, username);
        }).then(function(siteIds) {
            if (siteIds.length) {
                modal.dismiss(); 
                return self.handleLink(url, username).then(function(treated) {
                    if (!treated) {
                        $mmUtil.showErrorModal('mm.contentlinks.errornoactions', true);
                    }
                });
            } else {
                var siteUrl = $mmContentLinksDelegate.getSiteUrl(url);
                if (!siteUrl) {
                    $mmUtil.showErrorModal('mm.login.invalidsite', true);
                    return;
                }
                return $mmSitesManager.checkSite(siteUrl).then(function(result) {
                    var promise,
                        ssoNeeded = $mmLoginHelper.isSSOLoginNeeded(result.code),
                        hasRemoteAddonsLoaded = false,
                        stateParams = {
                            siteurl: result.siteurl,
                            username: username,
                            urltoopen: url
                        };
                    modal.dismiss(); 
                    if (!$mmSite.isLoggedIn()) {
                        promise = $q.when();
                    } else {
                        promise = $mmUtil.showConfirm($translate('mm.contentlinks.confirmurlothersite')).then(function() {
                            if (!ssoNeeded) {
                                hasRemoteAddonsLoaded = $mmAddonManager.hasRemoteAddonsLoaded();
                                if (hasRemoteAddonsLoaded) {
                                    $mmApp.storeRedirect(mmCoreNoSiteId, 'mm_login.credentials', stateParams);
                                }
                                return $mmSitesManager.logout().catch(function() {
                                });
                            }
                        });
                    }
                    return promise.then(function() {
                        if (ssoNeeded) {
                            $mmLoginHelper.confirmAndOpenBrowserForSSOLogin(
                                        result.siteurl, result.code, result.service, result.config && result.config.launchurl);
                        } else if (!hasRemoteAddonsLoaded) {
                            $state.go('mm_login.credentials', stateParams);
                        }
                    });
                }, function(error) {
                    $mmUtil.showErrorModal(error);
                });
            }
        }).finally(function() {
            modal.dismiss();
        });
        return true;
    };
    self.handleLink = function(url, username) {
        return $mmContentLinksDelegate.getActionsFor(url, undefined, username).then(function(actions) {
            var action = self.getFirstValidAction(actions);
            if (action) {
                if (!$mmSite.isLoggedIn()) {
                    if (action.sites.length == 1) {
                        action.action(action.sites[0]);
                    } else {
                        self.goToChooseSite(url);
                    }
                } else if (action.sites.length == 1 && action.sites[0] == $mmSite.getId()) {
                    action.action(action.sites[0]);
                } else {
                    $mmUtil.showConfirm($translate('mm.contentlinks.confirmurlothersite')).then(function() {
                        if (action.sites.length == 1) {
                            action.action(action.sites[0]);
                        } else {
                            self.goToChooseSite(url);
                        }
                    });
                }
                return true;
            }
            return false;
        }).catch(function() {
            return false;
        });
    };
    self.isModuleIndexEnabled = function(service, siteId, courseId) {
        var promise;
        if (service.isPluginEnabled) {
            promise = service.isPluginEnabled(siteId);
        } else {
            promise = $q.when(true);
        }
        return promise.then(function(enabled) {
            if (!enabled) {
                return false;
            }
            return courseId || $mmCourse.canGetModuleWithoutCourseId(siteId);
        });
    };
    self.treatModuleGradeUrl = function(siteIds, url, params, courseId, gotoReview) {
        return [{
            action: function(siteId) {
                var modal = $mmUtil.showModalLoading();
                $mmSitesManager.getSite(siteId).then(function(site) {
                    if (!params.userid || params.userid == site.getUserId()) {
                        $mmCourseHelper.navigateToModule(parseInt(params.id, 10), siteId, courseId);
                    } else if (angular.isFunction(gotoReview)) {
                        gotoReview(url, params, courseId, siteId);
                    } else {
                        return site.openInBrowserWithAutoLogin(url);
                    }
                }).finally(function() {
                    modal.dismiss();
                });
            }
        }];
    };
    self.treatModuleIndexUrl = function(siteIds, url, params, courseId) {
        courseId = courseId || params.courseid || params.cid;
        return [{
            action: function(siteId) {
                $mmCourseHelper.navigateToModule(parseInt(params.id, 10), siteId, courseId);
            }
        }];
    };
    return self;
}]);

angular.module('mm.core.course')
.controller('mmCourseModContentCtrl', ["$log", "$stateParams", "$scope", "$mmCourseDelegate", "$mmCourse", "$translate", "$mmText", function($log, $stateParams, $scope, $mmCourseDelegate, $mmCourse, $translate, $mmText) {
    $log = $log.getInstance('mmCourseModContentCtrl');
    var module = $stateParams.module || {};
    $scope.isDisabledInSite = $mmCourseDelegate.isModuleDisabledInSite(module.modname);
    $scope.isSupportedByTheApp = $mmCourseDelegate.hasContentHandler(module.modname);
    $scope.moduleName = $mmCourse.translateModuleName(module.modname);
    $scope.description = module.description;
    $scope.title = module.name;
    $scope.url = module.url;
    $scope.expandDescription = function() {
        $mmText.expandText($translate.instant('mm.core.description'), $scope.description, false);
    };
}]);

angular.module('mm.core.course')
.controller('mmCourseSectionCtrl', ["$mmCourse", "$mmUtil", "$scope", "$stateParams", "$translate", "$mmEvents", "$ionicScrollDelegate", "$mmCourses", "$q", "mmCoreEventCompletionModuleViewed", "$mmCoursePrefetchDelegate", "$mmCourseHelper", "$timeout", function($mmCourse, $mmUtil, $scope, $stateParams, $translate, $mmEvents, $ionicScrollDelegate,
            $mmCourses, $q, mmCoreEventCompletionModuleViewed, $mmCoursePrefetchDelegate, $mmCourseHelper, $timeout) {
    var courseId = $stateParams.cid,
        sectionId = $stateParams.sectionid || -1,
        moduleId = $stateParams.mid,
        scrollView;
    $scope.sections = []; 
    $scope.sectionHasContent = $mmCourseHelper.sectionHasContent;
    if (sectionId < 0) {
        $scope.title = $translate.instant('mm.course.allsections');
        $scope.summary = null;
        $scope.allSections = true;
    }
    function loadContent(sectionId, refresh) {
        return $mmCourses.getUserCourse(courseId, true).catch(function() {
        }).then(function(course) {
            var promise;
            if (course && course.enablecompletion === false) {
                promise = $q.when([]); 
            } else {
                promise = $mmCourse.getActivitiesCompletionStatus(courseId).catch(function() {
                    return []; 
                });
            }
            return promise.then(function(completionStatus) {
                var promise,
                    sectionnumber;
                if (sectionId < 0) {
                    sectionnumber = 0;
                    promise = $mmCourse.getSections(courseId, false, true);
                } else {
                    sectionnumber = sectionId;
                    promise = $mmCourse.getSection(courseId, false, true, sectionId).then(function(section) {
                        $scope.title = section.name.trim();
                        $scope.summary = section.summary;
                        return [section];
                    });
                }
                return promise.then(function(sections) {
                    var promise;
                    if (refresh) {
                        var modules = $mmCourseHelper.getSectionsModules(sections);
                        promise = $mmCoursePrefetchDelegate.invalidateModules(modules, courseId);
                    } else {
                        promise = $q.when();
                    }
                    return promise.then(function() {
                        return sections;
                    });
                }).then(function(sections) {
                    sections = sections.map(function(section) {
                        section.name = section.name.trim() || false;
                        return section;
                    });
                    $scope.hasContent = $mmCourseHelper.addContentHandlerControllerForSectionModules(sections, courseId,
                        moduleId, completionStatus, $scope);
                    $scope.sections = sections;
                    if (sectionId > 0 && sections[0] && typeof sections[0].section != 'undefined') {
                        $mmCourse.logView(courseId, sections[0].section);
                    } else {
                        $mmCourse.logView(courseId);
                    }
                }, function(error) {
                    $mmUtil.showErrorModalDefault(error, 'mm.course.couldnotloadsectioncontent', true);
                });
            });
        });
    }
    loadContent(sectionId).finally(function() {
        $scope.sectionLoaded = true;
        if (moduleId) {
            $timeout(function() {
                if (!scrollView) {
                    scrollView = $ionicScrollDelegate.$getByHandle('mmSectionScroll');
                }
                $mmUtil.scrollToElement(document.body, '#mm-course-module-' + moduleId, scrollView);
            }, 400);
        }
    });
    $scope.doRefresh = function() {
        var promises = [];
        promises.push($mmCourse.invalidateSections(courseId));
        if ($scope.sections) {
            promises.push($mmCoursePrefetchDelegate.invalidateCourseUpdates(courseId));
        }
        $q.all(promises).finally(function() {
            loadContent(sectionId, true).finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
    function refreshAfterCompletionChange() {
        if (!scrollView) {
            scrollView = $ionicScrollDelegate.$getByHandle('mmSectionScroll');
        }
        var scrollPosition = scrollView.getScrollPosition() || {};
        $scope.sectionLoaded = false;
        $scope.sections = [];
        scrollView.scrollTop(); 
        loadContent(sectionId).finally(function() {
            $scope.sectionLoaded = true;
            $timeout(function() {
                scrollView.scrollTo(scrollPosition.left, scrollPosition.top);
            });
        });
    }
    $scope.completionChanged = function() {
        $mmCourse.invalidateSections(courseId).finally(function() {
            refreshAfterCompletionChange();
        });
    };
    var observer = $mmEvents.on(mmCoreEventCompletionModuleViewed, function(cid) {
        if (cid === courseId) {
            refreshAfterCompletionChange();
        }
    });
    $scope.$on('$destroy', function() {
        if (observer && observer.off) {
            observer.off();
        }
    });
}]);

angular.module('mm.core.course')
.controller('mmCourseSectionsCtrl', ["$mmCourse", "$mmUtil", "$scope", "$stateParams", "$translate", "$mmCourseHelper", "$mmEvents", "$mmSite", "$mmCoursePrefetchDelegate", "$mmCourses", "$q", "$ionicHistory", "$ionicPlatform", "mmCoreCourseAllSectionsId", "mmCoreEventSectionStatusChanged", "$state", "$timeout", "$mmCoursesDelegate", "$controller", "mmCoreEventCourseStatusChanged", function($mmCourse, $mmUtil, $scope, $stateParams, $translate, $mmCourseHelper, $mmEvents,
            $mmSite, $mmCoursePrefetchDelegate, $mmCourses, $q, $ionicHistory, $ionicPlatform, mmCoreCourseAllSectionsId,
            mmCoreEventSectionStatusChanged, $state, $timeout, $mmCoursesDelegate, $controller, mmCoreEventCourseStatusChanged) {
    var courseId = $stateParams.courseid,
        sectionId = parseInt($stateParams.sid, 10),
        sectionNumber = parseInt($stateParams.sectionnumber, 10),
        moduleId = $stateParams.moduleid,
        course = $stateParams.course ? angular.copy($stateParams.course) : false;
    $scope.courseId = courseId;
    $scope.sectionToLoad = 2; 
    $scope.fullname = course.fullname || "";
    $scope.downloadSectionsEnabled = $mmCourseHelper.isDownloadSectionsEnabled();
    $scope.downloadSectionsIcon = getDownloadSectionIcon();
    $scope.sectionHasContent = $mmCourseHelper.sectionHasContent;
    $scope.courseActions = [];
    $scope.prefetchCourseIcon = 'spinner'; 
    function loadSections(refresh) {
        var promise;
        if (course) {
            promise = $q.when();
        } else {
            promise = $mmCourses.getUserCourse(courseId).catch(function() {
                return $mmCourses.getCourse(courseId);
            }).then(function(courseResponse) {
                course = courseResponse;
                return course.fullname;
            }).catch(function() {
                return $translate.instant('mm.core.course');
            });
        }
        return promise.then(function(courseFullName) {
            if (courseFullName) {
                $scope.fullname = courseFullName;
            }
            $mmCoursesDelegate.getNavHandlersToDisplay(course, refresh, false, true).then(function(buttons) {
                $scope.courseActions = buttons.map(function(button) {
                    var newScope = $scope.$new();
                    $controller(button.controller, {$scope: newScope});
                    var buttonInfo = {
                            text: $translate.instant(newScope.title),
                            icon: newScope.icon || false,
                            priority: button.priority || false,
                            action: function() {
                                var ev = document.createEvent("MouseEvent");
                                return newScope.action(ev, course);
                            },
                            prefetch: button.prefetch
                        };
                    newScope.$destroy();
                    return buttonInfo;
                });
            });
            return $mmCourse.getSections(courseId, false, true).then(function(sections) {
                sections = sections.map(function(section) {
                    section.name = section.name.trim() || section.section;
                    return section;
                });
                var result = [{
                    name: $translate.instant('mm.course.allsections'),
                    id: mmCoreCourseAllSectionsId
                }].concat(sections);
                $scope.sections = result;
                if ($scope.downloadSectionsEnabled) {
                    calculateSectionStatus(refresh);
                }
            });
        }).catch(function(error) {
            $mmUtil.showErrorModalDefault(error, 'mm.course.couldnotloadsections', true);
        });
    }
    $scope.toggleDownloadSections = function() {
        $scope.downloadSectionsEnabled = !$scope.downloadSectionsEnabled;
        $mmCourseHelper.setDownloadSectionsEnabled($scope.downloadSectionsEnabled);
        $scope.downloadSectionsIcon = getDownloadSectionIcon();
        if ($scope.downloadSectionsEnabled) {
            calculateSectionStatus(false);
        }
    };
    function getDownloadSectionIcon() {
        return $scope.downloadSectionsEnabled ? 'ion-android-checkbox-outline' : 'ion-android-checkbox-outline-blank';
    }
    function calculateSectionStatus(refresh) {
        $mmCourseHelper.calculateSectionsStatus($scope.sections, $scope.courseId, true, refresh).catch(function() {
        }).then(function(downloadpromises) {
            if (downloadpromises && downloadpromises.length) {
                $mmUtil.allPromises(downloadpromises).catch(function(error) {
                    if (!$scope.$$destroyed) {
                        $mmUtil.showErrorModalDefault(error, 'mm.course.errordownloadingsection', true);
                    }
                }).finally(function() {
                    if (!$scope.$$destroyed) {
                        $mmCourseHelper.calculateSectionsStatus($scope.sections, $scope.courseId, false);
                    }
                });
            }
        });
    }
    function determineCoursePrefetchIcon() {
        return $mmCourseHelper.getCourseStatusIcon(courseId).then(function(icon) {
            $scope.prefetchCourseIcon = icon;
        });
    }
    function prefetch(section, manual) {
        $mmCourseHelper.prefetch(section, courseId, $scope.sections).catch(function(error) {
            if ($scope.$$destroyed) {
                return;
            }
            var current = $ionicHistory.currentStateName(),
                isCurrent = ($ionicPlatform.isTablet() && current == 'site.mm_course.mm_course-section') ||
                            (!$ionicPlatform.isTablet() && current == 'site.mm_course');
            if (!manual && !isCurrent) {
                return;
            }
            $mmUtil.showErrorModalDefault(error, 'mm.course.errordownloadingsection', true);
        }).finally(function() {
            if (!$scope.$$destroyed) {
                $mmCourseHelper.calculateSectionsStatus($scope.sections, courseId, false);
            }
        });
    }
    function autoloadSection() {
        if (sectionId || sectionNumber >= 0) {
            if ($ionicPlatform.isTablet()) {
                for (var index in $scope.sections) {
                    var section = $scope.sections[index];
                    if (section.id == sectionId || (sectionNumber >= 0 && section.section === sectionNumber)) {
                        $scope.sectionToLoad = parseInt(index, 10) + 1;
                        break;
                    }
                }
                $scope.moduleId = moduleId;
                $timeout(function() {
                    $scope.moduleId = null; 
                }, 500);
            } else {
                if (!sectionId) {
                    for (var index in $scope.sections) {
                        var section = $scope.sections[index];
                        if (section.section == sectionNumber) {
                            sectionId = section.id
                            break;
                        }
                    }
                }
                if (sectionId) {
                    $state.go('site.mm_course-section', {
                        sectionid: sectionId,
                        cid: courseId,
                        mid: moduleId
                    });
                }
            }
        }
    }
    $scope.doRefresh = function() {
        var promises = [];
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmCourse.invalidateSections(courseId));
        if ($scope.sections && $scope.downloadSectionsEnabled) {
            var modules = $mmCourseHelper.getSectionsModules($scope.sections);
            promises.push($mmCoursePrefetchDelegate.invalidateModules(modules, courseId));
        }
        promises.push($mmCoursesDelegate.clearAndInvalidateCoursesOptions(courseId));
        $q.all(promises).finally(function() {
            loadSections(true).finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
    $scope.prefetch = function(e, section) {
        e.preventDefault();
        e.stopPropagation();
        section.isCalculating = true;
        $mmCourseHelper.confirmDownloadSize(courseId, section, $scope.sections).then(function() {
            prefetch(section, true);
        }, function(error) {
            if (error) {
                $mmUtil.showErrorModal(error);
            }
        }).finally(function() {
            section.isCalculating = false;
        });
    };
    $scope.prefetchCourse = function() {
        $mmCourseHelper.confirmAndPrefetchCourse($scope, course, $scope.sections, $scope.courseActions).then(function(downloaded) {
            if (downloaded && $scope.downloadSectionsEnabled) {
                calculateSectionStatus(false);
            }
        });
    };
    loadSections().finally(function() {
        autoloadSection();
        $scope.sectionsLoaded = true;
        determineCoursePrefetchIcon().then(function() {
            if ($scope.prefetchCourseIcon == 'spinner') {
                var promise = $mmCourseHelper.getCourseDownloadPromise(courseId);
                if (promise) {
                    promise.catch(function(error) {
                        if (!$scope.$$destroyed) {
                            $mmUtil.showErrorModalDefault(error, 'mm.course.errordownloadingcourse', true);
                        }
                    });
                } else {
                    $mmCourse.setCoursePreviousStatus(courseId).then(function(status) {
                        $scope.prefetchCourseIcon = $mmCourseHelper.getCourseStatusIconFromStatus(status);
                    });
                }
            }
        });
    });
    var statusObserver = $mmEvents.on(mmCoreEventSectionStatusChanged, function(data) {
        if ($scope.downloadSectionsEnabled && $scope.sections && $scope.sections.length && data.siteid === $mmSite.getId() &&
                    !$scope.$$destroyed && data.sectionid) {
            if ($mmCoursePrefetchDelegate.isBeingDownloaded($mmCourseHelper.getSectionDownloadId({id: data.sectionid}))) {
                return;
            }
            $mmCourseHelper.calculateSectionsStatus($scope.sections, courseId, false).then(function() {
                var section;
                angular.forEach($scope.sections, function(s) {
                    if (s.id === data.sectionid) {
                        section = s;
                    }
                });
                if (section) {
                    var downloadid = $mmCourseHelper.getSectionDownloadId(section);
                    if (section.isDownloading && !$mmCoursePrefetchDelegate.isBeingDownloaded(downloadid)) {
                        prefetch(section, false);
                    }
                }
            });
        }
    });
    var courseStatusObserver = $mmEvents.on(mmCoreEventCourseStatusChanged, function(data) {
        if (data.siteId == $mmSite.getId() && data.courseId == courseId) {
            $scope.prefetchCourseIcon = $mmCourseHelper.getCourseStatusIconFromStatus(data.status);
        }
    });
    $scope.$on('$destroy', function() {
        statusObserver && statusObserver.off && statusObserver.off();
        courseStatusObserver && courseStatusObserver.off && courseStatusObserver.off();
    });
}]);

angular.module('mm.core.course')
.directive('mmCourseModDescription', function() {
    return {
        compile: function(element, attrs) {
            if (attrs.watch) {
                element.find('mm-format-text').attr('watch', attrs.watch);
            }
            return function(scope) { 
                scope.showfull = !!attrs.showfull;
            };
        },
        restrict: 'E',
        scope: {
            description: '=',
            note: '=?',
            component: '@?',
            componentId: '@?'
        },
        templateUrl: 'core/components/course/templates/mod_description.html'
    };
});

angular.module('mm.core.course')
.directive('mmCourseModule', function() {
    return {
        restrict: 'E',
        scope: {
            module: '=',
            completionChanged: '=?'
        },
        templateUrl: 'core/components/course/templates/module.html'
    };
});

angular.module('mm.core.course')
.factory('$mmCourseContentHandler', ["$mmCourse", "$mmSite", function($mmCourse, $mmSite) {
    return {
        getController: function(module) {
            return function($scope, $state) {
                $scope.icon = $mmCourse.getModuleIconSrc(module.modname);
                $scope.title = module.name;
                $scope.class = 'mm-course-default-handler mm-course-module-' + module.modname + '-handler';
                $scope.action = function(e) {
                    $state.go('site.mm_course-modcontent', {module: module});
                    e.preventDefault();
                    e.stopPropagation();
                };
                if (module.url) {
                    $scope.buttons = [{
                        icon: 'ion-share',
                        label: 'mm.core.openinbrowser',
                        action: function(e) {
                            e.preventDefault();
                            e.stopPropagation();
                            $mmSite.openInBrowserWithAutoLoginIfSameSite(module.url);
                        }
                    }];
                }
            };
        }
    };
}]);

angular.module('mm.core.course')
.constant('mmCoreCourseModulesStore', 'course_modules') 
.constant('mmCoreCourseStatusStore', 'course_status')
.config(["$mmSitesFactoryProvider", "mmCoreCourseModulesStore", "mmCoreCourseStatusStore", function($mmSitesFactoryProvider, mmCoreCourseModulesStore, mmCoreCourseStatusStore) {
    var stores = [
        {
            name: mmCoreCourseModulesStore,
            keyPath: 'id'
        },
        {
            name: mmCoreCourseStatusStore,
            keyPath: 'id',
            indexes: [
                {
                    name: 'status',
                }
            ]
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.factory('$mmCourse', ["$mmSite", "$translate", "$q", "$log", "$mmEvents", "$mmSitesManager", "mmCoreEventCompletionModuleViewed", "mmCoreCourseStatusStore", "mmCoreDownloading", "mmCoreNotDownloaded", "mmCoreEventCourseStatusChanged", "$mmUtil", function($mmSite, $translate, $q, $log, $mmEvents, $mmSitesManager, mmCoreEventCompletionModuleViewed,
        mmCoreCourseStatusStore, mmCoreDownloading, mmCoreNotDownloaded, mmCoreEventCourseStatusChanged, $mmUtil) {
    $log = $log.getInstance('$mmCourse');
    var self = {},
        mods = ["assign", "assignment", "book", "chat", "choice", "data", "database", "date", "external-tool",
            "feedback", "file", "folder", "forum", "glossary", "ims", "imscp", "label", "lesson", "lti", "page", "quiz",
            "resource", "scorm", "survey", "url", "wiki", "workshop"
        ],
        modsWithContent = ['book', 'folder', 'imscp', 'page', 'resource', 'url'];
    function addContentsIfNeeded(module) {
        if (modsWithContent.indexOf(module.modname) > -1) {
            module.contents = module.contents || [];
        }
        return module;
    }
    self.canGetModuleWithoutCourseId = function(siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.wsAvailable('core_course_get_course_module');
        });
    };
    self.canGetModuleByInstance = function(siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.wsAvailable('core_course_get_course_module_by_instance');
        });
    };
    self.checkModuleCompletion = function(courseId, completion) {
        if (completion && completion.tracking === 2 && completion.state === 0) {
            self.invalidateSections(courseId).finally(function() {
                $mmEvents.trigger(mmCoreEventCompletionModuleViewed, courseId);
            });
        }
    };
    self.clearAllCoursesStatus = function(siteId) {
        var promises = [];
        $log.debug('Clear all course status for site ' + siteId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb();
            return db.getAll(mmCoreCourseStatusStore).then(function(entries) {
                angular.forEach(entries, function(entry) {
                    promises.push(db.remove(mmCoreCourseStatusStore, entry.id).then(function() {
                        self._triggerCourseStatusChanged(entry.id, mmCoreNotDownloaded, siteId);
                    }));
                });
                return $q.all(promises);
            });
        });
    };
    self.getActivitiesCompletionStatus = function(courseid, userid) {
        userid = userid || $mmSite.getUserId();
        $log.debug('Getting completion status for user ' + userid + ' in course ' + courseid);
        var params = {
                courseid: courseid,
                userid: userid
            },
            preSets = {
                cacheKey: getActivitiesCompletionCacheKey(courseid, userid)
            };
        return $mmSite.read('core_completion_get_activities_completion_status', params, preSets).then(function(data) {
            if (data && data.statuses) {
                var formattedStatuses = {};
                angular.forEach(data.statuses, function(status) {
                    formattedStatuses[status.cmid] = status;
                });
                return formattedStatuses;
            }
            return $q.reject();
        });
    };
    function getActivitiesCompletionCacheKey(courseid, userid) {
        return 'mmCourse:activitiescompletion:' + courseid + ':' + userid;
    }
    self.getCourseStatusData = function(courseId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb();
            return db.get(mmCoreCourseStatusStore, courseId).then(function(entry) {
                if (!entry) {
                    return $q.reject();
                }
                return entry;
            });
        });
    };
    self.getCourseStatus = function(courseId, siteId) {
        return self.getCourseStatusData(courseId, siteId).then(function(entry) {
            return entry.status || mmCoreNotDownloaded;
        }).catch(function() {
            return mmCoreNotDownloaded;
        });
    };
    self.getModuleBasicInfo = function(moduleId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                    cmid: moduleId
                },
                preSets = {
                    cacheKey: getModuleCacheKey(moduleId)
                };
            return site.read('core_course_get_course_module', params, preSets).then(function(response) {
                if (response.cm && (!response.warnings || !response.warnings.length)) {
                    return response.cm;
                }
                return $q.reject();
            });
        });
    };
    self.getModuleBasicGradeInfo = function(moduleId, siteId) {
        return self.getModuleBasicInfo(moduleId, siteId).then(function(info) {
            var grade = {
                advancedgrading: info.advancedgrading || false,
                grade: info.grade || false,
                gradecat: info.gradecat || false,
                gradepass: info.gradepass || false,
                outcomes: info.outcomes || false,
                scale: info.scale || false
            };
            if (grade.grade !== false || grade.advancedgrading !== false || grade.outcomes !== false) {
                return grade;
            }
            return false;
        });
    };
    self.getModuleBasicInfoByInstance = function(id, module, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                    instance: id,
                    module: module
                },
                preSets = {
                    cacheKey: getModuleByInstanceCacheKey(id, module)
                };
            return site.read('core_course_get_course_module_by_instance', params, preSets).then(function(response) {
                if (response.cm && (!response.warnings || !response.warnings.length)) {
                    return response.cm;
                }
                return $q.reject();
            });
        });
    };
    self.getModule = function(moduleId, courseId, sectionId, preferCache, ignoreCache, siteId) {
        siteId = siteId || $mmSite.getId();
        if (!moduleId) {
            return $q.reject();
        }
        if (typeof preferCache == 'undefined') {
            preferCache = false;
        }
        var promise;
        if (!courseId) {
            promise = self.getModuleBasicInfo(moduleId, siteId).then(function(module) {
                return module.course;
            });
        } else {
            promise = $q.when(courseId);
        }
        return promise.then(function(cid) {
            courseId = cid;
            return $mmSitesManager.getSite(siteId);
        }).then(function(site) {
            $log.debug('Getting module ' + moduleId + ' in course ' + courseId);
            params = {
                courseid: courseId,
                options: [
                    {
                        name: 'cmid',
                        value: moduleId
                    }
                ]
            };
            preSets = {
                cacheKey: getModuleCacheKey(moduleId),
                omitExpires: preferCache
            };
            if (!preferCache && ignoreCache) {
                preSets.getFromCache = 0;
                preSets.emergencyCache = 0;
            }
            if (sectionId) {
                params.options.push({
                    name: 'sectionid',
                    value: sectionId
                });
            }
            return site.read('core_course_get_contents', params, preSets).catch(function() {
                return self.getSections(courseId, false, false, preSets, siteId);
            }).then(function(sections) {
                var section,
                    module;
                for (var i = 0; i < sections.length; i++) {
                    section = sections[i];
                    for (var j = 0; j < section.modules.length; j++) {
                        module = section.modules[j];
                        if (module.id == moduleId) {
                            module.course = courseId;
                            return addContentsIfNeeded(module);
                        }
                    }
                }
                return $q.reject();
            });
        });
    };
    function getModuleByInstanceCacheKey(id, module) {
        return 'mmCourse:moduleByInstance:' + module + ':' + id;
    }
    function getModuleCacheKey(moduleid) {
        return 'mmCourse:module:' + moduleid;
    }
    self.getModuleIconSrc = function(moduleName) {
        if (mods.indexOf(moduleName) < 0) {
            moduleName = "external-tool";
        }
        return "img/mod/" + moduleName + ".svg";
    };
    self.getModuleSectionId = function(moduleId, courseId, siteId) {
        if (!moduleId) {
            return $q.reject();
        }
        return self.getModuleBasicInfo(moduleId, siteId).then(function(module) {
            return module.section;
        }).catch(function() {
            if (!courseId) {
                return $q.reject();
            }
            return self.getSections(courseId, false, true, {}, siteId).then(function(sections) {
                for (var i = 0, seclen = sections.length; i < seclen; i++) {
                    var section = sections[i];
                    for (var j = 0, modlen = section.modules.length; j < modlen; j++) {
                        if (section.modules[j].id == moduleId) {
                            return section.id;
                        }
                    }
                }
                return $q.reject();
            });
        });
    };
    self.getSection = function(courseId, excludeModules, excludeContents, sectionId) {
        if (sectionId < 0) {
            return $q.reject('Invalid section ID');
        }
        return self.getSections(courseId, excludeModules, excludeContents).then(function(sections) {
            for (var i = 0; i < sections.length; i++) {
                if (sections[i].id == sectionId) {
                    return sections[i];
                }
            }
            return $q.reject('Unkown section');
        });
    };
    self.getSections = function(courseId, excludeModules, excludeContents, preSets, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            preSets = preSets || {};
            preSets.cacheKey = getSectionsCacheKey(courseId);
            preSets.getCacheUsingCacheKey = true; 
            var options = [
                    {
                        name: 'excludemodules',
                        value: excludeModules ? 1 : 0
                    },
                    {
                        name: 'excludecontents',
                        value: excludeContents ? 1 : 0
                    }
                ];
            return site.read('core_course_get_contents', {
                courseid: courseId,
                options: options
            }, preSets).then(function(sections) {
                var siteHomeId = site.getSiteHomeId(),
                    showSections = true;
                if (courseId == siteHomeId) {
                    showSections = site.getStoredConfig('numsections');
                }
                if (typeof showSections != 'undefined' && !showSections && sections.length > 0) {
                    sections.pop();
                }
                angular.forEach(sections, function(section) {
                    angular.forEach(section.modules, function(module) {
                        addContentsIfNeeded(module);
                    });
                });
                return sections;
            });
        });
    };
    function getSectionsCacheKey(courseid) {
        return 'mmCourse:sections:' + courseid;
    }
    self.invalidateModule = function(moduleId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getModuleCacheKey(moduleId));
        });
    };
    self.invalidateModuleByInstance = function(id, module, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getModuleByInstanceCacheKey(id, module));
        });
    };
    self.invalidateSections = function(courseId, userId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var promises = [],
                siteHomeId = site.getSiteHomeId();
            userId = userId || site.getUserId();
            promises.push(site.invalidateWsCacheForKey(getSectionsCacheKey(courseId)));
            promises.push(site.invalidateWsCacheForKey(getActivitiesCompletionCacheKey(courseId, userId)));
            if (courseId == siteHomeId) {
                promises.push(site.invalidateConfig());
            }
            return $q.all(promises);
        });
    };
    self.loadModuleContents = function(module, courseId, sectionId, preferCache, ignoreCache, siteId) {
        siteId = siteId || $mmSite.getId();
        if (!ignoreCache && module.contents && module.contents.length) {
            return $q.when();
        }
        return $mmSitesManager.getSite(siteId).then(function(site) {
            if (site.isVersionGreaterEqualThan('2.9')) {
                return self.getModule(module.id, courseId, sectionId, preferCache, ignoreCache, siteId).then(function(mod) {
                    module.contents = mod.contents;
                });
            }
        });
    };
    self.logView = function(courseId, section) {
        var params = {
            courseid: courseId
        };
        if (typeof section != 'undefined') {
            params.sectionnumber = section;
        }
        return $mmSite.write('core_course_view_course', params).then(function(response) {
            if (!response.status) {
                return $q.reject();
            }
        });
    };
    self.setCoursePreviousStatus = function(courseId, siteId) {
        siteId = siteId || $mmSite.getId();
        $log.debug('Set previous status for course ' + courseId + ' in site ' + siteId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb();
            return db.get(mmCoreCourseStatusStore, courseId).then(function(entry) {
                if (entry.status == mmCoreDownloading) {
                    entry.downloadtime = entry.previousdownloadtime;
                }
                entry.status = entry.previous || mmCoreNotDownloaded;
                entry.updated = Date.now();
                $log.debug('Set previous status \'' + entry.status + '\' for course ' + courseId);
                return db.insert(mmCoreCourseStatusStore, entry).then(function() {
                    self._triggerCourseStatusChanged(courseId, entry.status, siteId);
                    return entry.status;
                });
            });
        });
    };
    self.setCourseStatus = function(courseId, status, siteId) {
        siteId = siteId || $mmSite.getId();
        $log.debug('Set status \'' + status + '\' for course ' + courseId + ' in site ' + siteId);
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                downloadTime,
                previousDownloadTime;
            if (status == mmCoreDownloading) {
                downloadTime = $mmUtil.timestamp();
            }
            return db.get(mmCoreCourseStatusStore, courseId).then(function(entry) {
                if (typeof downloadTime == 'undefined') {
                    downloadTime = entry.downloadtime;
                    previousDownloadTime = entry.previousdownloadtime;
                } else {
                    previousDownloadTime = entry.downloadTime;
                }
                return entry.status;
            }).catch(function() {
                return undefined; 
            }).then(function(previousStatus) {
                var promise;
                if (previousStatus === status) {
                    promise = $q.when();
                } else {
                    promise = db.insert(mmCoreCourseStatusStore, {
                        id: courseId,
                        status: status,
                        previous: previousStatus,
                        updated: new Date().getTime(),
                        downloadtime: downloadTime,
                        previousdownloadtime: previousDownloadTime
                    });
                }
                return promise.then(function() {
                    self._triggerCourseStatusChanged(courseId, status, siteId);
                });
            });
        });
    };
    self.translateModuleName = function(moduleName) {
        if (mods.indexOf(moduleName) < 0) {
            moduleName = "external-tool";
        }
        var langKey = 'mm.core.mod_' + moduleName,
            translated = $translate.instant(langKey);
        return translated !== langKey ? translated : moduleName;
    };
    self._triggerCourseStatusChanged = function(courseId, status, siteId) {
        var data = {
            siteId: siteId,
            courseId: courseId,
            status: status
        };
        $mmEvents.trigger(mmCoreEventCourseStatusChanged, data);
    };
    return self;
}]);

angular.module('mm.core.course')
.provider('$mmCourseDelegate', function() {
    var contentHandlers = {},
        self = {};
    self.registerContentHandler = function(addon, handles, handler) {
        if (typeof contentHandlers[handles] !== 'undefined') {
            console.log("$mmCourseDelegateProvider: Addon '" + contentHandlers[handles].addon + "' already registered as handler for '" + handles + "'");
            return false;
        }
        console.log("$mmCourseDelegateProvider: Registered addon '" + addon + "' as course content handler.");
        contentHandlers[handles] = {
            addon: addon,
            handler: handler,
            instance: undefined
        };
        return true;
    };
    self.$get = ["$q", "$log", "$mmSite", "$mmUtil", "$mmCourseContentHandler", function($q, $log, $mmSite, $mmUtil, $mmCourseContentHandler) {
        var enabledHandlers = {},
            self = {},
            lastUpdateHandlersStart = {};
        $log = $log.getInstance('$mmCourseDelegate');
        self.getContentHandlerControllerFor = function(handles, module, courseid, sectionid) {
            if (typeof enabledHandlers[handles] !== 'undefined') {
                return enabledHandlers[handles].getController(module, courseid, sectionid);
            }
            return $mmCourseContentHandler.getController(module, courseid, sectionid);
        };
        self.hasContentHandler = function(handles) {
            return typeof contentHandlers[handles] !== 'undefined';
        };
        self.isModuleDisabled = function(handles, siteId) {
            return $mmSitesManager.getSite(siteId).then(function(site) {
                return self.isModuleDisabledInSite(handles, site);
            });
        };
        self.isModuleDisabledInSite = function(handles, site) {
            site = site || $mmSite;
            if (typeof contentHandlers[handles] !== 'undefined') {
                return site.isFeatureDisabled('$mmCourseDelegate_' + contentHandlers[handles].addon);
            }
            return false;
        };
        self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
        self.updateContentHandler = function(handles, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else if ($mmSite.isFeatureDisabled('$mmCourseDelegate_' + handlerInfo.addon)) {
                promise = $q.when(false);
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[handles] = handlerInfo.instance;
                    } else {
                        delete enabledHandlers[handles];
                    }
                }
            });
        };
        self.updateContentHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating content handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(contentHandlers, function(handlerInfo, handles) {
                promises.push(self.updateContentHandler(handles, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.course')
.factory('$mmCourseHelper', ["$q", "$mmCoursePrefetchDelegate", "$mmFilepool", "$mmUtil", "$mmCourse", "$mmSite", "$state", "$mmText", "mmCoreNotDownloaded", "mmCoreOutdated", "mmCoreDownloading", "mmCoreCourseAllSectionsId", "$mmSitesManager", "$mmAddonManager", "$controller", "$mmCourseDelegate", "$translate", "$mmEvents", "mmCoreEventPackageStatusChanged", "mmCoreNotDownloadable", "mmCoreDownloaded", "$mmCoursesDelegate", function($q, $mmCoursePrefetchDelegate, $mmFilepool, $mmUtil, $mmCourse, $mmSite, $state, $mmText,
            mmCoreNotDownloaded, mmCoreOutdated, mmCoreDownloading, mmCoreCourseAllSectionsId, $mmSitesManager, $mmAddonManager,
            $controller, $mmCourseDelegate, $translate, $mmEvents, mmCoreEventPackageStatusChanged, mmCoreNotDownloadable,
            mmCoreDownloaded, $mmCoursesDelegate) {
    var self = {},
        calculateSectionStatus = false,
        courseDwnPromises = {};
    self.isDownloadSectionsEnabled = function() {
        return calculateSectionStatus;
    };
    self.setDownloadSectionsEnabled = function(status) {
        calculateSectionStatus = status;
        return calculateSectionStatus;
    };
    self.calculateSectionStatus = function(section, courseid, restoreDownloads, refresh, dwnpromises) {
        if (section.id !== mmCoreCourseAllSectionsId) {
            return $mmCoursePrefetchDelegate.getModulesStatus(section.id, section.modules, courseid, refresh, restoreDownloads)
                    .then(function(result) {
                var downloadid = self.getSectionDownloadId(section);
                if ($mmCoursePrefetchDelegate.isBeingDownloaded(downloadid)) {
                    result.status = mmCoreDownloading;
                }
                section.showDownload = result.status === mmCoreNotDownloaded;
                section.showRefresh = result.status === mmCoreOutdated;
                if (result.status !== mmCoreDownloading) {
                    section.isDownloading = false;
                    section.total = 0;
                } else if (!restoreDownloads) {
                    section.count = 0;
                    section.total = result[mmCoreOutdated].length + result[mmCoreNotDownloaded].length +
                                    result[mmCoreDownloading].length;
                    section.isDownloading = true;
                } else {
                    var promise = self.startOrRestorePrefetch(section, result, courseid).then(function(prevented) {
                        if (prevented !== true) {
                            return self.calculateSectionStatus(section, courseid);
                        }
                    });
                    if (dwnpromises) {
                        dwnpromises.push(promise);
                    }
                }
                return result;
            });
        }
        return $q.reject();
    };
    self.calculateSectionsStatus = function(sections, courseid, restoreDownloads, refresh) {
        var allsectionssection,
            allsectionsstatus,
            downloadpromises = [],
            statuspromises = [];
        angular.forEach(sections, function(section) {
            if (section.id === mmCoreCourseAllSectionsId) {
                allsectionssection = section;
                section.isCalculating = true;
            } else {
                section.isCalculating = true;
                statuspromises.push(self.calculateSectionStatus(section, courseid, restoreDownloads, refresh, downloadpromises)
                        .then(function(result) {
                    allsectionsstatus = $mmFilepool.determinePackagesStatus(allsectionsstatus, result.status);
                }).finally(function() {
                    section.isCalculating = false;
                }));
            }
        });
        return $q.all(statuspromises).then(function() {
            if (allsectionssection) {
                allsectionssection.showDownload = allsectionsstatus === mmCoreNotDownloaded;
                allsectionssection.showRefresh = allsectionsstatus === mmCoreOutdated;
                allsectionssection.isDownloading = allsectionsstatus === mmCoreDownloading;
            }
            return downloadpromises;
        }).finally(function() {
            if (allsectionssection) {
                allsectionssection.isCalculating = false;
            }
        });
    };
    self.confirmDownloadSize = function(courseid, section, sections, alwaysConfirm) {
        var sizePromise;
        if (section && section.id != mmCoreCourseAllSectionsId) {
            sizePromise = $mmCoursePrefetchDelegate.getDownloadSize(section.modules, courseid);
        } else {
            var promises = [],
                results = {
                    size: 0,
                    total: true
                };
            angular.forEach(sections, function(s) {
                if (s.id != mmCoreCourseAllSectionsId) {
                    promises.push($mmCoursePrefetchDelegate.getDownloadSize(s.modules, courseid).then(function(sectionsize) {
                        results.total = results.total && sectionsize.total;
                        results.size += sectionsize.size;
                    }));
                }
            });
            sizePromise = $q.all(promises).then(function() {
                return results;
            });
        }
        return sizePromise.then(function(size) {
            return $mmUtil.confirmDownloadSize(size, undefined, undefined, undefined, undefined, alwaysConfirm);
        });
    };
    self.getModuleCourseIdByInstance = function(id, module, siteId) {
        return $mmCourse.getModuleBasicInfoByInstance(id, module, siteId).then(function(cm) {
            return cm.course;
        }).catch(function(error) {
            if (error) {
                $mmUtil.showErrorModal(error);
            } else {
                $mmUtil.showErrorModal('mm.course.errorgetmodule', true);
            }
            return $q.reject();
        });
    };
    self.getModulePrefetchInfo = function(module, courseId, invalidateCache, component) {
        var moduleInfo = {
                size: false,
                sizeReadable: false,
                timemodified: false,
                timemodifiedReadable: false,
                status: false,
                statusIcon: false
            },
            siteId = $mmSite.getId(),
            promises = [];
        if (typeof invalidateCache != "undefined" && invalidateCache) {
            $mmCoursePrefetchDelegate.invalidateModuleStatusCache(module);
        }
        promises.push($mmCoursePrefetchDelegate.getModuleDownloadedSize(module, courseId).then(function(moduleSize) {
            moduleInfo.size = moduleSize;
            moduleInfo.sizeReadable = $mmText.bytesToSize(moduleSize, 2);
        }));
        promises.push($mmCoursePrefetchDelegate.getModuleTimemodified(module, courseId).then(function(moduleModified) {
            moduleInfo.timemodified = moduleModified;
            if (moduleModified > 0) {
                var now = $mmUtil.timestamp();
                if (now - moduleModified < 7 * 86400) {
                    moduleInfo.timemodifiedReadable = moment(moduleModified * 1000).fromNow();
                } else {
                    moduleInfo.timemodifiedReadable = moment(moduleModified * 1000).calendar();
                }
            } else {
                moduleInfo.timemodifiedReadable = "";
            }
        }));
        promises.push($mmCoursePrefetchDelegate.getModuleStatus(module, courseId).then(function(moduleStatus) {
            moduleInfo.status = moduleStatus;
            switch (moduleStatus) {
                case mmCoreNotDownloaded:
                    moduleInfo.statusIcon = 'ion-ios-cloud-download-outline';
                    break;
                case mmCoreDownloading:
                    moduleInfo.statusIcon = 'spinner';
                    break;
                case mmCoreOutdated:
                    moduleInfo.statusIcon = 'ion-android-refresh';
                    break;
                default:
                    moduleInfo.statusIcon = "";
                    break;
            }
        }));
        promises.push($mmFilepool.getPackageData(siteId, component, module.id).then(function(data) {
            if (data && data.downloadtime && (data.status == mmCoreOutdated || data.status == mmCoreDownloaded)) {
                moduleInfo.downloadtime = data.downloadtime;
                var now = $mmUtil.timestamp();
                if (now - data.downloadtime < 7 * 86400) {
                    moduleInfo.downloadtimeReadable = moment(data.downloadtime * 1000).fromNow();
                } else {
                    moduleInfo.downloadtimeReadable = moment(data.downloadtime * 1000).calendar();
                }
            }
        }).catch(function() {
            moduleInfo.downloadtime = 0;
        }));
        return $q.all(promises).then(function () {
            return moduleInfo;
        });
    };
    self.getSectionDownloadId = function(section) {
        return 'Section-'+section.id;
    };
    self.getSectionsModules = function(sections) {
        if (!sections || !sections.length) {
            return [];
        }
        var modules = [];
        sections.forEach(function(section) {
            if (section.modules) {
                modules = modules.concat(section.modules);
            }
        });
        return modules;
    };
    self.addContentHandlerControllerForSectionModules = function(sections, courseId, moduleId, completionStatus, scope) {
        var hasContent = false;
        angular.forEach(sections, function(section) {
            if (!section || !self.sectionHasContent(section)) {
                return;
            }
            hasContent = true;
            angular.forEach(section.modules, function(module) {
                module._controller =
                        $mmCourseDelegate.getContentHandlerControllerFor(module.modname, module, courseId, section.id);
                if (completionStatus && typeof completionStatus[module.id] != 'undefined') {
                    module.completionstatus = completionStatus[module.id];
                    module.completionstatus.courseId = courseId;
                }
                if (module.id == moduleId) {
                    var newScope = scope.$new();
                    $controller(module._controller, {$scope: newScope});
                    if (newScope.action) {
                        newScope.action();
                    }
                    newScope.$destroy();
                }
            });
        });
        return hasContent;
    }
    self.navigateToModule = function(moduleId, siteId, courseId, sectionId) {
        siteId = siteId || $mmSite.getId();
        var modal = $mmUtil.showModalLoading(),
            promise;
        return $mmCourse.canGetModuleWithoutCourseId(siteId).then(function(enabled) {
            if (courseId && sectionId) {
                promise = $q.when();
            } else if (!courseId && !enabled) {
                promise = $q.reject();
            } else if (!courseId) {
                promise = $mmCourse.getModuleBasicInfo(moduleId, siteId).then(function(module) {
                    courseId = module.course;
                    sectionId = module.section;
                });
            } else {
                promise = $mmCourse.getModuleSectionId(moduleId, courseId, siteId).then(function(id) {
                    sectionId = id;
                });
            }
            return promise.then(function() {
                return $mmSitesManager.getSite(siteId);
            }).then(function(site) {
                if (courseId == site.getSiteHomeId()) {
                    var $mmaFrontpage = $mmAddonManager.get('$mmaFrontpage');
                    if ($mmaFrontpage && !$mmaFrontpage.isDisabledInSite(site)) {
                        return $mmaFrontpage.isFrontpageAvailable().then(function() {
                            return $state.go('redirect', {
                                siteid: siteId,
                                state: 'site.frontpage',
                                params: {
                                    moduleid: moduleId
                                }
                            });
                        });
                    }
                } else {
                    return $state.go('redirect', {
                        siteid: siteId,
                        state: 'site.mm_course',
                        params: {
                            courseid: courseId,
                            moduleid: moduleId,
                            sid: sectionId
                        }
                    });
                }
            });
        }).catch(function(error) {
            $mmUtil.showErrorModalDefault(error, 'mm.course.errorgetmodule', true);
            return $q.reject();
        }).finally(function() {
            modal.dismiss();
        });
    };
    self.prefetch = function(section, courseid, sections) {
        if (section.id != mmCoreCourseAllSectionsId) {
            return self.prefetchSection(section, courseid, true, sections);
        } else {
            var promises = [];
            section.isDownloading = true;
            angular.forEach(sections, function(s) {
                if (s.id != mmCoreCourseAllSectionsId) {
                    promises.push(self.prefetchSection(s, courseid, false, sections).then(function() {
                        return self.calculateSectionStatus(s, courseid);
                    }));
                }
            });
            return $mmUtil.allPromises(promises);
        }
    };
    self.prefetchModule = function(scope, service, module, size, refresh, courseId) {
        return $mmUtil.confirmDownloadSize(size).then(function() {
            var promise = refresh ? service.invalidateContent(module.id, courseId) : $q.when();
            return promise.catch(function() {
            }).then(function() {
                var promise;
                if (service.prefetch) {
                    promise = service.prefetch(module, courseId);
                } else if (service.prefetchContent) {
                    promise = service.prefetchContent(module, courseId);
                } else {
                    return $q.reject();
                }
                return promise.catch(function(error) {
                    if (!scope.$$destroyed) {
                        $mmUtil.showErrorModalDefault(error, 'mm.core.errordownloading', true);
                        return $q.reject();
                    }
                });
            });
        });
    };
    self.prefetchSection = function(section, courseid, singleDownload, sections) {
        if (section.id == mmCoreCourseAllSectionsId) {
            return $q.when();
        }
        section.isDownloading = true;
        return $mmCoursePrefetchDelegate.getModulesStatus(section.id, section.modules, courseid).then(function(result) {
            if (result.status === mmCoreNotDownloaded || result.status === mmCoreOutdated || result.status === mmCoreDownloading) {
                var promise = self.startOrRestorePrefetch(section, result, courseid);
                if (singleDownload) {
                    self.calculateSectionsStatus(sections, courseid, false);
                }
                return promise;
            }
        }, function() {
            section.isDownloading = false;
            return $q.reject();
        });
    };
    self.startOrRestorePrefetch = function(section, status, courseid) {
        if (section.id == mmCoreCourseAllSectionsId) {
            return $q.when(true);
        }
        if (section.total > 0) {
            return $q.when(true);
        }
        var modules = status[mmCoreOutdated].concat(status[mmCoreNotDownloaded]).concat(status[mmCoreDownloading]),
            downloadid = self.getSectionDownloadId(section);
        section.count = 0;
        section.total = modules.length;
        section.dwnModuleIds = modules.map(function(m) {
            return m.id;
        });
        section.isDownloading = true;
        return $mmCoursePrefetchDelegate.prefetchAll(downloadid, modules, courseid).then(undefined, undefined, function(id) {
            var index = section.dwnModuleIds.indexOf(id);
            if (index > -1) {
                section.dwnModuleIds.splice(index, 1);
                section.count++;
            }
        });
    };
    self.sectionHasContent = function(section) {
        return !section.hiddenbynumsections && ((typeof section.availabilityinfo != "undefined" && section.availabilityinfo != '') ||
            section.summary != '' || section.modules.length);
    };
    self.confirmAndRemove = function(module, courseId) {
        return $mmUtil.showConfirm($translate('mm.course.confirmdeletemodulefiles')).then(function() {
            return $mmCoursePrefetchDelegate.removeModuleFiles(module, courseId);
        });
    };
    self.contextMenuPrefetch = function(scope, module, courseId) {
        var icon = scope.prefetchStatusIcon;
        scope.prefetchStatusIcon = 'spinner'; 
        return $mmCoursePrefetchDelegate.getModuleDownloadSize(module, courseId, true).then(function(size) {
            return $mmUtil.confirmDownloadSize(size).then(function() {
                return $mmCoursePrefetchDelegate.prefetchModule(module, courseId, true).catch(function(error) {
                    return failPrefetch(!scope.$$destroyed, error);
                });
            }, function() {
                scope.prefetchStatusIcon = icon;
                return failPrefetch(false);
            });
        }, function(error) {
            return failPrefetch(true, error);
        });
        function failPrefetch(showError, error) {
            scope.prefetchStatusIcon = icon;
            if (showError) {
                $mmUtil.showErrorModalDefault(error, 'mm.core.errordownloading', true);
            }
            return $q.reject();
        }
    };
    self.fillContextMenu = function(scope, module, courseId, invalidateCache, component) {
        return self.getModulePrefetchInfo(module, courseId, invalidateCache, component).then(function(moduleInfo) {
            scope.size = moduleInfo.size > 0 ? moduleInfo.sizeReadable : 0;
            scope.prefetchStatusIcon = moduleInfo.statusIcon;
            if (moduleInfo.status != mmCoreNotDownloadable) {
                if (moduleInfo.timemodified > 0) {
                    scope.timemodified = $translate.instant('mm.core.lastmodified') + ': ' + moduleInfo.timemodifiedReadable;
                } else if (moduleInfo.downloadtime > 0) {
                    scope.timemodified = $translate.instant('mm.core.lastdownloaded') + ': ' + moduleInfo.downloadtimeReadable;
                } else {
                    scope.timemodified = $translate.instant('mm.core.download');
                }
            }
            if (typeof scope.statusObserver == 'undefined' && component) {
                scope.statusObserver = $mmEvents.on(mmCoreEventPackageStatusChanged, function(data) {
                    if (data.siteid === $mmSite.getId() && data.componentId === module.id && data.component === component) {
                        self.fillContextMenu(scope, module, courseId, false, component);
                    }
                });
                scope.$on('$destroy', function() {
                    scope.statusObserver && scope.statusObserver.off && scope.statusObserver.off();
                });
            }
        });
    };
    self.getCourseDownloadPromise = function(courseId, siteId) {
        siteId = siteId || $mmSite.getId();
        return courseDwnPromises[siteId] && courseDwnPromises[siteId][courseId];
    };
    self.getCourseStatusIcon = function(courseId, siteId) {
        return $mmCourse.getCourseStatus(courseId, siteId).then(function(status) {
            return self.getCourseStatusIconFromStatus(status);
        });
    };
    self.getCourseStatusIconFromStatus = function(status) {
        if (status == mmCoreDownloaded) {
            return 'ion-android-refresh';
        } else if (status == mmCoreDownloading) {
            return 'spinner';
        } else {
            return 'ion-ios-cloud-download-outline';
        }
    };
    self.prefetchCourse = function(course, sections, courseOptions, siteId) {
        siteId = siteId || $mmSite.getId();
        if (courseDwnPromises[siteId] && courseDwnPromises[siteId][course.id]) {
            return courseDwnPromises[siteId][course.id];
        } else if (!courseDwnPromises[siteId]) {
            courseDwnPromises[siteId] = {};
        }
        courseDwnPromises[siteId][course.id] = $mmCourse.setCourseStatus(course.id, mmCoreDownloading, siteId).then(function() {
            var promises = [],
                allSectionsSection;
            allSectionsSection = sections[0].id == mmCoreCourseAllSectionsId ? sections[0] : {id: mmCoreCourseAllSectionsId};
            promises.push(self.prefetch(allSectionsSection, course.id, sections));
            angular.forEach(courseOptions, function(option) {
                if (option.prefetch) {
                    promises.push($q.when(option.prefetch(course)).catch(function() {
                    }));
                }
            });
            return $mmUtil.allPromises(promises);
        }).then(function() {
            return $mmCourse.setCourseStatus(course.id, mmCoreDownloaded, siteId);
        }).catch(function(error) {
            return $mmCourse.setCoursePreviousStatus(course.id, siteId).then(function() {
                return $q.reject(error);
            });
        }).finally(function() {
            delete courseDwnPromises[siteId][course.id];
        });
        return courseDwnPromises[siteId][course.id];
    };
    self.confirmAndPrefetchCourse = function(scope, course, sections, courseOptions) {
        var initialIcon = scope.prefetchCourseIcon,
            promise,
            siteId = $mmSite.getId();
        scope.prefetchCourseIcon = 'spinner';
        if (sections) {
            promise = $q.when(sections);
        } else {
            promise = $mmCourse.getSections(course.id, false, true);
        }
        return promise.then(function(sections) {
            return self.confirmDownloadSize(course.id, undefined, sections, true).then(function() {
                if (courseOptions) {
                    promise = $q.when(courseOptions);
                } else {
                    promise = $mmCoursesDelegate.getNavHandlersToDisplay(course, false, false, true);
                }
                return promise.then(function(handlers) {
                    return self.prefetchCourse(course, sections, handlers, siteId);
                }).then(function() {
                    return true;
                });
            }, function(error) {
                if (error) {
                    $mmUtil.showErrorModal(error);
                }
                scope.prefetchCourseIcon = initialIcon;
                return false;
            });
        }).catch(function(error) {
            if (!scope.$$destroyed) {
                $mmUtil.showErrorModalDefault(error, 'mm.course.errordownloadingcourse', true);
            }
            return $q.reject(error);
        });
    };
    self.confirmAndPrefetchCourses = function(courses) {
        var siteId = $mmSite.getId();
        return $mmUtil.showConfirm($translate('mm.core.areyousure')).then(function() {
            var deferred = $q.defer(), 
                promises = [],
                total = courses.length,
                count = 0;
            setTimeout(function() {
                deferred.notify({
                    count: count,
                    total: total
                });
            });
            angular.forEach(courses, function(course) {
                var subPromises = [],
                    sections,
                    handlers,
                    success = true;
                subPromises.push($mmCourse.getSections(course.id, false, true).then(function(courseSections) {
                    sections = courseSections;
                }));
                subPromises.push($mmCoursesDelegate.getNavHandlersToDisplay(course, false, false, true).then(function(cHandlers) {
                    handlers = cHandlers;
                }));
                promises.push($q.all(subPromises).then(function() {
                    return self.prefetchCourse(course, sections, handlers, siteId);
                }).catch(function(error) {
                    success = false;
                    if (course && course.fullname) {
                        error = $translate.instant('mm.course.errordownloadingcoursewithname', {
                            name: course.fullname,
                            error: error || ''
                        });
                    }
                    return $q.reject(error);
                }).finally(function() {
                    count++;
                    deferred.notify({
                        count: count,
                        total: total,
                        course: course.id,
                        success: success
                    });
                }));
            });
            $mmUtil.allPromises(promises).then(function() {
                deferred.resolve(true);
            }, deferred.reject);
            return deferred.promise;
        }, function() {
            return false;
        });
    };
    self.determineCoursesStatus = function(courses) {
        var promises = [],
            siteId = $mmSite.getId();
        angular.forEach(courses, function(course) {
            promises.push($mmCourse.getCourseStatus(course.id, siteId));
        });
        return $q.all(promises).then(function(statuses) {
            var status = statuses[0];
            for (var i = 1; i < statuses.length; i++) {
                status = $mmFilepool.determinePackagesStatus(status, statuses[i]);
            }
            return status;
        });
    };
    return self;
}])
.run(["$mmEvents", "mmCoreEventLogout", "$mmCourseHelper", function($mmEvents, mmCoreEventLogout, $mmCourseHelper) {
    $mmEvents.on(mmCoreEventLogout, function() {
        $mmCourseHelper.setDownloadSectionsEnabled(false);
    });
}]);
angular.module('mm.core')
.constant('mmCoreCheckUpdatesTimesStore', 'check_updates_times')
.provider('$mmCoursePrefetchDelegate', ["$mmSitesFactoryProvider", "mmCoreCheckUpdatesTimesStore", function($mmSitesFactoryProvider, mmCoreCheckUpdatesTimesStore) {
    var prefetchHandlers = {},
        self = {},
        stores = [
            {
                name: mmCoreCheckUpdatesTimesStore,
                keyPath: 'courseid',
                indexes: []
            }
        ];
    $mmSitesFactoryProvider.registerStores(stores);
    self.registerPrefetchHandler = function(addon, handles, handler) {
        if (typeof prefetchHandlers[handles] !== 'undefined') {
            console.log("$mmCoursePrefetchDelegateProvider: Addon '" + prefetchHandlers[handles].addon +
                            "' already registered as handler for '" + handles + "'");
            return false;
        }
        console.log("$mmCoursePrefetchDelegateProvider: Registered addon '" + addon + "' as prefetch handler.");
        prefetchHandlers[handles] = {
            addon: addon,
            handler: handler,
            instance: undefined
        };
        return true;
    };
    self.$get = ["$q", "$log", "$mmSite", "$mmUtil", "$mmFilepool", "$mmEvents", "$mmCourse", "mmCoreDownloaded", "mmCoreDownloading", "mmCoreNotDownloaded", "mmCoreOutdated", "mmCoreNotDownloadable", "mmCoreEventSectionStatusChanged", "$mmFS", "md5", "$mmSitesManager", "mmCoreCheckUpdatesTimesStore", function($q, $log, $mmSite, $mmUtil, $mmFilepool, $mmEvents, $mmCourse, mmCoreDownloaded, mmCoreDownloading,
                mmCoreNotDownloaded, mmCoreOutdated, mmCoreNotDownloadable, mmCoreEventSectionStatusChanged, $mmFS, md5,
                $mmSitesManager, mmCoreCheckUpdatesTimesStore) {
        var enabledHandlers = {},
            self = {},
            deferreds = {},
            lastUpdateHandlersStart,
            courseUpdatesPromises = {}; 
        $log = $log.getInstance('$mmCoursePrefetchDelegate');
        self.canCheckUpdates = function() {
            return $mmSite.wsAvailable('core_course_check_updates');
        };
        self.canModuleUseCheckUpdates = function(module, courseId) {
            var handler = enabledHandlers[module.modname];
            if (!handler) {
                return $q.when(false);
            }
            if (handler.canUseCheckUpdates) {
                return $q.when(handler.canUseCheckUpdates(module, courseId));
            }
            return $q.when(true);
        };
        self.clearStatusCache = function() {
            statusCache.clear();
        };
        self.invalidateModuleStatusCache = function(module) {
            var handler = enabledHandlers[module.modname];
            if (handler) {
                statusCache.invalidate(handler.component, module.id);
            }
        };
        var statusCache = new function() {
            var cacheStore = {};
            this.clear = function() {
                cacheStore = {};
            };
            this.get = function(component, componentId) {
                var packageId = $mmFilepool.getPackageId(component, componentId);
                if (!cacheStore[packageId]) {
                    cacheStore[packageId] = {};
                }
                return cacheStore[packageId];
            };
            this.getValue = function(component, componentId, name, ignoreInvalidate) {
                var cache = this.get(component, componentId);
                if (cache[name] && typeof cache[name].value != "undefined") {
                    var now = new Date().getTime();
                    if (ignoreInvalidate || cache[name].lastupdate + 300000 >= now) {
                        return cache[name].value;
                    }
                }
                return undefined;
            };
            this.setValue = function(component, componentId, name, value) {
                var cache = this.get(component, componentId);
                cache[name] = {
                    value: value,
                    lastupdate: new Date().getTime()
                };
                return value;
            };
            this.invalidate = function(component, componentId) {
                var cache = this.get(component, componentId);
                angular.forEach(cache, function(entry) {
                    entry.lastupdate = 0;
                });
            };
        };
        self.determineModuleStatus = function(module, status, restoreDownloads, canCheck) {
            var handler = enabledHandlers[module.modname];
            if (handler) {
                if (status == mmCoreDownloading && restoreDownloads) {
                    if (!$mmFilepool.getPackageDownloadPromise($mmSite.getId(), handler.component, module.id)) {
                        handler.prefetch(module);
                    }
                } else if (handler.determineStatus) {
                    return handler.determineStatus(status, canCheck, module);
                }
            }
            return status;
        };
        function getCourseUpdatesCacheKey(courseId) {
            return 'mmCourse:courseUpdates:' + courseId;
        }
        function createToCheckList(modules, courseId) {
            var result = {
                    toCheck: [],
                    cannotUse: []
                },
                promises = [];
            angular.forEach(modules, function(module) {
                promises.push(getModuleStatusAndDownloadTime(module, courseId).then(function(data) {
                    if (data.status == mmCoreDownloaded) {
                        return self.canModuleUseCheckUpdates(module, courseId).then(function(canUse) {
                            if (canUse) {
                                result.toCheck.push({
                                    contextlevel: 'module',
                                    id: module.id,
                                    since: data.downloadtime || 0
                                });
                            } else {
                                result.cannotUse.push(module);
                            }
                        });
                    }
                }).catch(function() {
                }));
            });
            return $q.all(promises).then(function() {
                result.toCheck.sort(function (a, b) {
                    return a.id >= b.id ? 1 : -1;
                });
                return result;
            });
        }
        function getModuleStatusAndDownloadTime(module, courseId) {
            var handler = enabledHandlers[module.modname],
                siteId = $mmSite.getId();
            if (handler) {
                return self.isModuleDownloadable(module, courseId).then(function(downloadable) {
                    if (!downloadable) {
                        return {
                            status: mmCoreNotDownloadable
                        };
                    }
                    var status = statusCache.getValue(handler.component, module.id, 'status');
                    if (typeof status != 'undefined' && status != mmCoreDownloaded) {
                        return {
                            status: status
                        };
                    }
                    return $mmFilepool.getPackageData(siteId, handler.component, module.id).then(function(data) {
                        var time = typeof data.downloadtime != 'undefined' ? data.downloadtime : data.timemodified;
                        return {
                            status: data.status,
                            downloadtime: time
                        };
                    });
                });
            }
            return $q.when({
                status: mmCoreNotDownloadable
            });
        }
        self.getCourseUpdates = function(modules, courseId) {
            if (!self.canCheckUpdates()) {
                return $q.reject();
            }
            var id = md5.createHash(courseId + '#' + JSON.stringify(modules)),
                siteId = $mmSite.getId(),
                promise;
            if (courseUpdatesPromises[siteId] && courseUpdatesPromises[siteId][id]) {
                return courseUpdatesPromises[siteId][id];
            } else if (!courseUpdatesPromises[siteId]) {
                courseUpdatesPromises[siteId] = {};
            }
            promise = createToCheckList(modules, courseId).then(function(data) {
                var result = {};
                angular.forEach(data.cannotUse, function(module) {
                    result[module.id] = false;
                });
                if (!data.toCheck.length) {
                    return result;
                }
                return $mmSitesManager.getSite(siteId).then(function(site) {
                    var params = {
                            courseid: courseId,
                            tocheck: data.toCheck
                        },
                        preSets = {
                            cacheKey: getCourseUpdatesCacheKey(courseId),
                            emergencyCache: false, 
                            uniqueCacheKey: true
                        };
                    return site.read('core_course_check_updates', params, preSets).then(function(response) {
                        if (!response || typeof response.instances == 'undefined') {
                            return $q.reject();
                        }
                        site.getDb().insert(mmCoreCheckUpdatesTimesStore, {
                            courseid: courseId,
                            time: $mmUtil.timestamp()
                        });
                        return treatCheckUpdatesResult(data.toCheck, response, result);
                    }).catch(function(error) {
                        return site.getDb().get(mmCoreCheckUpdatesTimesStore, courseId).then(function(entry) {
                            preSets.getCacheUsingCacheKey = true;
                            preSets.omitExpires = true;
                            return site.read('core_course_check_updates', params, preSets).then(function(response) {
                                if (!response || typeof response.instances == 'undefined') {
                                    return $q.reject(error);
                                }
                                return treatCheckUpdatesResult(data.toCheck, response, result, entry.time);
                            });
                        }, function() {
                            return result;
                        });
                    });
                });
            }).finally(function() {
                delete courseUpdatesPromises[siteId][id];
            });
            courseUpdatesPromises[siteId][id] = promise;
            return promise;
        };
        function treatCheckUpdatesResult(toCheckList, response, result, previousTime) {
            angular.forEach(response.instances, function(instance) {
                result[instance.id] = instance;
            });
            angular.forEach(response.warnings, function(warning) {
                if (warning.warningcode == 'missingcallback') {
                    result[warning.itemid] = false;
                }
            });
            if (previousTime) {
                angular.forEach(toCheckList, function(entry) {
                    if (result[entry.id] && entry.since > previousTime) {
                        delete result[entry.id];
                    }
                });
            }
            return result;
        }
        self.getCourseUpdatesByCourseId = function(courseId) {
            if (!self.canCheckUpdates()) {
                return $q.reject();
            }
            return $mmCourse.getSections(courseId, false, true, {omitExpires: true}).then(function(sections) {
                var modules = [];
                angular.forEach(sections, function(section) {
                    if (section.modules) {
                        modules = modules.concat(section.modules);
                    }
                });
                return self.getCourseUpdates(modules, courseId);
            });
        };
        self.invalidateCourseUpdates = function(courseId) {
            return $mmSite.invalidateWsCacheForKey(getCourseUpdatesCacheKey(courseId));
        };
        self.getDownloadSize = function(modules, courseid) {
            var promises = [],
                results = {
                    size: 0,
                    total: true
                };
            angular.forEach(modules, function(module) {
                promises.push(self.getModuleStatus(module, courseid).then(function(modstatus) {
                    if (modstatus === mmCoreNotDownloaded || modstatus === mmCoreOutdated) {
                        return self.getModuleDownloadSize(module, courseid).then(function(modulesize) {
                            results.total = results.total && modulesize.total;
                            results.size += modulesize.size;
                        });
                    }
                    return $q.when();
                }));
            });
            return $q.all(promises).then(function() {
                return results;
            });
        };
        self.prefetchModule = function(module, courseid, single) {
            var handler = enabledHandlers[module.modname];
            if (handler) {
                return handler.prefetch(module, courseid, single);
            }
            return $q.when();
        };
        self.getModuleDownloadSize = function(module, courseid, single) {
            var downloadSize,
                handler = enabledHandlers[module.modname];
            if (handler) {
                return self.isModuleDownloadable(module, courseid).then(function(downloadable) {
                    if (!downloadable) {
                        return {size: 0, total: true};
                    }
                    downloadSize = statusCache.getValue(handler.component, module.id, 'downloadSize');
                    if (typeof downloadSize != 'undefined') {
                        return downloadSize;
                    }
                    return $q.when(handler.getDownloadSize(module, courseid, single)).then(function(size) {
                        return statusCache.setValue(handler.component, module.id, 'downloadSize', size);
                    }).catch(function(error) {
                        var cachedSize = statusCache.getValue(handler.component, module.id, 'downloadSize', true);
                        if (cachedSize) {
                            return cachedSize;
                        }
                        return $q.reject(error);
                    });
                });
            }
            return $q.when({size: 0, total: false});
        };
        self.getModuleDownloadedSize = function(module, courseid) {
            var downloadedSize,
                handler = enabledHandlers[module.modname];
            if (handler) {
                return self.isModuleDownloadable(module, courseid).then(function(downloadable) {
                    var promise;
                    if (!downloadable) {
                        return 0;
                    }
                    downloadedSize = statusCache.getValue(handler.component, module.id, 'downloadedSize');
                    if (typeof downloadedSize != 'undefined') {
                        return downloadedSize;
                    }
                    if (handler.getDownloadedSize) {
                        promise = $q.when(handler.getDownloadedSize(module, courseid));
                    } else {
                        promise = self.getModuleFiles(module, courseid).then(function(files) {
                            var siteId = $mmSite.getId(),
                                promises = [],
                                size = 0;
                            angular.forEach(files, function(file) {
                                var fileUrl = file.url || file.fileurl;
                                promises.push($mmFilepool.getFilePathByUrl(siteId, fileUrl).then(function(path) {
                                    return $mmFS.getFileSize(path).catch(function () {
                                        return $mmFilepool.isFileDownloadingByUrl(siteId, fileUrl).then(function() {
                                            return file.filesize;
                                        }).catch(function() {
                                            return 0;
                                        });
                                    }).then(function(fs) {
                                        size += fs;
                                    });
                                }));
                            });
                            return $q.all(promises).then(function() {
                                return size;
                            });
                        });
                    }
                    return promise.then(function(size) {
                        return statusCache.setValue(handler.component, module.id, 'downloadedSize', size);
                    }).catch(function() {
                        return statusCache.getValue(handler.component, module.id, 'downloadedSize', true);
                    });
                });
            }
            return $q.when(0);
        };
        self.getModuleTimemodified = function(module, courseid, files) {
            var handler = enabledHandlers[module.modname],
                promise, timemodified;
            if (handler) {
                timemodified = statusCache.getValue(handler.component, module.id, 'timemodified');
                if (typeof timemodified != 'undefined') {
                    return $q.when(timemodified);
                }
                if (handler.getTimemodified) {
                    promise = handler.getTimemodified(module, courseid);
                } else {
                    promise = files ? $q.when(files) : self.getModuleFiles(module, courseid);
                    return promise.then(function(files) {
                        return $mmFilepool.getTimemodifiedFromFileList(files);
                    });
                }
                return $q.when(promise).then(function(timemodified) {
                    return statusCache.setValue(handler.component, module.id, 'timemodified', timemodified);
                }).catch(function() {
                    return statusCache.getValue(handler.component, module.id, 'timemodified', true);
                });
            }
            return $q.reject();
        };
        self.getModuleRevision = function(module, courseid, files) {
            var handler = enabledHandlers[module.modname],
                promise, revision;
            if (handler) {
                revision = statusCache.getValue(handler.component, module.id, 'revision');
                if (typeof revision != 'undefined') {
                    return $q.when(revision);
                }
                if (handler.getRevision) {
                    promise = handler.getRevision(module, courseid);
                } else {
                    promise = files ? $q.when(files) : self.getModuleFiles(module, courseid);
                    promise = promise.then(function(files) {
                        return $mmFilepool.getRevisionFromFileList(files);
                    });
                }
                return $q.when(promise).then(function(revision) {
                    return statusCache.setValue(handler.component, module.id, 'revision', revision);
                }).catch(function() {
                    return statusCache.getValue(handler.component, module.id, 'revision', true);
                });
            }
            return $q.reject();
        };
        self.getModuleFiles = function(module, courseId) {
            var handler = enabledHandlers[module.modname];
            module.contents = module.contents || [];
            if (handler.getFiles) {
                return $q.when(handler.getFiles(module, courseId));
            } else if (handler.loadContents) {
                return handler.loadContents(module, courseId).then(function() {
                    return module.contents;
                });
            } else {
                return $q.when(module.contents);
            }
        };
        self.removeModuleFiles = function(module, courseid) {
            var handler = enabledHandlers[module.modname],
                siteId = $mmSite.getId(),
                promise;
            if (handler && handler.removeFiles) {
                promise = handler.removeFiles(module, courseid);
            } else {
                promise = self.getModuleFiles(module, courseid).then(function(files) {
                    var promises = [];
                    angular.forEach(files, function(file) {
                        var fileUrl = file.url || file.fileurl;
                        promises.push($mmFilepool.removeFileByUrl(siteId, fileUrl).catch(function() {
                        }));
                    });
                    return $q.all(promises);
                });
            }
            return promise.then(function() {
                if (handler) {
                    statusCache.setValue(handler.component, module.id, 'downloadedSize', 0);
                    $mmFilepool.storePackageStatus(siteId, handler.component, module.id, mmCoreNotDownloaded);
                }
            });
        };
        self.getModuleStatus = function(module, courseid, revision, timemodified, updates) {
            var handler = enabledHandlers[module.modname],
                siteid = $mmSite.getId(),
                canCheck = self.canCheckUpdates();
            if (handler) {
                return self.isModuleDownloadable(module, courseid).then(function(downloadable) {
                    if (!downloadable) {
                        return mmCoreNotDownloadable;
                    }
                    var status = statusCache.getValue(handler.component, module.id, 'status'),
                        promise;
                    if (typeof status != 'undefined') {
                        return self.determineModuleStatus(module, status, true, canCheck);
                    }
                    return $mmFilepool.getPackageCurrentStatus(siteid, handler.component, module.id).then(function(status) {
                        status = handler.determineStatus ? handler.determineStatus(status, canCheck, module) : status;
                        if (status == mmCoreNotDownloaded || status == mmCoreOutdated || status == mmCoreDownloading) {
                            self.updateStatusCache(handler.component, module.id, status);
                            return self.determineModuleStatus(module, status, true, canCheck);
                        }
                        if (typeof updates == 'undefined') {
                            promise = self.getCourseUpdatesByCourseId(courseid).then(function(updates) {
                                if (!updates || updates[module.id] === false) {
                                    return $q.reject();
                                }
                                return updates;
                            });
                        } else if (updates === false) {
                            promise = $q.reject(); 
                        } else {
                            promise = $q.when(updates);
                        }
                        return promise.then(function(updates) {
                            var hasUpdPrms = self.moduleHasUpdates(module, courseid, updates).then(function(hasUpdates) {
                                if (hasUpdates) {
                                    status = mmCoreOutdated;
                                    return $mmFilepool.storePackageStatus(siteid, handler.component, module.id, status)
                                            .catch(function() {
                                    }).then(function() {
                                        return status;
                                    });
                                } else {
                                    return status;
                                }
                            });
                            return getStatus(hasUpdPrms, true);
                        }, function() {
                            var revisionNeedsFiles = typeof revision == 'undefined' && !handler.getRevision &&
                                            typeof statusCache.getValue(handler.component, module.id, 'revision') == 'undefined',
                                timemodifiedNeedsFiles = typeof timemodified == 'undefined' && !handler.getTimemodified &&
                                            typeof statusCache.getValue(handler.component, module.id, 'timemodified') == 'undefined';
                            if (revisionNeedsFiles || timemodifiedNeedsFiles) {
                                promise = self.getModuleFiles(module, courseid);
                            } else {
                                promise = $q.when();
                            }
                            return promise.then(function(files) {
                                var promises = [];
                                if (typeof revision == 'undefined') {
                                    promises.push(self.getModuleRevision(module, courseid, files).then(function(rev) {
                                        revision = rev;
                                    }));
                                }
                                if (typeof timemodified == 'undefined') {
                                    promises.push(self.getModuleTimemodified(module, courseid, files).then(function(timemod) {
                                        timemodified = timemod;
                                    }));
                                }
                                return $q.all(promises).then(function() {
                                    var getStatusPromise = $mmFilepool.getPackageStatus(
                                            siteid, handler.component, module.id, revision, timemodified);
                                    return getStatus(getStatusPromise, false);
                                });
                            });
                        });
                    });
                });
            }
            return $q.when(mmCoreNotDownloadable);
            function getStatus(promise, canCheck) {
                return promise.then(function(status) {
                    self.updateStatusCache(handler.component, module.id, status);
                    return self.determineModuleStatus(module, status, true, canCheck);
                }).catch(function() {
                    var status = statusCache.getValue(handler.component, module.id, 'status', true);
                    return self.determineModuleStatus(module, status, true, canCheck);
                });
            }
        };
        self.getModulesStatus = function(sectionid, modules, courseid, refresh, restoreDownloads) {
            var promises = [],
                status = mmCoreNotDownloadable,
                result = {};
            result[mmCoreNotDownloaded] = [];
            result[mmCoreDownloaded] = [];
            result[mmCoreDownloading] = [];
            result[mmCoreOutdated] = [];
            result.total = 0;
            return self.getCourseUpdatesByCourseId(courseid).catch(function() {
                return false;
            }).then(function(updates) {
                angular.forEach(modules, function(module) {
                    var handler = enabledHandlers[module.modname],
                        promise,
                        canCheck = updates && updates[module.id] !== false;
                    module.contents = module.contents || [];
                    if (handler) {
                        var cacheStatus = statusCache.getValue(handler.component, module.id, 'status');
                        if (!refresh && typeof cacheStatus != 'undefined') {
                            promise = $q.when(self.determineModuleStatus(module, cacheStatus, restoreDownloads, canCheck));
                        } else {
                            promise = self.getModuleStatus(module, courseid, undefined, undefined, updates);
                        }
                        promises.push(
                            promise.then(function(modstatus) {
                                if (modstatus != mmCoreNotDownloadable) {
                                    statusCache.setValue(handler.component, module.id, 'sectionid', sectionid);
                                    self.updateStatusCache(handler.component, module.id, modstatus);
                                    status = $mmFilepool.determinePackagesStatus(status, modstatus);
                                    result[modstatus].push(module);
                                    result.total++;
                                }
                            }).catch(function() {
                                modstatus = statusCache.getValue(handler.component, module.id, 'status', true);
                                if (typeof modstatus == 'undefined') {
                                    return $q.reject();
                                }
                                if (modstatus != mmCoreNotDownloadable) {
                                    status = $mmFilepool.determinePackagesStatus(status, modstatus);
                                    result[modstatus].push(module);
                                    result.total++;
                                }
                            })
                        );
                    }
                });
                return $q.all(promises).then(function() {
                    result.status = status;
                    return result;
                });
            });
        };
        self.getPrefetchHandlerFor = function(handles) {
            return enabledHandlers[handles];
        };
        self.invalidateModules = function(modules, courseId) {
            var promises = [];
            angular.forEach(modules, function(module) {
                var handler = enabledHandlers[module.modname];
                if (handler) {
                    if (handler.invalidateModule) {
                        promises.push(handler.invalidateModule(module, courseId).catch(function() {
                        }));
                    }
                    statusCache.invalidate(handler.component, module.id);
                }
            });
            promises.push(self.invalidateCourseUpdates(courseId));
            return $q.all(promises);
        };
        self.isBeingDownloaded = function(id) {
            return deferreds[$mmSite.getId()] && deferreds[$mmSite.getId()][id];
        };
        self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
        self.isModuleDownloadable = function(module, courseid) {
            var handler = enabledHandlers[module.modname],
                promise;
            if (handler) {
                if (typeof handler.isDownloadable == 'function') {
                    var downloadable = statusCache.getValue(handler.component, module.id, 'downloadable');
                    if (typeof downloadable != 'undefined') {
                        promise = $q.when(downloadable);
                    } else {
                        promise = $q.when(handler.isDownloadable(module, courseid)).then(function(downloadable) {
                            statusCache.setValue(handler.component, module.id, 'downloadable', downloadable);
                            return downloadable;
                        });
                    }
                } else {
                    promise = $q.when(true); 
                }
                return promise.catch(function() {
                    return false;
                });
            } else {
                return $q.when(false);
            }
        };
        self.moduleHasUpdates = function(module, courseId, updates) {
            var handler = enabledHandlers[module.modname],
                moduleUpdates = updates[module.id];
            if (handler && handler.hasUpdates) {
                return $q.when(handler.hasUpdates(module, courseId, moduleUpdates));
            } else if (!moduleUpdates || !moduleUpdates.updates || !moduleUpdates.updates.length) {
                return $q.when(false);
            } else if (handler && handler.updatesNames && handler.updatesNames.test) {
                for (var i = 0, len = moduleUpdates.updates.length; i < len; i++) {
                    if (handler.updatesNames.test(moduleUpdates.updates[i].name)) {
                        return $q.when(true);
                    }
                }
                return $q.when(false);
            }
            return $q.when(true);
        };
        self.prefetchAll = function(id, modules, courseid) {
            var siteid = $mmSite.getId();
            if (deferreds[siteid] && deferreds[siteid][id]) {
                return deferreds[siteid][id].promise;
            }
            var deferred = $q.defer(),
                promises = [];
            if (!deferreds[siteid]) {
                deferreds[siteid] = {};
            }
            deferreds[siteid][id] = deferred;
            angular.forEach(modules, function(module) {
                module.contents = module.contents || [];
                var handler = enabledHandlers[module.modname];
                if (handler) {
                    promises.push(self.isModuleDownloadable(module, courseid).then(function(downloadable) {
                        if (!downloadable) {
                            return;
                        }
                        return handler.prefetch(module, courseid).then(function() {
                            deferred.notify(module.id);
                        });
                    }));
                }
            });
            $q.all(promises).then(function() {
                delete deferreds[siteid][id]; 
                deferred.resolve();
            }, function(error) {
                delete deferreds[siteid][id]; 
                deferred.reject(error);
            });
            return deferred.promise;
        };
        self.updatePrefetchHandler = function(handles, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[handles] = handlerInfo.instance;
                    } else {
                        delete enabledHandlers[handles];
                    }
                }
            });
        };
        self.updatePrefetchHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating prefetch handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(prefetchHandlers, function(handlerInfo, handles) {
                promises.push(self.updatePrefetchHandler(handles, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        self.updateStatusCache = function(component, componentId, status) {
            var notify,
                cachedStatus = statusCache.getValue(component, componentId, 'status', true);
            notify = typeof cachedStatus != 'undefined' && cachedStatus !== status;
            if (notify) {
                var sectionId = statusCache.getValue(component, componentId, 'sectionid', true);
                statusCache.invalidate(component, componentId);
                statusCache.setValue(component, componentId, 'status', status);
                statusCache.setValue(component, componentId, 'sectionid', sectionId);
                $mmEvents.trigger(mmCoreEventSectionStatusChanged, {
                    sectionid: sectionId,
                    siteid: $mmSite.getId()
                });
            } else {
                statusCache.setValue(component, componentId, 'status', status);
            }
        };
        return self;
    }];
    return self;
}])
.run(["$mmEvents", "mmCoreEventLogin", "mmCoreEventSiteUpdated", "mmCoreEventLogout", "$mmCoursePrefetchDelegate", "$mmSite", "mmCoreEventPackageStatusChanged", "mmCoreEventRemoteAddonsLoaded", function($mmEvents, mmCoreEventLogin, mmCoreEventSiteUpdated, mmCoreEventLogout, $mmCoursePrefetchDelegate, $mmSite,
            mmCoreEventPackageStatusChanged, mmCoreEventRemoteAddonsLoaded) {
    $mmEvents.on(mmCoreEventLogin, $mmCoursePrefetchDelegate.updatePrefetchHandlers);
    $mmEvents.on(mmCoreEventSiteUpdated, $mmCoursePrefetchDelegate.updatePrefetchHandlers);
    $mmEvents.on(mmCoreEventRemoteAddonsLoaded, $mmCoursePrefetchDelegate.updatePrefetchHandlers);
    $mmEvents.on(mmCoreEventLogout, $mmCoursePrefetchDelegate.clearStatusCache);
    $mmEvents.on(mmCoreEventPackageStatusChanged, function(data) {
        if (data.siteid === $mmSite.getId()) {
            $mmCoursePrefetchDelegate.updateStatusCache(data.component, data.componentId, data.status);
        }
    });
}]);

angular.module('mm.core.course')
.factory('$mmPrefetchFactory', ["$mmSite", "$mmFilepool", "$mmUtil", "$q", "$mmLang", "$mmApp", "mmCoreDownloading", "mmCoreDownloaded", "$mmCourse", function($mmSite, $mmFilepool, $mmUtil, $q, $mmLang, $mmApp, mmCoreDownloading, mmCoreDownloaded,
            $mmCourse) {
    var self = {},
        modulePrefetchHandler = (function () {
            var downloadPromises = {}; 
            this.component = 'core_module';
            this.isResource = false;
            this.updatesNames = /^.*files$/;
            this.addOngoingDownload = function (id, promise, siteId) {
                var uniqueId = this.getUniqueId(id);
                siteId = siteId || $mmSite.getId();
                if (!downloadPromises[siteId]) {
                    downloadPromises[siteId] = {};
                }
                downloadPromises[siteId][uniqueId] = promise;
                return promise.finally(function() {
                    delete downloadPromises[siteId][uniqueId];
                });
            };
            this.download = function(module, courseId) {
                return this.downloadOrPrefetch(module, courseId, false);
            };
            this.downloadOrPrefetch = function(module, courseId, prefetch, dirPath) {
                if (!$mmApp.isOnline()) {
                    return $mmLang.translateAndReject('mm.core.networkerrormsg');
                }
                var siteId = $mmSite.getId(),
                    that = this;
                return that.loadContents(module, courseId, true).then(function() {
                    return that.getIntroFiles(module, courseId);
                }).then(function(introFiles) {
                    return that.getRevisionAndTimemodified(module, courseId, introFiles).then(function(data) {
                        var downloadFn = prefetch ? $mmFilepool.prefetchPackage : $mmFilepool.downloadPackage,
                            contentFiles = that.getContentDownloadableFiles(module),
                            promises = [];
                        if (dirPath) {
                            promises.push($mmFilepool.downloadOrPrefetchFiles(siteId, introFiles, prefetch, false,
                                    that.component, module.id));
                            promises.push(downloadFn(siteId, contentFiles, that.component,
                                    module.id, data.revision, data.timemod, dirPath));
                        } else {
                            var files = introFiles.concat(contentFiles);
                            promises.push(downloadFn(siteId, files, that.component, module.id, data.revision, data.timemod));
                        }
                        return $q.all(promises);
                    });
                });
            };
            this.getContentDownloadableFiles = function(module) {
                var files = [],
                    that = this;
                angular.forEach(module.contents, function(content) {
                    if (that.isFileDownloadable(content)) {
                        files.push(content);
                    }
                });
                return files;
            };
            this.getDownloadSize = function(module, courseId) {
                return this.getFiles(module, courseId).then(function(files) {
                    return $mmUtil.sumFileSizes(files);
                }).catch(function() {
                    return {size: -1, total: false};
                });
            };
            this.getDownloadedSize = function(module, courseId) {
                return $mmFilepool.getFilesSizeByComponent($mmSite.getId(), this.component, module.id);
            };
            this.getDownloadingFilesEventNames = function(module, courseId) {
                var that = this,
                    siteId = $mmSite.getId();
                return that.loadContents(module, courseId).then(function() {
                    var promises = [],
                        eventNames = [];
                    angular.forEach(module.contents, function(content) {
                        var url = content.url || content.fileurl;
                        if (!that.isFileDownloadable(content)) {
                            return;
                        }
                        promises.push($mmFilepool.isFileDownloadingByUrl(siteId, url).then(function() {
                            return $mmFilepool.getFileEventNameByUrl(siteId, url).then(function(eventName) {
                                eventNames.push(eventName);
                            });
                        }).catch(function() {
                        }));
                    });
                    return $q.all(promises).then(function() {
                        return eventNames;
                    });
                });
            };
            this.getFileEventNames = function(module, courseId) {
                var that = this,
                    siteId = $mmSite.getId();
                return that.loadContents(module, courseId).then(function() {
                    var promises = [];
                    angular.forEach(module.contents, function(content) {
                        var url = content.url || content.fileurl;
                        if (!that.isFileDownloadable(content)) {
                            return;
                        }
                        promises.push($mmFilepool.getFileEventNameByUrl(siteId, url));
                    });
                    return $q.all(promises);
                });
            };
            this.getFiles = function(module, courseId) {
                var that = this;
                return that.loadContents(module, courseId).then(function() {
                    return that.getIntroFiles(module, courseId).then(function(files) {
                        return files.concat(that.getContentDownloadableFiles(module));
                    });
                });
            };
            this.getIntroFiles = function(module, courseId) {
                return $q.when(this.getIntroFilesFromInstance(module));
            };
            this.getIntroFilesFromInstance = function(module, instance) {
                if (instance) {
                    if (typeof instance.introfiles != 'undefined') {
                        return instance.introfiles;
                    } else if (instance.intro) {
                        return $mmUtil.extractDownloadableFilesFromHtmlAsFakeFileObjects(instance.intro);
                    }
                }
                if (module.description) {
                    return $mmUtil.extractDownloadableFilesFromHtmlAsFakeFileObjects(module.description);
                }
                return [];
            };
            this.getOngoingDownload = function (id, siteId) {
                siteId = siteId || $mmSite.getId();
                if (this.isDownloading(id, siteId)) {
                    var uniqueId = this.getUniqueId(id);
                    return downloadPromises[siteId][uniqueId];
                }
                return $q.when();
            };
            this.getRevision = function(module, courseId) {
                return this.getRevisionAndTimemodified(module, courseId).then(function(data) {
                    return data.revision;
                });
            };
            this.getRevisionAndTimemodified = function(module, courseId, introFiles) {
                var that = this;
                return that.loadContents(module, courseId).then(function() {
                    var promise = introFiles ? $q.when(introFiles) : that.getIntroFiles(module, courseId);
                    return promise.then(function(files) {
                        files = files.concat(module.contents || []);
                        return {
                            timemod: $mmFilepool.getTimemodifiedFromFileList(files),
                            revision: $mmFilepool.getRevisionFromFileList(files)
                        };
                    });
                });
            };
            this.getTimemodified = function(module, courseId) {
                return this.getRevisionAndTimemodified(module, courseId).then(function(data) {
                    return data.timemod;
                });
            };
            this.getUniqueId = function(id) {
                return this.component + '#' + id;
            };
            this.invalidateContent = function(moduleId) {
                var promises = [];
                promises.push($mmCourse.invalidateModule(moduleId));
                promises.push($mmFilepool.invalidateFilesByComponent($mmSite.getId(), this.component, moduleId));
                return $q.all(promises);
            };
            this.invalidateModule = function(module, courseId) {
                return $mmCourse.invalidateModule(module.id);
            };
            this.isDownloadable = function(module, courseId) {
                return $q.when(true);
            };
            this.isDownloading = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                var uniqueId = this.getUniqueId(id);
                return !!(downloadPromises[siteId] && downloadPromises[siteId][uniqueId]);
            };
            this.isEnabled = function() {
                return $mmSite.canDownloadFiles();
            };
            this.isFileDownloadable = function(file) {
                return file.type === 'file';
            };
            this.loadContents = function(module, courseId, ignoreCache) {
                if (this.isResource) {
                    return $mmCourse.loadModuleContents(module, courseId, false, false, ignoreCache);
                }
                return $q.when();
            };
            this.prefetch = function(module, courseId, single) {
                return this.downloadOrPrefetch(module, courseId, true);
            };
            this.prefetchPackage = function(module, courseId, single, downloadFn, siteId) {
                siteId = siteId || $mmSite.getId();
                if (!$mmApp.isOnline()) {
                    return $mmLang.translateAndReject('mm.core.networkerrormsg');
                }
                var that = this,
                    prefetchPromise,
                    extraParams = Array.prototype.slice.call(arguments, 5);
                if (that.isDownloading(module.id, siteId)) {
                    return that.getOngoingDownload(module.id, siteId);
                }
                prefetchPromise = this.setDownloading(module.id, siteId).then(function() {
                    var params = [module, courseId, single, siteId].concat(extraParams);
                    return $q.when(downloadFn.apply(that, params));
                }).then(function(data) {
                    return that.setDownloaded(module.id, siteId, data.revision, data.timemod);
                }).catch(function(error) {
                    return that.setPreviousStatusAndReject(module.id, error, siteId);
                });
                return that.addOngoingDownload(module.id, prefetchPromise, siteId);
            };
            this.setDownloaded = function(id, siteId, revision, timemod) {
                siteId = siteId || $mmSite.getId();
                return $mmFilepool.storePackageStatus(siteId, this.component, id, mmCoreDownloaded, revision, timemod);
            };
            this.setDownloading = function(id, siteId) {
                siteId = siteId || $mmSite.getId();
                return $mmFilepool.storePackageStatus(siteId, this.component, id, mmCoreDownloading);
            };
            this.setPreviousStatusAndReject = function(id, error, siteId) {
                siteId = siteId || $mmSite.getId();
                return $mmFilepool.setPackagePreviousStatus(siteId, this.component, id).then(function() {
                    return $q.reject(error);
                });
            };
            this.removeFiles = function(module, courseId) {
                return $mmFilepool.removeFilesByComponent($mmSite.getId(), this.component, module.id);
            };
            return this;
        }());
    self.createPrefetchHandler = function(component, isResource) {
        var child = Object.create(modulePrefetchHandler);
        child.component = component;
        child.isResource = !!isResource;
        return child;
    };
    return self;
}]);

angular.module('mm.core.courses')
.directive('mmCourseListItem', ["$mmCourses", "$translate", function($mmCourses, $translate) {
    return {
        restrict: 'E',
        templateUrl: 'core/components/courses/templates/courselistitem.html',
        scope: {
            course: '=',
        },
        link: function(scope) {
            var course = scope.course;
            return $mmCourses.getUserCourse(course.id).then(function() {
                course.isEnrolled = true;
            }).catch(function() {
                course.isEnrolled = false;
                course.enrollment = [];
                angular.forEach(course.enrollmentmethods, function(instance) {
                    if (instance === 'self') {
                        course.enrollment.push({
                            name: $translate.instant('mm.courses.selfenrolment'),
                            icon: 'ion-unlocked'
                        });
                    } else if (instance === 'guest') {
                        course.enrollment.push({
                            name: $translate.instant('mm.courses.allowguests'),
                            icon: 'ion-person'
                        });
                    } else if (instance === 'paypal') {
                        course.enrollment.push({
                            name: $translate.instant('mm.courses.paypalaccepted'),
                            img: 'img/icons/paypal.png'
                        });
                    }
                });
                if (course.enrollment.length == 0) {
                    course.enrollment.push({
                        name: $translate.instant('mm.courses.notenrollable'),
                        icon: 'ion-locked'
                    });
                }
            });
        }
    };
}]);

angular.module('mm.core.courses')
.directive('mmCourseListProgress', ["$ionicActionSheet", "$mmCoursesDelegate", "$translate", "$controller", "$q", "$mmCourseHelper", "$mmUtil", "$mmCourse", "$mmEvents", "$mmSite", "mmCoreEventCourseStatusChanged", function($ionicActionSheet, $mmCoursesDelegate, $translate, $controller, $q, $mmCourseHelper,
        $mmUtil, $mmCourse, $mmEvents, $mmSite, mmCoreEventCourseStatusChanged) {
    return {
        restrict: 'E',
        templateUrl: 'core/components/courses/templates/courselistprogress.html',
        transclude: true,
        scope: {
            course: '=',
            roundProgress: '=?',
            showSummary: "=?"
        },
        link: function(scope) {
            var buttons,
                obsStatus,
                downloadText = $translate.instant('mm.course.downloadcourse'),
                downloadingText = $translate.instant('mm.core.downloading'),
                downloadButton = {
                    isDownload: true,
                    className: 'mm-download-course',
                    priority: 1000
                };
            scope.actionsLoaded = true;
            $mmCourseHelper.getCourseStatusIcon(scope.course.id).then(function(icon) {
                scope.prefetchCourseIcon = icon;
                if (icon == 'spinner') {
                    downloadButton.text = downloadingText;
                    var promise = $mmCourseHelper.getCourseDownloadPromise(scope.course.id);
                    if (promise) {
                        promise.catch(function(error) {
                            if (!scope.$$destroyed) {
                                $mmUtil.showErrorModalDefault(error, 'mm.course.errordownloadingcourse', true);
                            }
                        });
                    } else {
                        $mmCourse.setCoursePreviousStatus(scope.course.id);
                    }
                } else {
                    downloadButton.text = '<i class="icon ' + icon + '"></i>' + downloadText;
                }
            });
            obsStatus = $mmEvents.on(mmCoreEventCourseStatusChanged, function(data) {
                if (data.siteId == $mmSite.getId() && data.courseId == scope.course.id) {
                    var icon = $mmCourseHelper.getCourseStatusIconFromStatus(data.status);
                    scope.prefetchCourseIcon = icon;
                    if (icon == 'spinner') {
                        downloadButton.text = downloadingText;
                    } else {
                        downloadButton.text = '<i class="icon ' + icon + '"></i>' + downloadText;
                    }
                }
            });
            scope.showCourseActions = function($event) {
                $event.preventDefault();
                $event.stopPropagation();
                scope.actionsLoaded = false;
                $mmCoursesDelegate.getNavHandlersToDisplay(scope.course, false, false, true).then(function(handlers) {
                    buttons = handlers.map(function(handler) {
                        var newScope = scope.$new();
                        $controller(handler.controller, {$scope: newScope});
                        var title = newScope.title || "",
                            icon = newScope.icon || false,
                            buttonInfo = {
                                text: (icon ? '<i class="icon ' + icon + '"></i>' : '') + $translate.instant(title),
                                action: newScope.action || false,
                                className: newScope.class || false,
                                priority: handler.priority || false
                            };
                        newScope.$destroy();
                        return buttonInfo;
                    });
                    buttons.unshift(downloadButton);
                    buttons = buttons.sort(function(a, b) {
                        return b.priority - a.priority;
                    });
                }).then(function() {
                    $ionicActionSheet.show({
                        titleText: scope.course.fullname,
                        buttons: buttons,
                        cancelText: $translate.instant('mm.core.cancel'),
                        buttonClicked: function(index) {
                            if (buttons[index].isDownload) {
                                $mmCourseHelper.confirmAndPrefetchCourse(scope, scope.course);
                                return true;
                            } else if (angular.isFunction(buttons[index].action)) {
                                return buttons[index].action($event, scope.course);
                            }
                            return false;
                        },
                        cancel: function() {
                            return true;
                        }
                    });
                }).catch(function(error) {
                    $mmUtil.showErrorModalDefault(error, 'Error loading options');
                }).finally(function() {
                    scope.actionsLoaded = true;
                });
            };
            scope.$on('$destroy', function() {
                obsStatus && obsStatus.off && obsStatus.off();
            });
        }
    };
}]);

angular.module('mm.core.courses')
.controller('mmCoursesAvailableCtrl', ["$scope", "$mmCourses", "$q", "$mmUtil", "$mmSite", function($scope, $mmCourses, $q, $mmUtil, $mmSite) {
    function loadCourses() {
        var frontpageCourseId = $mmSite.getSiteHomeId();
        return $mmCourses.getCoursesByField().then(function(courses) {
            $scope.courses = courses.filter(function(course) {
                return course.id != frontpageCourseId;
            });
        }).catch(function(message) {
            $mmUtil.showErrorModalDefault(message, 'mm.courses.errorloadcourses', true);
            return $q.reject();
        });
    }
    loadCourses().finally(function() {
        $scope.coursesLoaded = true;
    });
    $scope.refreshCourses = function() {
        var promises = [];
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmCourses.invalidateCoursesByField());
        $q.all(promises).finally(function() {
            loadCourses().finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.core.courses')
.controller('mmCourseCategoriesCtrl', ["$scope", "$stateParams", "$mmCourses", "$mmUtil", "$q", "$mmSite", function($scope, $stateParams, $mmCourses, $mmUtil, $q, $mmSite) {
    var categoryId = $stateParams.categoryid || 0;
    function fetchCategories() {
        return $mmCourses.getCategories(categoryId, true).then(function(cats) {
            $scope.currentCategory = false;
            angular.forEach(cats, function(cat, index) {
                if (cat.id == categoryId) {
                    $scope.currentCategory = cat;
                    delete cats[index];
                }
            });
            cats.sort(function(a,b) {
                if (a.depth == b.depth) {
                    return (a.sortorder > b.sortorder) ? 1 : ((b.sortorder > a.sortorder) ? -1 : 0);
                }
                return a.depth > b.depth ? 1 : -1;
            });
            $scope.categories = $mmUtil.formatTree(cats, 'parent', 'id', categoryId);
            if ($scope.currentCategory) {
                $scope.title = $scope.currentCategory.name;
                return $mmCourses.getCoursesByField('category', categoryId).then(function(courses) {
                    $scope.courses = courses;
                }, function(error) {
                    $mmUtil.showErrorModalDefault(error, 'mm.courses.errorloadcourses', true);
                });
            }
        }, function(error) {
            $mmUtil.showErrorModalDefault(error, 'mm.courses.errorloadcategories', true);
        });
    }
    fetchCategories().finally(function() {
        $scope.categoriesLoaded = true;
    });
    $scope.refreshCategories = function() {
        var promises = [];
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmCourses.invalidateCategories(categoryId, true));
        promises.push($mmCourses.invalidateCoursesByField('category', categoryId));
        promises.push($mmSite.invalidateConfig());
        $q.all(promises).finally(function() {
            fetchCategories(true).finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.core.courses')
.controller('mmCoursesListCtrl', ["$scope", "$mmCourses", "$mmCoursesDelegate", "$mmUtil", "$mmEvents", "$mmSite", "$q", "mmCoursesEventMyCoursesUpdated", "mmCoreEventSiteUpdated", "$mmCourseHelper", function($scope, $mmCourses, $mmCoursesDelegate, $mmUtil, $mmEvents, $mmSite, $q,
            mmCoursesEventMyCoursesUpdated, mmCoreEventSiteUpdated, $mmCourseHelper) {
    var updateSiteObserver,
        myCoursesObserver,
        prefetchIconInitialized = false;
    $scope.searchEnabled = $mmCourses.isSearchCoursesAvailable() && !$mmCourses.isSearchCoursesDisabledInSite();
    $scope.filter = {};
    $scope.prefetchCoursesData = {};
    $scope.showFilter = false;
    function fetchCourses(refresh) {
        return $mmCourses.getUserCourses().then(function(courses) {
            $scope.filter.filterText = ''; 
            var courseIds = courses.map(function(course) {
                return course.id;
            });
            return $mmCourses.getCoursesOptions(courseIds).then(function(options) {
                angular.forEach(courses, function(course) {
                    course.progress = isNaN(parseInt(course.progress, 10)) ? false : parseInt(course.progress, 10);
                    course.navOptions = options.navOptions[course.id];
                    course.admOptions = options.admOptions[course.id];
                });
                $scope.courses = courses;
                initPrefetchCoursesIcon();
            });
        }, function(error) {
            $mmUtil.showErrorModalDefault(error, 'mm.courses.errorloadcourses', true);
        });
    }
    function initPrefetchCoursesIcon() {
        if (prefetchIconInitialized) {
            return;
        }
        prefetchIconInitialized = true;
        if (!$scope.courses || $scope.courses.length < 2) {
            $scope.prefetchCoursesData.icon = '';
            return;
        }
        $mmCourseHelper.determineCoursesStatus($scope.courses).then(function(status) {
            var icon = $mmCourseHelper.getCourseStatusIconFromStatus(status);
            if (icon == 'spinner') {
                icon = 'ion-ios-cloud-download-outline';
            }
            $scope.prefetchCoursesData.icon = icon;
        });
    }
    fetchCourses().finally(function() {
        $scope.coursesLoaded = true;
    });
    $scope.refreshCourses = function() {
        var promises = [];
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmCoursesDelegate.clearAndInvalidateCoursesOptions());
        $q.all(promises).finally(function() {
            prefetchIconInitialized = false;
            fetchCourses(true).finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
    $scope.switchFilter = function() {
        $scope.filter.filterText = '';
        $scope.showFilter = !$scope.showFilter;
    };
    $scope.downloadCourses = function() {
        var initialIcon = $scope.prefetchCoursesData.icon;
        $scope.prefetchCoursesData.icon = 'spinner';
        $scope.prefetchCoursesData.badge = '';
        return $mmCourseHelper.confirmAndPrefetchCourses($scope.courses).then(function(downloaded) {
            $scope.prefetchCoursesData.icon = downloaded ? 'ion-android-refresh' : initialIcon;
        }, function(error) {
            if (!$scope.$$destroyed) {
                $mmUtil.showErrorModalDefault(error, 'mm.course.errordownloadingcourse', true);
                $scope.prefetchCoursesData.icon = initialIcon;
            }
        }, function(progress) {
            $scope.prefetchCoursesData.badge = progress.count + ' / ' + progress.total;
        }).finally(function() {
            $scope.prefetchCoursesData.badge = '';
        });
    };
    myCoursesObserver = $mmEvents.on(mmCoursesEventMyCoursesUpdated, function(siteid) {
        if (siteid == $mmSite.getId()) {
            fetchCourses();
        }
    });
    updateSiteObserver = $mmEvents.on(mmCoreEventSiteUpdated, function(siteId) {
        if ($mmSite.getId() === siteId) {
            $scope.searchEnabled = $mmCourses.isSearchCoursesAvailable() && !$mmCourses.isSearchCoursesDisabledInSite();
        }
    });
    $scope.$on('$destroy', function() {
        myCoursesObserver && myCoursesObserver.off && myCoursesObserver.off();
        updateSiteObserver && updateSiteObserver.off && updateSiteObserver.off();
    });
}]);

angular.module('mm.core.courses')
.controller('mmCoursesSearchCtrl', ["$scope", "$mmCourses", "$q", "$mmUtil", function($scope, $mmCourses, $q, $mmUtil) {
    var page = 0,
    	currentSearch = '';
    $scope.searchText = '';
    function searchCourses(refresh) {
        if (refresh) {
            page = 0;
        }
        return $mmCourses.search(currentSearch, page).then(function(response) {
            if (page === 0) {
                $scope.courses = response.courses;
            } else {
                $scope.courses = $scope.courses.concat(response.courses);
            }
            $scope.total = response.total;
            page++;
            $scope.canLoadMore = $scope.courses.length < $scope.total;
        }).catch(function(message) {
            $scope.canLoadMore = false;
            $mmUtil.showErrorModalDefault(message, 'mm.courses.errorsearching', true);
            return $q.reject();
        });
    }
    $scope.search = function(text) {
        currentSearch = text;
        $scope.courses = undefined;
    	var modal = $mmUtil.showModalLoading('mm.core.searching', true);
    	searchCourses(true).finally(function() {
            modal.dismiss();
    	});
    };
    $scope.loadMoreResults = function() {
    	searchCourses();
    };
}]);

angular.module('mm.core.courses')
.controller('mmCoursesViewResultCtrl', ["$scope", "$stateParams", "$mmCourses", "$mmCoursesDelegate", "$mmUtil", "$translate", "$q", "$ionicModal", "$mmEvents", "$mmSite", "mmCoursesSearchComponent", "mmCoursesEnrolInvalidKey", "mmCoursesEventMyCoursesUpdated", "$timeout", "$mmFS", "$rootScope", "$mmApp", "$ionicPlatform", "$mmCourseHelper", "$mmCourse", "mmCoreEventCourseStatusChanged", function($scope, $stateParams, $mmCourses, $mmCoursesDelegate, $mmUtil, $translate, $q,
            $ionicModal, $mmEvents, $mmSite, mmCoursesSearchComponent, mmCoursesEnrolInvalidKey, mmCoursesEventMyCoursesUpdated,
            $timeout, $mmFS, $rootScope, $mmApp, $ionicPlatform, $mmCourseHelper, $mmCourse, mmCoreEventCourseStatusChanged) {
    var course = angular.copy($stateParams.course || {}), 
        selfEnrolWSAvailable = $mmCourses.isSelfEnrolmentEnabled(),
        guestWSAvailable = $mmCourses.isGuestWSAvailable(),
        isGuestEnabled = false,
        guestInstanceId,
        enrollmentMethods,
        waitStart = 0,
        enrolUrl = $mmFS.concatenatePaths($mmSite.getURL(), 'enrol/index.php?id=' + course.id),
        courseUrl = $mmFS.concatenatePaths($mmSite.getURL(), 'course/view.php?id=' + course.id),
        paypalReturnUrl = $mmFS.concatenatePaths($mmSite.getURL(), 'enrol/paypal/return.php'),
        inAppLoadListener,
        inAppFinishListener,
        inAppExitListener,
        appResumeListener,
        obsStatus;
    $scope.course = course;
    $scope.component = mmCoursesSearchComponent;
    $scope.handlersShouldBeShown = true;
    $scope.selfEnrolInstances = [];
    $scope.enroldata = {
        password: ''
    };
    $scope.loadingHandlers = function() {
        return $scope.handlersShouldBeShown && !$mmCoursesDelegate.areNavHandlersLoadedFor(course.id);
    };
    function getCourse(refresh) {
        var promise;
        if (selfEnrolWSAvailable || guestWSAvailable) {
            $scope.selfEnrolInstances = [];
            promise = $mmCourses.getCourseEnrolmentMethods(course.id).then(function(methods) {
                enrollmentMethods = methods;
                angular.forEach(enrollmentMethods, function(method) {
                    if (selfEnrolWSAvailable && method.type === 'self') {
                        $scope.selfEnrolInstances.push(method);
                    } else if (guestWSAvailable && method.type === 'guest') {
                        isGuestEnabled = true;
                    }
                });
            }).catch(function(error) {
                if (error) {
                    $mmUtil.showErrorModal(error);
                }
            });
        } else {
            promise = $q.when(); 
        }
        return promise.then(function() {
            return $mmCourses.getUserCourse(course.id).then(function(c) {
                $scope.isEnrolled = true;
                return c;
            }).catch(function() {
                $scope.isEnrolled = false;
                return $mmCourses.getCourse(course.id);
            }).then(function(c) {
                course.fullname = c.fullname || course.fullname;
                course.summary = c.summary || course.summary;
                return loadCourseNavHandlers(refresh, false);
            }).catch(function() {
                return canAccessAsGuest().then(function(passwordRequired) {
                    if (!passwordRequired) {
                        return loadCourseNavHandlers(refresh, true);
                    } else {
                        course._handlers = [];
                        $scope.handlersShouldBeShown = false;
                    }
                }).catch(function() {
                    course._handlers = [];
                    $scope.handlersShouldBeShown = false;
                });
            });
        }).finally(function() {
            $scope.courseLoaded = true;
        });
    }
    function canAccessAsGuest() {
        if (!isGuestEnabled) {
            return $q.reject();
        }
        angular.forEach(enrollmentMethods, function(method) {
            if (method.type == 'guest') {
                guestInstanceId = method.id;
            }
        });
        if (guestInstanceId) {
            return $mmCourses.getCourseGuestEnrolmentInfo(guestInstanceId).then(function(info) {
                if (!info.status) {
                    return $q.reject();
                }
                return info.passwordrequired;
            });
        }
        return $q.reject();
    }
    function loadCourseNavHandlers(refresh, guest) {
        return $mmCoursesDelegate.getNavHandlersToDisplay(course, refresh, guest, true).then(function(handlers) {
            course._handlers = handlers;
            $scope.handlersShouldBeShown = true;
        });
    }
    function refreshData() {
        var promises = [];
        promises.push($mmCourses.invalidateUserCourses());
        promises.push($mmCourses.invalidateCourse(course.id));
        promises.push($mmCourses.invalidateCourseEnrolmentMethods(course.id));
        promises.push($mmCoursesDelegate.clearAndInvalidateCoursesOptions(course.id));
        if (guestInstanceId) {
            promises.push($mmCourses.invalidateCourseGuestEnrolmentInfo(guestInstanceId));
        }
        return $q.all(promises).finally(function() {
            return getCourse(true);
        });
    }
    getCourse().finally(function() {
        $scope.prefetchCourseIcon = 'spinner';
        $mmCourseHelper.getCourseStatusIcon(course.id).then(function(icon) {
            $scope.prefetchCourseIcon = icon;
            if (icon == 'spinner') {
                var promise = $mmCourseHelper.getCourseDownloadPromise(course.id);
                if (promise) {
                    promise.catch(function(error) {
                        if (!scope.$$destroyed) {
                            $mmUtil.showErrorModalDefault(error, 'mm.course.errordownloadingcourse', true);
                        }
                    });
                } else {
                    $mmCourse.setCoursePreviousStatus(courseId);
                }
            }
        });
    });
    $scope.doRefresh = function() {
        refreshData().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
    $scope.prefetchCourse = function() {
        $mmCourseHelper.confirmAndPrefetchCourse($scope, course, undefined, course._handlers);
    };
    obsStatus = $mmEvents.on(mmCoreEventCourseStatusChanged, function(data) {
        if (data.siteId == $mmSite.getId() && data.courseId == course.id) {
            $scope.prefetchCourseIcon = $mmCourseHelper.getCourseStatusIconFromStatus(data.status);
        }
    });
    if (selfEnrolWSAvailable && course.enrollmentmethods && course.enrollmentmethods.indexOf('self') > -1) {
        $ionicModal.fromTemplateUrl('core/components/courses/templates/password-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function(modal) {
            $scope.modal = modal;
            $scope.closeModal = function() {
                $scope.enroldata.password = '';
                delete $scope.currentEnrolInstance;
                return modal.hide();
            };
            $scope.$on('$destroy', function() {
                modal.remove();
            });
        });
        $scope.enrol = function(instanceId, password) {
            var promise;
            if ($scope.modal.isShown()) {
                promise = $q.when();
            } else {
                promise = $mmUtil.showConfirm($translate('mm.courses.confirmselfenrol'));
            }
            promise.then(function() {
                var modal = $mmUtil.showModalLoading('mm.core.loading', true);
                $mmCourses.selfEnrol(course.id, password, instanceId).then(function() {
                    $scope.isEnrolled = true;
                    $scope.courseLoaded = false;
                    $scope.closeModal().then(function() {
                        return waitForEnrolled(true);
                    }).then(function() {
                        refreshData().finally(function() {
                            $mmEvents.trigger(mmCoursesEventMyCoursesUpdated, $mmSite.getId());
                        });
                    });
                }).catch(function(error) {
                    if (error) {
                        if (error.code === mmCoursesEnrolInvalidKey) {
                            if ($scope.modal.isShown()) {
                                $mmUtil.showErrorModal(error.message);
                            } else {
                                $scope.currentEnrolInstance = instanceId;
                                $scope.modal.show();
                            }
                        } else if (typeof error == 'string') {
                            $mmUtil.showErrorModal(error);
                        }
                    } else {
                        $mmUtil.showErrorModal('mm.courses.errorselfenrol', true);
                    }
                }).finally(function() {
                    modal.dismiss();
                });
            });
        };
        function waitForEnrolled(init) {
            if (init) {
                waitStart = Date.now();
            }
            return $mmCourses.invalidateUserCourses().catch(function() {
            }).then(function() {
                return $mmCourses.getUserCourse(course.id);
            }).catch(function() {
                if ($scope.$$destroyed || (Date.now() - waitStart > 60000)) {
                    return;
                }
                return $timeout(function() {
                    return waitForEnrolled();
                }, 5000);
            });
        }
    }
    if (course.enrollmentmethods && course.enrollmentmethods.indexOf('paypal') > -1) {
        $scope.paypalEnabled = true;
        $scope.paypalEnrol = function() {
            var hasReturnedFromPaypal = false;
            stopListeners();
            $mmSite.openInAppWithAutoLogin(enrolUrl);
            inAppLoadListener = $rootScope.$on('$cordovaInAppBrowser:loadstart', urlLoaded);
            if (!$mmApp.isDevice()) {
                inAppFinishListener = $rootScope.$on('$cordovaInAppBrowser:loadstop', urlLoaded);
                appResumeListener = $ionicPlatform.on('resume', function() {
                    if (!$scope.courseLoaded) {
                        return;
                    }
                    $scope.courseLoaded = false;
                    refreshData();
                });
            }
            inAppExitListener = $rootScope.$on('$cordovaInAppBrowser:exit', inAppClosed);
            function stopListeners() {
                inAppLoadListener && inAppLoadListener();
                inAppFinishListener && inAppFinishListener();
                inAppExitListener && inAppExitListener();
                appResumeListener && appResumeListener();
            }
            function urlLoaded(e, event) {
                if (event.url.indexOf(paypalReturnUrl) != -1) {
                    hasReturnedFromPaypal = true;
                } else if (event.url.indexOf(courseUrl) != -1 && hasReturnedFromPaypal) {
                    inAppClosed();
                    $mmUtil.closeInAppBrowser();
                }
            }
            function inAppClosed() {
                stopListeners();
                if (!$scope.courseLoaded) {
                    return;
                }
                $scope.courseLoaded = false;
                refreshData();
            }
        };
    }
    $scope.$on('$destroy', function() {
        obsStatus && obsStatus.off && obsStatus.off();
    });
}]);

angular.module('mm.core.courses')
.factory('$mmCourses', ["$q", "$mmSite", "$log", "$mmSitesManager", "mmCoursesSearchPerPage", "mmCoursesEnrolInvalidKey", function($q, $mmSite, $log, $mmSitesManager, mmCoursesSearchPerPage, mmCoursesEnrolInvalidKey) {
    $log = $log.getInstance('$mmCourses');
    var self = {},
        currentCourses = {};
    self.getCategories = function(categoryId, addSubcategories, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var criteriaKey = categoryId == 0 ? 'parent' : 'id';
            var data = {
                    criteria: [
                        { key: criteriaKey, value: categoryId }
                    ],
                    addsubcategories: addSubcategories ? 1 : 0
                },
                preSets = {
                    cacheKey: getCategoriesCacheKey(categoryId, addSubcategories)
                };
            return site.read('core_course_get_categories', data, preSets);
        });
    };
    function getCategoriesCacheKey(categoryId, addSubcategories) {
        return 'mmCourses:categories:' + categoryId + ':' + addSubcategories;
    }
    function getCourseIdsForOptions(courseIds, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var siteHomeId = site.getSiteHomeId();
            if (courseIds.length == 1) {
                return self.getUserCourses(true, siteId).then(function(courses) {
                    var courseId = courseIds[0],
                        useAllCourses = false;
                    if (courseId == siteHomeId) {
                        useAllCourses = true;
                    } else {
                        for (var i = 0; i < courses.length; i++) {
                            if (courses[i].id == courseId) {
                                useAllCourses = true;
                                break;
                            }
                        }
                    }
                    if (useAllCourses) {
                        courseIds = courses.map(function(course) {
                            return course.id;
                        });
                        courseIds.push(siteHomeId);
                    }
                    return courseIds;
                }).catch(function() {
                    return courseIds;
                });
            } else {
                return courseIds;
            }
        });
    }
    self.isGetCategoriesAvailable = function() {
        return $mmSite.wsAvailable('core_course_get_categories');
    };
    self.isMyCoursesDisabled = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return self.isMyCoursesDisabledInSite(site);
        });
    };
    self.isMyCoursesDisabledInSite = function(site) {
        site = site || $mmSite;
        return site.isFeatureDisabled('$mmSideMenuDelegate_mmCourses');
    };
    self.isSearchCoursesDisabled = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return self.isSearchCoursesDisabledInSite(site);
        });
    };
    self.isSearchCoursesDisabledInSite = function(site) {
        site = site || $mmSite;
        return site.isFeatureDisabled('$mmCoursesDelegate_search');
    };
    self.clearCurrentCourses = function() {
        currentCourses = {};
    };
    self.getCourse = function(id, siteid) {
        return self.getCourses([id], siteid).then(function(courses) {
            if (courses && courses.length > 0) {
                return courses[0];
            }
            return $q.reject();
        });
    };
    self.getCourseEnrolmentMethods = function(id) {
        var params = {
                courseid: id
            },
            preSets = {
                cacheKey: getCourseEnrolmentMethodsCacheKey(id)
            };
        return $mmSite.read('core_enrol_get_course_enrolment_methods', params, preSets);
    };
    function getCourseEnrolmentMethodsCacheKey(id) {
        return 'mmCourses:enrolmentmethods:' + id;
    }
    self.getCourseGuestEnrolmentInfo = function(instanceId) {
        var params = {
                instanceid: instanceId
            },
            preSets = {
                cacheKey: getCourseGuestEnrolmentInfoCacheKey(instanceId)
            };
        return $mmSite.read('enrol_guest_get_instance_info', params, preSets).then(function(response) {
            return response.instanceinfo;
        });
    };
    function getCourseGuestEnrolmentInfoCacheKey(instanceId) {
        return 'mmCourses:guestinfo:' + instanceId;
    }
    self.getCourses = function(ids, siteid) {
        if (!angular.isArray(ids)) {
            return $q.reject();
        } else if (ids.length === 0) {
            return $q.when([]);
        }
        return $mmSitesManager.getSite(siteid).then(function(site) {
            var data = {
                    options: {
                        ids: ids
                    }
                },
                preSets = {
                    cacheKey: getCoursesCacheKey(ids)
                };
            return site.read('core_course_get_courses', data, preSets).then(function(courses) {
                if (typeof courses != 'object' && !angular.isArray(courses)) {
                    return $q.reject();
                }
                return courses;
            });
        });
    };
    function getCoursesCacheKey(ids) {
        return 'mmCourses:course:' + JSON.stringify(ids);
    }
    self.getCoursesByField = function(field, value, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var data = {
                    field: field || "",
                    value: field ? value : ""
                },
                preSets = {
                    cacheKey: getCoursesByFieldCacheKey(field, value)
                };
            return site.read('core_course_get_courses_by_field', data, preSets).then(function(courses) {
                if (courses.courses) {
                    return courses.courses.sort(function(a, b) {
                        if (typeof a.sortorder == "undefined" && typeof b.sortorder == "undefined") {
                            return b.id - a.id;
                        }
                        if (typeof a.sortorder == "undefined") {
                            return 1;
                        }
                        if (typeof b.sortorder == "undefined") {
                            return -1;
                        }
                        return a.sortorder - b.sortorder;
                    });
                }
                return $q.reject();
            });
        });
    };
    function getCoursesByFieldCacheKey(field, value) {
        field = field || "";
        value = field ? value : "";
        return 'mmCourses:coursesbyfield:' + field + ":" + value;
    }
    self.isGetCoursesByFieldAvailable = function() {
        return $mmSite.wsAvailable('core_course_get_courses_by_field');
    };
    self.getStoredCourse = function(id) {
        $log.warn('The function \'getStoredCourse\' is deprecated. Please use \'getUserCourse\' instead');
        return currentCourses[id];
    };
    self.getCoursesOptions = function(courseIds, siteId) {
        var promises = [],
            navOptions,
            admOptions;
        return getCourseIdsForOptions(courseIds, siteId).then(function(courseIds) {
            promises.push(self.getUserNavigationOptions(courseIds, siteId).catch(function() {
                return {};
            }).then(function(options) {
                navOptions = options;
            }));
            promises.push(self.getUserAdministrationOptions(courseIds, siteId).catch(function() {
                return {};
            }).then(function(options) {
                admOptions = options;
            }));
            return $q.all(promises).then(function() {
                return {navOptions: navOptions, admOptions: admOptions};
            });
        });
    };
    function getUserAdministrationOptionsCommonCacheKey() {
        return 'mmCourses:administrationOptions:';
    }
    function getUserAdministrationOptionsCacheKey(courseIds) {
        return getUserAdministrationOptionsCommonCacheKey() + courseIds.join(',');
    }
    self.getUserAdministrationOptions = function(courseIds, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                    courseids: courseIds
                },
                preSets = {
                    cacheKey: getUserAdministrationOptionsCacheKey(courseIds)
                };
            return site.read('core_course_get_user_administration_options', params, preSets).then(function(response) {
                return formatUserOptions(response.courses);
            });
        });
    };
    self.getUserCourse = function(id, preferCache, siteid) {
        if (!id) {
            return $q.reject();
        }
        if (typeof preferCache == 'undefined') {
            preferCache = false;
        }
        return self.getUserCourses(preferCache, siteid).then(function(courses) {
            var course;
            angular.forEach(courses, function(c) {
                if (c.id == id) {
                    course = c;
                }
            });
            return course ? course : $q.reject();
        });
    };
    self.getUserCourses = function(preferCache, siteid) {
        if (typeof preferCache == 'undefined') {
            preferCache = false;
        }
        return $mmSitesManager.getSite(siteid).then(function(site) {
            var userid = site.getUserId(),
                presets = {
                    cacheKey: getUserCoursesCacheKey(),
                    omitExpires: preferCache
                },
                data = {userid: userid};
            if (typeof userid === 'undefined') {
                return $q.reject();
            }
            return site.read('core_enrol_get_users_courses', data, presets).then(function(courses) {
                siteid = siteid || site.getId();
                if (siteid === $mmSite.getId()) {
                    storeCoursesInMemory(courses);
                }
                return courses;
            });
        });
    };
    function getUserCoursesCacheKey() {
        return 'mmCourses:usercourses';
    }
    function getUserNavigationOptionsCommonCacheKey() {
        return 'mmCourses:navigationOptions:';
    }
    function getUserNavigationOptionsCacheKey(courseIds) {
        return getUserNavigationOptionsCommonCacheKey() + courseIds.join(',');
    }
    self.getUserNavigationOptions = function(courseIds, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var params = {
                    courseids: courseIds
                },
                preSets = {
                    cacheKey: getUserNavigationOptionsCacheKey(courseIds)
                };
            return site.read('core_course_get_user_navigation_options', params, preSets).then(function(response) {
                return formatUserOptions(response.courses);
            });
        });
    };
    function formatUserOptions(courses) {
        var result = {};
        angular.forEach(courses, function(course) {
            var options = {};
            angular.forEach(course.options, function(option) {
                options[option.name] = option.available;
            });
            result[course.id] = options;
        });
        return result;
    }
    self.invalidateCategories = function(categoryId, addSubcategories, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getCategoriesCacheKey(categoryId, addSubcategories));
        });
    };
    self.invalidateCourse = function(id, siteId) {
        return self.invalidateCourses([id], siteId);
    };
    self.invalidateCourseEnrolmentMethods = function(id) {
        return $mmSite.invalidateWsCacheForKey(getCourseEnrolmentMethodsCacheKey(id));
    };
    self.invalidateCourseGuestEnrolmentInfo = function(instanceId) {
        return $mmSite.invalidateWsCacheForKey(getCourseGuestEnrolmentInfoCacheKey(instanceId));
    };
    self.invalidateCoursesOptions = function(courseIds, siteId) {
        return getCourseIdsForOptions(courseIds, siteId).then(function(ids) {
            var promises = [];
            promises.push(self.invalidateUserAdministrationOptionsForCourses(ids, siteId));
            promises.push(self.invalidateUserNavigationOptionsForCourses(ids, siteId));
            return $q.all(promises);
        });
    };
    self.invalidateCourses = function(ids, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getCoursesCacheKey(ids));
        });
    };
    self.invalidateCoursesByField = function(field, value, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getCoursesByFieldCacheKey(field, value));
        });
    };
    self.invalidateUserAdministrationOptions = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKeyStartingWith(getUserAdministrationOptionsCommonCacheKey());
        });
    };
    self.invalidateUserAdministrationOptionsForCourses = function(courseIds, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getUserAdministrationOptionsCacheKey(courseIds));
        });
    };
    self.invalidateUserCourses = function(siteid) {
        return $mmSitesManager.getSite(siteid).then(function(site) {
            return site.invalidateWsCacheForKey(getUserCoursesCacheKey());
        });
    };
    self.invalidateUserNavigationOptions = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKeyStartingWith(getUserNavigationOptionsCommonCacheKey());
        });
    };
    self.invalidateUserNavigationOptionsForCourses = function(courseIds, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getUserNavigationOptionsCacheKey(courseIds));
        });
    };
    self.isGuestWSAvailable = function() {
        return $mmSite.wsAvailable('enrol_guest_get_instance_info');
    };
    self.isSearchCoursesAvailable = function() {
        return $mmSite.wsAvailable('core_course_search_courses');
    };
    self.isSelfEnrolmentEnabled = function() {
        return $mmSite.wsAvailable('enrol_self_enrol_user');
    };
    self.search = function(text, page, perpage) {
        page = page || 0;
        perpage = perpage || mmCoursesSearchPerPage;
        var params = {
                criterianame: 'search',
                criteriavalue: text,
                page: page,
                perpage: perpage
            }, preSets = {
                getFromCache: false
            };
        return $mmSite.read('core_course_search_courses', params, preSets).then(function(response) {
            if (typeof response == 'object') {
                return {total: response.total, courses: response.courses};
            }
            return $q.reject();
        });
    };
    self.selfEnrol = function(courseid, password, instanceId) {
        if (typeof password == 'undefined') {
            password = '';
        }
        var params = {
            courseid: courseid,
            password: password
        };
        if (instanceId) {
            params.instanceid = instanceId;
        }
        return $mmSite.write('enrol_self_enrol_user', params).then(function(response) {
            if (response) {
                if (response.status) {
                    return true;
                } else if (response.warnings && response.warnings.length) {
                    var message;
                    angular.forEach(response.warnings, function(warning) {
                        if (warning.warningcode == '2' || warning.warningcode == '3' || warning.warningcode == '4') {
                            message = warning.message;
                        }
                    });
                    if (message) {
                        return $q.reject({code: mmCoursesEnrolInvalidKey, message: message});
                    }
                }
            }
            return $q.reject();
        });
    };
    function storeCoursesInMemory(courses) {
        angular.forEach(courses, function(course) {
            currentCourses[course.id] = angular.copy(course); 
        });
    }
    return self;
}]);

angular.module('mm.core.courses')
.provider('$mmCoursesDelegate', function() {
    var navHandlers = {},
        self = {};
    self.registerNavHandler = function(addon, handler, priority) {
        if (typeof navHandlers[addon] !== 'undefined') {
            console.log("$mmCoursesDelegateProvider: Addon '" + navHandlers[addon].addon + "' already registered as navigation handler");
            return false;
        }
        console.log("$mmCoursesDelegateProvider: Registered addon '" + addon + "' as navibation handler.");
        navHandlers[addon] = {
            addon: addon,
            handler: handler,
            instance: undefined,
            priority: priority
        };
        return true;
    };
    self.$get = ["$mmUtil", "$q", "$log", "$mmSite", "mmCoursesAccessMethods", "$mmCourses", "$mmEvents", "mmCoursesEventMyCoursesRefreshed", function($mmUtil, $q, $log, $mmSite, mmCoursesAccessMethods, $mmCourses, $mmEvents,
            mmCoursesEventMyCoursesRefreshed) {
        var enabledNavHandlers = {},
            coursesHandlers = {},
            self = {},
            loaded = {},
            lastUpdateHandlersStart,
            lastUpdateHandlersForCoursesStart = {};
        $log = $log.getInstance('$mmCoursesDelegate');
        self.areNavHandlersLoadedFor = function(courseId) {
            return loaded[courseId];
        };
        self.clearCoursesHandlers = function(courseId) {
            if (courseId) {
                coursesHandlers[courseId] = false;
                loaded[courseId] = false;
            } else {
                coursesHandlers = {};
                loaded = {};
            }
        };
        self.clearAndInvalidateCoursesOptions = function(courseId) {
            var promises = [];
            $mmEvents.trigger(mmCoursesEventMyCoursesRefreshed);
            if (courseId) {
                promises.push($mmCourses.invalidateCoursesOptions([courseId]));
                promises.push(self.invalidateCourseHandlers(courseId));
            } else {
                promises.push($mmCourses.invalidateUserNavigationOptions());
                promises.push($mmCourses.invalidateUserAdministrationOptions());
                for (var cId in coursesHandlers) {
                    promises.push(self.invalidateCourseHandlers(cId));
                }
            }
            self.clearCoursesHandlers(courseId);
            return $q.all(promises);
        };
        function getNavHandlersForAccess(courseId, refresh, accessData, navOptions, admOptions, waitForPromise) {
            courseId = parseInt(courseId, 10);
            if (coursesHandlers[courseId] && coursesHandlers[courseId].deferred &&
                    coursesHandlers[courseId].deferred.promise.$$state &&
                    coursesHandlers[courseId].deferred.promise.$$state.status === 0) {
                refresh = false;
            }
            if (refresh || !coursesHandlers[courseId] || coursesHandlers[courseId].access.type != accessData.type) {
                coursesHandlers[courseId] = {
                    access: accessData,
                    navOptions: navOptions,
                    admOptions: admOptions,
                    enabledHandlers: [],
                    deferred: $q.defer()
                };
                self.updateNavHandlersForCourse(courseId, accessData, navOptions, admOptions);
            }
            if (waitForPromise) {
                return coursesHandlers[courseId].deferred.promise.then(function() {
                    return coursesHandlers[courseId].enabledHandlers;
                });
            }
            return coursesHandlers[courseId].enabledHandlers;
        }
        self.getNavHandlersFor = function(courseId, refresh, navOptions, admOptions, waitForPromise) {
            var accessData = {
                type: mmCoursesAccessMethods.default
            };
            return getNavHandlersForAccess(courseId, refresh, accessData, navOptions, admOptions, waitForPromise);
        };
        self.getNavHandlersForCourse = function(course, refresh, waitForPromise) {
            return loadCourseOptions(course, refresh).then(function() {
                return self.getNavHandlersFor(course.id, refresh, course.navOptions, course.admOptions, waitForPromise);
            });
        };
        self.getNavHandlersForGuest = function(courseId, refresh, navOptions, admOptions, waitForPromise) {
            var accessData = {
                type: mmCoursesAccessMethods.guest
            };
            return getNavHandlersForAccess(courseId, refresh, accessData, navOptions, admOptions, waitForPromise);
        };
        self.getNavHandlersToDisplay = function(course, refresh, isGuest, waitForPromise, navOptions, admOptions) {
            course.id = parseInt(course.id, 10);
            var accessData = {
                type: isGuest ? mmCoursesAccessMethods.guest : mmCoursesAccessMethods.default
            };
            if (navOptions) {
                course.navOptions = navOptions;
            }
            if (admOptions) {
                course.admOptions = admOptions;
            }
            return loadCourseOptions(course, refresh).then(function() {
                return getNavHandlersForAccess(course.id, refresh, accessData, course.navOptions, course.admOptions, waitForPromise);
            }).then(function() {
                var handlersToDisplay = [],
                    promises = [],
                    promise;
                angular.forEach(coursesHandlers[course.id].enabledHandlers, function(handler) {
                    if (handler.instance.shouldDisplayForCourse) {
                        promise = $q.when(handler.instance.shouldDisplayForCourse(
                                course.id, accessData, course.navOptions, course.admOptions));
                    } else {
                        promise = $q.when(true);
                    }
                    promises.push(promise.then(function(enabled) {
                        if (enabled) {
                            handlersToDisplay.push({
                                controller: handler.instance.getController(course.id),
                                priority: handler.priority,
                                prefetch: handler.instance.prefetch
                            });
                        }
                    }));
                });
                return $mmUtil.allPromises(promises).then(function() {
                    return handlersToDisplay;
                });
            });
        };
        self.invalidateCourseHandlers = function(courseId) {
            var promises = [],
                courseData = coursesHandlers[courseId];
            if (!courseData) {
                return $q.when();
            }
            angular.forEach(courseData.enabledHandlers, function(handler) {
                if (handler && handler.instance && handler.instance.invalidateEnabledForCourse) {
                    promises.push($q.when(
                            handler.instance.invalidateEnabledForCourse(courseId, courseData.navOptions, courseData.admOptions)));
                }
            });
            return $mmUtil.allPromises(promises);
        };
        self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
        self.isLastUpdateCourseCall = function(courseId, time) {
            if (!lastUpdateHandlersForCoursesStart[courseId]) {
                return true;
            }
            return time == lastUpdateHandlersForCoursesStart[courseId];
        };
        function loadCourseOptions(course, refresh) {
            var promise;
            if (typeof course.navOptions == "undefined" || typeof course.admOptions == "undefined" || refresh) {
                promise = $mmCourses.getCoursesOptions([course.id]).then(function(options) {
                    course.navOptions = options.navOptions[course.id];
                    course.admOptions = options.admOptions[course.id];
                });
            } else {
                promise = $q.when();
            }
            return promise;
        }
        self.updateNavHandler = function(addon, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else if ($mmSite.isFeatureDisabled('$mmCoursesDelegate_' + addon)) {
                promise = $q.when(false);
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledNavHandlers[addon] = {
                            instance: handlerInfo.instance,
                            priority: handlerInfo.priority
                        };
                    } else {
                        delete enabledNavHandlers[addon];
                    }
                }
            });
        };
        self.updateNavHandlers = function() {
            var promises = [],
                siteId = $mmSite.getId(),
                now = new Date().getTime();
            $log.debug('Updating navigation handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(navHandlers, function(handlerInfo, addon) {
                promises.push(self.updateNavHandler(addon, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            }).finally(function() {
                if (self.isLastUpdateCall(now) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    angular.forEach(coursesHandlers, function(handler, courseId) {
                        self.updateNavHandlersForCourse(parseInt(courseId), handler.access, handler.navOptions, handler.admOptions);
                    });
                }
            });
        };
        self.updateNavHandlersForCourse = function(courseId, accessData, navOptions, admOptions) {
            var promises = [],
                enabledForCourse = [],
                siteId = $mmSite.getId(),
                now = new Date().getTime();
            lastUpdateHandlersForCoursesStart[courseId] = now;
            angular.forEach(enabledNavHandlers, function(handler, name) {
                var promise = $q.when(handler.instance.isEnabledForCourse(courseId, accessData, navOptions, admOptions))
                        .then(function(enabled) {
                    if (enabled) {
                        enabledForCourse.push(handler);
                    } else {
                        return $q.reject();
                    }
                }).catch(function() {
                });
                promises.push(promise);
            });
            return $q.all(promises).then(function() {
                return true;
            }).catch(function() {
                return true;
            }).finally(function() {
                if (self.isLastUpdateCourseCall(courseId, now) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    $mmUtil.emptyArray(coursesHandlers[courseId].enabledHandlers);
                    angular.forEach(enabledForCourse, function(handler) {
                        coursesHandlers[courseId].enabledHandlers.push(handler);
                    });
                    loaded[courseId] = true;
                    coursesHandlers[courseId].deferred.resolve();
                }
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.courses')
.factory('$mmCoursesHandlers', ["$mmSite", "$state", "$mmCourses", "$q", "$mmUtil", "$translate", "$timeout", "$mmCourse", "$mmSitesManager", "mmCoursesEnrolInvalidKey", "$mmContentLinkHandlerFactory", "$mmAddonManager", function($mmSite, $state, $mmCourses, $q, $mmUtil, $translate, $timeout, $mmCourse, $mmSitesManager,
            mmCoursesEnrolInvalidKey, $mmContentLinkHandlerFactory, $mmAddonManager) {
    var self = {};
    self.coursesLinksHandler = $mmContentLinkHandlerFactory.createChild(
                /\/course\/?(index\.php.*)?$/, '$mmSideMenuDelegate_mmCourses');
    self.coursesLinksHandler.getActions = function(siteIds, url, params, courseId) {
        return [{
            action: function(siteId) {
                var state = 'site.mm_courses', 
                    stateParams = {};
                if ($mmCourses.isGetCoursesByFieldAvailable()) {
                    if (params.categoryid && $mmCourses.isGetCategoriesAvailable()) {
                        state = 'site.mm_coursescategories';
                        stateParams.categoryid = parseInt(params.categoryid, 10);
                    } else {
                        state = 'site.mm_availablecourses';
                    }
                }
                $state.go('redirect', {
                    siteid: siteId || $mmSite.getId(),
                    state: state,
                    params: stateParams
                });
            }
        }];
    };
    self.courseLinksHandler = $mmContentLinkHandlerFactory.createChild(
                /((\/enrol\/index\.php)|(\/course\/enrol\.php)|(\/course\/view\.php)).*([\?\&]id=\d+)/);
    self.courseLinksHandler.isEnabled = function(siteId, url, params, courseId) {
        courseId = parseInt(params.id, 10);
        if (!courseId) {
            return false;
        }
        return $mmSitesManager.getSiteHomeId(siteId).then(function(siteHomeId) {
           return courseId != siteHomeId;
       });
    };
    self.courseLinksHandler.getActions = function(siteIds, url, params, courseId) {
        courseId = parseInt(params.id, 10);
        var sectionId = params.sectionid ? parseInt(params.sectionid, 10) : null,
            sectionNumber = typeof params.section != 'undefined' ? parseInt(params.section, 10) : NaN,
            stateParams = {
                courseid: courseId,
                sid: sectionId || null
            };
        if (!isNaN(sectionNumber)) {
            stateParams.sectionnumber = sectionNumber;
        }
        return [{
            action: function(siteId) {
                siteId = siteId || $mmSite.getId();
                if (siteId == $mmSite.getId()) {
                    actionEnrol(courseId, url, stateParams);
                } else {
                    $state.go('redirect', {
                        siteid: siteId,
                        state: 'site.mm_course',
                        params: stateParams
                    });
                }
            }
        }];
    };
    function actionEnrol(courseId, url, stateParams) {
        var modal = $mmUtil.showModalLoading(),
            isEnrolUrl = !!url.match(/(\/enrol\/index\.php)|(\/course\/enrol\.php)/);
        $mmCourses.getUserCourse(courseId).catch(function() {
            return canSelfEnrol(courseId).then(function() {
                var promise;
                modal.dismiss();
                promise = isEnrolUrl ? $q.when() : $mmUtil.showConfirm($translate('mm.courses.confirmselfenrol'));
                return promise.then(function() {
                    return selfEnrol(courseId).catch(function(error) {
                        if (typeof error == 'string') {
                            $mmUtil.showErrorModal(error);
                        }
                        return $q.reject();
                    });
                }, function() {
                    return $mmCourse.getSections(courseId, false, true);
                });
            }, function(error) {
                return $mmCourse.getSections(courseId, false, true).catch(function() {
                    modal.dismiss();
                    if (typeof error != 'string') {
                        error = $translate.instant('mm.courses.notenroled');
                    }
                    var body = $translate('mm.core.twoparagraphs',
                                    {p1: error, p2: $translate.instant('mm.core.confirmopeninbrowser')});
                    $mmUtil.showConfirm(body).then(function() {
                        $mmSite.openInBrowserWithAutoLogin(url);
                    });
                    return $q.reject();
                });
            });
        }).then(function() {
            modal.dismiss();
            $state.go('redirect', {
                siteid: $mmSite.getId(),
                state: 'site.mm_course',
                params: stateParams
            });
        });
    }
    function canSelfEnrol(courseId) {
        if (!$mmCourses.isSelfEnrolmentEnabled()) {
            return $q.reject();
        }
        return $mmCourses.getCourseEnrolmentMethods(courseId).then(function(methods) {
            var isSelfEnrolEnabled = false,
                instances = 0;
            angular.forEach(methods, function(method) {
                if (method.type == 'self' && method.status) {
                    isSelfEnrolEnabled = true;
                    instances++;
                }
            });
            if (!isSelfEnrolEnabled || instances != 1) {
                return $q.reject();
            }
        });
    }
    function selfEnrol(courseId, password) {
        var modal = $mmUtil.showModalLoading();
        return $mmCourses.selfEnrol(courseId, password).then(function() {
            return $mmCourses.invalidateUserCourses().catch(function() {
            }).then(function() {
                return $timeout(function() {}, 4000).finally(function() {
                    modal.dismiss();
                });
            });
        }).catch(function(error) {
            modal.dismiss();
            if (error && error.code === mmCoursesEnrolInvalidKey) {
                var title = $translate.instant('mm.courses.selfenrolment'),
                    body = ' ', 
                    placeholder = $translate.instant('mm.courses.password');
                if (typeof password != 'undefined') {
                    $mmUtil.showErrorModal(error.message);
                }
                return $mmUtil.showPrompt(body, title, placeholder).then(function(password) {
                    return selfEnrol(courseId, password);
                });
            } else {
                return $q.reject(error);
            }
        });
    }
    self.dashboardLinksHandler = $mmContentLinkHandlerFactory.createChild(
                /\/my\/?$/, '$mmSideMenuDelegate_mmCourses');
    self.dashboardLinksHandler.getActions = function(siteIds, url, params, courseId) {
        return [{
            action: function(siteId) {
                $state.go('redirect', {
                    siteid: siteId || $mmSite.getId(),
                    state: 'site.mm_courses'
                });
            }
        }];
    };
    self.sideMenuNav = function() {
        var self = {};
        self.isEnabled = function() {
            var myCoursesDisabled = $mmCourses.isMyCoursesDisabledInSite();
            var $mmaMyOverview = $mmAddonManager.get('$mmaMyOverview');
            if ($mmaMyOverview) {
                return $mmaMyOverview.isSideMenuAvailable().then(function(enabled) {
                    if (enabled) {
                        return false;
                    }
                    return !myCoursesDisabled;
                });
            }
            return !myCoursesDisabled;
        };
        self.getController = function() {
            return function($scope) {
                $scope.icon = 'ion-ionic';
                $scope.title = 'mm.courses.mycourses';
                $scope.state = 'site.mm_courses';
                $scope.class = 'mm-mycourses-handler';
            };
        };
        return self;
    };
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorClipboard', ["$log", "$q", "$mmApp", "$cordovaClipboard", function($log, $q, $mmApp, $cordovaClipboard) {
    $log = $log.getInstance('$mmEmulatorClipboard');
    var self = {};
    self.load = function() {
        var isDesktop = $mmApp.isDesktop(),
            clipboard,
            copyTextarea;
        if (isDesktop) {
            clipboard = require('electron').clipboard;
        } else {
            copyTextarea = document.createElement('textarea');
            angular.element(copyTextarea).addClass('mm-browser-copy-area');
            copyTextarea.setAttribute('aria-hidden', 'true');
            document.body.append(copyTextarea);
        }
        $cordovaClipboard.copy = function(text) {
            var deferred = $q.defer();
            if (isDesktop) {
                clipboard.writeText(text);
                deferred.resolve();
            } else {
                copyTextarea.innerHTML = text;
                copyTextarea.select();
                try {
                    if (document.execCommand('copy')) {
                        deferred.resolve();
                    } else {
                        deferred.reject();
                    }
                } catch (err) {
                    deferred.reject();
                }
                copyTextarea.innerHTML = '';
            }
            return deferred.promise;
        };
        $cordovaClipboard.paste = function() {
            var deferred = $q.defer();
            if (isDesktop) {
                deferred.resolve(clipboard.readText());
            } else {
                copyTextarea.innerHTML = '';
                copyTextarea.select();
                try {
                    if (document.execCommand('paste')) {
                        deferred.resolve(copyTextarea.innerHTML);
                    } else {
                        deferred.reject();
                    }
                } catch (err) {
                    deferred.reject();
                }
                copyTextarea.innerHTML = '';
            }
            return deferred.promise;
        };
        return $q.when();
    };
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorCustomURLScheme', ["$log", "$q", "$mmApp", function($log, $q, $mmApp) {
    $log = $log.getInstance('$mmEmulatorCustomURLScheme');
    var self = {};
    self.load = function() {
        if (!$mmApp.isDesktop()) {
            return $q.when();
        }
        require('electron').ipcRenderer.on('mmAppLaunched', function(event, url) {
            window.handleOpenURL && window.handleOpenURL(url);
        });
        return $q.when();
    };
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorManager', ["$log", "$q", "$mmFS", "$mmEmulatorClipboard", "$mmEmulatorCustomURLScheme", "$mmEmulatorFile", "$mmEmulatorFileTransfer", "$mmEmulatorGlobalization", "$mmEmulatorInAppBrowser", "$mmEmulatorLocalNotifications", "$mmEmulatorPushNotifications", "$mmEmulatorZip", "$mmUtil", "$mmEmulatorMediaCapture", "$mmEmulatorNetwork", "$ionicPlatform", "$mmApp", function($log, $q, $mmFS, $mmEmulatorClipboard, $mmEmulatorCustomURLScheme, $mmEmulatorFile,
            $mmEmulatorFileTransfer, $mmEmulatorGlobalization, $mmEmulatorInAppBrowser, $mmEmulatorLocalNotifications,
            $mmEmulatorPushNotifications, $mmEmulatorZip, $mmUtil, $mmEmulatorMediaCapture, $mmEmulatorNetwork,
            $ionicPlatform, $mmApp) {
    $log = $log.getInstance('$mmEmulatorManager');
    var self = {};
    self.loadHTMLAPI = function() {
        if ($mmFS.isAvailable()) {
            $log.debug('Stop loading HTML API, it was already loaded or the environment doesn\'t need it.');
            return $q.when();
        }
        $log.debug('Loading HTML API.');
        var promises = [];
        promises.push($mmEmulatorClipboard.load());
        promises.push($mmEmulatorCustomURLScheme.load());
        promises.push($mmEmulatorFile.load());
        promises.push($mmEmulatorFileTransfer.load());
        promises.push($mmEmulatorGlobalization.load());
        promises.push($mmEmulatorInAppBrowser.load());
        promises.push($mmEmulatorLocalNotifications.load());
        promises.push($mmEmulatorMediaCapture.load());
        promises.push($mmEmulatorPushNotifications.load());
        promises.push($mmEmulatorZip.load());
        promises.push($mmEmulatorNetwork.load());
        if ($mmApp.isDesktop()) {
            require('electron').ipcRenderer.on('mmAppFocused', function() {
                document.dispatchEvent(new Event('resume'));
            });
        }
        return $mmUtil.allPromises(promises);
    };
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorFile', ["$log", "$q", "$mmFS", "$window", "$mmApp", "mmCoreConfigConstants", function($log, $q, $mmFS, $window, $mmApp, mmCoreConfigConstants) {
    $log = $log.getInstance('$mmEmulatorFile');
    var self = {};
    function deleteEmptyFolder(fs, path, successCallback, errorCallback) {
        fs.rmdir(path, function(err) {
            if (err) {
                errorCallback && errorCallback(err);
            } else {
                successCallback && successCallback();
            }
        });
    }
    function deleteRecursive(fs, path, successCallback, errorCallback) {
        fs.stat(path, function(err, stats) {
            if (err) {
                errorCallback && errorCallback(err);
            } else if (stats.isFile()) {
                fs.unlink(path, function(err) {
                    if (err) {
                        errorCallback && errorCallback(err);
                    } else {
                        successCallback && successCallback();
                    }
                });
            } else {
                fs.readdir(path, function(err, files) {
                    if (err) {
                        errorCallback && errorCallback(err);
                    } else if (!files.length) {
                        deleteEmptyFolder(fs, path, successCallback, errorCallback);
                    } else {
                        var removed = 0;
                        files.forEach(function(filename) {
                            deleteRecursive(fs, $mmFS.concatenatePaths(path, filename), function() {
                                removed++;
                                if (removed == files.length) {
                                    deleteEmptyFolder(fs, path, successCallback, errorCallback);
                                }
                            }, errorCallback);
                        });
                    }
                });
            }
        });
    }
    function emulateCordovaFileForDesktop(fs) {
        if (!$mmApp.isDesktop()) {
            return;
        }
        emulateEntry(fs);
        emulateFileWriter(fs);
        emulateDirectoryReader(fs);
        emulateFileEntry(fs);
        emulateDirectoryEntry(fs);
        $window.resolveLocalFileSystemURL = function(path, successCallback, errorCallback) {
            fs.stat(path, function(err, stats) {
                if (err) {
                    errorCallback && errorCallback(err);
                } else {
                    var constructorFn = stats.isDirectory() ? DirectoryEntry : FileEntry,
                        fileAndDir = $mmFS.getFileAndDirectoryFromPath(path);
                    successCallback && successCallback(new constructorFn(fileAndDir.name, path));
                }
            });
        };
    }
    function emulateDirectoryEntry(fs) {
        $window.DirectoryEntry = function(name, fullPath, fileSystem, nativeURL) {
            if ((fullPath) && !/\/$/.test(fullPath)) {
                fullPath += '/';
            }
            if (nativeURL && !/\/$/.test(nativeURL)) {
                nativeURL += '/';
            }
            $window.Entry.call(this, false, true, name, fullPath, fileSystem, nativeURL);
        };
        $window.DirectoryEntry.prototype = Object.create($window.Entry.prototype); 
        $window.DirectoryEntry.prototype.createReader = function() {
            return new DirectoryReader(this.fullPath);
        };
        $window.DirectoryEntry.prototype.getDirectory = function(path, options, successCallback, errorCallback) {
            getDirOrFile(fs, this, true, path, options, successCallback, errorCallback);
        };
        $window.DirectoryEntry.prototype.removeRecursively = function(successCallback, errorCallback) {
            var deferred = $q.defer();
            deferred.promise.then(function() {
                successCallback && successCallback();
            }).catch(function(error) {
                errorCallback && errorCallback(error);
            });
            deleteRecursive(fs, this.fullPath, deferred.resolve, deferred.reject);
        };
        $window.DirectoryEntry.prototype.getFile = function(path, options, successCallback, errorCallback) {
            getDirOrFile(fs, this, false, path, options, successCallback, errorCallback);
        };
    }
    function emulateDirectoryReader(fs) {
        $window.DirectoryReader = function(localURL) {
            this.localURL = localURL || null;
        };
        $window.DirectoryReader.prototype.readEntries = function(successCallback, errorCallback) {
            var that = this;
            fs.readdir(this.localURL, function(err, files) {
                if (err) {
                    errorCallback && errorCallback(err);
                } else {
                    try {
                        var entries = [];
                        for (var i = 0; i < files.length; i++) {
                            var fileName = files[i],
                                filePath = $mmFS.concatenatePaths(that.localURL, fileName),
                                stats = fs.statSync(filePath); 
                            if (stats.isDirectory()) {
                                entries.push(new DirectoryEntry(fileName, filePath));
                            } else if (stats.isFile()) {
                                entries.push(new FileEntry(fileName, filePath));
                            }
                        }
                        successCallback && successCallback(entries);
                    } catch(ex) {
                        errorCallback && errorCallback(ex);
                    }
                }
            });
        };
    }
    function emulateEntry(fs) {
        $window.Entry = function(isFile, isDirectory, name, fullPath, fileSystem, nativeURL) {
            this.isFile = !!isFile;
            this.isDirectory = !!isDirectory;
            this.name = name || '';
            this.fullPath = fullPath || '';
            this.filesystem = fileSystem || null;
            this.nativeURL = nativeURL || null;
        };
        $window.Entry.prototype.getMetadata = function(successCallback, errorCallback) {
            fs.stat(this.fullPath, function(err, stats) {
                if (err) {
                    errorCallback && errorCallback(err);
                } else {
                    successCallback && successCallback({
                        size: stats.size,
                        modificationTime: stats.mtime
                    });
                }
            });
        };
        $window.Entry.prototype.setMetadata = function(successCallback, errorCallback, metadataObject) {
            errorCallback && errorCallback('Not supported');
        };
        $window.Entry.prototype.moveTo = function(parent, newName, successCallback, errorCallback) {
            newName = newName || this.name;
            var srcPath = this.fullPath,
                destPath = $mmFS.concatenatePaths(parent.fullPath, newName),
                that = this;
            fs.rename(srcPath, destPath, function(err) {
                if (err) {
                    errorCallback && errorCallback(err);
                } else {
                    var constructorFn = that.isDirectory ? DirectoryEntry : FileEntry;
                    successCallback && successCallback(new constructorFn(newName, destPath));
                }
            });
        };
        $window.Entry.prototype.copyTo = function(parent, newName, successCallback, errorCallback) {
            newName = newName || this.name;
            var srcPath = this.fullPath,
                destPath = $mmFS.concatenatePaths(parent.fullPath, newName),
                reader = fs.createReadStream(srcPath),
                writer = fs.createWriteStream(destPath),
                deferred = $q.defer(), 
                that = this;
            deferred.promise.then(function() {
                var constructorFn = that.isDirectory ? DirectoryEntry : FileEntry;
                successCallback && successCallback(new constructorFn(newName, destPath));
            }).catch(function(error) {
                errorCallback && errorCallback(error);
            });
            reader.on('error', deferred.reject);
            writer.on('error', deferred.reject);
            writer.on('close', deferred.resolve);
            reader.pipe(writer);
        };
        $window.Entry.prototype.toInternalURL = function() {
            return 'file://' + this.fullPath;
        };
        $window.Entry.prototype.toURL = function() {
            return this.fullPath;
        };
        $window.Entry.prototype.remove = function(successCallback, errorCallback) {
            var removeFn = this.isDirectory ? fs.rmdir : fs.unlink;
            removeFn(this.fullPath, function(err) {
                if (err < 0) {
                    errorCallback && errorCallback(err);
                } else {
                    successCallback && successCallback();
                }
            });
        };
        $window.Entry.prototype.getParent = function(successCallback, errorCallback) {
            var fullPath = this.fullPath.slice(-1) == '/' ? this.fullPath.slice(0, -1) : this.fullPath,
                parentPath = fullPath.substr(0, fullPath.lastIndexOf('/'));
            fs.stat(parentPath, function(err, stats) {
                if (err || !stats.isDirectory()) {
                    errorCallback && errorCallback(err);
                } else {
                    var fileAndDir = $mmFS.getFileAndDirectoryFromPath(parentPath);
                    successCallback && successCallback(new DirectoryEntry(fileAndDir.name, parentPath));
                }
            });
        };
    }
    function emulateFileEntry(fs) {
        $window.FileEntry = function(name, fullPath, fileSystem, nativeURL) {
            if (fullPath && /\/$/.test(fullPath)) {
                fullPath = fullPath.substring(0, fullPath.length - 1);
            }
            if (nativeURL && /\/$/.test(nativeURL)) {
                nativeURL = nativeURL.substring(0, nativeURL.length - 1);
            }
            $window.Entry.call(this, true, false, name, fullPath, fileSystem, nativeURL);
        };
        $window.FileEntry.prototype = Object.create($window.Entry.prototype); 
        $window.FileEntry.prototype.createWriter = function(successCallback, errorCallback) {
            this.file(function(file) {
                successCallback && successCallback(new FileWriter(file));
            }, errorCallback);
        };
        $window.FileEntry.prototype.file = function(successCallback, errorCallback) {
            var that = this;
            this.getMetadata(function(metadata) {
                fs.readFile(that.fullPath, function(err, data) {
                    if (err) {
                        errorCallback && errorCallback(err);
                    } else {
                        data = Uint8Array.from(data).buffer; 
                        var file = new File([data], that.name || '', {
                            lastModified: metadata.modificationTime || null,
                            type: $mmFS.getMimeType($mmFS.getFileExtension(that.name)) || null
                        });
                        file.localURL = that.fullPath;
                        file.start = 0;
                        file.end = file.size;
                        successCallback && successCallback(file);
                    }
                });
            }, errorCallback);
        };
    }
    function emulateFileWriter(fs) {
        $window.FileWriter = function(file) {
            this.fileName = '';
            this.length = 0;
            if (file) {
                this.localURL = file.localURL || file;
                this.length = file.size || 0;
            }
            this.position = 0; 
            this.readyState = 0; 
            this.result = null;
            this.error = null;
            this.onwritestart = null;   
            this.onprogress = null;     
            this.onwrite = null;        
            this.onwriteend = null;     
            this.onabort = null;        
            this.onerror = null;        
        };
        $window.FileWriter.prototype.write = function(data) {
            var that = this;
            if (data && data.toString() == '[object Blob]') {
                var reader = new FileReader();
                reader.onload = function() {
                    if (reader.readyState == 2) {
                        write(new Buffer(reader.result));
                    }
                };
                reader.readAsArrayBuffer(data);
            } else if (data && data.toString() == '[object ArrayBuffer]') {
                write(Buffer.from(new Uint8Array(data)));
            } else {
                write(data);
            }
            function write(data) {
                fs.writeFile(that.localURL, data, function(err) {
                    if (err) {
                        that.onerror && that.onerror(err);
                    } else {
                        that.onwrite && that.onwrite();
                    }
                    that.onwriteend && that.onwriteend();
                });
                that.onwritestart && that.onwritestart();
            }
        };
    }
    function getDirOrFile(fs, entry, isDir, path, options, successCallback, errorCallback) {
        var filename = $mmFS.getFileAndDirectoryFromPath(path).name,
            fileDirPath = $mmFS.concatenatePaths(entry.fullPath, path);
        fs.stat(fileDirPath, function(err) {
            if (err) {
                if (options.create) {
                    create(function(error2) {
                        if (!error2) {
                            success();
                        } else if (error2.code === 'EEXIST') {
                            success();
                        } else if (error2.code === 'ENOENT') {
                            var parent = fileDirPath.substring(0, fileDirPath.lastIndexOf('/'));
                            if (parent) {
                                entry.getDirectory(parent, options, function() {
                                    create(function(error3) {
                                        if (!error3) {
                                            success();
                                        } else {
                                            errorCallback && errorCallback(error3);
                                        }
                                    });
                                }, errorCallback);
                            } else {
                                errorCallback && errorCallback(error2);
                            }
                        } else {
                            errorCallback && errorCallback(error2);
                        }
                    });
                } else {
                    errorCallback && errorCallback(err);
                }
            } else {
                success();
            }
        });
        function success() {
            var constructorFn = isDir ? DirectoryEntry : FileEntry;
            successCallback && successCallback(new constructorFn(filename, fileDirPath));
        }
        function create(done) {
            if (isDir) {
                fs.mkdir(fileDirPath, done);
            } else {
                fs.writeFile(fileDirPath, '', done);
            }
        }
    }
    self.load = function() {
        var deferred = $q.defer(),
            basePath;
        $window.requestFileSystem  = $window.requestFileSystem || $window.webkitRequestFileSystem;
        $window.resolveLocalFileSystemURL = $window.resolveLocalFileSystemURL || $window.webkitResolveLocalFileSystemURL;
        $window.LocalFileSystem = {
            PERSISTENT: 1
        };
        if ($mmApp.isDesktop()) {
            var fs = require('fs'),
                app = require('electron').remote.app;
            emulateCordovaFileForDesktop(fs);
            basePath = app.getPath('documents') || app.getPath('home');
            if (!basePath) {
                deferred.reject('Cannot calculate base path for file system.');
                return;
            }
            basePath = $mmFS.concatenatePaths(basePath.replace(/\\/g, '/'), mmCoreConfigConstants.app_id) + '/';
            fs.mkdir(basePath, function(e) {
                if (!e || (e && e.code === 'EEXIST')) {
                    $mmFS.setHTMLBasePath(basePath);
                    deferred.resolve();
                } else {
                    deferred.reject('Error creating base path.');
                }
            });
        } else {
            $window.webkitStorageInfo.requestQuota(PERSISTENT, 500 * 1024 * 1024, function(granted) {
                $window.requestFileSystem(PERSISTENT, granted, function(entry) {
                    basePath = entry.root.toURL();
                    $mmFS.setHTMLBasePath(basePath);
                    deferred.resolve();
                }, deferred.reject);
            }, deferred.reject);
        }
        return deferred.promise;
    };
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorFileTransfer', ["$log", "$q", "$mmFS", "$window", "$mmApp", function($log, $q, $mmFS, $window, $mmApp) {
    $log = $log.getInstance('$mmEmulatorFileTransfer');
    var self = {},
        fileTransferIdCounter = 0;
    function getBasicAuthHeader(urlString) {
        var header =  null;
        if (window.btoa) {
            var credentials = getUrlCredentials(urlString);
            if (credentials) {
                var authHeader = 'Authorization';
                var authHeaderValue = 'Basic ' + window.btoa(credentials);
                header = {
                    name : authHeader,
                    value : authHeaderValue
                };
            }
        }
        return header;
    }
    function getUrlCredentials(urlString) {
        var credentialsPattern = /^https?\:\/\/(?:(?:(([^:@\/]*)(?::([^@\/]*))?)?@)?([^:\/?#]*)(?::(\d*))?).*$/,
            credentials = credentialsPattern.exec(urlString);
        return credentials && credentials[1];
    }
    self.load = function() {
        $window.FileTransferError = function(code, source, target, status, body, exception) {
            this.code = code || null;
            this.source = source || null;
            this.target = target || null;
            this.http_status = status || null;
            this.body = body || null;
            this.exception = exception || null;
        };
        $window.FileTransferError.FILE_NOT_FOUND_ERR = 1;
        $window.FileTransferError.INVALID_URL_ERR = 2;
        $window.FileTransferError.CONNECTION_ERR = 3;
        $window.FileTransferError.ABORT_ERR = 4;
        $window.FileTransferError.NOT_MODIFIED_ERR = 5;
        $window.FileTransfer = function() {
            this._id = ++fileTransferIdCounter;
            this.onprogress = null; 
        };
        $window.FileTransfer.prototype.download = function(source, target, successCallback, errorCallback, trustAllHosts, options) {
            var basicAuthHeader = getBasicAuthHeader(source),
                xhr = new XMLHttpRequest(),
                isDesktop = $mmApp.isDesktop(),
                deferred = $q.defer(), 
                headers = null;
            deferred.promise.then(function(entry) {
                successCallback && successCallback(entry);
            }).catch(function(error) {
                errorCallback && errorCallback(error);
            });
            this.xhr = xhr;
            this.deferred = deferred;
            this.source = source;
            this.target = target;
            if (basicAuthHeader) {
                source = source.replace(getUrlCredentials(source) + '@', '');
                options = options || {};
                options.headers = options.headers || {};
                options.headers[basicAuthHeader.name] = basicAuthHeader.value;
            }
            if (options) {
                headers = options.headers || null;
            }
            xhr.open('GET', source, true);
            xhr.responseType = isDesktop ? 'arraybuffer' : 'blob';
            angular.forEach(headers, function(value, name) {
                xhr.setRequestHeader(name, value);
            });
            if (this.onprogress) {
                xhr.onprogress = this.onprogress;
            }
            xhr.onerror = function() {
                deferred.reject(new FileTransferError(-1, source, target, xhr.status, xhr.statusText));
            };
            xhr.onload = function() {
                var response = xhr.response;
                if (!response) {
                    deferred.reject();
                } else {
                    var basePath = $mmFS.getBasePathInstant();
                    target = target.replace(basePath, ''); 
                    target = target.replace(/%20/g, ' '); 
                    if (isDesktop) {
                        response = Buffer.from(new Uint8Array(response));
                    }
                    $mmFS.writeFile(target, response).then(deferred.resolve, deferred.reject);
                }
            };
            xhr.send();
        };
        $window.FileTransfer.prototype.upload = function(filePath, server, successCallback, errorCallback, options, trustAllHosts) {
            var fileKey = null,
                fileName = null,
                mimeType = null,
                params = null,
                headers = null,
                httpMethod = null,
                deferred = $q.defer(), 
                basicAuthHeader = getBasicAuthHeader(server),
                that = this;
            deferred.promise.then(function(result) {
                successCallback && successCallback(result);
            }).catch(function(error) {
                errorCallback && errorCallback(error);
            });
            if (basicAuthHeader) {
                server = server.replace(getUrlCredentials(server) + '@', '');
                options = options || {};
                options.headers = options.headers || {};
                options.headers[basicAuthHeader.name] = basicAuthHeader.value;
            }
            if (options) {
                fileKey = options.fileKey;
                fileName = options.fileName;
                mimeType = options.mimeType;
                headers = options.headers;
                httpMethod = options.httpMethod || 'POST';
                if (httpMethod.toUpperCase() == "PUT"){
                    httpMethod = 'PUT';
                } else {
                    httpMethod = 'POST';
                }
                if (options.params) {
                    params = options.params;
                } else {
                    params = {};
                }
            }
            headers = headers || {};
            if (!headers['Content-Disposition']) {
                headers['Content-Disposition'] = 'form-data;' + (fileKey ? ' name="' + fileKey + '";' : '') +
                    (fileName ? ' filename="' + fileName + '"' : '')
            }
            delete headers['Content-Type'];
            $mmFS.getFile(filePath).then(function(fileEntry) {
                return $mmFS.getFileObjectFromFileEntry(fileEntry);
            }).then(function(file) {
                var xhr = new XMLHttpRequest();
                xhr.open(httpMethod || 'POST', server);
                angular.forEach(headers, function(value, name) {
                    if (name != 'Connection') {
                        xhr.setRequestHeader(name, value);
                    }
                });
                if (that.onprogress) {
                    xhr.onprogress = that.onprogress;
                }
                that.xhr = xhr;
                that.deferred = deferred;
                this.source = filePath;
                this.target = server;
                xhr.onerror = function() {
                    deferred.reject(new FileTransferError(-1, filePath, server, xhr.status, xhr.statusText));
                };
                xhr.onload = function() {
                    deferred.resolve({
                        bytesSent: file.size,
                        responseCode: xhr.status,
                        response: xhr.response,
                        objectId: ''
                    });
                };
                var fd = new FormData();
                angular.forEach(params, function(value, name) {
                    fd.append(name, value);
                });
                fd.append('file', file);
                xhr.send(fd);
            }).catch(deferred.reject);
        };
        $window.FileTransfer.prototype.abort = function() {
            if (this.xhr) {
                this.xhr.abort();
                this.deferred.reject(new FileTransferError(FileTransferError.ABORT_ERR, this.source, this.target));
            }
        };
        return $q.when();
    };
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorGlobalization', ["$log", "$q", "$window", "$mmApp", function($log, $q, $window, $mmApp) {
    $log = $log.getInstance('$mmEmulatorGlobalization');
    var self = {};
    function getLocale() {
        var navLang = navigator.userLanguage || navigator.language;
        try {
            if ($mmApp.isDesktop()) {
                var locale = require('electron').remote.app.getLocale();
                return locale || navLang;
            } else {
                return navLang;
            }
        } catch(ex) {
            return navLang;
        }
    }
    self.load = function() {
        $window.GlobalizationError = function(code, message) {
            this.code = code || null;
            this.message = message || '';
        };
        $window.GlobalizationError.UNKNOWN_ERROR = 0;
        $window.GlobalizationError.FORMATTING_ERROR = 1;
        $window.GlobalizationError.PARSING_ERROR = 2;
        $window.GlobalizationError.PATTERN_ERROR = 3;
        navigator.globalization = {
            getLocaleName: function(successCallback, errorCallback) {
                var locale = getLocale();
                if (locale) {
                    successCallback && successCallback({value: locale});
                } else {
                    var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Cannot get language');
                    errorCallback && errorCallback(error);
                }
            },
            numberToString: function(number, successCallback, errorCallback, options) {
                var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Not supported.');
                errorCallback && errorCallback(error);
            },
            isDayLightSavingsTime: function(date, successCallback, errorCallback) {
                var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Not supported.');
                errorCallback && errorCallback(error);
            },
            getFirstDayOfWeek: function(successCallback, errorCallback) {
                var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Not supported.');
                errorCallback && errorCallback(error);
            },
            getDateNames: function (successCallback, errorCallback, options) {
                var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Not supported.');
                errorCallback && errorCallback(error);
            },
            getDatePattern: function(successCallback, errorCallback, options) {
                var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Not supported.');
                errorCallback && errorCallback(error);
            },
            getNumberPattern: function(successCallback, errorCallback, options) {
                var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Not supported.');
                errorCallback && errorCallback(error);
            },
            getCurrencyPattern: function(currencyCode, successCallback, errorCallback) {
                var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Not supported.');
                errorCallback && errorCallback(error);
            },
            stringToDate: function(dateString, successCallback, errorCallback, options) {
                var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Not supported.');
                errorCallback && errorCallback(error);
            },
            stringToNumber: function(numberString, successCallback, errorCallback, options) {
                var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Not supported.');
                errorCallback && errorCallback(error);
            },
            dateToString: function(date, successCallback, errorCallback, options) {
                var error = new GlobalizationError(GlobalizationError.UNKNOWN_ERROR, 'Not supported.');
                errorCallback && errorCallback(error);
            },
        };
        navigator.globalization.getPreferredLanguage = navigator.globalization.getLocaleName;
        return $q.when();
    };
    return self;
}]);

angular.module('mm.core.emulator')
.constant('mmCoreEmulatorLastReceivedNotificationStore', 'mm_emulator_last_received_notification')
.config(["$mmSitesFactoryProvider", "mmCoreEmulatorLastReceivedNotificationStore", function($mmSitesFactoryProvider, mmCoreEmulatorLastReceivedNotificationStore) {
    var stores = [
        {
            name: mmCoreEmulatorLastReceivedNotificationStore,
            keyPath: 'component' 
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.factory('$mmEmulatorHelper', ["$log", "$mmSitesManager", "$mmApp", "$q", "$mmLocalNotifications", "$mmUtil", "mmCoreSecondsDay", "mmCoreEmulatorLastReceivedNotificationStore", function($log, $mmSitesManager, $mmApp, $q, $mmLocalNotifications, $mmUtil, mmCoreSecondsDay,
            mmCoreEmulatorLastReceivedNotificationStore) {
    $log = $log.getInstance('$mmEmulatorHelper');
    var self = {};
    self.checkNewNotifications = function(component, fetchFn, getDataFn, siteId) {
        if (!$mmApp.isDesktop() || !$mmLocalNotifications.isAvailable()) {
            return $q.when();
        }
        if (!$mmApp.isOnline()) {
            $log.debug('Cannot check push notifications because device is offline.');
            return $q.reject();
        }
        var promise;
        if (!siteId) {
            promise = $mmSitesManager.getSitesIds();
        } else {
            promise = $q.when([siteId]);
        }
        return promise.then(function(siteIds) {
            var sitePromises = [];
            angular.forEach(siteIds, function(siteId) {
                sitePromises.push(checkNewNotificationsForSite(component, fetchFn, getDataFn, siteId));
            });
            return $q.all(sitePromises);
        });
    };
    function checkNewNotificationsForSite(component, fetchFn, getDataFn, siteId) {
        return self.getLastReceivedNotification(component, siteId).then(function(lastNotification) {
            return fetchFn(siteId).then(function(notifications) {
                if (!lastNotification || !notifications.length) {
                    return;
                }
                var notification = notifications[0];
                if (notification.id == lastNotification.id || notification.timecreated <= lastNotification.timecreated ||
                        $mmUtil.timestamp() - notification.timecreated > mmCoreSecondsDay) {
                    return;
                }
                return $q.when(getDataFn(notification)).then(function(titleAndText) {
                    var localNotif = {
                            id: 1,
                            at: new Date(),
                            title: titleAndText.title,
                            text: titleAndText.text,
                            data: {
                                notif: notification,
                                site: siteId
                            }
                        };
                    $mmLocalNotifications.schedule(localNotif, component, siteId);
                });
            });
        });
    }
    self.getLastReceivedNotification = function(component, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().get(mmCoreEmulatorLastReceivedNotificationStore, component);
        }).catch(function() {
            return false;
        });
    };
    self.isLinux = function() {
        try {
            var os = require('os');
            return os.platform().indexOf('linux') === 0;
        } catch(ex) {
            return false;
        }
    };
    self.isMac = function() {
        try {
            var os = require('os');
            return os.platform().indexOf('darwin') === 0;
        } catch(ex) {
            return false;
        }
    };
    self.isWindows = function() {
        try {
            var os = require('os');
            return os.platform().indexOf('win') === 0;
        } catch(ex) {
            return false;
        }
    };
    self.storeLastReceivedNotification = function(component, notification, siteId) {
        if (!notification) {
            notification = {id: -1, timecreated: 0};
        }
        notification.component = component;
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().insert(mmCoreEmulatorLastReceivedNotificationStore, notification);
        });
    };
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorInAppBrowser', ["$log", "$q", "$mmFS", "$window", "$mmApp", "$timeout", "$mmEmulatorHelper", "$mmUtil", function($log, $q, $mmFS, $window, $mmApp, $timeout, $mmEmulatorHelper, $mmUtil) {
    $log = $log.getInstance('$mmEmulatorInAppBrowser');
    var self = {};
    function getLaunchUrl(webContents, retry) {
        retry = retry || 0;
        var jsCode = 'var el = document.querySelector("#launchapp"); el && el.href;',
            deferred = $q.defer(),
            found = false;
        webContents.executeJavaScript(jsCode).then(function(launchUrl) {
            found = true;
            deferred.resolve(launchUrl);
        });
        $timeout(function() {
            if (found) {
            } else if (retry > 5) {
                deferred.reject();
            } else {
                getLaunchUrl(webContents, retry + 1).then(deferred.resolve, deferred.reject);
            }
        }, 300);
        return deferred.promise;
    }
    self.load = function() {
        if (!$mmApp.isDesktop()) {
            return $q.when();
        }
        var BrowserWindow = require('electron').remote.BrowserWindow,
            screen = require('electron').screen;
        $window.open = function(url, frameName, features) {
            var width = 800,
                height = 600,
                display,
                newWindow,
                listeners = {},
                isLinux = $mmEmulatorHelper.isLinux(),
                isSSO = !!(url && url.match(/\/launch\.php\?service=.+&passport=/));
            if (screen) {
                display = screen.getPrimaryDisplay();
                if (display && display.workArea) {
                    width = display.workArea.width || width;
                    height = display.workArea.height || height;
                }
            }
            newWindow = new BrowserWindow({
                width: width,
                height: height
            });
            newWindow.loadURL(url);
            if (isLinux && isSSO) {
                var userAgent = 'Mozilla/5.0 (iPad) AppleWebKit/603.3.8 (KHTML, like Gecko) Mobile/14G60';
                newWindow.webContents.setUserAgent(userAgent);
            }
            newWindow.addEventListener = function(name, callback) {
                var that = this;
                listeners[callback] = [received];
                switch (name) {
                    case 'loadstart':
                        that.webContents.addListener('did-start-loading', received);
                        if (isLinux && isSSO) {
                            listeners[callback].push(finishLoad);
                            that.webContents.addListener('did-finish-load', finishLoad);
                            function finishLoad(event) {
                                if ($mmUtil.removeUrlParams(url) == $mmUtil.removeUrlParams(that.getURL())) {
                                    getLaunchUrl(that.webContents).then(function(launchUrl) {
                                        if (launchUrl) {
                                            received(event, launchUrl);
                                        }
                                    });
                                }
                            }
                        }
                        break;
                    case 'loadstop':
                        that.webContents.addListener('did-finish-load', received);
                        break;
                    case 'loaderror':
                        that.webContents.addListener('did-fail-load', received);
                        break;
                    case 'exit':
                        that.addListener('close', received);
                        break;
                }
                function received(event, url) {
                    try {
                        event.url = url || that.getURL();
                        callback(event);
                    } catch(ex) {}
                }
            };
            newWindow.removeEventListener = function(name, callback) {
                var that = this,
                    cbListeners = listeners[callback];
                if (!cbListeners || !cbListeners.length) {
                    return;
                }
                switch (name) {
                    case 'loadstart':
                        that.webContents.removeListener('did-start-loading', cbListeners[0]);
                        if (cbListeners.length > 1) {
                            that.webContents.removeListener('did-finish-load', cbListeners[1]);
                        }
                        break;
                    case 'loadstop':
                        that.webContents.removeListener('did-finish-load', cbListeners[0]);
                        break;
                    case 'loaderror':
                        that.webContents.removeListener('did-fail-load', cbListeners[0]);
                        break;
                    case 'exit':
                        that.removeListener('close', cbListeners[0]);
                        break;
                }
            };
            newWindow.executeScript = function(details, callback) {
                var that = this;
                if (details.code) {
                    that.webContents.executeJavaScript(details.code, false, callback);
                } else if (details.file) {
                    $mmFS.readFile(details.file).then(function(code) {
                        that.webContents.executeJavaScript(code, false, callback);
                    }).catch(callback);
                } else {
                    callback('executeScript requires exactly one of code or file to be specified');
                }
            };
            newWindow.insertCSS = function(details, callback) {
                var that = this;
                if (details.code) {
                    that.webContents.insertCSS(details.code);
                    callback();
                } else if (details.file) {
                    $mmFS.readFile(details.file).then(function(code) {
                        that.webContents.insertCSS(code);
                        callback();
                    }).catch(callback);
                } else {
                    callback('insertCSS requires exactly one of code or file to be specified');
                }
            };
            return newWindow;
        };
        return $q.when();
    };
    return self;
}]);

angular.module('mm.core.emulator')
.constant('mmCoreDesktopLocalNotificationsStore', 'desktop_local_notifications')
.config(["$mmAppProvider", "mmCoreDesktopLocalNotificationsStore", function($mmAppProvider, mmCoreDesktopLocalNotificationsStore) {
    var stores = [
        {
            name: mmCoreDesktopLocalNotificationsStore, 
            keyPath: 'id',
            indexes: [
                {
                    name: 'triggered'
                }
            ]
        }
    ];
    $mmAppProvider.registerStores(stores);
}])
.factory('$mmEmulatorLocalNotifications', ["$log", "$q", "$mmApp", "$mmUtil", "$timeout", "$interval", "$rootScope", "$cordovaLocalNotification", "mmCoreDesktopLocalNotificationsStore", "mmCoreSecondsYear", "mmCoreSecondsDay", "mmCoreSecondsHour", "mmCoreSecondsMinute", "$mmEmulatorHelper", "mmCoreConfigConstants", function($log, $q, $mmApp, $mmUtil, $timeout, $interval, $rootScope,
            $cordovaLocalNotification, mmCoreDesktopLocalNotificationsStore, mmCoreSecondsYear, mmCoreSecondsDay,
            mmCoreSecondsHour, mmCoreSecondsMinute, $mmEmulatorHelper, mmCoreConfigConstants) {
    $log = $log.getInstance('$mmEmulatorLocalNotifications');
    var self = {},
        scheduled = {},
        triggered = {},
        defaults = {
            text:  '',
            title: '',
            sound: '',
            badge: 0,
            id:    0,
            data:  undefined,
            every: undefined,
            at:    undefined
        },
        winNotif, 
        toastTemplate = '<toast><visual><binding template="ToastText02"><text id="1" hint-wrap="true">%s</text>' +
                        '<text id="2" hint-wrap="true">%s</text></binding></visual></toast>', 
        tileBindingTemplate =   '<text hint-style="base" hint-wrap="true">%s</text>' +
                                '<text hint-style="captionSubtle" hint-wrap="true">%s</text>',
        tileTemplate = '<tile><visual branding="nameAndLogo">' +
                            '<binding template="TileMedium">' + tileBindingTemplate + '</binding>' +
                            '<binding template="TileWide">' + tileBindingTemplate + '</binding>' +
                            '<binding template="TileLarge">' + tileBindingTemplate + '</binding>' +
                        '</visual></tile>'; 
    function cancelNotification(id, omitEvent, eventName) {
        var notification = scheduled[id].notification;
        $timeout.cancel(scheduled[id].timeout);
        $interval.cancel(scheduled[id].interval);
        delete scheduled[id];
        delete triggered[id];
        removeNotification(id);
        if (!omitEvent) {
            $rootScope.$broadcast(eventName, notification, 'foreground');
        }
    }
    function convertIds(ids) {
        var convertedIds = [];
        for (var i = 0; i < ids.length; i++) {
            convertedIds.push(Number(ids[i]));
        }
        return convertedIds;
    }
    function convertProperties(options) {
        if (options.id) {
            if (isNaN(options.id)) {
                options.id = defaults.id;
                $log.warn('Id is not a number: ' + options.id);
            } else {
                options.id = Number(options.id);
            }
        }
        if (options.title) {
            options.title = options.title.toString();
        }
        if (options.text) {
            options.text  = options.text.toString();
        }
        if (options.badge) {
            if (isNaN(options.badge)) {
                options.badge = defaults.badge;
                $log.warn('Badge number is not a number: ' + options.id);
            } else {
                options.badge = Number(options.badge);
            }
        }
        if (options.at) {
            if (typeof options.at == 'object') {
                options.at = options.at.getTime();
            }
            options.at = Math.round(options.at / 1000);
        }
        if (typeof options.data == 'object') {
            options.data = JSON.stringify(options.data);
        }
        return options;
    }
    function getAllNotifications() {
        return $mmApp.getDB().getAll(mmCoreDesktopLocalNotificationsStore);
    }
    function getNotifications(ids, getScheduled, getTriggered) {
        var notifications = [];
        if (getScheduled) {
            angular.forEach(scheduled, function(entry, id) {
                if (!ids || ids.indexOf(id) != -1) {
                    notifications.push(entry.notification);
                }
            });
        }
        if (getTriggered) {
            angular.forEach(triggered, function(notification, id) {
                if ((!getScheduled || !scheduled[id]) && (!ids || ids.indexOf(id) != -1)) {
                    notifications.push(notification);
                }
            });
        }
        return notifications;
    }
    function getValueFor(options) {
        var keys = Array.apply(null, arguments).slice(1);
        for (var i = 0; i < keys.length; i++) {
            var key = keys[i];
            if (options.hasOwnProperty(key)) {
                return options[key];
            }
        }
    }
    self.load = function() {
        if (!$mmApp.isDesktop()) {
            return $q.when();
        }
        if ($mmEmulatorHelper.isWindows()) {
            try {
                winNotif = require('electron-windows-notifications');
            } catch(ex) {}
        }
        $cordovaLocalNotification.schedule = function(notifications, scope, isUpdate) {
            var promises = [];
            notifications = Array.isArray(notifications) ? notifications : [notifications];
            angular.forEach(notifications, function(notification) {
                mergeWithDefaults(notification);
                convertProperties(notification);
                $cordovaLocalNotification.cancel(notification.id, null, true);
                scheduled[notification.id] = {
                    notification: notification
                };
                promises.push(storeNotification(notification, false));
                if (Math.abs(moment().diff(notification.at * 1000, 'days')) > 15) {
                    return;
                }
                var toTrigger = notification.at * 1000 - Date.now();
                scheduled[notification.id].timeout = $timeout(function trigger() {
                    triggerNotification(notification);
                    triggered[notification.id] = notification;
                    storeNotification(notification, true);
                    $rootScope.$broadcast('$cordovaLocalNotification:trigger', notification, 'foreground');
                    if (notification.every && scheduled[notification.id] && !scheduled[notification.id].interval) {
                        var interval = parseInterval(notification.every);
                        if (interval > 0) {
                            scheduled[notification.id].interval = $interval(trigger, interval);
                        }
                    }
                }, toTrigger);
                var eventName = isUpdate ? 'update' : 'schedule';
                $rootScope.$broadcast('$cordovaLocalNotification:' + eventName, notification, 'foreground');
            });
            return $q.when();
        };
        $cordovaLocalNotification.update = function(notifications) {
            return $cordovaLocalNotification.schedule(notifications, null, true);
        };
        $cordovaLocalNotification.clear = function(ids, scope, omitEvent) {
            var promises = [];
            ids = Array.isArray(ids) ? ids : [ids];
            ids = convertIds(ids);
            angular.forEach(ids, function(id) {
                if (scheduled[id] && scheduled[id].notification && !scheduled[id].notification.every) {
                    promises.push(cancelNotification(id, omitEvent, '$cordovaLocalNotification:clear'));
                }
            });
            return $q.all(promises);
        };
        $cordovaLocalNotification.clearAll = function(scope, omitEvent) {
            var ids = Object.keys(scheduled);
            return $cordovaLocalNotification.clear(ids, scope, omitEvent).then(function() {
                if (!omitEvent) {
                    $rootScope.$broadcast('$cordovaLocalNotification:clearall', 'foreground');
                }
            });
        };
        $cordovaLocalNotification.cancel = function(ids, scope, omitEvent) {
            var promises = [];
            ids = Array.isArray(ids) ? ids : [ids];
            ids = convertIds(ids);
            angular.forEach(ids, function(id) {
                if (scheduled[id]) {
                    promises.push(cancelNotification(id, omitEvent, '$cordovaLocalNotification:cancel'));
                }
            });
            return $q.all(promises);
        };
        $cordovaLocalNotification.cancelAll = function(scope, omitEvent) {
            var ids = Object.keys(scheduled);
            return $cordovaLocalNotification.cancel(ids, scope, omitEvent).then(function() {
                if (!omitEvent) {
                    $rootScope.$broadcast('$cordovaLocalNotification:cancelall', 'foreground');
                }
            });
        };
        $cordovaLocalNotification.isPresent = function(id) {
            return $q.when(!!scheduled[id] || !!triggered[notification.id]);
        };
        $cordovaLocalNotification.isScheduled = function(id) {
            return $q.when(!!scheduled[id]);
        };
        $cordovaLocalNotification.isTriggered = function(id) {
            return $q.when(!!triggered[notification.id]);
        };
        $cordovaLocalNotification.hasPermission = function() {
            return $q.when(true);
        };
        $cordovaLocalNotification.registerPermission = function() {
            return $q.when(true);
        };
        $cordovaLocalNotification.getAllIds = function() {
            return $q.when($mmUtil.mergeArraysWithoutDuplicates(Object.keys(scheduled), Object.keys(triggered)));
        };
        $cordovaLocalNotification.getIds = $cordovaLocalNotification.getAllIds;
        $cordovaLocalNotification.getScheduledIds = function() {
            return $q.when(Object.keys(scheduled));
        };
        $cordovaLocalNotification.getTriggeredIds = function() {
            return $q.when(Object.keys(triggered));
        };
        $cordovaLocalNotification.get = function(ids) {
            ids = Array.isArray(ids) ? ids : [ids];
            ids = convertIds(ids);
            return $q.when(getNotifications(ids, true, true));
        };
        $cordovaLocalNotification.getAll = function() {
            return $q.when(getNotifications(null, true, true));
        };
        $cordovaLocalNotification.getScheduled = function(ids) {
            ids = Array.isArray(ids) ? ids : [ids];
            ids = convertIds(ids);
            return $q.when(getNotifications(ids, true, false));
        };
        $cordovaLocalNotification.getAllScheduled = function() {
            return $q.when(getNotifications(null, true, false));
        };
        $cordovaLocalNotification.getTriggered = function(ids) {
            ids = Array.isArray(ids) ? ids : [ids];
            ids = convertIds(ids);
            return $q.when(getNotifications(ids, false, true));
        };
        $cordovaLocalNotification.getAllTriggered = function() {
            return $q.when(getNotifications(null, false, true));
        };
        $cordovaLocalNotification.getDefaults = function() {
            return defaults;
        };
        $cordovaLocalNotification.setDefaults = function(newDefaults) {
            for (var key in defaults) {
                if (newDefaults.hasOwnProperty(key)) {
                    defaults[key] = newDefaults[key];
                }
            }
        };
        return getAllNotifications().catch(function() {
            return [];
        }).then(function(notifications) {
            angular.forEach(notifications, function(notification) {
                if (notification.triggered) {
                    delete notification.triggered;
                    scheduled[notification.id] = {
                        notification: notification
                    };
                    triggered[notification.id] = notification;
                } else {
                    delete notification.triggered;
                    notification.at = notification.at * 1000;
                    if (notification.at - Date.now() > - mmCoreSecondsHour * 1000) {
                        $cordovaLocalNotification.schedule(notification);
                    }
                }
            });
        });
    };
    function mergeWithDefaults(options) {
        options.at   = getValueFor(options, 'at', 'firstAt', 'date');
        options.text = getValueFor(options, 'text', 'message');
        options.data = getValueFor(options, 'data', 'json');
        if (defaults.hasOwnProperty('autoClear')) {
            options.autoClear = getValueFor(options, 'autoClear', 'autoCancel');
        }
        if (options.autoClear !== true && options.ongoing) {
            options.autoClear = false;
        }
        if (options.at === undefined || options.at === null) {
            options.at = new Date();
        }
        for (var key in defaults) {
            if (options[key] === null || options[key] === undefined) {
                if (options.hasOwnProperty(key) && ['data','sound'].indexOf(key) > -1) {
                    options[key] = undefined;
                } else {
                    options[key] = defaults[key];
                }
            }
        }
        for (key in options) {
            if (!defaults.hasOwnProperty(key)) {
                delete options[key];
                $log.warn('Unknown property: ' + key);
            }
        }
        return options;
    }
    function notificationClicked(notification) {
        $rootScope.$broadcast('$cordovaLocalNotification:click', notification, 'foreground');
        require('electron').ipcRenderer.send('focusApp');
    }
    function parseInterval(every) {
        var interval;
        every = String(every).toLowerCase();
        if (!every || every == 'undefined') {
            interval = 0;
        } else if (every == 'second') {
            interval = 1000;
        } else if (every == 'minute') {
            interval = mmCoreSecondsMinute * 1000;
        } else if (every == 'hour') {
            interval = mmCoreSecondsHour * 1000;
        } else if (every == 'day') {
            interval = mmCoreSecondsDay * 1000;
        } else if (every == 'week') {
            interval = mmCoreSecondsDay * 7 * 1000;
        } else if (every == 'month') {
            interval = mmCoreSecondsDay * 31 * 1000;
        } else if (every == 'quarter') {
            interval = mmCoreSecondsHour * 2190 * 1000;
        } else if (every == 'year') {
            interval = mmCoreSecondsYear * 1000;
        } else {
            interval = parseInt(every, 10);
            if (isNaN(interval)) {
                interval = 0;
            } else {
                interval *= 60000;
            }
        }
        return interval;
    }
    function removeNotification(id) {
        return $mmApp.getDB().remove(mmCoreDesktopLocalNotificationsStore, id);
    }
    function storeNotification(notification, triggered) {
        notification = angular.copy(notification);
        notification.triggered = !!triggered;
        return $mmApp.getDB().insert(mmCoreDesktopLocalNotificationsStore, notification);
    }
    function triggerNotification(notification) {
        if (winNotif) {
            var notifInstance = new winNotif.ToastNotification({
                appId: mmCoreConfigConstants.app_id,
                template: toastTemplate,
                strings: [notification.title,  notification.text]
            });
            notifInstance.on('activated', function() {
                notificationClicked(notification);
            });
            notifInstance.show();
            try {
                var tileNotif = new winNotif.TileNotification({
                    tag: notification.id + '',
                    template: tileTemplate,
                    strings: [notification.title,  notification.text, notification.title,  notification.text, notification.title,  notification.text],
                    expirationTime: new Date(Date.now() + mmCoreSecondsHour * 1000) 
                })
                tileNotif.show()
            } catch(ex) {
                $log.warn('Error showing TileNotification. Please notice they only work with the app installed.', ex);
            }
        } else {
            var notifInstance = new Notification(notification.title, {
                body: notification.text
            });
            notifInstance.onclick = function() {
                notificationClicked(notification);
            };
        }
    }
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorMediaCapture', ["$log", "$q", "$ionicModal", "$rootScope", "$window", "$mmUtil", "$mmFS", "$timeout", function($log, $q, $ionicModal, $rootScope, $window, $mmUtil, $mmFS, $timeout) {
    $log = $log.getInstance('$mmEmulatorMediaCapture');
    var self = {},
        possibleAudioMimeTypes = {
            'audio/webm': 'weba',
            'audio/ogg': 'ogg'
        },
        possibleVideoMimeTypes = {
            'video/webm;codecs=vp9': 'webm',
            'video/webm;codecs=vp8': 'webm',
            'video/ogg': 'ogv'
        },
        videoMimeType,
        audioMimeType;
    function captureMedia(type, successCallback, errorCallback, options) {
        options = options || {};
        var loadingModal;
        try {
            var scope = $rootScope.$new(),
                facingMode = 'environment',
                mimetype,
                extension,
                quality = 0.92, 
                returnData = false, 
                isCaptureImage = false, 
                mimeAndExt;
            loadingModal = $mmUtil.showModalLoading();
            if (type == 'captureimage') {
                isCaptureImage = true;
                type = 'image';
            }
            if (type == 'video') {
                scope.isVideo = true;
                title = 'mm.core.capturevideo';
                mimeAndExt = getMimeTypeAndExtension(type, options.mimetypes);
                mimetype = mimeAndExt.mimetype;
                extension = mimeAndExt.extension;
            } else if (type == 'audio') {
                scope.isAudio = true;
                title = 'mm.core.captureaudio';
                mimeAndExt = getMimeTypeAndExtension(type, options.mimetypes);
                mimetype = mimeAndExt.mimetype;
                extension = mimeAndExt.extension;
            } else if (type == 'image') {
                scope.isImage = true;
                title = 'mm.core.captureimage';
                if (typeof options.sourceType != 'undefined' && options.sourceType != Camera.PictureSourceType.CAMERA) {
                    errorCallback && errorCallback('This source type is not supported in desktop.');
                    loadingModal.dismiss();
                    return;
                }
                if (options.cameraDirection == Camera.Direction.FRONT) {
                    facingMode = 'user';
                }
                if (options.encodingType == Camera.EncodingType.PNG) {
                    mimetype = 'image/png';
                    extension = 'png';
                } else {
                    mimetype = 'image/jpeg';
                    extension = 'jpeg';
                }
                if (options.quality >= 0 && options.quality <= 100) {
                    quality = options.quality / 100;
                }
                if (options.destinationType == Camera.DestinationType.DATA_URL) {
                    returnData = true;
                }
            }
            if (options.duration) {
                scope.chronoEndTime = options.duration * 1000;
            }
            initModal(scope).then(function(modal) {
                var constraints = {
                    video: scope.isAudio ? false : {facingMode: facingMode},
                    audio: !scope.isImage
                };
                return navigator.mediaDevices.getUserMedia(constraints).then(function(localMediaStream) {
                    var streamVideo,
                        previewMedia,
                        canvas,
                        imgEl,
                        mediaRecorder,
                        chunks = [],
                        mediaBlob,
                        audioDrawer;
                    if (scope.isImage) {
                        canvas = modal.modalEl.querySelector('canvas.mm-webcam-image-canvas');
                        imgEl = modal.modalEl.querySelector('img.mm-webcam-image');
                    } else {
                        if (scope.isVideo) {
                            previewMedia = modal.modalEl.querySelector('video.mm-webcam-video-captured');
                        } else {
                            previewMedia = modal.modalEl.querySelector('audio.mm-audio-captured');
                            canvas = modal.modalEl.querySelector('canvas.mm-audio-canvas');
                            audioDrawer = initAudioDrawer(localMediaStream, canvas);
                            audioDrawer.start();
                        }
                        mediaRecorder = new MediaRecorder(localMediaStream, {mimeType: mimetype});
                        mediaRecorder.ondataavailable = function(e) {
                            if (e.data.size > 0) {
                                chunks.push(e.data);
                            }
                        };
                        mediaRecorder.onstop = function() {
                            mediaBlob = new Blob(chunks);
                            chunks = [];
                            previewMedia.src = $window.URL.createObjectURL(mediaBlob);
                        };
                    }
                    if (scope.isImage || scope.isVideo) {
                        var hasLoaded = false,
                            waitTimeout;
                        streamVideo = modal.modalEl.querySelector('video.mm-webcam-stream');
                        streamVideo.src = $window.URL.createObjectURL(localMediaStream);
                        streamVideo.onloadedmetadata = function() {
                            if (hasLoaded) {
                                return;
                            }
                            hasLoaded = true;
                            $timeout.cancel(waitTimeout);
                            loadingModal.dismiss();
                            modal.show();
                            scope.readyToCapture = true;
                            streamVideo.onloadedmetadata = null;
                        };
                        waitTimeout = $timeout(function() {
                            if (!hasLoaded) {
                                hasLoaded = true;
                                loadingModal.dismiss();
                                errorCallback && errorCallback({code: -1, message: 'Cannot connect to webcam.'});
                            }
                        }, 10000);
                    } else {
                        loadingModal.dismiss();
                        modal.show();
                        scope.readyToCapture = true;
                    }
                    scope.actionClicked = function() {
                        if (scope.isCapturing) {
                            scope.stopCapturing();
                        } else {
                            if (!scope.isImage) {
                                scope.isCapturing = true;
                                mediaRecorder.start();
                                scope.$broadcast('mm-chrono-start');
                            } else {
                                var width = streamVideo.videoWidth,
                                    height = streamVideo.videoHeight;
                                canvas.width = width;
                                canvas.height = height;
                                canvas.getContext('2d').drawImage(streamVideo, 0, 0, width, height);
                                loadingModal = $mmUtil.showModalLoading();
                                canvas.toBlob(function(blob) {
                                    loadingModal.dismiss();
                                    mediaBlob = blob;
                                    imgEl.setAttribute('src', $window.URL.createObjectURL(mediaBlob));
                                    scope.hasCaptured = true;
                                }, mimetype, quality);
                            }
                        }
                    };
                    scope.stopCapturing = function() {
                        streamVideo && streamVideo.pause();
                        audioDrawer && audioDrawer.stop();
                        mediaRecorder.stop();
                        scope.isCapturing = false;
                        scope.hasCaptured = true;
                        scope.$broadcast('mm-chrono-stop');
                    };
                    scope.discard = function() {
                        previewMedia && previewMedia.pause();
                        streamVideo && streamVideo.play();
                        audioDrawer && audioDrawer.start();
                        scope.hasCaptured = false;
                        scope.isCapturing = false;
                        scope.$broadcast('mm-chrono-reset');
                        delete mediaBlob;
                    };
                    scope.done = function() {
                        if (returnData) {
                            success(canvas.toDataURL(mimetype, quality));
                            return;
                        }
                        if (!mediaBlob) {
                            $mmUtil.showErrorModal('Please capture the media first.');
                            return;
                        }
                        var fileName = type + '_' + $mmUtil.readableTimestamp() + '.' + extension,
                            path = $mmFS.concatenatePaths($mmFS.getTmpFolder(), 'media/' + fileName);
                        loadingModal = $mmUtil.showModalLoading();
                        $mmFS.writeFile(path, mediaBlob).then(function(fileEntry) {
                            if (scope.isImage && !isCaptureImage) {
                                success(fileEntry.toURL());
                            } else {
                                fileEntry.getFormatData = function(successFn, errorFn) {
                                    errorFn && errorFn('Not supported');
                                };
                                success([fileEntry]);
                            }
                        }).catch(function(err) {
                            $mmUtil.showErrorModal(err);
                        }).finally(function() {
                            loadingModal.dismiss();
                        });
                    };
                    function success(data) {
                        scope.modal.hide();
                        $timeout(function() {
                            successCallback && successCallback(data);
                        }, 400);
                    }
                    scope.cancel = function() {
                        scope.modal.hide();
                        var error = scope.isImage && !isCaptureImage ? 'Camera cancelled' : {code: 3, message: 'Canceled.'};
                        errorCallback && errorCallback(error);
                    };
                    scope.$on('modal.hidden', function() {
                        var tracks = localMediaStream.getTracks();
                        angular.forEach(tracks, function(track) {
                            track.stop();
                        });
                        streamVideo && streamVideo.pause();
                        previewMedia && previewMedia.pause();
                        audioDrawer && audioDrawer.stop();
                        scope.$destroy();
                    });
                    scope.$on('$destroy', function() {
                        scope.modal.remove();
                    });
                });
            }).catch(function(err) {
                loadingModal && loadingModal.dismiss();
                errorCallback && errorCallback(err);
            });
        } catch(ex) {
            loadingModal && loadingModal.dismiss();
            errorCallback && errorCallback(ex.toString());
        }
    }
    function getMimeTypeAndExtension(type, mimetypes) {
        var result = {};
        if (mimetypes && mimetypes.length) {
            for (var i = 0; i < mimetypes.length; i++) {
                var mimetype = mimetypes[i],
                    matches = mimetype.match(new RegExp('^' + type + '/'));
                if (matches && matches.length && MediaRecorder.isTypeSupported(mimetype)) {
                    result.mimetype = mimetype;
                    break;
                }
            }
        }
        if (result.mimetype) {
            result.extension = $mmFS.getExtension(result.mimetype);
        } else if (type == 'video') {
            result.mimetype = videoMimeType;
            result.extension = possibleVideoMimeTypes[result.mimetype];
        } else if (type == 'audio') {
            result.mimetype = audioMimeType;
            result.extension = possibleAudioMimeTypes[result.mimetype];
        }
        return result;
    }
    function initAudioDrawer(stream, canvas) {
        var audioCtx = new (window.AudioContext || webkitAudioContext)(),
            canvasCtx = canvas.getContext("2d"),
            source = audioCtx.createMediaStreamSource(stream),
            analyser = audioCtx.createAnalyser(),
            bufferLength = analyser.frequencyBinCount,
            dataArray = new Uint8Array(bufferLength),
            width = canvas.width,
            height = canvas.height,
            running = false,
            skip = true;
        analyser.fftSize = 2048;
        source.connect(analyser);
        return {
            start: function() {
                if (running) {
                    return;
                }
                running = true;
                drawAudio();
            },
            stop: function() {
                running = false;
            }
        };
        function drawAudio() {
            if (!running) {
                return;
            }
            requestAnimationFrame(drawAudio);
            skip = !skip;
            if (skip) {
                return;
            }
            var sliceWidth = width / bufferLength,
                x = 0;
            analyser.getByteTimeDomainData(dataArray);
            canvasCtx.fillStyle = 'rgb(200, 200, 200)';
            canvasCtx.fillRect(0, 0, width, height);
            canvasCtx.lineWidth = 1;
            canvasCtx.strokeStyle = 'rgb(0, 0, 0)';
            canvasCtx.beginPath();
            for(var i = 0; i < bufferLength; i++) {
                var v = dataArray[i] / 128.0,
                    y = v * height / 2;
                if (i === 0) {
                    canvasCtx.moveTo(x, y);
                } else {
                    canvasCtx.lineTo(x, y);
                }
                x += sliceWidth;
            }
            canvasCtx.lineTo(width, height / 2);
            canvasCtx.stroke();
        }
    }
    function initGetUserMedia() {
        navigator.mediaDevices = navigator.mediaDevices || {};
        if (!navigator.mediaDevices.getUserMedia) {
            navigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia ||
                            navigator.mozGetUserMedia || navigator.msGetUserMedia;
            if (navigator.getUserMedia) {
                navigator.mediaDevices.getUserMedia = function(constraints) {
                    var deferred = $q.defer();
                    navigator.getUserMedia(constraints, deferred.resolve, deferred.reject);
                    return deferred.promise;
                };
            } else {
                return false;
            }
        }
        return true;
    }
    function initMimeTypes() {
        for (var mimeType in possibleVideoMimeTypes) {
            if (MediaRecorder.isTypeSupported(mimeType)) {
                videoMimeType = mimeType;
                break;
            }
        }
        for (mimeType in possibleAudioMimeTypes) {
            if (MediaRecorder.isTypeSupported(mimeType)) {
                audioMimeType = mimeType;
                break;
            }
        }
    }
    function initModal(scope) {
        return $ionicModal.fromTemplateUrl('core/components/emulator/templates/capturemediamodal.html', {
            scope: scope,
            animation: 'slide-in-up'
        }).then(function(modal) {
            scope.modal = modal;
            return modal;
        });
    }
    self.load = function() {
        if (typeof window.MediaRecorder == 'undefined') {
            return $q.when();
        }
        if (!initGetUserMedia()) {
            return $q.when();
        }
        initMimeTypes();
        navigator.device = navigator.device || {};
        navigator.device.capture = navigator.device.capture || {};
        navigator.camera = navigator.camera || {};
        $window.Camera = $window.Camera || {};
        $window.Camera.DestinationType = {
            DATA_URL: 0,
            FILE_URI: 1,
            NATIVE_URI: 2
        };
        $window.Camera.Direction = {
            BACK: 0,
            FRONT: 1
        };
        $window.Camera.EncodingType = {
            JPEG: 0,
            PNG: 1
        };
        $window.Camera.MediaType = {
            PICTURE: 0,
            VIDEO: 1,
            ALLMEDIA: 2
        };
        $window.Camera.PictureSourceType = {
            PHOTOLIBRARY: 0,
            CAMERA: 1,
            SAVEDPHOTOALBUM: 2
        };
        $window.Camera.PopoverArrowDirection = {
            ARROW_UP: 1,
            ARROW_DOWN: 2,
            ARROW_LEFT: 4,
            ARROW_RIGHT: 8,
            ARROW_ANY: 15
        };
        angular.extend(navigator.camera, $window.Camera);
        $window.CameraPopoverOptions = function() {
        };
        $window.CameraPopoverHandle = function() {
        };
        $window.CameraPopoverHandle.prototype.setPosition = function() {
        };
        navigator.camera.getPicture = function(successCallback, errorCallback, options) {
            return captureMedia('image', successCallback, errorCallback, options);
        };
        navigator.camera.cleanup = function(successCallback, errorCallback) {
            successCallback && successCallback();
        };
        navigator.device.capture.captureImage = function(successCallback, errorCallback, options) {
            return captureMedia('captureimage', successCallback, errorCallback, options);
        };
        navigator.device.capture.captureVideo = function(successCallback, errorCallback, options) {
            return captureMedia('video', successCallback, errorCallback, options);
        };
        navigator.device.capture.captureAudio = function(successCallback, errorCallback, options) {
            return captureMedia('audio', successCallback, errorCallback, options);
        };
        $window.CaptureAudioOptions = function() {};
        $window.CaptureImageOptions = function() {};
        $window.CaptureVideoOptions = function() {};
        $window.CaptureError = function(c) {
            this.code = c || null;
        };
        return $q.when();
    };
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorNetwork', ["$log", "$q", function($log, $q) {
    $log = $log.getInstance('$mmEmulatorNetwork');
    var self = {};
    self.load = function() {
        window.Connection = {
            UNKNOWN: 'unknown',
            ETHERNET: 'ethernet',
            WIFI: 'wifi',
            CELL_2G: '2g',
            CELL_3G: '3g',
            CELL_4G: '4g',
            CELL: 'cellular',
            NONE: 'none'
        };
        return $q.when();
    };
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorPushNotifications', ["$log", "$q", "$window", "$mmApp", function($log, $q, $window, $mmApp) {
    $log = $log.getInstance('$mmEmulatorPushNotifications');
    var self = {};
    self.load = function() {
        var PushNotification = function(options) {};
        PushNotification.prototype.unregister = function(successCallback, errorCallback, options) {
            errorCallback && errorCallback('Unregister is only supported in mobile devices');
        };
        PushNotification.prototype.subscribe = function(topic, successCallback, errorCallback) {
            errorCallback && errorCallback('Suscribe is only supported in mobile devices');
        };
        PushNotification.prototype.unsubscribe = function(topic, successCallback, errorCallback) {
            errorCallback && errorCallback('Unsuscribe is only supported in mobile devices');
        };
        PushNotification.prototype.setApplicationIconBadgeNumber = function(successCallback, errorCallback, badge) {
            if (!$mmApp.isDesktop()) {
                errorCallback && errorCallback('setApplicationIconBadgeNumber is not supported in browser');
                return;
            }
            try {
                var app = require('electron').remote.app;
                if (app.setBadgeCount(badge)) {
                    successCallback && successCallback();
                } else {
                    errorCallback && errorCallback();
                }
            } catch(ex) {
                errorCallback && errorCallback(ex);
            }
        };
        PushNotification.prototype.getApplicationIconBadgeNumber = function(successCallback, errorCallback) {
            if (!$mmApp.isDesktop()) {
                errorCallback && errorCallback('getApplicationIconBadgeNumber is not supported in browser');
                return;
            }
            try {
                var app = require('electron').remote.app;
                successCallback && successCallback(app.getBadgeCount());
            } catch(ex) {
                errorCallback && errorCallback(ex);
            }
        };
        PushNotification.prototype.clearAllNotifications = function(successCallback, errorCallback) {
            errorCallback && errorCallback('clearAllNotifications is only supported in mobile devices');
        };
        PushNotification.prototype.on = function(eventName, callback) {};
        PushNotification.prototype.off = function(eventName, handle) {};
        PushNotification.prototype.emit = function() {};
        PushNotification.prototype.finish = function(successCallback, errorCallback, id) {
            errorCallback && errorCallback('finish is only supported in mobile devices');
        };
        $window.PushNotification = {
            init: function(options) {
                return new PushNotification(options);
            },
            hasPermission: function(successCallback, errorCallback) {
                errorCallback && errorCallback('hasPermission is only supported in mobile devices');
            },
            PushNotification: PushNotification
        };
        return $q.when();
    };
    return self;
}]);

angular.module('mm.core.emulator')
.factory('$mmEmulatorZip', ["$log", "$q", "$mmFS", "$window", function($log, $q, $mmFS, $window) {
    $log = $log.getInstance('$mmEmulatorZip');
    var self = {};
    self.load = function() {
        $window.zip = {
            unzip: function(source, destination, callback, progressCallback) {
                var basePath = $mmFS.getBasePathInstant();
                source = source.replace(basePath, '').replace(/%20/g, ' ');
                destination = destination.replace(basePath, '').replace(/%20/g, ' ');
                $mmFS.readFile(source, $mmFS.FORMATARRAYBUFFER).then(function(data) {
                    var zip = new JSZip(data),
                        promises = [],
                        loaded = 0,
                        total = Object.keys(zip.files).length;
                    angular.forEach(zip.files, function(file, name) {
                        var filePath = $mmFS.concatenatePaths(destination, name),
                            type,
                            promise;
                        if (!file.dir) {
                            type = $mmFS.getMimeType($mmFS.getFileExtension(name));
                            promise = $mmFS.writeFile(filePath, new Blob([file.asArrayBuffer()], {type: type}));
                        } else {
                            promise = $mmFS.createDir(filePath);
                        }
                        promises.push(promise.then(function() {
                            loaded++;
                            progressCallback && progressCallback({loaded: loaded, total: total});
                        }));
                    });
                    return $q.all(promises).then(function() {
                        callback(0);
                    });
                }).catch(function() {
                    callback(-1);
                });
            }
        };
        return $q.when();
    };
    return self;
}]);

angular.module('mm.core.fileuploader')
.directive('mmFileUploaderOnChange', function() {
  return {
    restrict: 'A',
    link: function (scope, element, attrs) {
      var onChangeHandler = scope.$eval(attrs.mmFileUploaderOnChange);
      element.bind('change', onChangeHandler);
    }
  };
});

angular.module('mm.core.fileuploader')
.provider('$mmFileUploaderDelegate', function() {
    var handlers = {},
        self = {};
    self.registerHandler = function(addon, handler, priority) {
        if (typeof handlers[addon] !== 'undefined') {
            console.log("$mmFileUploaderDelegate: Addon '" + handlers[addon].addon + "' already registered as handler");
            return false;
        }
        console.log("$mmFileUploaderDelegate: Registered addon '" + addon + "' as handler.");
        handlers[addon] = {
            addon: addon,
            handler: handler,
            instance: undefined,
            priority: priority
        };
        return true;
    };
    self.$get = ["$mmUtil", "$q", "$log", "$mmSite", function($mmUtil, $q, $log, $mmSite) {
        var enabledHandlers = {},
            self = {},
            lastUpdateHandlersStart;
        $log = $log.getInstance('$mmFileUploaderDelegate');
        self.clearSiteHandlers = function() {
            enabledHandlers = {};
        };
        self.getHandlers = function(mimetypes) {
            var handlers = [];
            angular.forEach(enabledHandlers, function(handler) {
                var supportedMimetypes;
                if (mimetypes) {
                    if (!handler.instance.getSupportedMimeTypes) {
                        return;
                    }
                    supportedMimetypes = handler.instance.getSupportedMimeTypes(mimetypes);
                    if (!supportedMimetypes.length) {
                        return;
                    }
                }
                var data = handler.instance.getData();
                data.priority = handler.priority;
                data.mimetypes = supportedMimetypes;
                handlers.push(data);
            });
            return handlers;
        };
        self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
        self.updateHandler = function(addon, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[addon] = {
                            instance: handlerInfo.instance,
                            priority: handlerInfo.priority
                        };
                    } else {
                        delete enabledHandlers[addon];
                    }
                }
            });
        };
        self.updateHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating navigation handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(handlers, function(handlerInfo, addon) {
                promises.push(self.updateHandler(addon, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.fileuploader')
.factory('$mmFileUploader', ["$mmSite", "$mmFS", "$q", "$timeout", "$log", "$mmSitesManager", "$mmFilepool", "$mmUtil", function($mmSite, $mmFS, $q, $timeout, $log, $mmSitesManager, $mmFilepool, $mmUtil) {
    $log = $log.getInstance('$mmFileUploader');
    var self = {};
    self.storeFilesToUpload = function(folderPath, files) {
        var result = {
            online: [],
            offline: 0
        };
        if (!files || !files.length) {
            return $q.when(result);
        }
        return $mmFS.removeUnusedFiles(folderPath, files).then(function() {
            var promises = [];
            angular.forEach(files, function(file) {
                if (file.filename && !file.name) {
                    result.online.push({
                        filename: file.filename,
                        fileurl: file.fileurl
                    });
                } else if (!file.name) {
                    promises.push($q.reject());
                } else if (file.fullPath && file.fullPath.indexOf(folderPath) != -1) {
                    result.offline++;
                } else {
                    var destFile = $mmFS.concatenatePaths(folderPath, file.name);
                    promises.push($mmFS.copyFile(file.toURL(), destFile));
                    result.offline++;
                }
            });
            return $q.all(promises).then(function() {
                return result;
            });
        });
    };
    self.uploadFile = function(uri, options, siteId) {
        options = options || {};
        siteId = siteId || $mmSite.getId();
        var deleteAfterUpload = options.deleteAfterUpload,
            ftOptions = angular.copy(options);
        delete ftOptions.deleteAfterUpload;
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.uploadFile(uri, ftOptions);
        }).then(function(result) {
            if (deleteAfterUpload) {
                $timeout(function() {
                    $mmFS.removeExternalFile(uri);
                }, 500);
            }
            return result;
        });
    };
    self.uploadImage = function(uri, isFromAlbum) {
        $log.debug('Uploading an image');
        var options = {
                fileName: 'image_' + $mmUtil.readableTimestamp() + '.jpg', 
                mimeType: 'image/jpeg'
            },
            fileName,
            extension;
        if (typeof uri == 'undefined' || uri === '') {
            $log.debug('Received invalid URI in $mmFileUploader.uploadImage()');
            return $q.reject();
        }
        if (isFromAlbum) {
            fileName = $mmFS.getFileAndDirectoryFromPath(uri).name;
            fileName = fileName.replace(/(\.[^\.]*)\?[^\.]*$/, '$1');
            extension = $mmFS.getFileExtension(fileName);
            if (extension) {
                options.fileName = fileName;
                options.mimeType = $mmFS.getMimeType(extension);
            }
        }
        options.deleteAfterUpload = !isFromAlbum;
        options.fileKey = 'file';
        return self.uploadFile(uri, options);
    };
    self.uploadMedia = function(mediaFile) {
        $log.debug('Uploading media');
        var options = {},
            filename = mediaFile.name,
            split;
        split = filename.split('.');
        split[0] += '_' + $mmUtil.readableTimestamp();
        filename = split.join('.');
        options.fileKey = null;
        options.fileName = filename;
        options.mimeType = null;
        options.deleteAfterUpload = true;
        return self.uploadFile(mediaFile.fullPath, options);
    };
    self.uploadGenericFile = function(uri, name, type, deleteAfterUpload, fileArea, itemId, siteId) {
        var options = {};
        options.fileKey = null;
        options.fileName = name;
        options.mimeType = type;
        options.deleteAfterUpload = deleteAfterUpload;
        options.itemId = itemId || 0;
        options.fileArea = fileArea;
        return self.uploadFile(uri, options, siteId);
    };
    self.uploadOrReuploadFile = function(file, itemId, component, componentId, siteId) {
        siteId = siteId || $mmSite.getId();
        var promise,
            fileName;
        if (file.filename && !file.name) {
            fileName = file.filename;
            promise = $mmFilepool.downloadUrl(siteId, file.url || file.fileurl, false, component, componentId,
                    file.timemodified, undefined, file).then(function(path) {
                return $mmFS.getExternalFile(path);
            });
        } else {
            fileName = file.name;
            promise = $q.when(file);
        }
        return promise.then(function(fileEntry) {
            return self.uploadGenericFile(fileEntry.toURL(), fileName, fileEntry.type, true, 'draft', itemId, siteId)
                    .then(function(result) {
                return result.itemid;
            });
        });
    };
    self.uploadOrReuploadFiles = function(files, component, componentId, siteId) {
        siteId = siteId || $mmSite.getId();
        if (!files || !files.length) {
            return $q.when(1);
        }
        return self.uploadOrReuploadFile(files[0], 0, component, componentId, siteId).then(function(itemId) {
            var promises = [],
                error;
            angular.forEach(files, function(file, index) {
                if (index === 0) {
                    return;
                }
                promises.push(self.uploadOrReuploadFile(file, itemId, component, componentId, siteId).catch(function(message) {
                    error = message;
                    return $q.reject();
                }));
            });
            return $q.all(promises).then(function() {
                return itemId;
            }).catch(function() {
                return $q.reject(error);
            });
        });
    };
    return self;
}]);

angular.module('mm.core.fileuploader')
.factory('$mmFileUploaderHandlers', ["$mmFileUploaderHelper", "$rootScope", "$compile", "$mmUtil", "$mmApp", "$translate", "$mmFS", function($mmFileUploaderHelper, $rootScope, $compile, $mmUtil, $mmApp, $translate, $mmFS) {
    var self = {};
    self.albumFilePicker = function() {
        var self = {};
        self.isEnabled = function() {
            return $mmApp.isDevice();
        };
        self.getData = function() {
            return {
                name: 'album',
                title: 'mm.fileuploader.photoalbums',
                class: 'mm-fileuploader-album-handler',
                icon: 'ion-images',
                action: function(maxSize, upload, allowOffline, mimetypes) {
                    return $mmFileUploaderHelper.uploadImage(true, maxSize, upload, mimetypes).then(function(result) {
                        return {
                            uploaded: true,
                            result: result
                        };
                    });
                }
            };
        };
        self.getSupportedMimeTypes = function(mimetypes) {
            return $mmUtil.filterByRegexp(mimetypes, /^(image|video)\//);
        };
        return self;
    };
    self.cameraFilePicker = function() {
        var self = {};
        self.isEnabled = function() {
            return $mmApp.isDevice() || $mmApp.canGetUserMedia();
        };
        self.getData = function() {
            return {
                name: 'camera',
                title: 'mm.fileuploader.camera',
                class: 'mm-fileuploader-camera-handler',
                icon: 'ion-camera',
                action: function(maxSize, upload, allowOffline, mimetypes) {
                    return $mmFileUploaderHelper.uploadImage(false, maxSize, upload, mimetypes).then(function(result) {
                        return {
                            uploaded: true,
                            result: result
                        };
                    });
                }
            };
        };
        self.getSupportedMimeTypes = function(mimetypes) {
            return $mmUtil.filterByRegexp(mimetypes, /^image\/(jpeg|png)$/);
        };
        return self;
    };
    self.audioFilePicker = function() {
        var self = {};
        self.isEnabled = function() {
            return $mmApp.isDevice() || ($mmApp.canGetUserMedia() && $mmApp.canRecordMedia());
        };
        self.getData = function() {
            return {
                name: 'audio',
                title: 'mm.fileuploader.audio',
                class: 'mm-fileuploader-audio-handler',
                icon: 'ion-mic-a',
                action: function(maxSize, upload, allowOffline, mimetypes) {
                    return $mmFileUploaderHelper.uploadAudioOrVideo(true, maxSize, upload, mimetypes).then(function(result) {
                        return {
                            uploaded: true,
                            result: result
                        };
                    });
                }
            };
        };
        self.getSupportedMimeTypes = function(mimetypes) {
            if (ionic.Platform.isIOS()) {
                return $mmUtil.filterByRegexp(mimetypes, /^audio\/wav$/);
            } else if (ionic.Platform.isAndroid()) {
                return $mmUtil.filterByRegexp(mimetypes, /^audio\//);
            } else {
                if (MediaRecorder) {
                    return mimetypes.filter(function(type) {
                        var matches = type.match(/^audio\//);
                        return matches && matches.length && MediaRecorder.isTypeSupported(type);
                    });
                }
            }
            return [];
        };
        return self;
    };
    self.videoFilePicker = function() {
        var self = {};
        self.isEnabled = function() {
            return $mmApp.isDevice() || ($mmApp.canGetUserMedia() && $mmApp.canRecordMedia());
        };
        self.getData = function() {
            return {
                name: 'video',
                title: 'mm.fileuploader.video',
                class: 'mm-fileuploader-video-handler',
                icon: 'ion-ios-videocam',
                action: function(maxSize, upload, allowOffline, mimetypes) {
                    return $mmFileUploaderHelper.uploadAudioOrVideo(false, maxSize, upload, mimetypes).then(function(result) {
                        return {
                            uploaded: true,
                            result: result
                        };
                    });
                }
            };
        };
        self.getSupportedMimeTypes = function(mimetypes) {
            if (ionic.Platform.isIOS()) {
                return $mmUtil.filterByRegexp(mimetypes, /^video\/quicktime$/);
            } else if (ionic.Platform.isAndroid()) {
                return $mmUtil.filterByRegexp(mimetypes, /^video\//);
            } else {
                if (MediaRecorder) {
                    return mimetypes.filter(function(type) {
                        var matches = type.match(/^video\//);
                        return matches && matches.length && MediaRecorder.isTypeSupported(type);
                    });
                }
            }
            return [];
        };
        return self;
    };
    self.filePicker = function() {
        var self = {},
            uploadFileScope;
        self.isEnabled = function() {
            return ionic.Platform.isAndroid() || !$mmApp.isDevice() ||
                    (ionic.Platform.isIOS() && parseInt(ionic.Platform.version(), 10) >= 9);
        };
        self.getData = function() {
            var isIOS = ionic.Platform.isIOS();
            return {
                name: 'file',
                title: isIOS ? 'mm.fileuploader.more' : 'mm.fileuploader.file',
                class: 'mm-fileuploader-file-handler',
                icon: isIOS ? 'ion-more' : 'ion-folder',
                afterRender: function(maxSize, upload, allowOffline, mimetypes) {
                    var element = document.querySelector('.mm-fileuploader-file-handler');
                    if (element) {
                        var input = angular.element('<input type="file" mm-file-uploader-on-change="filePicked">');
                        if (mimetypes && mimetypes.length && (!ionic.Platform.isAndroid() || mimetypes.length === 1)) {
                            input.attr('accept', mimetypes.join(', '));
                        }
                        if (!uploadFileScope) {
                            uploadFileScope = $rootScope.$new();
                        }
                        uploadFileScope.filePicked = function(evt) {
                            var input = evt.srcElement,
                                file = input.files[0],
                                fileName;
                            input.value = ''; 
                            if (!file) {
                                return;
                            }
                            var error = $mmFileUploaderHelper.isInvalidMimetype(mimetypes, file.name, file.type);
                            if (error) {
                                $mmUtil.showErrorModal(error);
                                return;
                            }
                            fileName = file.name;
                            if (isIOS) {
                                var matches = fileName.match(/image\.(jpe?g|png)/);
                                if (matches) {
                                    fileName = 'image_' + $mmUtil.readableTimestamp() + '.' + matches[1];
                                }
                            }
                            $mmFileUploaderHelper.uploadFileObject(file, maxSize, upload, allowOffline, fileName)
                                    .then(function(result) {
                                $mmFileUploaderHelper.fileUploaded(result);
                            }).catch(function(error) {
                                if (error) {
                                    $mmUtil.showErrorModal(error);
                                }
                            });
                        };
                        $compile(input)(uploadFileScope);
                        element.appendChild(input[0]);
                    }
                }
            };
        };
        self.getSupportedMimeTypes = function(mimetypes) {
            return mimetypes;
        };
        return self;
    };
    return self;
}]);

angular.module('mm.core.fileuploader')
.constant('mmFileUploaderFileSizeWarning', 1048576) 
.constant('mmFileUploaderWifiFileSizeWarning', 10485760) 
.factory('$mmFileUploaderHelper', ["$q", "$mmUtil", "$mmApp", "$log", "$translate", "$window", "$rootScope", "$ionicActionSheet", "$mmFileUploader", "$cordovaCamera", "$cordovaCapture", "$mmLang", "$mmFS", "$mmText", "$timeout", "mmFileUploaderFileSizeWarning", "mmFileUploaderWifiFileSizeWarning", "$mmFileUploaderDelegate", function($q, $mmUtil, $mmApp, $log, $translate, $window, $rootScope, $ionicActionSheet,
        $mmFileUploader, $cordovaCamera, $cordovaCapture, $mmLang, $mmFS, $mmText, $timeout, mmFileUploaderFileSizeWarning,
        mmFileUploaderWifiFileSizeWarning, $mmFileUploaderDelegate) {
    $log = $log.getInstance('$mmFileUploaderHelper');
    var self = {},
        filePickerDeferred,
        hideActionSheet;
    self.areFileListDifferent = function(a, b) {
        a = a || [];
        b = b || [];
        if (a.length != b.length) {
            return true;
        }
        for (var i = 0; i < a.length; i++) {
            if ((a[i].name || a[i].filename) != (b[i].name || b[i].filename)) {
                return true;
            }
        }
        return false;
    };
    self.clearTmpFiles = function(files) {
        files.forEach(function(file) {
            if (!file.offline && file.remove) {
                file.remove(function() {});
            }
        });
    };
    self.confirmUploadFile = function(size, alwaysConfirm, allowOffline, wifiThreshold, limitedThreshold) {
        if (size == 0) {
            return $q.when();
        }
        if (!allowOffline && !$mmApp.isOnline()) {
            return $mmLang.translateAndReject('mm.fileuploader.errormustbeonlinetoupload');
        }
        wifiThreshold = typeof wifiThreshold == 'undefined' ? mmFileUploaderWifiFileSizeWarning : wifiThreshold;
        limitedThreshold = typeof limitedThreshold == 'undefined' ? mmFileUploaderFileSizeWarning : limitedThreshold;
        if (size < 0) {
            return $mmUtil.showConfirm($translate('mm.fileuploader.confirmuploadunknownsize'));
        } else if (size >= wifiThreshold || ($mmApp.isNetworkAccessLimited() && size >= limitedThreshold)) {
            size = $mmText.bytesToSize(size, 2);
            return $mmUtil.showConfirm($translate('mm.fileuploader.confirmuploadfile', {size: size}));
        } else {
            if (alwaysConfirm) {
                return $mmUtil.showConfirm($translate('mm.core.areyousure'));
            } else {
                return $q.when();
            }
        }
    };
    self.copyAndUploadFile = function(file, upload, name) {
        name = name || file.name;
        var modal = $mmUtil.showModalLoading('mm.fileuploader.readingfile', true),
            fileData;
        return $mmFS.readFileData(file, $mmFS.FORMATARRAYBUFFER).then(function(data) {
            fileData = data;
            return $mmFS.getUniqueNameInFolder($mmFS.getTmpFolder(), name);
        }).then(function(newName) {
            var filepath = $mmFS.concatenatePaths($mmFS.getTmpFolder(), newName);
            return $mmFS.writeFile(filepath, fileData);
        }).catch(function(error) {
            $log.error('Error reading file to upload: '+JSON.stringify(error));
            modal.dismiss();
            return $mmLang.translateAndReject('mm.fileuploader.errorreadingfile');
        }).then(function(fileEntry) {
            modal.dismiss();
            if (upload) {
                return self.uploadGenericFile(fileEntry.toURL(), name, file.type, true);
            } else {
                return fileEntry;
            }
        });
    };
    self.errorMaxBytes = function(maxSize, fileName) {
        var error = $translate.instant('mm.fileuploader.maxbytesfile', {$a: {
            file: fileName,
            size: $mmText.bytesToSize(maxSize, 2)
        }});
        $mmUtil.showErrorModal(error);
        return $q.reject();
    };
    self.filePickerClosed = function() {
        if (filePickerDeferred) {
            filePickerDeferred.reject();
            filePickerDeferred = undefined;
        }
        if (hideActionSheet) {
            hideActionSheet();
        }
    };
    self.fileUploaded = function(result) {
        if (filePickerDeferred) {
            filePickerDeferred.resolve(result);
            filePickerDeferred = undefined;
        }
        if (hideActionSheet) {
            hideActionSheet();
        }
    };
    self.getStoredFiles = function(folderPath) {
        return $mmFS.getDirectoryContents(folderPath).then(function(files) {
            return self.markOfflineFiles(files);
        });
    };
    self.getStoredFilesFromOfflineFilesObject = function(filesObject, folderPath) {
        var files = [];
        if (filesObject) {
            if (filesObject.online && filesObject.online.length > 0) {
                files = angular.copy(filesObject.online);
            }
            if (filesObject.offline > 0) {
                return self.getStoredFiles(folderPath).then(function(offlineFiles) {
                    return files.concat(offlineFiles);
                }).catch(function() {
                    return files;
                });
            }
        }
        return $q.when(files);
    };
    self.isInvalidMimetype = function(mimetypes, path, mimetype) {
        var extension;
        if (mimetypes) {
            if (mimetype) {
                extension = $mmFS.getExtension(mimetype);
            } else {
                extension = $mmFS.getFileExtension(path);
                mimetype = $mmFS.getMimeType(extension);
            }
            if (mimetype && mimetypes.indexOf(mimetype) == -1) {
                extension = extension || $translate.instant('mm.core.unknown');
                return $translate.instant('mm.fileuploader.invalidfiletype', {$a: extension});
            }
        }
        return false;
    };
    function addDot(extension) {
        return '.' + extension;
    }
    self.prepareFiletypeList = function(filetypeList) {
        var filetypes = filetypeList.split(/[;, ]+/g),
            mimetypes = {}, 
            typesInfo = [];
        angular.forEach(filetypes, function(filetype) {
            filetype = filetype.trim();
            if (filetype) {
                if (filetype.indexOf('/') != -1) {
                    typesInfo.push({
                        name: $mmFS.getMimetypeDescription(filetype),
                        extlist: $mmFS.getExtensions(filetype).map(addDot).join(' ')
                    });
                    mimetypes[filetype] = true;
                } else if (filetype.indexOf('.') === 0) {
                    var mimetype = $mmFS.getMimeType(filetype);
                    typesInfo.push({
                        name: mimetype ? $mmFS.getMimetypeDescription(mimetype) : false,
                        extlist: filetype
                    });
                    if (mimetype) {
                        mimetypes[mimetype] = true;
                    }
                } else {
                    var groupExtensions = $mmFS.getGroupMimeInfo(filetype, 'extensions'),
                        groupMimetypes = $mmFS.getGroupMimeInfo(filetype, 'mimetypes');
                    if (groupExtensions.length > 0) {
                        typesInfo.push({
                            name: $mmFS.getTranslatedGroupName(filetype),
                            extlist: groupExtensions ? groupExtensions.map(addDot).join(' ') : ''
                        });
                        angular.forEach(groupMimetypes, function(mimetype) {
                            if (mimetype) {
                                mimetypes[mimetype] = true;
                            }
                        });
                    } else {
                        filetype = '.' + filetype;
                        var mimetype = $mmFS.getMimeType(filetype);
                        typesInfo.push({
                            name: mimetype ? $mmFS.getMimetypeDescription(mimetype) : false,
                            extlist: filetype
                        });
                        if (mimetype) {
                            mimetypes[mimetype] = true;
                        }
                    }
                }
            }
        });
        return {
            info: typesInfo,
            mimetypes: Object.keys(mimetypes)
        };
    };
    self.markOfflineFiles = function(files) {
        angular.forEach(files, function(file) {
            file.offline = true;
            file.filename = file.name;
        });
        return files;
    };
    self.selectAndUploadFile = function(maxSize, title, filterMethods, mimetypes) {
        return selectFile(maxSize, false, title, filterMethods, true, mimetypes);
    };
    self.selectFile = function(maxSize, allowOffline, title, filterMethods, mimetypes) {
        return selectFile(maxSize, allowOffline, title, filterMethods, false, mimetypes);
    };
    function selectFile(maxSize, allowOffline, title, filterMethods, upload, mimetypes) {
        var buttons = [],
            handlers;
        filePickerDeferred = $q.defer();
        handlers = $mmFileUploaderDelegate.getHandlers(mimetypes);
        handlers.sort(function(a, b) {
            return a.priority <= b.priority ? 1 : -1;
        });
        angular.forEach(handlers, function(handler) {
            if (filterMethods && filterMethods.indexOf(handler.name) == -1) {
                return;
            }
            buttons.push({
                text: (handler.icon ? '<i class="icon ' + handler.icon + '"></i>' : '') + $translate.instant(handler.title),
                action: handler.action,
                className: handler.class,
                afterRender: handler.afterRender,
                mimetypes: handler.mimetypes
            });
        });
        hideActionSheet = $ionicActionSheet.show({
            buttons: buttons,
            titleText: title ? title : $translate.instant('mm.fileuploader.' + (upload ? 'uploadafile' : 'selectafile')),
            cancelText: $translate.instant('mm.core.cancel'),
            buttonClicked: function(index) {
                if (angular.isFunction(buttons[index].action)) {
                    if (!allowOffline && !$mmApp.isOnline()) {
                        $mmUtil.showErrorModal('mm.fileuploader.errormustbeonlinetoupload', true);
                        return;
                    }
                    buttons[index].action(maxSize, upload, allowOffline, buttons[index].mimetypes).then(function(data) {
                        if (data.uploaded) {
                            return data.result;
                        } else {
                            if (data.fileEntry) {
                                return self.uploadFileEntry(data.fileEntry, data.delete, maxSize, upload, allowOffline);
                            } else if (data.path) {
                                return $mmFS.getFile(data.path).then(function(fileEntry) {
                                    return self.uploadFileEntry(fileEntry, data.delete, maxSize, upload, allowOffline);
                                }, function() {
                                    return $mmFS.getExternalFile(data.path).then(function(fileEntry) {
                                        return uploadFileEntry(fileEntry, data.delete, maxSize, upload, allowOffline);
                                    });
                                });
                            }
                            $mmUtil.showErrorModal('No file received');
                        }
                    }).then(function(result) {
                        self.fileUploaded(result);
                    }).catch(function(error) {
                        if (error) {
                            $mmUtil.showErrorModal(error);
                        }
                    });
                }
                return false;
            },
            cancel: function() {
                self.filePickerClosed();
                return true;
            }
        });
        $timeout(function() {
            angular.forEach(buttons, function(button) {
                if (angular.isFunction(button.afterRender)) {
                    button.afterRender(maxSize, upload, allowOffline, button.mimetypes);
                }
            });
        }, 500);
        return filePickerDeferred.promise;
    }
    self.showConfirmAndUploadInSite = function(fileEntry, deleteAfterUpload, siteId) {
        return $mmFS.getFileObjectFromFileEntry(fileEntry).then(function(file) {
            return self.confirmUploadFile(file.size).then(function() {
                return self.uploadGenericFile(fileEntry.toURL(), file.name, file.type, deleteAfterUpload, siteId).then(function() {
                    $mmUtil.showModal('mm.core.success', 'mm.fileuploader.fileuploaded');
                });
            }).catch(function(err) {
                if (err) {
                    $mmUtil.showErrorModal(err);
                }
                return $q.reject();
            });
        }, function() {
            $mmUtil.showErrorModal('mm.fileuploader.errorreadingfile', true);
            return $q.reject();
        });
    };
    self.uploadAudioOrVideo = function(isAudio, maxSize, upload, mimetypes) {
        $log.debug('Trying to record a video file');
        var fn = isAudio ? $cordovaCapture.captureAudio : $cordovaCapture.captureVideo;
        return fn({limit: 1, mimetypes: mimetypes}).then(function(medias) {
            var media = medias[0],
                path = media.localURL || media.toURL(),
                error = self.isInvalidMimetype(mimetypes, path); 
            if (error) {
                return $q.reject(error);
            }
            if (upload) {
                return uploadFile(true, path, maxSize, true, $mmFileUploader.uploadMedia, media);
            } else {
                return copyToTmpFolder(path, true, maxSize);
            }
        }, function(error) {
            var defaultError = isAudio ? 'mm.fileuploader.errorcapturingaudio' : 'mm.fileuploader.errorcapturingvideo';
            return treatCaptureError(error, defaultError);
        });
    };
    self.uploadGenericFile = function(uri, name, type, deleteAfterUpload, siteId) {
        return uploadFile(deleteAfterUpload, uri, -1, false,
                $mmFileUploader.uploadGenericFile, uri, name, type, deleteAfterUpload, undefined, undefined, siteId);
    };
    self.uploadImage = function(fromAlbum, maxSize, upload, mimetypes) {
        $log.debug('Trying to capture an image with camera');
        var options = {
            quality: 50,
            destinationType: navigator.camera.DestinationType.FILE_URI,
            correctOrientation: true
        };
        if (fromAlbum) {
            var imageSupported = !mimetypes || $mmUtil.indexOfRegexp(mimetypes, /^image\//) > -1,
                videoSupported = !mimetypes || $mmUtil.indexOfRegexp(mimetypes, /^video\//) > -1;
            options.sourceType = navigator.camera.PictureSourceType.PHOTOLIBRARY;
            options.popoverOptions = new CameraPopoverOptions(10, 10, $window.innerWidth  - 200, $window.innerHeight - 200,
                                            Camera.PopoverArrowDirection.ARROW_ANY);
            if (imageSupported && !videoSupported) {
                options.mediaType = Camera.MediaType.PICTURE;
            } else if (!imageSupported && videoSupported) {
                options.mediaType = Camera.MediaType.VIDEO;
            } else if (ionic.Platform.isIOS()) {
                options.mediaType = Camera.MediaType.ALLMEDIA;
            }
        } else if (mimetypes) {
            if (mimetypes.indexOf('image/jpeg') > -1) {
                options.encodingType = Camera.EncodingType.JPEG;
            } else if (mimetypes.indexOf('image/png') > -1) {
                options.encodingType = Camera.EncodingType.PNG;
            }
        }
        return $cordovaCamera.getPicture(options).then(function(path) {
            var error = self.isInvalidMimetype(mimetypes, path); 
            if (error) {
                return $q.reject(error);
            }
            if (upload) {
                return uploadFile(!fromAlbum, path, maxSize, true, $mmFileUploader.uploadImage, path, fromAlbum);
            } else {
                return copyToTmpFolder(path, !fromAlbum, maxSize, 'jpg');
            }
        }, function(error) {
            var defaultError = fromAlbum ? 'mm.fileuploader.errorgettingimagealbum' : 'mm.fileuploader.errorcapturingimage';
            return treatImageError(error, defaultError);
        });
    };
    self.uploadFileEntry = function(fileEntry, deleteAfter, maxSize, upload, allowOffline, name) {
        return $mmFS.getFileObjectFromFileEntry(fileEntry).then(function(file) {
            return self.uploadFileObject(file, maxSize, upload, allowOffline, name).then(function(result) {
                if (deleteAfter) {
                    $mmFS.removeFileByFileEntry(fileEntry);
                }
                return result;
            });
        });
    };
    self.uploadFileObject = function(file, maxSize, upload, allowOffline, name) {
        if (maxSize != -1 && file.size > maxSize) {
            return self.errorMaxBytes(maxSize, file.name);
        }
        return self.confirmUploadFile(file.size, false, allowOffline).then(function() {
            return self.copyAndUploadFile(file, upload, name);
        });
    };
    function treatImageError(error, defaultMessage) {
        if (error) {
            if (typeof error == 'string') {
                if (error.toLowerCase().indexOf("error") > -1 || error.toLowerCase().indexOf("unable") > -1) {
                    $log.error('Error getting image: ' + error);
                    return $q.reject(error);
                } else {
                    $log.debug('Cancelled');
                }
            } else {
                return $mmLang.translateAndReject(defaultMessage);
            }
        }
        return $q.reject();
    }
    function treatCaptureError(error, defaultMessage) {
        if (error) {
            if (typeof error === 'string') {
                $log.error('Error while recording audio/video: ' + error);
                if (error.indexOf('No Activity found') > -1) {
                    return $mmLang.translateAndReject('mm.fileuploader.errornoapp');
                } else {
                    return $mmLang.translateAndReject(defaultMessage);
                }
            } else {
                if (error.code != 3) {
                    $log.error('Error while recording audio/video: ' + JSON.stringify(error));
                    return $mmLang.translateAndReject(defaultMessage);
                } else {
                    $log.debug('Cancelled');
                }
            }
        }
        return $q.reject();
    }
    function copyToTmpFolder(path, shouldDelete, maxSize, defaultExt) {
        var fileName = $mmFS.getFileAndDirectoryFromPath(path).name,
            promise,
            fileTooLarge;
        if (typeof maxSize != 'undefined' && maxSize != -1) {
            promise = $mmFS.getExternalFile(path).then(function(fileEntry) {
                return $mmFS.getFileObjectFromFileEntry(fileEntry).then(function(file) {
                    if (file.size > maxSize) {
                        fileTooLarge = file;
                    }
                });
            }).catch(function() {
            });
        } else {
            promise = $q.when();
        }
        return promise.then(function() {
            if (fileTooLarge) {
                return self.errorMaxBytes(maxSize, fileTooLarge.name);
            }
            fileName = fileName.replace(/(\.[^\.]*)\?[^\.]*$/, '$1');
            return $mmFS.getUniqueNameInFolder($mmFS.getTmpFolder(), fileName, defaultExt);
        }).then(function(newName) {
            var destPath = $mmFS.concatenatePaths($mmFS.getTmpFolder(), newName);
            if (shouldDelete) {
                return $mmFS.moveExternalFile(path, destPath);
            } else {
                return $mmFS.copyExternalFile(path, destPath);
            }
        });
    }
    function uploadFile(deleteAfterUpload, path, maxSize, checkSize, uploadFn) {
        var errorStr = $translate.instant('mm.core.error'),
            retryStr = $translate.instant('mm.core.retry'),
            args = arguments,
            progressTemplate =  "<div>" +
                                    "<ion-spinner></ion-spinner>" +
                                    "<p ng-if=\"!perc\">{{'mm.fileuploader.uploading' | translate}}</p>" +
                                    "<p ng-if=\"perc\">{{'mm.fileuploader.uploadingperc' | translate:{$a: perc} }}</p>" +
                                "</div>",
            scope,
            modal,
            promise,
            file;
        if (!$mmApp.isOnline()) {
            return errorUploading($translate.instant('mm.fileuploader.errormustbeonlinetoupload'));
        }
        if (checkSize) {
            promise = $mmFS.getExternalFile(path).then(function(fileEntry) {
                return $mmFS.getFileObjectFromFileEntry(fileEntry).then(function(f) {
                    file = f;
                    return file.size;
                });
            }).catch(function() {
            });
        } else {
            promise = $q.when(0);
        }
        return promise.then(function(size) {
            if (maxSize != -1 && size > maxSize) {
                return self.errorMaxBytes(maxSize, file.name);
            }
            if (size > 0) {
                return self.confirmUploadFile(size);
            }
        }).then(function() {
            scope = $rootScope.$new();
            modal = $mmUtil.showModalLoadingWithTemplate(progressTemplate, {scope: scope});
            return uploadFn.apply(undefined, Array.prototype.slice.call(args, 5)).then(undefined, undefined, function(progress) {
                if (progress && progress.lengthComputable) {
                    var perc = parseFloat(Math.min((progress.loaded / progress.total) * 100, 100)).toFixed(1);
                    if (perc >= 0) {
                        scope.perc = perc;
                    }
                }
            }).catch(function(error) {
                $log.error('Error uploading file: '+JSON.stringify(error));
                modal.dismiss();
                if (typeof error != 'string') {
                    error = $translate.instant('mm.fileuploader.errorwhileuploading');
                }
                return errorUploading(error);
            }).finally(function() {
                modal.dismiss();
                scope.$destroy();
            });
        });
        function errorUploading(error) {
            var options = {
                okText: retryStr
            };
            return $mmUtil.showConfirm(error, errorStr, options).then(function() {
                return uploadFile.apply(undefined, args);
            }, function() {
                if (deleteAfterUpload) {
                    $mmFS.removeExternalFile(path);
                }
                return $q.reject();
            });
        }
    }
    return self;
}]);

angular.module('mm.core.grades')
.controller('mmGradesGradeCtrl', ["$scope", "$stateParams", "$mmUtil", "$mmGrades", "$mmSite", "$mmGradesHelper", "$log", function($scope, $stateParams, $mmUtil, $mmGrades, $mmSite, $mmGradesHelper, $log) {
    $log = $log.getInstance('mmGradesGradeCtrl');
    var courseId = $stateParams.courseid,
        userId = $stateParams.userid || $mmSite.getUserId();
    function fetchGrade() {
        return $mmGrades.getGradesTable(courseId, userId).then(function(table) {
            $scope.grade = $mmGradesHelper.getGradeRow(table, $stateParams.gradeid);
        }, function(message) {
            $mmUtil.showErrorModal(message);
            $scope.errormessage = message;
        });
    }
    fetchGrade().finally(function() {
        $scope.gradeLoaded = true;
    });
    $scope.refreshGrade = function() {
        fetchGrade().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
    $scope.refreshGrade = function() {
        $mmGrades.invalidateGradesTableData(courseId, userId).finally(function() {
            fetchGrade().finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.core.grades')
.controller('mmGradesTableCtrl', ["$scope", "$stateParams", "$mmUtil", "$mmGrades", "$mmSite", "$mmGradesHelper", "$state", function($scope, $stateParams, $mmUtil, $mmGrades, $mmSite, $mmGradesHelper, $state) {
    var course = $stateParams.course || {},
        courseId = $stateParams.courseid || course.id,
        userId = $stateParams.userid || $mmSite.getUserId(),
        forcePhoneView = $stateParams.forcephoneview || false;
    $scope.forcePhoneView = !!forcePhoneView;
    function fetchGrades() {
        return $mmGrades.getGradesTable(courseId, userId).then(function(table) {
            table = $mmGradesHelper.formatGradesTable(table, forcePhoneView);
            return $mmGradesHelper.translateGradesTable(table).then(function(table) {
                $scope.gradesTable = table;
            });
        }, function(message) {
            $mmUtil.showErrorModal(message);
            $scope.errormessage = message;
        });
    }
    fetchGrades().then(function() {
        $mmSite.write('gradereport_user_view_grade_report', {
            courseid: courseId,
            userid: userId
        });
    }).finally(function() {
        $scope.gradesLoaded = true;
    });
    $scope.expandGradeInfo = function(gradeid) {
        if (gradeid) {
            $state.go('site.grade', {
                courseid: courseId,
                userid: userId,
                gradeid: gradeid
            });
        }
    };
    $scope.refreshGrades = function() {
        $mmGrades.invalidateGradesTableData(courseId, userId).finally(function() {
            fetchGrades().finally(function() {
                $scope.$broadcast('scroll.refreshComplete');
            });
        });
    };
}]);

angular.module('mm.core.grades')
.factory('$mmGrades', ["$q", "$log", "$mmSite", "$mmCourses", "$mmSitesManager", "$mmUtil", "$mmText", function($q, $log, $mmSite, $mmCourses, $mmSitesManager, $mmUtil, $mmText) {
    $log = $log.getInstance('$mmGrades');
    var self = {};
    function getGradesTableCacheKey(courseId, userId) {
        return getGradesTablePrefixCacheKey(courseId) + userId;
    }
    function getGradeItemsCacheKey(courseId, userId, groupId) {
        groupId = groupId || 0;
        return getGradeItemsPrefixCacheKey(courseId) + userId + ':' + groupId;
    }
    function getGradesTablePrefixCacheKey(courseId) {
        return 'mmGrades:table:' + courseId + ':';
    }
    function getGradeItemsPrefixCacheKey(courseId) {
        return 'mmGrades:items:' + courseId + ':';
    }
    self.invalidateGradesTableData = function(courseId, userId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            return site.invalidateWsCacheForKey(getGradesTableCacheKey(courseId, userId));
        });
    };
    self.invalidateGradeItemsData = function(courseId, userId, groupId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKey(getGradeItemsCacheKey(courseId, userId, groupId));
        });
    };
    self.invalidateGradesTableCourseData = function(courseId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKeyStartingWith(getGradesTablePrefixCacheKey(courseId));
        });
    };
    self.invalidateGradeCourseItemsData = function(courseId, siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.invalidateWsCacheForKeyStartingWith(getGradeItemsPrefixCacheKey(courseId));
        });
    };
    self.isPluginEnabled = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.wsAvailable('gradereport_user_get_grades_table');
        });
    };
    self.isPluginEnabledForCourse = function(courseId, siteId) {
        if (!courseId) {
            return $q.reject();
        }
        return $mmCourses.getUserCourse(courseId, true, siteId).then(function(course) {
            if (course && typeof course.showgrades != 'undefined' && course.showgrades == 0) {
                return false;
            }
            return true;
        });
    };
    self.isGradeItemsAvalaible = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.wsAvailable('gradereport_user_get_grade_items');
        });
    };
    self.isPluginEnabledForUser = function(courseId, userId) {
        var data = {
                courseid: courseId,
                userid: userId
            };
        return $mmSite.read('gradereport_user_get_grades_table', data, {}).then(function() {
            return true;
        }).catch(function() {
            return false;
        });
    };
    self.getGradesTable = function(courseId, userId, siteId, ignoreCache) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            $log.debug('Get grades for course ' + courseId + ' and user ' + userId);
            var data = {
                    courseid : courseId,
                    userid   : userId
                },
                preSets = {
                    cacheKey: getGradesTableCacheKey(courseId, userId)
                };
            if (ignoreCache) {
                preSets.getFromCache = 0;
                preSets.emergencyCache = 0;
            }
            return site.read('gradereport_user_get_grades_table', data, preSets).then(function (table) {
                if (table && table.tables && table.tables[0]) {
                    return table.tables[0];
                }
                return $q.reject();
            });
        });
    };
    self.getGradeItems = function(courseId, userId, groupId, siteId, ignoreCache) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            $log.debug('Get grades for course ' + courseId + ', user ' + userId);
            var data = {
                    courseid : courseId,
                    userid   : userId,
                    groupid  : groupId || 0
                },
                preSets = {
                    cacheKey: getGradeItemsCacheKey(courseId, userId, groupId)
                };
            if (ignoreCache) {
                preSets.getFromCache = 0;
                preSets.emergencyCache = 0;
            }
            return site.read('gradereport_user_get_grade_items', data, preSets).then(function(grades) {
                if (grades && grades.usergrades && grades.usergrades[0]) {
                    return grades.usergrades[0];
                }
                return $q.reject();
            });
        });
    };
    function getGradeModuleItems(courseId, moduleId, userId, groupId, siteId, ignoreCache) {
        return self.getGradeItems(courseId, userId, groupId, siteId, ignoreCache).then(function(grades) {
            if (grades && grades.gradeitems) {
                var items = [];
                for (var x in grades.gradeitems) {
                    if (grades.gradeitems[x].cmid == moduleId) {
                        items.push(grades.gradeitems[x]);
                    }
                }
                if (items.length > 0) {
                    return items;
                }
            }
            return $q.reject();
        });
    }
    function getGradesItemFromTable(courseId, moduleId, userId, siteId, ignoreCache) {
        return self.getGradesTable(courseId, userId, siteId, ignoreCache).then(function(table) {
            var regex = /href="([^"]*\/mod\/[^"|^\/]*\/[^"|^\.]*\.php[^"]*)/, 
                matches,
                hrefParams,
                entry,
                items = [];
            for (var i = 0; i < table.tabledata.length; i++) {
                entry = table.tabledata[i];
                if (entry.itemname && entry.itemname.content) {
                    matches = entry.itemname.content.match(regex);
                    if (matches && matches.length) {
                        hrefParams = $mmUtil.extractUrlParams(matches[1]);
                        if (hrefParams && hrefParams.id == moduleId) {
                            var item = {};
                            angular.forEach(entry, function(value, name) {
                                if (value && value.content) {
                                    switch (name) {
                                        case 'grade':
                                            var grade = parseFloat(value.content);
                                            if (!isNaN(grade)) {
                                                item.gradeformatted = grade;
                                            }
                                            break;
                                        case 'percentage':
                                        case 'range':
                                            name += 'formatted';
                                        default:
                                            item[name] = $mmText.decodeHTML(value.content).trim();
                                    }
                                }
                            });
                            items.push(item);
                        }
                    }
                }
            }
            if (items.length > 0) {
                return items;
            }
            return $q.reject();
        });
    }
    self.getGradeModuleItems = function(courseId, moduleId, userId, groupId, siteId, ignoreCache) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            return self.isGradeItemsAvalaible(siteId).then(function(enabled) {
                if (enabled) {
                    return getGradeModuleItems(courseId, moduleId, userId, groupId, siteId, ignoreCache).catch(function() {
                        return getGradesItemFromTable(courseId, moduleId, userId, siteId, ignoreCache);
                    });
                } else {
                    return getGradesItemFromTable(courseId, moduleId, userId, siteId, ignoreCache);
                }
            });
        });
    };
    self.invalidateGradeModuleItems = function(courseId, userId, groupId, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            userId = userId || site.getUserId();
            return self.isGradeItemsAvalaible(siteId).then(function(enabled) {
                if (enabled) {
                    return self.invalidateGradeItemsData(courseId, userId, groupId, siteId);
                } else {
                    return self.invalidateGradesTableData(courseId, userId, siteId);
                }
            });
        });
    };
    self.invalidateGradeCourseItems = function(courseId, siteId) {
        siteId = siteId || $mmSite.getId();
        return self.isGradeItemsAvalaible(siteId).then(function(enabled) {
            if (enabled) {
                return self.invalidateGradeCourseItemsData(courseId, siteId);
            } else {
                return self.invalidateGradesTableCourseData(courseId, siteId);
            }
        });
    };
    return self;
}]);

angular.module('mm.core.grades')
.factory('$mmGradesHelper', ["$q", "$mmText", "$translate", "$mmCourse", "$sce", "$mmUtil", function($q, $mmText, $translate, $mmCourse, $sce, $mmUtil) {
    var self = {};
    self.formatGradesTable = function(table, forcePhoneView) {
        var formatted = {
            columns: [],
            rows: []
        };
        var columns = {
            itemname: true,
            weight: false,
            grade: false,
            range: false,
            percentage: false,
            lettergrade: false,
            rank: false,
            average: false,
            feedback: false,
            contributiontocoursetotal: false
        };
        var returnedColumns = [];
        var tabledata = [];
        var maxDepth = 0;
        if (table['tabledata']) {
            tabledata = table['tabledata'];
            maxDepth = table['maxdepth'];
            for (var el in tabledata) {
                if (!angular.isArray(tabledata[el]) && typeof(tabledata[el]["leader"]) === "undefined") {
                    for (var col in tabledata[el]) {
                        returnedColumns.push(col);
                    }
                    break;
                }
            }
        }
        if (returnedColumns.length > 0) {
            var columnAdded = false;
            for (var i = 0; i < tabledata.length && !columnAdded; i++) {
                if (typeof(tabledata[i]["grade"]) != "undefined" &&
                        typeof(tabledata[i]["grade"]["content"]) != "undefined") {
                    columns.grade = true;
                    columnAdded = true;
                } else if (typeof(tabledata[i]["percentage"]) != "undefined" &&
                        typeof(tabledata[i]["percentage"]["content"]) != "undefined") {
                    columns.percentage = true;
                    columnAdded = true;
                }
            }
            if (!columnAdded) {
                columns.grade = true;
            }
            for (var colName in columns) {
                if (returnedColumns.indexOf(colName) > -1) {
                    var width = colName == "itemname" ? maxDepth : 1;
                    var column = {
                        id: colName,
                        name: colName,
                        width: width,
                        showAlways: columns[colName]
                    };
                    formatted.columns.push(column);
                }
            }
            var name, rowspan, tclass, colspan, content, celltype, id, headers, img;
            for (var i = 0; i < tabledata.length; i++) {
                var row = {};
                row.text = '';
                if (typeof(tabledata[i]['leader']) != "undefined") {
                    rowspan = tabledata[i]['leader']['rowspan'];
                    tclass = tabledata[i]['leader']['class'];
                    row.text += '<td class="' + tclass + '" rowspan="' + rowspan + '"></td>';
                }
                for (el in returnedColumns) {
                    name = returnedColumns[el];
                    if (forcePhoneView && !columns[name]) {
                        continue;
                    }
                    if (typeof(tabledata[i][name]) != "undefined") {
                        tclass = (typeof(tabledata[i][name]['class']) != "undefined")? tabledata[i][name]['class'] : '';
                        tclass += columns[name] ? '' : ' hidden-phone';
                        colspan = (typeof(tabledata[i][name]['colspan']) != "undefined")? "colspan='"+tabledata[i][name]['colspan']+"'" : '';
                        content = (typeof(tabledata[i][name]['content']) != "undefined")? tabledata[i][name]['content'] : null;
                        celltype = (typeof(tabledata[i][name]['celltype']) != "undefined")? tabledata[i][name]['celltype'] : 'td';
                        id = (typeof(tabledata[i][name]['id']) != "undefined")? "id='" + tabledata[i][name]['id'] +"'" : '';
                        headers = (typeof(tabledata[i][name]['headers']) != "undefined")? "headers='" + tabledata[i][name]['headers'] + "'" : '';
                        if (typeof(content) != "undefined") {
                            img = getImgHTML(content);
                            content = content.replace(/<\/span>/gi, "\n");
                            content = $mmText.cleanTags(content);
                            content = $mmText.replaceNewLines(content, '<br>');
                            content = img + " " + content;
                            row.text += "<" + celltype + " " + id + " " + headers + " " + "class='"+ tclass +"' " + colspan +">";
                            row.text += content;
                            row.text += "</" + celltype + ">";
                        }
                    }
                }
                if (row.text.length > 0) {
                    if (tabledata[i].itemname && tabledata[i].itemname.id && tabledata[i].itemname.id.substr(0, 3) == 'row') {
                        row.id = tabledata[i].itemname.id.split('_')[1];
                    }
                    row.text = $sce.trustAsHtml(row.text);
                }
                formatted.rows.push(row);
            }
        }
        return formatted;
    };
    self.getGradeRow = function(table, gradeid) {
        var row = {},
            selectedRow = false;
        if (table['tabledata']) {
            var tabledata = table['tabledata'];
            for (var i = 0; i < tabledata.length; i++) {
                if (tabledata[i].itemname && tabledata[i].itemname.id && tabledata[i].itemname.id.substr(0, 3) == 'row') {
                    if (tabledata[i].itemname.id.split('_')[1] == gradeid) {
                        selectedRow = tabledata[i];
                        break;
                    }
                }
            }
        }
        if (!selectedRow) {
            return "";
        }
        for (var name in selectedRow) {
            if (typeof(selectedRow[name]) != "undefined" && typeof(selectedRow[name]['content']) != "undefined") {
                var content = selectedRow[name]['content'];
                if (name == 'itemname') {
                    var img = getImgHTML(content);
                    row.link = getModuleLink(content);
                    content = content.replace(/<\/span>/gi, "\n");
                    content = $mmText.cleanTags(content);
                    content = img + " " + content;
                } else {
                    content = $mmText.replaceNewLines(content, '<br>');
                }
                if (content == '&nbsp;') {
                    content = "";
                }
                row[name] = content.trim();
            }
        }
        return row;
    };
    function getImgHTML(text) {
        var img = '';
        text = text.replace("%2F", "/").replace("%2f", "/");
        if (text.indexOf("/agg_mean") > -1) {
            img = '<img src="core/components/grades/img/agg_mean.png" width="16">';
        } else if (text.indexOf("/agg_sum") > -1) {
            img = '<img src="core/components/grades/img/agg_sum.png" width="16">';
        } else if (text.indexOf("/outcomes") > -1) {
            img = '<img src="core/components/grades/img/outcomes.png" width="16">';
        } else if (text.indexOf("i/folder") > -1) {
            img = '<img src="core/components/grades/img/folder.png" width="16">';
        } else if (text.indexOf("/manual_item") > -1) {
            img = '<img src="core/components/grades/img/manual_item.png" width="16">';
        } else if (text.indexOf("/mod/") > -1) {
            var module = text.match(/mod\/([^\/]*)\//);
            if (typeof module[1] != "undefined") {
                var moduleSrc = $mmCourse.getModuleIconSrc(module[1]);
                img = '<img src="' + moduleSrc + '" width="16">';
            }
        }
        if (img) {
            img = '<span class="app-ico">' + img + '</span>';
        }
        return img;
    }
    function getModuleLink(text) {
        var el = angular.element(text)[0],
            link = el.attributes['href'] ? el.attributes['href'].value : false;
        if (!link || link.indexOf("/mod/") < 0) {
            return false;
        }
        return link;
    }
    self.translateGradesTable = function(table) {
        var columns = angular.copy(table.columns),
            promises = [];
        columns.forEach(function(column) {
            var promise = $translate('mm.grades.'+column.name).then(function(translated) {
                column.name = translated;
            });
            promises.push(promise);
        });
        return $q.all(promises).then(function() {
            return {
                columns: columns,
                rows: table.rows
            };
        });
    };
    self.makeGradesMenu = function(gradingType, moduleId, defaultLabel, defaultValue, scale) {
        gradingType = parseInt(gradingType, 10);
        defaultValue = defaultValue || '';
        if (gradingType < 0) {
            if (scale) {
                return $q.when($mmUtil.makeMenuFromList(scale, defaultLabel, false, defaultValue));
            } else {
                return $mmCourse.getModuleBasicGradeInfo(moduleId).then(function(gradeInfo) {
                    if (gradeInfo.scale) {
                        return $mmUtil.makeMenuFromList(gradeInfo.scale, defaultLabel, false,  defaultValue);
                    }
                    return [];
                });
            }
        }
        if (gradingType > 0) {
            var grades = [];
            if (defaultLabel) {
                grades.push({
                    label: defaultLabel,
                    value: defaultValue
                });
            }
            for (var i = gradingType; i >= 0; i--) {
                 grades.push({
                    label: i +' / '+ gradingType,
                    value: i
                });
            }
            return $q.when(grades);
        }
        return $q.when([]);
    };
    self.getGradeLabelFromValue = function(grades, selectedGrade) {
        selectedGrade = parseInt(selectedGrade, 10);
        if (!grades || !selectedGrade || selectedGrade <= 0) {
            return "";
        }
        for (var x in grades) {
            if (grades[x].value == selectedGrade) {
                return grades[x].label;
            }
        }
        return "";
    };
    self.getGradeValueFromLabel = function(grades, selectedGrade) {
        if (!grades || !selectedGrade) {
            return 0;
        }
        for (var x in grades) {
            if (grades[x].label == selectedGrade) {
                return grades[x].value < 0 ? 0 : grades[x].value;
            }
        }
        return 0;
    };
    return self;
}]);

angular.module('mm.core.login')
.controller('mmLoginCredentialsCtrl', ["$scope", "$stateParams", "$mmSitesManager", "$mmUtil", "$ionicHistory", "$mmApp", "$mmEvents", "$q", "$mmLoginHelper", "$mmContentLinksDelegate", "$mmContentLinksHelper", "$translate", "mmCoreLoginSiteCheckedEvent", "$state", "mmCoreLoginSiteUncheckedEvent", function($scope, $stateParams, $mmSitesManager, $mmUtil, $ionicHistory, $mmApp, $mmEvents,
            $q, $mmLoginHelper, $mmContentLinksDelegate, $mmContentLinksHelper, $translate, mmCoreLoginSiteCheckedEvent, $state,
            mmCoreLoginSiteUncheckedEvent) {
    $scope.siteurl = $stateParams.siteurl;
    $scope.credentials = {
        username: $stateParams.username
    };
    $scope.siteChecked = false;
    var urlToOpen = $stateParams.urltoopen,
        siteConfig = $stateParams.siteconfig,
        eventThrown = false,
        siteId;
    treatSiteConfig(siteConfig);
    function checkSite(siteurl) {
        $scope.pageLoaded = false;
        var protocol = siteurl.indexOf('http://') === 0 ? 'http://' : undefined;
        return $mmSitesManager.checkSite(siteurl, protocol).then(function(result) {
            $scope.siteChecked = true;
            $scope.siteurl = result.siteurl;
            siteConfig = result.config;
            treatSiteConfig(result.config);
            if (result && result.warning) {
                $mmUtil.showErrorModal(result.warning, true, 4000);
            }
            if ($mmLoginHelper.isSSOLoginNeeded(result.code)) {
                $scope.isBrowserSSO = true;
                if (!$mmApp.isSSOAuthenticationOngoing() && !$scope.$$destroyed) {
                    $mmLoginHelper.confirmAndOpenBrowserForSSOLogin(
                                result.siteurl, result.code, result.service, result.config && result.config.launchurl);
                }
            } else {
                $scope.isBrowserSSO = false;
            }
        }).catch(function(error) {
            $mmUtil.showErrorModal(error);
            return $q.reject();
        }).finally(function() {
            $scope.pageLoaded = true;
        });
    }
    function treatSiteConfig(siteConfig) {
        if (siteConfig) {
            $scope.sitename = siteConfig.sitename;
            $scope.logourl = siteConfig.logourl || siteConfig.compactlogourl;
            $scope.authInstructions = siteConfig.authinstructions || $translate.instant('mm.login.loginsteps');
            $scope.canSignup = siteConfig.registerauth == 'email' && !$mmLoginHelper.isEmailSignupDisabled(siteConfig);
            $scope.identityProviders = $mmLoginHelper.getValidIdentityProviders(siteConfig);
            if (!eventThrown && !$scope.$$destroyed) {
                eventThrown = true;
                $mmEvents.trigger(mmCoreLoginSiteCheckedEvent, {
                    config: siteConfig
                });
            }
        } else {
            $scope.sitename = null;
            $scope.logourl = null;
            $scope.authInstructions = null;
            $scope.canSignup = false;
            $scope.identityProviders = [];
        }
    }
    if ($mmLoginHelper.isFixedUrlSet()) {
        checkSite($scope.siteurl);
    } else {
        $scope.siteChecked = true;
        $scope.pageLoaded = true;
    }
    $scope.login = function() {
        $mmApp.closeKeyboard();
        var siteurl = $scope.siteurl,
            username = $scope.credentials.username,
            password = $scope.credentials.password;
        if (!$scope.siteChecked) {
            return checkSite(siteurl).then(function() {
                if (!$scope.isBrowserSSO) {
                    return $scope.login();
                }
            });
        } else if ($scope.isBrowserSSO) {
            return checkSite(siteurl);
        }
        if (!username) {
            $mmUtil.showErrorModal('mm.login.usernamerequired', true);
            return;
        }
        if (!password) {
            $mmUtil.showErrorModal('mm.login.passwordrequired', true);
            return;
        }
        if (!$mmApp.isOnline()) {
            $mmUtil.showErrorModal('mm.core.networkerrormsg', true);
            return;
        }
        var modal = $mmUtil.showModalLoading();
        return $mmSitesManager.getUserToken(siteurl, username, password).then(function(data) {
            return $mmSitesManager.newSite(data.siteurl, data.token, data.privatetoken).then(function(id) {
                delete $scope.credentials; 
                $ionicHistory.nextViewOptions({disableBack: true});
                siteId = id;
                if (urlToOpen) {
                    return $mmContentLinksDelegate.getActionsFor(urlToOpen, undefined, username).then(function(actions) {
                        action = $mmContentLinksHelper.getFirstValidAction(actions);
                        if (action && action.sites.length) {
                            action.action(action.sites[0]);
                        } else {
                            return $mmLoginHelper.goToSiteInitialPage();
                        }
                    });
                } else {
                    return $mmLoginHelper.goToSiteInitialPage();
                }
            });
        }).catch(function(error) {
            $mmLoginHelper.treatUserTokenError(siteurl, error);
        }).finally(function() {
            modal.dismiss();
        });
    };
    $scope.forgottenPassword = function() {
        if (siteConfig && siteConfig.forgottenpasswordurl) {
            return $mmUtil.openInApp(siteConfig.forgottenpasswordurl);
        }
        var modal = $mmUtil.showModalLoading();
        $mmLoginHelper.canRequestPasswordReset($scope.siteurl).then(function(canReset) {
            if (canReset) {
                $state.go('mm_login.forgottenpassword', {
                    siteurl: $scope.siteurl,
                    username: $scope.credentials.username
                });
            } else {
                $mmLoginHelper.openForgottenPassword($scope.siteurl);
            }
        }).finally(function() {
            modal.dismiss();
        });
    };
    $scope.oauthClicked = function(provider) {
        if (!$mmLoginHelper.openBrowserForOAuthLogin($scope.siteurl, provider, siteConfig.launchurl)) {
            $mmUtil.showErrorModal('Invalid data.');
        }
    };
    $scope.$on('$destroy', function() {
        $mmEvents.trigger(mmCoreLoginSiteUncheckedEvent, {
            siteid: siteId,
            config: siteConfig
        });
    });
}]);

angular.module('mm.core.login')
.controller('mmLoginEmailSignupCtrl', ["$scope", "$stateParams", "$mmUtil", "$ionicHistory", "$mmLoginHelper", "$mmWS", "$q", "$translate", "$ionicModal", "$ionicScrollDelegate", "$mmUserProfileFieldsDelegate", "$mmSitesManager", "$mmText", function($scope, $stateParams, $mmUtil, $ionicHistory, $mmLoginHelper, $mmWS, $q, $translate,
            $ionicModal, $ionicScrollDelegate, $mmUserProfileFieldsDelegate, $mmSitesManager, $mmText) {
    var siteConfig,
        modalInitialized = false,
        scrollView = $ionicScrollDelegate.$getByHandle('mmLoginEmailSignupScroll'),
        recaptchaV1Enabled = false;
    $scope.siteurl = $stateParams.siteurl;
    $scope.data = {};
    $scope.verifyAgeData = {};
    $scope.isMinor = false;
    $scope.escapeForRegex = $mmText.escapeForRegex;
    $scope.usernameErrors = $mmLoginHelper.getErrorMessages('mm.login.usernamerequired');
    $scope.passwordErrors = $mmLoginHelper.getErrorMessages('mm.login.passwordrequired');
    $scope.emailErrors = $mmLoginHelper.getErrorMessages('mm.login.missingemail');
    $scope.email2Errors = $mmLoginHelper.getErrorMessages('mm.login.missingemail', null, 'mm.login.emailnotmatch');
    $scope.policyErrors = $mmLoginHelper.getErrorMessages('mm.login.policyagree');
    function fetchData() {
        return $mmSitesManager.getSitePublicConfig($scope.siteurl).then(function(config) {
            siteConfig = config;
            if (treatSiteConfig(siteConfig)) {
                if (typeof $scope.ageDigitalConsentVerification === 'undefined') {
                    return $mmWS.callAjax('core_auth_is_age_digital_consent_verification_enabled',
                            {}, {siteurl: $scope.siteurl }).then(function(ageDigitalConsentVerification) {
                        $scope.ageDigitalConsentVerification = ageDigitalConsentVerification.status;
                    }).catch(function(e) {
                    }).finally(function() {
                        return getSignupSettings();
                    });
                } else {
                    return getSignupSettings();
                }
            }
        }).catch(function(err) {
            $mmUtil.showErrorModal(err);
            return $q.reject();
        });
    }
    function treatSiteConfig(siteConfig) {
        if (siteConfig && siteConfig.registerauth == 'email' && !$mmLoginHelper.isEmailSignupDisabled(siteConfig)) {
            $scope.sitename = siteConfig.sitename;
            $scope.authInstructions = siteConfig.authinstructions;
            $scope.ageDigitalConsentVerification = siteConfig.agedigitalconsentverification;
            $scope.supportName = siteConfig.supportname;
            $scope.supportEmail = siteConfig.supportemail;
            $scope.verifyAgeData.country = siteConfig.country;
            initAuthInstructionsModal();
            return true;
        } else {
            $mmUtil.showErrorModal($translate.instant('mm.login.signupplugindisabled',
                    {$a: $translate.instant('mm.login.auth_email')}));
            $ionicHistory.goBack();
            return false;
        }
    }
    function getSignupSettings() {
        return $mmWS.callAjax('auth_email_get_signup_settings', {}, {siteurl: $scope.siteurl}).then(function(settings) {
            $scope.settings = settings;
            $scope.countries = $mmUtil.getCountryList();
            $scope.categories = $mmLoginHelper.formatProfileFieldsForSignup(settings.profilefields);
            recaptchaV1Enabled = !!(settings.recaptchapublickey && settings.recaptchachallengehash &&
                    settings.recaptchachallengeimage);
            if (settings.defaultcity && !$scope.data.city) {
                $scope.data.city = settings.defaultcity;
            }
            if (settings.country && !$scope.data.country) {
                $scope.data.country = settings.country;
            }
            if (recaptchaV1Enabled) {
                $scope.data.recaptcharesponse = ''; 
            }
            if (!$scope.verifyAgeData.country) {
                $scope.verifyAgeData.country = $scope.data.country;
            }
            $scope.namefieldsErrors = {};
            angular.forEach(settings.namefields, function(field) {
                $scope.namefieldsErrors[field] = $mmLoginHelper.getErrorMessages('mm.login.missing' + field);
            });
        });
    }
    function initAuthInstructionsModal() {
        if ($scope.authInstructions && !modalInitialized) {
            $ionicModal.fromTemplateUrl('core/components/login/templates/authinstructions-modal.html', {
                scope: $scope,
                animation: 'slide-in-up'
            }).then(function(modal) {
                modalInitialized = true;
                $scope.showAuthInstructions = function() {
                    modal.show();
                };
                $scope.closeAuthInstructions = function() {
                    modal.hide();
                };
                $scope.$on('$destroy', function() {
                    modal.remove();
                });
            });
        }
    }
    fetchData().finally(function() {
        $scope.settingsLoaded = true;
    });
    $scope.refreshSettings = function() {
        fetchData().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
    $scope.requestCaptchaV1 = function(ignoreError) {
        var modal = $mmUtil.showModalLoading();
        getSignupSettings().catch(function(err) {
            if (!ignoreError && err) {
                $mmUtil.showErrorModal(err);
            }
            return $q.reject();
        }).finally(function() {
            modal.dismiss();
        });
    };
    $scope.create = function(signupForm) {
        if (!signupForm.$valid) {
            return $mmUtil.scrollToInputError(document, scrollView).then(function(found) {
                if (!found) {
                    $mmUtil.showErrorModal('mm.core.errorinvalidform', true);
                }
            });
        } else {
            var fields = $scope.settings.profilefields,
                params = {
                    username: $scope.data.username.trim().toLowerCase(),
                    password: $scope.data.password,
                    firstname: $mmText.cleanTags($scope.data.firstname),
                    lastname: $mmText.cleanTags($scope.data.lastname),
                    email: $scope.data.email.trim(),
                    city: $mmText.cleanTags($scope.data.city),
                    country: $scope.data.country
                },
                modal = $mmUtil.showModalLoading('mm.core.sending', true);
            if (siteConfig.launchurl) {
                var service = $mmSitesManager.determineService($scope.siteurl);
                params.redirect = $mmLoginHelper.prepareForSSOLogin($scope.siteurl, service, siteConfig.launchurl);
            }
            if ($scope.data.recaptcharesponse) {
                params.recaptcharesponse = $scope.data.recaptcharesponse;
            }
            if ($scope.settings.recaptchachallengehash) {
                params.recaptchachallengehash = $scope.settings.recaptchachallengehash;
            }
            $mmUserProfileFieldsDelegate.getDataForFields(fields, true, 'email', $scope.data).then(function(fieldsData) {
                params.customprofilefields = fieldsData;
                return $mmWS.callAjax('auth_email_signup_user', params, {siteurl: $scope.siteurl}).then(function(result) {
                    if (result.success) {
                        var message = $translate.instant('mm.login.emailconfirmsent', {$a: $scope.data.email});
                        $mmUtil.showModal('mm.core.success', message);
                        $ionicHistory.goBack();
                    } else {
                        if (result.warnings && result.warnings.length) {
                            var error = result.warnings[0].message;
                            if (error == 'incorrect-captcha-sol') {
                                error = $translate.instant('mm.login.recaptchaincorrect');
                            }
                            $mmUtil.showErrorModal(error);
                        } else {
                            $mmUtil.showErrorModal('mm.login.usernotaddederror', true);
                        }
                        if (recaptchaV1Enabled) {
                            $scope.requestCaptchaV1(true);
                        } else {
                            $scope.$broadcast('mmCore:ResetRecaptchaV2');
                        }
                    }
                });
            }).catch(function(error) {
                $mmUtil.showErrorModalDefault(error && error.error, 'mm.login.usernotaddederror', true);
                if (recaptchaV1Enabled) {
                    $scope.requestCaptchaV1(true);
                } else {
                    $scope.$broadcast('mmCore:ResetRecaptchaV2');
                }
            }).finally(function() {
                modal.dismiss();
            });
        }
    };
    $scope.verifyAge = function(verifyAgeForm) {
        if (verifyAgeForm.$valid) {
            var modal = $mmUtil.showModalLoading();
            params = {
                age: parseInt($scope.verifyAgeData.age),    
                country: $scope.verifyAgeData.country
            };
            $mmWS.callAjax('core_auth_is_minor', params, {siteurl: $scope.siteurl}).then(function(result) {
                if (!result.status) {
                    $scope.ageDigitalConsentVerification = false;
                } else {
                    $scope.isMinor = true;
                }
            }).catch(function() {
                $mmUtil.showErrorModal('There was an error verifying your age, please try again using the browser.');
            }).finally(function() {
                modal.dismiss();
            });
        }
    };
    $scope.showContactOnSite = function() {
        $mmUtil.openInBrowser($scope.siteurl + '/login/verify_age_location.php');
    };
}]);

angular.module('mm.core.login')
.controller('mmLoginForgottenPasswordCtrl', ["$scope", "$stateParams", "$q", "$mmUtil", "$mmLoginHelper", "$ionicHistory", function($scope, $stateParams, $q, $mmUtil, $mmLoginHelper, $ionicHistory) {
    $scope.siteurl = $stateParams.siteurl;
    $scope.data = {
        field: 'username',
        value: $stateParams.username || ''
    };
    $scope.resetPassword = function(field, value) {
        if (!value) {
            $mmUtil.showErrorModal('mm.login.usernameoremail', true);
            return;
        }
        var modal = $mmUtil.showModalLoading('mm.core.sending', true),
            isMail = field == 'email';
        $mmLoginHelper.requestPasswordReset($scope.siteurl, isMail ? '' : value, isMail ? value : '').then(function(response) {
            if (response.status == 'dataerror') {
                showError(isMail, response.warnings);
            } else if (response.status == 'emailpasswordconfirmnotsent' || response.status == 'emailpasswordconfirmnoemail') {
                $mmUtil.showErrorModal(response.notice);
            } else {
                $mmUtil.showModal('mm.core.success', response.notice);
                $ionicHistory.goBack();
            }
        }).catch(function(error) {
            $mmUtil.showErrorModal(error.error);
            return $q.reject();
        }).finally(function() {
            modal.dismiss();
        });
    };
    function showError(isMail, warnings) {
        for (var i = 0; i < warnings.length; i++) {
            var warning = warnings[i];
            if ((warning.item == 'email' && isMail) || (warning.item == 'username' && !isMail)) {
                $mmUtil.showErrorModal(warning.message);
                break;
            }
        }
    }
}]);

angular.module('mm.core.login')
.controller('mmLoginInitCtrl', ["$log", "$ionicHistory", "$state", "$mmSitesManager", "$mmSite", "$mmApp", "$mmLoginHelper", "mmCoreNoSiteId", function($log, $ionicHistory, $state, $mmSitesManager, $mmSite, $mmApp, $mmLoginHelper,
            mmCoreNoSiteId) {
    $log = $log.getInstance('mmLoginInitCtrl');
    $mmApp.ready().then(function() {
        $ionicHistory.nextViewOptions({
            disableAnimate: true,
            disableBack: true
        });
        var redirectData = $mmApp.getRedirect();
        if (redirectData.siteid && redirectData.state) {
            $mmApp.storeRedirect('', '', '');
            if (new Date().getTime() - redirectData.timemodified < 20000) {
                if (redirectData.siteid != mmCoreNoSiteId) {
                    return $mmSitesManager.loadSite(redirectData.siteid).then(function() {
                        if (!$mmLoginHelper.isSiteLoggedOut(redirectData.state, redirectData.params)) {
                            $state.go(redirectData.state, redirectData.params);
                        }
                    }).catch(function() {
                        loadCurrent();
                    });
                } else {
                    return $state.go(redirectData.state, redirectData.params);
                }
            }
        }
        loadCurrent();
    });
    function loadCurrent() {
        if ($mmSite.isLoggedIn()) {
            if (!$mmLoginHelper.isSiteLoggedOut()) {
                $mmLoginHelper.goToSiteInitialPage();
            }
        } else {
            $mmSitesManager.hasSites().then(function() {
                return $state.go('mm_login.sites');
            }, function() {
                return $mmLoginHelper.goToAddSite();
            });
        }
    }
}]);

angular.module('mm.core.login')
.controller('mmLoginReconnectCtrl', ["$scope", "$state", "$stateParams", "$mmSitesManager", "$mmApp", "$mmUtil", "$ionicHistory", "$mmLoginHelper", "$mmSite", function($scope, $state, $stateParams, $mmSitesManager, $mmApp, $mmUtil, $ionicHistory,
            $mmLoginHelper, $mmSite) {
    var infositeurl = $stateParams.infositeurl, 
        stateName = $stateParams.statename,
        stateParams = $stateParams.stateparams,
        siteConfig = $stateParams.siteconfig;
    $scope.siteurl = $stateParams.siteurl;
    $scope.credentials = {
        username: $stateParams.username,
        password: ''
    };
    $scope.isLoggedOut = $mmSite.isLoggedOut();
    $mmSitesManager.getSite($stateParams.siteid).then(function(site) {
        $scope.site = {
            id: site.id,
            fullname: site.infos.fullname,
            avatar: site.infos.userpictureurl
        };
        $scope.credentials.username = site.infos.username;
        $scope.siteurl = site.infos.siteurl;
        $scope.sitename = site.infos.sitename;
        if ($scope.site.avatar.startsWith(site.infos.siteurl + '/theme/image.php')) {
            $scope.site.avatar = false;
            return site.getPublicConfig().then(function(config) {
                $scope.logourl = config.logourl || config.compactlogourl;
            });
        }
    });
    if (siteConfig) {
        $scope.identityProviders = $mmLoginHelper.getValidIdentityProviders(siteConfig);
    }
    $scope.cancel = function() {
        $mmSitesManager.logout().finally(function() {
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $state.go('mm_login.sites');
        });
    };
    $scope.login = function() {
        $mmApp.closeKeyboard();
        var siteurl = $scope.siteurl,
            username = $scope.credentials.username,
            password = $scope.credentials.password;
        if (!password) {
            $mmUtil.showErrorModal('mm.login.passwordrequired', true);
            return;
        }
        if (!$mmApp.isOnline()) {
            $mmUtil.showErrorModal('mm.core.networkerrormsg', true);
            return;
        }
        var modal = $mmUtil.showModalLoading();
        $mmSitesManager.getUserToken(siteurl, username, password).then(function(data) {
            $mmSitesManager.updateSiteToken(infositeurl, username, data.token, data.privatetoken).then(function() {
                $mmSitesManager.updateSiteInfoByUrl(infositeurl, username).finally(function() {
                    delete $scope.credentials; 
                    $ionicHistory.nextViewOptions({disableBack: true});
                    if (stateName) {
                        return $state.go(stateName, stateParams);
                    } else {
                        return $mmLoginHelper.goToSiteInitialPage();
                    }
                });
            }, function() {
                $mmUtil.showErrorModal('mm.login.errorupdatesite', true);
                $scope.cancel();
            }).finally(function() {
                modal.dismiss();
            });
        }, function(error) {
            modal.dismiss();
            $mmLoginHelper.treatUserTokenError(siteurl, error);
        });
    };
    $scope.oauthClicked = function(provider) {
        if (!$mmLoginHelper.openBrowserForOAuthLogin($scope.siteurl, provider, siteConfig.launchurl)) {
            $mmUtil.showErrorModal('Invalid data.');
        }
    };
}]);

angular.module('mm.core.login')
.controller('mmLoginSiteCtrl', ["$scope", "$state", "$mmSitesManager", "$mmUtil", "$ionicHistory", "$mmApp", "$ionicModal", "$ionicPopup", "$mmLoginHelper", "$q", "mmCoreConfigConstants", function($scope, $state, $mmSitesManager, $mmUtil, $ionicHistory, $mmApp, $ionicModal, $ionicPopup,
        $mmLoginHelper, $q, mmCoreConfigConstants) {
    $scope.loginData = {
        siteurl: ''
    };
    $scope.connect = function(url) {
        $mmApp.closeKeyboard();
        if (!url) {
            $mmUtil.showErrorModal('mm.login.siteurlrequired', true);
            return;
        }
        if (!$mmApp.isOnline()) {
            $mmUtil.showErrorModal('mm.core.networkerrormsg', true);
            return;
        }
        var modal = $mmUtil.showModalLoading(),
            sitedata = $mmSitesManager.getDemoSiteData(url);
        if (sitedata) {
            $mmSitesManager.getUserToken(sitedata.url, sitedata.username, sitedata.password).then(function(data) {
                $mmSitesManager.newSite(data.siteurl, data.token, data.privatetoken).then(function() {
                    $ionicHistory.nextViewOptions({disableBack: true});
                    return $mmLoginHelper.goToSiteInitialPage();
                }, function(error) {
                    $mmUtil.showErrorModal(error);
                }).finally(function() {
                    modal.dismiss();
                });
            }, function(error) {
                modal.dismiss();
                $mmLoginHelper.treatUserTokenError(sitedata.url, error);
            });
        } else {
            $mmSitesManager.checkSite(url).then(function(result) {
                if (result.warning) {
                    $mmUtil.showErrorModal(result.warning, true, 4000);
                }
                if ($mmLoginHelper.isSSOLoginNeeded(result.code)) {
                    $mmLoginHelper.confirmAndOpenBrowserForSSOLogin(
                                result.siteurl, result.code, result.service, result.config && result.config.launchurl);
                } else {
                    $state.go('mm_login.credentials', {siteurl: result.siteurl, siteconfig: result.config});
                }
            }, function(error) {
                showLoginIssue(url, error);
            }).finally(function() {
                modal.dismiss();
            });
        }
    };
    if ($mmLoginHelper.hasSeveralFixedSites()) {
        $scope.fixedSites = $mmLoginHelper.getFixedSites();
        $scope.loginData.siteurl = $scope.fixedSites[0].url;
        $scope.displayAsButtons = mmCoreConfigConstants.multisitesdisplay == 'buttons';
    }
    $mmUtil.getDocsUrl().then(function(docsurl) {
        $scope.docsurl = docsurl;
    });
    function showLoginIssue(siteurl, issue) {
        $scope.loginData.siteurl = siteurl;
        $scope.issue = issue;
        var popup = $ionicPopup.show({
            templateUrl:  'core/components/login/templates/login-issue.html',
            scope: $scope,
            cssClass: 'mm-nohead mm-bigpopup'
        });
        $scope.closePopup = function() {
            popup.close();
        };
        return popup.then(function() {
            return $q.reject();
        });
    }
    $ionicModal.fromTemplateUrl('core/components/login/templates/help-modal.html', {
        scope: $scope,
        animation: 'slide-in-up'
    }).then(function(helpModal) {
        $scope.showHelp = function() {
            helpModal.show();
        };
        $scope.closeHelp = function() {
            helpModal.hide();
        };
        $scope.$on('$destroy', function() {
            helpModal.remove();
        });
    });
}]);

angular.module('mm.core.login')
.controller('mmLoginSitePolicyCtrl', ["$scope", "$state", "$stateParams", "$mmSitesManager", "$mmSite", "$mmUtil", "$ionicHistory", "$mmLoginHelper", "$mmWS", "$q", "$sce", "$mmFS", function($scope, $state, $stateParams, $mmSitesManager, $mmSite, $mmUtil, $ionicHistory,
            $mmLoginHelper, $mmWS, $q, $sce, $mmFS) {
    var siteId = $stateParams.siteid || $mmSite.getId();
    if (!siteId || siteId != $mmSite.getId() || !$mmSite.wsAvailable('core_user_agree_site_policy')) {
        cancel();
        return;
    }
    function fetchSitePolicy() {
        return $mmLoginHelper.getSitePolicy(siteId).then(function(sitePolicy) {
            $scope.sitePolicy = sitePolicy;
            return $mmUtil.getMimeTypeFromUrl($scope.sitePolicy).then(function(mimeType) {
                var extension = $mmFS.getExtension(mimeType, $scope.sitePolicy);
                $scope.showInline = extension == 'html' || extension == 'html';
                if ($scope.showInline) {
                    $scope.trustedSitePolicy = $sce.trustAsResourceUrl($scope.sitePolicy);
                }
            }).catch(function() {
                $scope.showInline = false;
            }).finally(function() {
                $scope.policyLoaded = true;
            });
        }).catch(function(error) {
            $mmUtil.showErrorModalDefault(error && error.error, 'Error getting site policy.');
            cancel();
        });
    }
    fetchSitePolicy();
    $scope.cancel = function() {
        cancel();
    };
    $scope.accept = function() {
        var modal = $mmUtil.showModalLoading('mm.core.sending', true);
        $mmLoginHelper.acceptSitePolicy(siteId).then(function() {
            return $mmSite.invalidateWsCache().catch(function() {
            }).then(function() {
                $ionicHistory.nextViewOptions({disableBack: true});
                return $mmLoginHelper.goToSiteInitialPage();
            });
        }).catch(function(error) {
            $mmUtil.showErrorModalDefault(error, 'Error accepting site policy.');
        }).finally(function() {
            modal.dismiss();
        });
    };
    function cancel() {
        $mmSitesManager.logout().finally(function() {
            $ionicHistory.nextViewOptions({
                disableAnimate: true,
                disableBack: true
            });
            $state.go('mm_login.sites');
        });
    }
}]);

angular.module('mm.core.login')
.controller('mmLoginSitesCtrl', ["$scope", "$mmSitesManager", "$log", "$translate", "$mmUtil", "$ionicHistory", "$mmText", "$mmLoginHelper", "$mmAddonManager", function($scope, $mmSitesManager, $log, $translate, $mmUtil, $ionicHistory, $mmText, $mmLoginHelper,
            $mmAddonManager) {
    $log = $log.getInstance('mmLoginSitesCtrl');
    var $mmaPushNotifications = $mmAddonManager.get('$mmaPushNotifications');
    $mmSitesManager.getSites().then(function(sites) {
        sites = sites.map(function(site) {
            site.siteurl = site.siteurl.replace(/^https?:\/\//, '');
            site.badge = 0;
            if ($mmaPushNotifications) {
                $mmaPushNotifications.getSiteCounter(site.id).then(function(number) {
                    site.badge = number;
                });
            }
            return site;
        });
        $scope.sites = $mmSitesManager.sortSites(sites);
        $scope.data = {
            hasSites: sites.length > 0,
            showDelete: false
        };
    });
    $scope.toggleDelete = function() {
        $scope.data.showDelete = !$scope.data.showDelete;
    };
    $scope.onItemDelete = function(e, index) {
        e.stopPropagation();
        var site = $scope.sites[index],
            sitename = site.sitename;
        $mmText.formatText(sitename).then(function(sitename) {
            $mmUtil.showConfirm($translate.instant('mm.login.confirmdeletesite', {sitename: sitename})).then(function() {
                $mmSitesManager.deleteSite(site.id).then(function() {
                    $scope.sites.splice(index, 1);
                    $scope.data.showDelete = false;
                    $mmSitesManager.hasNoSites().then(function() {
                        $ionicHistory.nextViewOptions({disableBack: true});
                        $mmLoginHelper.goToAddSite();
                    });
                }, function() {
                    $log.error('Delete site failed');
                    $mmUtil.showErrorModal('mm.login.errordeletesite', true);
                });
            });
        });
    };
    $scope.login = function(siteId) {
        var modal = $mmUtil.showModalLoading();
        $mmSitesManager.loadSite(siteId).then(function() {
            if (!$mmLoginHelper.isSiteLoggedOut()) {
                $ionicHistory.nextViewOptions({disableBack: true});
                return $mmLoginHelper.goToSiteInitialPage();
            }
        }, function(error) {
            $log.error('Error loading site ' + siteId);
            error = error || 'Error loading site.';
            $mmUtil.showErrorModal(error);
        }).finally(function() {
            modal.dismiss();
        });
    };
    $scope.add = function() {
        $mmLoginHelper.goToAddSite();
    };
}]);

angular.module('mm.core.login')
.constant('mmLoginSSOCode', 2) 
.constant('mmLoginSSOInAppCode', 3) 
.constant('mmLoginLaunchSiteURL', 'mmLoginLaunchSiteURL') 
.constant('mmLoginLaunchPassport', 'mmLoginLaunchPassport') 
.constant('mmLoginLaunchData', 'mmLoginLaunchData')
.factory('$mmLoginHelper', ["$q", "$log", "$mmConfig", "mmLoginSSOCode", "mmLoginSSOInAppCode", "mmLoginLaunchData", "$mmEvents", "md5", "$mmSite", "$mmSitesManager", "$mmLang", "$mmUtil", "$state", "$mmAddonManager", "$translate", "mmCoreConfigConstants", "mmCoreEventSessionExpired", "mmUserProfileState", "$mmCourses", "$mmFS", "$mmApp", "$mmEmulatorHelper", "$mmWS", function($q, $log, $mmConfig, mmLoginSSOCode, mmLoginSSOInAppCode, mmLoginLaunchData, $mmEvents,
            md5, $mmSite, $mmSitesManager, $mmLang, $mmUtil, $state, $mmAddonManager, $translate, mmCoreConfigConstants,
            mmCoreEventSessionExpired, mmUserProfileState, $mmCourses, $mmFS, $mmApp, $mmEmulatorHelper, $mmWS) {
    $log = $log.getInstance('$mmLoginHelper');
    var self = {};
    self.acceptSitePolicy = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.write('core_user_agree_site_policy', {}).then(function(result) {
                if (!result.status) {
                    if (result.warnings && result.warnings.length) {
                        return $q.reject(result.warnings[0].message);
                    } else {
                        return $q.reject();
                    }
                }
            });
        });
    };
    self.canRequestPasswordReset = function(siteUrl) {
        return self.requestPasswordReset(siteUrl).then(function() {
            return true;
        }).catch(function(error) {
            return error.available == 1 || error.errorcode != 'invalidrecord';
        });
    };
    self.confirmAndOpenBrowserForSSOLogin = function(siteurl, typeOfLogin, service, launchUrl) {
        var showConfirmation = self.shouldShowSSOConfirm(typeOfLogin),
            promise = showConfirmation ? $mmUtil.showConfirm($translate('mm.login.logininsiterequired')) : $q.when();
        promise.then(function() {
            self.openBrowserForSSOLogin(siteurl, typeOfLogin, service, launchUrl);
        });
    };
    self.formatProfileFieldsForSignup = function(profileFields) {
        var categories = {};
        angular.forEach(profileFields, function(field) {
            if (!field.signup) {
                return;
            }
            if (!categories[field.categoryid]) {
                categories[field.categoryid] = {
                    id: field.categoryid,
                    name: field.categoryname,
                    fields: []
                };
            }
            categories[field.categoryid].fields.push(field);
        });
        return categories;
    };
    self.getErrorMessages = function(requiredMsg, emailMsg, patternMsg, urlMsg, minlengthMsg, maxlengthMsg, minMsg, maxMsg) {
        var errors = {};
        if (requiredMsg) {
            errors.required = $translate.instant(requiredMsg);
        }
        if (emailMsg) {
            errors.email = $translate.instant(emailMsg);
        }
        if (patternMsg) {
            errors.pattern = $translate.instant(patternMsg);
        }
        if (urlMsg) {
            errors.url = $translate.instant(urlMsg);
        }
        if (minlengthMsg) {
            errors.minlength = $translate.instant(minlengthMsg);
        }
        if (maxlengthMsg) {
            errors.maxlength = $translate.instant(maxlengthMsg);
        }
        if (minMsg) {
            errors.min = $translate.instant(minMsg);
        }
        if (maxMsg) {
            errors.max = $translate.instant(maxMsg);
        }
        return errors;
    };
    self.getSitePolicy = function(siteId) {
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var sitePolicy = site.getStoredConfig('sitepolicy');
            if (typeof sitePolicy != 'undefined') {
                return sitePolicy ? sitePolicy : $q.reject();
            }
            return $mmWS.callAjax('auth_email_get_signup_settings', {}, {siteurl: site.getURL()}).then(function(settings) {
                return settings.sitepolicy ? settings.sitepolicy : $q.reject();
            });
        });
    };
    self.getFixedSites = function() {
        return mmCoreConfigConstants.siteurl;
    };
    self.getValidIdentityProviders = function(siteConfig) {
        var validProviders = [],
            httpUrl = $mmFS.concatenatePaths(siteConfig.wwwroot, 'auth/oauth2/'),
            httpsUrl = $mmFS.concatenatePaths(siteConfig.httpswwwroot, 'auth/oauth2/');
        angular.forEach(siteConfig.identityproviders, function(provider) {
            if (provider.url && (provider.url.indexOf(httpsUrl) != -1 || provider.url.indexOf(httpUrl) != -1)) {
                validProviders.push(provider);
            }
        });
        return validProviders;
    };
    self.goToAddSite = function() {
        if (self.isFixedUrlSet()) {
            var url = typeof mmCoreConfigConstants.siteurl == 'string' ?
                    mmCoreConfigConstants.siteurl : mmCoreConfigConstants.siteurl[0].url;
            return $state.go('mm_login.credentials', {siteurl: url});
        } else {
            return $state.go('mm_login.site');
        }
    };
    self.goToSiteInitialPage = function() {
        return isMyOverviewEnabled().then(function(myOverview) {
            var myCourses = !myOverview && isMyCoursesEnabled();
            if (($mmSite.getInfo() && $mmSite.getInfo().userhomepage === 0) || (!myCourses && !myOverview)) {
                promise = isFrontpageEnabled();
            } else {
                promise = $q.when(false);
            }
            return promise.then(function(frontpage) {
                if (frontpage) {
                    return $state.go('site.frontpage');
                } else if (myOverview) {
                    return $state.go('site.myoverview');
                } else if (myCourses) {
                    return $state.go('site.mm_courses');
                } else {
                    return $state.go(mmUserProfileState, {userid: $mmSite.getUserId()});
                }
            });
        });
        function isFrontpageEnabled() {
            var $mmaFrontpage = $mmAddonManager.get('$mmaFrontpage');
            if ($mmaFrontpage && !$mmaFrontpage.isDisabledInSite()) {
                return $mmaFrontpage.isFrontpageAvailable().then(function() {
                    return true;
                }).catch(function() {
                    return false;
                });
            }
            return $q.when(false);
        }
        function isMyCoursesEnabled() {
            return !$mmCourses.isMyCoursesDisabledInSite();
        }
        function isMyOverviewEnabled() {
            var $mmaMyOverview = $mmAddonManager.get('$mmaMyOverview');
            if ($mmaMyOverview) {
                return $mmaMyOverview.isSideMenuAvailable();
            }
            return $q.when(false);
        }
    };
    self.hasSeveralFixedSites = function() {
        return mmCoreConfigConstants.siteurl && angular.isArray(mmCoreConfigConstants.siteurl) &&
                mmCoreConfigConstants.siteurl.length > 1;
    };
    self.isEmailSignupDisabled = function(config) {
        var disabledFeatures = config && config.tool_mobile_disabledfeatures;
        if (!disabledFeatures) {
            return false;
        }
        var regEx = new RegExp('(,|^)\\$mmLoginEmailSignup(,|$)', 'g');
        return !!disabledFeatures.match(regEx);
    };
    self.isFixedUrlSet = function() {
        return mmCoreConfigConstants.siteurl &&
                (typeof mmCoreConfigConstants.siteurl == 'string' || mmCoreConfigConstants.siteurl.length == 1);
    };
    self.isSiteLoggedOut = function(stateName, stateParams) {
        if ($mmSite.isLoggedOut()) {
            $mmEvents.trigger(mmCoreEventSessionExpired, {
                siteid: $mmSite.getId(),
                statename: stateName,
                stateparams: stateParams
            });
            return true;
        }
        return false;
    };
    self.isSSOEmbeddedBrowser = function(code) {
        if ($mmApp.isDesktop() && $mmEmulatorHelper.isLinux()) {
            return true;
        }
        return code == mmLoginSSOInAppCode;
    };
    self.isSSOLoginNeeded = function(code) {
        return code == mmLoginSSOCode || code == mmLoginSSOInAppCode;
    };
    self.openBrowserForOAuthLogin = function(siteUrl, provider, launchUrl, stateName, stateParams) {
        launchUrl = launchUrl || siteUrl + '/admin/tool/mobile/launch.php';
        if (!provider || !provider.url) {
            return false;
        }
        var service = $mmSitesManager.determineService(siteUrl),
            loginUrl = self.prepareForSSOLogin(siteUrl, service, launchUrl, stateName, stateParams);
            params = $mmUtil.extractUrlParams(provider.url);
        if (!params.id) {
            return false;
        }
        loginUrl += '&oauthsso=' + params.id;
        if ($mmApp.isDesktop() && $mmEmulatorHelper.isLinux()) {
            $mmUtil.openInApp(loginUrl);
        } else {
            $mmUtil.openInBrowser(loginUrl);
            if (navigator.app) {
                navigator.app.exitApp();
            }
        }
        return true;
    };
    self.openBrowserForSSOLogin = function(siteurl, typeOfLogin, service, launchUrl, stateName, stateParams) {
        var loginUrl = self.prepareForSSOLogin(siteurl, service, launchUrl, stateName, stateParams);
        if (self.isSSOEmbeddedBrowser(typeOfLogin)) {
            var options = {
                clearsessioncache: 'yes', 
                closebuttoncaption: $translate.instant('mm.login.cancel'),
            };
            $mmUtil.openInApp(loginUrl, options);
        } else {
            $mmUtil.openInBrowser(loginUrl);
            if (navigator.app) {
                navigator.app.exitApp();
            }
        }
    };
    self.openForgottenPassword = function(siteUrl) {
        $mmUtil.openInApp(siteUrl + '/login/forgot_password.php');
    };
    self.prepareForSSOLogin = function(siteUrl, service, launchUrl, stateName, stateParams) {
        service = service || mmCoreConfigConstants.wsextservice;
        launchUrl = launchUrl || siteUrl + '/local/mobile/launch.php';
        var passport = Math.random() * 1000,
            loginUrl = launchUrl + '?service=' + service;
        loginUrl += "&passport=" + passport;
        loginUrl += "&urlscheme=" + mmCoreConfigConstants.customurlscheme;
        $mmConfig.set(mmLoginLaunchData, {
            siteurl: siteUrl,
            passport: passport,
            statename: stateName || '',
            stateparams: stateParams || {}
        });
        return loginUrl;
    };
    self.requestPasswordReset = function(siteUrl, username, email) {
        var params = {};
        if (username) {
            params.username = username;
        }
        if (email) {
            params.email = email;
        }
        return $mmWS.callAjax('core_auth_request_password_reset', params, {siteurl: siteUrl});
    };
    self.shouldShowSSOConfirm = function(typeOfLogin) {
        return !self.isSSOEmbeddedBrowser(typeOfLogin) &&
                    (!mmCoreConfigConstants.skipssoconfirmation || mmCoreConfigConstants.skipssoconfirmation === 'false');
    };
    self.validateBrowserSSOLogin = function(url) {
        var params = url.split(":::");
        return $mmConfig.get(mmLoginLaunchData).then(function(data) {
            var launchSiteURL = data.siteurl,
                passport = data.passport;
            $mmConfig.delete(mmLoginLaunchData);
            var signature = md5.createHash(launchSiteURL + passport);
            if (signature != params[0]) {
                if (launchSiteURL.indexOf("https://") != -1) {
                    launchSiteURL = launchSiteURL.replace("https://", "http://");
                } else {
                    launchSiteURL = launchSiteURL.replace("http://", "https://");
                }
                signature = md5.createHash(launchSiteURL + passport);
            }
            if (signature == params[0]) {
                $log.debug('Signature validated');
                return {
                    siteurl: launchSiteURL,
                    token: params[1],
                    privateToken: params[2],
                    statename: data.statename,
                    stateparams: data.stateparams
                };
            } else {
                $log.debug('Invalid signature in the URL request yours: ' + params[0] + ' mine: '
                                + signature + ' for passport ' + passport);
                return $mmLang.translateAndReject('mm.core.unexpectederror');
            }
        });
    };
    self.handleSSOLoginAuthentication = function(siteurl, token, privateToken) {
        if ($mmSite.isLoggedIn()) {
            var info = $mmSite.getInfo();
            if (typeof info != 'undefined' && typeof info.username != 'undefined') {
                return $mmSitesManager.updateSiteToken(info.siteurl, info.username, token, privateToken).then(function() {
                    $mmSitesManager.updateSiteInfoByUrl(info.siteurl, info.username);
                }).catch(function() {
                    return $mmLang.translateAndReject('mm.login.errorupdatesite');
                });
            }
            return $mmLang.translateAndReject('mm.login.errorupdatesite');
        } else {
            return $mmSitesManager.newSite(siteurl, token, privateToken);
        }
    };
    self.treatUserTokenError = function(siteurl, error) {
        if (typeof error == 'string') {
            $mmUtil.showErrorModal(error);
        } else if (error.errorcode == 'forcepasswordchangenotice') {
            self.openChangePassword(siteurl, error.error);
        } else {
            $mmUtil.showErrorModal(error.error);
        }
    };
    self.openChangePassword = function(siteurl, error) {
        return $mmUtil.showModal('mm.core.notice', error, 3000).then(function() {
            var changepasswordurl = siteurl + '/login/change_password.php';
            $mmUtil.openInApp(changepasswordurl);
        });
    };
    return self;
}]);

angular.module('mm.core.question')
.provider('$mmQuestionBehaviourDelegate', function() {
    var handlers = {},
        self = {};
    self.registerHandler = function(name, behaviour, handler) {
        if (typeof handlers[behaviour] !== 'undefined') {
            console.log("$mmQuestionBehaviourDelegateProvider: Addon '" + name +
                            "' already registered as handler for '" + behaviour + "'");
            return false;
        }
        console.log("$mmQuestionBehaviourDelegateProvider: Registered handler '" + name + "' for behaviour '" + behaviour + "'");
        handlers[behaviour] = {
            addon: name,
            instance: undefined,
            handler: handler
        };
    };
    self.$get = ["$log", "$q", "$mmUtil", "$mmSite", "$mmQuestionDelegate", function($log, $q, $mmUtil, $mmSite, $mmQuestionDelegate) {
        $log = $log.getInstance('$mmQuestionBehaviourDelegate');
        var enabledHandlers = {},
            self = {},
            lastUpdateHandlersStart;
        self.determineQuestionState = function(behaviour, component, attemptId, question, siteId) {
            behaviour = $mmQuestionDelegate.getBehaviourForQuestion(question, behaviour);
            var handler = enabledHandlers[behaviour];
            if (typeof handler != 'undefined' && handler.determineQuestionState) {
                return $q.when(handler.determineQuestionState(component, attemptId, question, siteId));
            }
            return $q.when(false);
        };
        self.handleQuestion = function(question, behaviour) {
            behaviour = $mmQuestionDelegate.getBehaviourForQuestion(question, behaviour);
            if (typeof enabledHandlers[behaviour] != 'undefined') {
                return enabledHandlers[behaviour].handleQuestion(question);
            }
        };
        self.isBehaviourSupported = function(behaviour) {
            return typeof enabledHandlers[behaviour] != 'undefined';
        };
        self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
        self.updateQuestionBehaviourHandler = function(behaviour, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[behaviour] = handlerInfo.instance;
                    } else {
                        delete enabledHandlers[behaviour];
                    }
                }
            });
        };
        self.updateQuestionBehaviourHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating question behaviour handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(handlers, function(handlerInfo, behaviour) {
                promises.push(self.updateQuestionBehaviourHandler(behaviour, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.question')
.provider('$mmQuestionDelegate', function() {
    var handlers = {},
        self = {};
    self.registerHandler = function(name, questionType, handler) {
        if (typeof handlers[questionType] !== 'undefined') {
            console.log("$mmQuestionDelegateProvider: Addon '" + name + "' already registered as handler for '" + questionType + "'");
            return false;
        }
        console.log("$mmQuestionDelegateProvider: Registered handler '" + name + "' for question type '" + questionType + "'");
        handlers[questionType] = {
            addon: name,
            instance: undefined,
            handler: handler
        };
    };
    self.$get = ["$log", "$q", "$mmUtil", "$mmSite", function($log, $q, $mmUtil, $mmSite) {
        $log = $log.getInstance('$mmQuestionDelegate');
        var enabledHandlers = {},
            self = {},
            lastUpdateHandlersStart;
        self.getBehaviourForQuestion = function(question, behaviour) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined' && enabledHandlers[type].getBehaviour) {
                var questionBehaviour = enabledHandlers[type].getBehaviour(question, behaviour);
                if (questionBehaviour) {
                    return questionBehaviour;
                }
            }
            return behaviour;
        };
        self.getDirectiveForQuestion = function(question) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined') {
                return enabledHandlers[type].getDirectiveName(question);
            }
        };
        self.getPreventSubmitMessage = function(question) {
            var type = 'qtype_' + question.type,
                handler = enabledHandlers[type];
            if (typeof handler != 'undefined' && handler.getPreventSubmitMessage) {
                return handler.getPreventSubmitMessage(question);
            }
        };
        self.isCompleteResponse = function(question, answers) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined') {
                if (enabledHandlers[type].isCompleteResponse) {
                    return enabledHandlers[type].isCompleteResponse(question, answers);
                }
            }
            return -1;
        };
        self.isGradableResponse = function(question, answers) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined') {
                if (enabledHandlers[type].isGradableResponse) {
                    return enabledHandlers[type].isGradableResponse(question, answers);
                }
            }
            return -1;
        };
        self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
        self.isSameResponse = function(question, prevAnswers, newAnswers) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined') {
                if (enabledHandlers[type].isSameResponse) {
                    return enabledHandlers[type].isSameResponse(question, prevAnswers, newAnswers);
                }
            }
            return false;
        };
        self.isQuestionSupported = function(type) {
            return typeof enabledHandlers['qtype_' + type] != 'undefined';
        };
        self.prepareAnswersForQuestion = function(question, answers, offline, siteId) {
            var type = 'qtype_' + question.type,
                handler = enabledHandlers[type];
            if (typeof handler != 'undefined' && handler.prepareAnswers) {
                return $q.when(handler.prepareAnswers(question, answers, offline, siteId));
            }
            return $q.when();
        };
        self.updateQuestionHandler = function(questionType, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[questionType] = handlerInfo.instance;
                    } else {
                        delete enabledHandlers[questionType];
                    }
                }
            });
        };
        self.updateQuestionHandlers = function() {
            var promises = [],
                now = new Date().getTime();
            $log.debug('Updating question handlers for current site.');
            lastUpdateHandlersStart = now;
            angular.forEach(handlers, function(handlerInfo, questionType) {
                promises.push(self.updateQuestionHandler(questionType, handlerInfo, now));
            });
            return $q.all(promises).then(function() {
                return true;
            }, function() {
                return true;
            });
        };
        self.validateSequenceCheck = function(question, offlineSequenceCheck) {
            var type = 'qtype_' + question.type;
            if (typeof enabledHandlers[type] != 'undefined') {
                if (enabledHandlers[type].validateSequenceCheck) {
                    return enabledHandlers[type].validateSequenceCheck(question, offlineSequenceCheck);
                } else {
                    return question.sequencecheck == offlineSequenceCheck;
                }
            }
            return false;
        };
        return self;
    }];
    return self;
});

angular.module('mm.core.question')
.factory('$mmQuestionHelper', ["$mmUtil", "$mmText", "$ionicModal", "mmQuestionComponent", "$mmSitesManager", "$mmFilepool", "$q", "$mmQuestion", "$mmSite", "$mmQuestionDelegate", function($mmUtil, $mmText, $ionicModal, mmQuestionComponent, $mmSitesManager, $mmFilepool, $q,
            $mmQuestion, $mmSite, $mmQuestionDelegate) {
    var self = {},
        lastErrorShown = 0;
    function addBehaviourButton(question, button) {
        if (!button || !question) {
            return;
        }
        if (!question.behaviourButtons) {
            question.behaviourButtons = [];
        }
        question.behaviourButtons.push({
            id: button.id,
            name: button.name,
            value: button.value,
            disabled: button.disabled
        });
    }
    self.calculatedDirective = function(scope, log) {
        var questionEl = self.inputTextDirective(scope, log);
        if (questionEl) {
            questionEl = questionEl[0] || questionEl; 
            var selectModel = {},
                select = questionEl.querySelector('select[name*=unit]'),
                options = select && select.querySelectorAll('option'),
                input;
            if (select && options && options.length) {
                selectModel.id = select.id;
                selectModel.name = select.name;
                selectModel.disabled = select.disabled;
                selectModel.options = [];
                angular.forEach(options, function(option) {
                    if (typeof option.value == 'undefined') {
                        log.warn('Aborting because couldn\'t find option value.', question.name);
                        return self.showDirectiveError(scope);
                    }
                    var opt = {
                        value: option.value,
                        label: option.innerHTML
                    };
                    if (option.selected) {
                        selectModel.selected = opt.value;
                        selectModel.selectedLabel = opt.label;
                    }
                    selectModel.options.push(opt);
                });
                if (!selectModel.selected) {
                    selectModel.selected = selectModel.options[0].value;
                    selectModel.selectedLabel = selectModel.options[0].label;
                }
                accessibilityLabel = questionEl.querySelector('label[for="' + select.id + '"]');
                selectModel.accessibilityLabel = accessibilityLabel.innerHTML;
                scope.select = selectModel;
                input = questionEl.querySelector('input[type="text"][name*=answer]');
                scope.selectFirst = questionEl.innerHTML.indexOf(input.outerHTML) > questionEl.innerHTML.indexOf(select.outerHTML);
                return;
            }
            options = questionEl.querySelectorAll('input[type="radio"]');
            if (!options || !options.length) {
                return;
            }
            scope.options = [];
            angular.forEach(options, function(element) {
                var option = {
                        id: element.id,
                        name: element.name,
                        value: element.value,
                        checked: element.checked,
                        disabled: element.disabled
                    },
                    label;
                label = questionEl.querySelector('label[for="' + option.id + '"]');
                if (label) {
                    option.text = label.innerText;
                    if (typeof option.name != 'undefined' && typeof option.value != 'undefined' &&
                                typeof option.text != 'undefined') {
                        if (element.checked) {
                            scope.unit = option.value;
                        }
                        scope.options.push(option);
                        return;
                    }
                }
                log.warn('Aborting because of an error parsing options.', question.name, option.name);
                return self.showDirectiveError(scope);
            });
            input = questionEl.querySelector('input[type="text"][name*=answer]');
            scope.optionsFirst = questionEl.innerHTML.indexOf(input.outerHTML) > questionEl.innerHTML.indexOf(options[0].outerHTML);
        }
    };
    self.directiveInit = function(scope, log) {
        var question = scope.question,
            questionEl;
        if (!question) {
            log.warn('Aborting because of no question received.');
            return self.showDirectiveError(scope);
        }
        questionEl = angular.element(question.html);
        question.text = $mmUtil.getContentsOfElement(questionEl, '.qtext');
        if (typeof question.text == 'undefined') {
            log.warn('Aborting because of an error parsing question.', question.name);
            return self.showDirectiveError(scope);
        }
        return questionEl;
    };
    self.extractQbehaviourButtons = function(question, selector) {
        selector = selector || '.im-controls input[type="submit"]';
        var div = document.createElement('div'),
            buttons;
        div.innerHTML = question.html;
        buttons = div.querySelectorAll(selector);
        angular.forEach(buttons, function(button) {
            addBehaviourButton(question, button);
        });
        question.html = div.innerHTML;
    };
    self.extractQbehaviourCBM = function(question) {
        var div = document.createElement('div'),
            labels;
        div.innerHTML = question.html;
        labels = div.querySelectorAll('.im-controls .certaintychoices label[for*="certainty"]');
        question.behaviourCertaintyOptions = [];
        angular.forEach(labels, function(label) {
            var input = label.querySelector('input[type="radio"]');
            if (input) {
                question.behaviourCertaintyOptions.push({
                    id: input.id,
                    name: input.name,
                    value: input.value,
                    text: $mmText.cleanTags(label.innerHTML),
                    disabled: input.disabled
                });
                if (input.checked) {
                    question.behaviourCertaintySelected = input.value;
                }
            }
        });
        if (question.localAnswers && typeof question.localAnswers['-certainty'] != 'undefined') {
            question.behaviourCertaintySelected = question.localAnswers['-certainty'];
        }
        return labels && labels.length;
    };
    self.extractQbehaviourRedoButton = function(question) {
        var div = document.createElement('div'),
            redoSelector = 'input[type="submit"][name*=redoslot], input[type="submit"][name*=tryagain]';
        if (!searchButton('html', '.outcome ' + redoSelector)) {
            if (question.feedbackHtml) {
                if (searchButton('feedbackHtml', redoSelector)) {
                    return;
                }
            }
            if (question.infoHtml) {
                searchButton('infoHtml', redoSelector);
            }
        }
        function searchButton(htmlProperty, selector) {
            var button;
            div.innerHTML = question[htmlProperty];
            button = div.querySelector(selector);
            if (button) {
                addBehaviourButton(question, button);
                angular.element(button).remove();
                question[htmlProperty] = div.innerHTML;
                return true;
            }
            return false;
        }
    };
    self.extractQbehaviourSeenInput = function(question) {
        var div = document.createElement('div'),
            seenInput;
        div.innerHTML = question.html;
        seenInput = div.querySelector('input[type="hidden"][name*=seen]');
        if (seenInput) {
            question.behaviourSeenInput = {
                name: seenInput.name,
                value: seenInput.value
            };
            angular.element(seenInput).remove();
            question.html = div.innerHTML;
            return true;
        }
        return false;
    };
    self.extractQuestionComment = function(question) {
        extractQuestionLastElementNotInContent(question, '.comment', 'commentHtml');
    };
    self.extractQuestionFeedback = function(question) {
        extractQuestionLastElementNotInContent(question, '.outcome', 'feedbackHtml');
    };
    self.extractQuestionInfoBox = function(question, selector) {
        extractQuestionLastElementNotInContent(question, selector, 'infoHtml');
    };
    function extractQuestionLastElementNotInContent(question, selector, attrName) {
        var div = document.createElement('div'),
            matches,
            last,
            position;
        div.innerHTML = question.html;
        matches = div.querySelectorAll(selector);
        position = matches.length -1;
        last = matches[position];
        while (last) {
            if (!$mmUtil.closest(last, '.formulation')) {
                question[attrName] = last.innerHTML;
                angular.element(last).remove();
                question.html = div.innerHTML;
                return;
            }
            position--;
            last = matches[position];
        }
    }
    self.extractQuestionScripts = function(question) {
        var matches;
        question.scriptsCode = '';
        question.initObjects = [];
        if (question.html) {
            matches = question.html.match(/<script[^>]*>[\s\S]*?<\/script>/mg);
            angular.forEach(matches, function(match) {
                question.scriptsCode += match;
                question.html = question.html.replace(match, '');
                var initMatches = match.match(new RegExp('M\.qtype_' + question.type + '\.init_question\\(.*?}\\);', 'mg'));
                if (initMatches) {
                    var initMatch = initMatches.pop();
                    initMatch = initMatch.replace('M.qtype_' + question.type + '.init_question(', '');
                    initMatch = initMatch.substr(0, initMatch.length - 2);
                    try {
                        question.initObjects = JSON.parse(initMatch);
                    } catch(ex) {}
                }
            });
        }
    };
    self.getAllInputNamesFromHtml = function(html) {
        var form = document.createElement('form'),
            answers = {};
        form.innerHTML = html;
        angular.forEach(form.elements, function(element) {
            var name = element.name || '';
            if (!name || name.match(/_:flagged$/) || element.type == 'submit' || element.tagName == 'BUTTON') {
                return;
            }
            answers[$mmQuestion.removeQuestionPrefix(name)] = true;
        });
        return answers;
    };
    self.getAnswersFromForm = function(form) {
        if (!form || !form.elements) {
            return {};
        }
        var answers = {};
        angular.forEach(form.elements, function(element) {
            var name = element.name || '';
            if (!name || name.match(/_:flagged$/) || element.type == 'submit' || element.tagName == 'BUTTON') {
                return;
            }
            if (element.type == 'checkbox') {
                answers[name] = !!element.checked;
            } else if (element.type == 'radio') {
                if (element.checked) {
                    answers[name] = element.value;
                }
            } else {
                answers[name] = element.value;
            }
        });
        return answers;
    };
    self.getQuestionAttachmentsFromHtml = function(html) {
        var el = angular.element('<div></div>'),
            anchors,
            attachments = [];
        el.html(html);
        el = el[0];
        $mmUtil.removeElement(el, 'div[id*=filemanager]');
        anchors = el.querySelectorAll('a');
        angular.forEach(anchors, function(anchor) {
            var content = anchor.innerHTML;
            if (anchor.href && content) {
                content = $mmText.cleanTags(content, true).trim();
                attachments.push({
                    filename: content,
                    fileurl: anchor.href
                });
            }
        });
        return attachments;
    };
    self.getQuestionSequenceCheckFromHtml = function(html) {
        var el,
            input;
        if (html) {
            el = angular.element(html)[0];
            input = el.querySelector('input[name*=sequencecheck]');
            if (input && typeof input.name != 'undefined' && typeof input.value != 'undefined') {
                return {
                    name: input.name,
                    value: input.value
                };
            }
        }
    };
    self.getQuestionStateClass = function(name) {
        var state = $mmQuestion.getState(name);
        return state ? state.class : '';
    };
    self.getValidationErrorFromHtml = function(html) {
        return $mmUtil.getContentsOfElement(angular.element(html), '.validationerror');
    };
    self.hasDraftFileUrls = function(html) {
        var url = $mmSite.getURL();
        if (url.slice(-1) != '/') {
            url = url += '/';
        }
        url += 'draftfile.php';
        return html.indexOf(url) != -1;
    };
    self.inputTextDirective = function(scope, log) {
        var questionEl = self.directiveInit(scope, log);
        if (questionEl) {
            questionEl = questionEl[0] || questionEl; 
            input = questionEl.querySelector('input[type="text"][name*=answer]');
            if (!input) {
                log.warn('Aborting because couldn\'t find input.', question.name);
                return self.showDirectiveError(scope);
            }
            scope.input = {
                id: input.id,
                name: input.name,
                value: input.value,
                readOnly: input.readOnly
            };
            if (input.className.indexOf('incorrect') >= 0) {
                scope.input.isCorrect = 0;
            } else if (input.className.indexOf('correct') >= 0) {
                scope.input.isCorrect = 1;
            }
        }
        return questionEl;
    };
    self.loadLocalAnswersInHtml = function(question) {
        var form = document.createElement('form');
        form.innerHTML = question.html;
        angular.forEach(form.elements, function(element) {
            var name = element.name || '';
            if (!name || name.match(/_:flagged$/) || element.type == 'submit' || element.tagName == 'BUTTON') {
                return;
            }
            name = $mmQuestion.removeQuestionPrefix(name);
            if (question.localAnswers && typeof question.localAnswers[name] != 'undefined') {
                var selected;
                if (element.tagName == 'TEXTAREA') {
                    element.innerHTML = question.localAnswers[name];
                } else if (element.tagName == 'SELECT') {
                    selected = element.querySelector('option[value="' + question.localAnswers[name] + '"]');
                    if (selected) {
                        selected.setAttribute('selected', 'selected');
                    }
                } else if (element.type == 'radio' || element.type == 'checkbox') {
                    if (element.value == question.localAnswers[name]) {
                        element.setAttribute('checked', 'checked');
                    }
                } else {
                    element.setAttribute('value', question.localAnswers[name]);
                }
            }
        });
        question.html = form.innerHTML;
    };
    self.matchingDirective = function(scope, log) {
        var questionEl = self.directiveInit(scope, log),
            question = scope.question,
            rows;
        if (questionEl) {
            questionEl = questionEl[0] || questionEl; 
            rows = questionEl.querySelectorAll('tr');
            if (!rows || !rows.length) {
                log.warn('Aborting because couldn\'t find any row.', question.name);
                return self.showDirectiveError(scope);
            }
            question.rows = [];
            angular.forEach(rows, function(row) {
                var rowModel = {},
                    select,
                    options,
                    accessibilityLabel,
                    columns = row.querySelectorAll('td');
                if (!columns || columns.length < 2) {
                    log.warn('Aborting because couldn\'t find the right columns.', question.name);
                    return self.showDirectiveError(scope);
                }
                rowModel.text = columns[0].innerHTML;
                select = columns[1].querySelector('select');
                options = columns[1].querySelectorAll('option');
                if (!select || !options || !options.length) {
                    log.warn('Aborting because couldn\'t find select or options.', question.name);
                    return self.showDirectiveError(scope);
                }
                rowModel.id = select.id;
                rowModel.name = select.name;
                rowModel.disabled = select.disabled;
                rowModel.selected = false;
                rowModel.options = [];
                if (columns[1].className.indexOf('incorrect') >= 0) {
                    rowModel.isCorrect = 0;
                } else if (columns[1].className.indexOf('correct') >= 0) {
                    rowModel.isCorrect = 1;
                }
                angular.forEach(options, function(option) {
                    if (typeof option.value == 'undefined') {
                        log.warn('Aborting because couldn\'t find option value.', question.name);
                        return self.showDirectiveError(scope);
                    }
                    var opt = {
                        value: option.value,
                        label: option.innerHTML,
                        selected: option.selected
                    };
                    if (opt.selected) {
                        rowModel.selected = opt;
                    }
                    rowModel.options.push(opt);
                });
                accessibilityLabel = columns[1].querySelector('label.accesshide');
                rowModel.accessibilityLabel = accessibilityLabel.innerHTML;
                question.rows.push(rowModel);
            });
            question.loaded = true;
        }
    };
    self.multiChoiceDirective = function(scope, log) {
        var questionEl = self.directiveInit(scope, log),
            question = scope.question;
        scope.mcAnswers = {};
        if (questionEl) {
            questionEl = questionEl[0] || questionEl; 
            question.prompt = $mmUtil.getContentsOfElement(questionEl, '.prompt');
            var options = questionEl.querySelectorAll('input[type="radio"]');
            if (!options || !options.length) {
                question.multi = true;
                options = questionEl.querySelectorAll('input[type="checkbox"]');
                if (!options || !options.length) {
                    log.warn('Aborting because of no radio and checkbox found.', question.name);
                    return self.showDirectiveError(scope);
                }
            }
            question.options = [];
            angular.forEach(options, function(element) {
                var option = {
                        id: element.id,
                        name: element.name,
                        value: element.value,
                        checked: element.checked,
                        disabled: element.disabled
                    },
                    label,
                    parent = element.parentNode,
                    feedback;
                label = questionEl.querySelector('label[for="' + option.id + '"]');
                if (label) {
                    option.text = label.innerHTML;
                    if (typeof option.name != 'undefined' && typeof option.value != 'undefined' &&
                                typeof option.text != 'undefined') {
                        if (element.checked) {
                            if (!question.multi) {
                                scope.mcAnswers[option.name] = option.value;
                            }
                            if (parent) {
                                if (parent && parent.className.indexOf('incorrect') >= 0) {
                                    option.isCorrect = 0;
                                } else if (parent && parent.className.indexOf('correct') >= 0) {
                                    option.isCorrect = 1;
                                }
                                feedback = parent.querySelector('.specificfeedback');
                                if (feedback) {
                                    option.feedback = feedback.innerHTML;
                                }
                            }
                        }
                        question.options.push(option);
                        return;
                    }
                }
                log.warn('Aborting because of an error parsing options.', question.name, option.name);
                return self.showDirectiveError(scope);
            });
        }
    };
    self.prefetchQuestionFiles = function(question, siteId, component, componentId) {
        var urls = $mmUtil.extractDownloadableFilesFromHtml(question.html);
        if (!component) {
            component = mmQuestionComponent;
            componentId = question.id;
        }
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var promises = [];
            angular.forEach(urls, function(url) {
                if (!site.canDownloadFiles() && $mmUtil.isPluginFileUrl(url)) {
                    return;
                }
                if (url.indexOf('theme/image.php') > -1 && url.indexOf('flagged') > -1) {
                    return;
                }
                promises.push($mmFilepool.addToQueueByUrl(siteId, url, component, componentId));
            });
            return $q.all(promises);
        });
    };
    self.prepareAnswers = function(questions, answers, offline, siteId) {
        siteId = siteId || $mmSite.getId();
        var promises = [],
            error;
        angular.forEach(questions, function(question) {
            promises.push($mmQuestionDelegate.prepareAnswersForQuestion(question, answers, offline, siteId).catch(function(e) {
                error = e;
                return $q.reject();
            }));
        });
        return $mmUtil.allPromises(promises).then(function() {
            return answers;
        }).catch(function() {
            return $q.reject(error);
        });
    };
    self.replaceCorrectnessClasses = function(element) {
        $mmUtil.replaceClassesInElement(element, {
            correct: 'mm-question-answer-correct',
            incorrect: 'mm-question-answer-incorrect'
        });
    };
    self.replaceFeedbackClasses = function(element) {
        $mmUtil.replaceClassesInElement(element, {
            outcome: 'mm-question-feedback-container mm-question-feedback-padding',
            specificfeedback: 'mm-question-feedback-container mm-question-feedback-inline'
        });
    };
    self.showDirectiveError = function(scope, error) {
        error = error || 'Error processing the question. This could be caused by custom modifications in your site.';
        var now = new Date().getTime();
        if (now - lastErrorShown > 500) {
            lastErrorShown = now;
            $mmUtil.showErrorModal(error);
        }
        scope.abort();
    };
    self.treatCorrectnessIcons = function(scope, element) {
        element = element[0] || element; 
        var icons = element.querySelectorAll('img.icon, img.questioncorrectnessicon');
        angular.forEach(icons, function(icon) {
            if (icon.src) {
                var newIcon = document.createElement('i');
                if (icon.src.indexOf('incorrect') > -1) {
                    newIcon.className = 'icon fa fa-remove text-danger fa-fw questioncorrectnessicon';
                } else if (icon.src.indexOf('correct') > -1) {
                    newIcon.className = 'icon fa fa-check text-success fa-fw questioncorrectnessicon';
                } else {
                    return;
                }
                newIcon.title = icon.title;
                newIcon.ariaLabel = icon.title;
                icon.parentNode.replaceChild(newIcon, icon);
                icon = newIcon;
            }
        });
        var spans = element.querySelectorAll('.feedbackspan.accesshide');
        angular.forEach(spans, function(span) {
            var icon = span.previousSibling,
                iconAng;
            if (!icon) {
                return;
            }
            iconAng = angular.element(icon);
            if (!iconAng.hasClass('icon') && !iconAng.hasClass('questioncorrectnessicon')) {
                return;
            }
            iconAng.addClass('questioncorrectnessicon');
            icon.setAttribute('ng-click', 'questionCorrectnessIconClicked($event)');
        });
        scope.questionCorrectnessIconClicked = function(event) {
            var parent = event.target.parentNode,
                feedback;
            if (parent) {
                feedback = parent.querySelector('.feedbackspan.accesshide');
                if (feedback && feedback.innerHTML) {
                    scope.currentFeedback = feedback.innerHTML;
                    scope.feedbackModal.show();
                }
            }
        };
        $ionicModal.fromTemplateUrl('core/components/question/templates/feedbackmodal.html', {
            scope: scope
        }).then(function(modal) {
            scope.feedbackModal = modal;
            scope.closeModal = function() {
                modal.hide();
            };
        });
    };
    return self;
}]);

angular.module('mm.core.question')
.constant('mmQuestionStore', 'questions')
.constant('mmQuestionAnswersStore', 'question_answers')
.config(["$mmSitesFactoryProvider", "mmQuestionStore", "mmQuestionAnswersStore", function($mmSitesFactoryProvider, mmQuestionStore, mmQuestionAnswersStore) {
    var stores = [
        {
            name: mmQuestionStore,
            keyPath: ['component', 'attemptid', 'slot'],
            indexes: [
                {
                    name: 'userid'
                },
                {
                    name: 'component'
                },
                {
                    name: 'componentId'
                },
                {
                    name: 'attemptid'
                },
                {
                    name: 'slot'
                },
                {
                    name: 'state'
                },
                {
                    name: 'componentAndAttempt',
                    keyPath: ['component', 'attemptid']
                },
                {
                    name: 'componentAndComponentId',
                    keyPath: ['component', 'componentId']
                }
            ]
        },
        {
            name: mmQuestionAnswersStore,
            keyPath: ['component', 'attemptid', 'name'],
            indexes: [
                {
                    name: 'userid'
                },
                {
                    name: 'component'
                },
                {
                    name: 'componentId'
                },
                {
                    name: 'attemptid'
                },
                {
                    name: 'name'
                },
                {
                    name: 'questionslot'
                },
                {
                    name: 'componentAndAttempt',
                    keyPath: ['component', 'attemptid']
                },
                {
                    name: 'componentAndComponentId',
                    keyPath: ['component', 'componentId']
                },
                {
                    name: 'componentAndAttemptAndQuestion',
                    keyPath: ['component', 'attemptid', 'questionslot']
                }
            ]
        }
    ];
    $mmSitesFactoryProvider.registerStores(stores);
}])
.factory('$mmQuestion', ["$log", "$mmSite", "$mmSitesManager", "$mmUtil", "$q", "$mmQuestionDelegate", "mmQuestionStore", "mmQuestionAnswersStore", function($log, $mmSite, $mmSitesManager, $mmUtil, $q, $mmQuestionDelegate, mmQuestionStore,
            mmQuestionAnswersStore) {
    $log = $log.getInstance('$mmQuestion');
    var self = {},
        questionPrefixRegex = /q\d+:(\d+)_/,
        states = {
            todo: {
                name: 'todo',
                class: 'mm-question-notyetanswered',
                status: 'notyetanswered',
                active: true,
                finished: false
            },
            invalid: {
                name: 'invalid',
                class: 'mm-question-invalidanswer',
                status: 'invalidanswer',
                active: true,
                finished: false
            },
            complete: {
                name: 'complete',
                class: 'mm-question-answersaved',
                status: 'answersaved',
                active: true,
                finished: false
            },
            needsgrading: {
                name: 'needsgrading',
                class: 'mm-question-requiresgrading',
                status: 'requiresgrading',
                active: false,
                finished: true
            },
            finished: {
                name: 'finished',
                class: 'mm-question-complete',
                status: 'complete',
                active: false,
                finished: true
            },
            gaveup: {
                name: 'gaveup',
                class: 'mm-question-notanswered',
                status: 'notanswered',
                active: false,
                finished: true
            },
            gradedwrong: {
                name: 'gradedwrong',
                class: 'mm-question-incorrect',
                status: 'incorrect',
                active: false,
                finished: true
            },
            gradedpartial: {
                name: 'gradedpartial',
                class: 'mm-question-partiallycorrect',
                status: 'partiallycorrect',
                active: false,
                finished: true
            },
            gradedright: {
                name: 'gradedright',
                class: 'mm-question-correct',
                status: 'correct',
                active: false,
                finished: true
            },
            mangrwrong: {
                name: 'mangrwrong',
                class: 'mm-question-incorrect',
                status: 'incorrect',
                active: false,
                finished: true
            },
            mangrpartial: {
                name: 'mangrpartial',
                class: 'mm-question-partiallycorrect',
                status: 'partiallycorrect',
                active: false,
                finished: true
            },
            mangrright: {
                name: 'mangrright',
                class: 'mm-question-correct',
                status: 'correct',
                active: false,
                finished: true
            },
            unknown: { 
                name: 'unknown',
                class: 'mm-question-unknown',
                status: 'unknown',
                active: true,
                finished: false
            }
        };
    self.compareAllAnswers = function(prevAnswers, newAnswers) {
        var equal = true,
            keys = $mmUtil.mergeArraysWithoutDuplicates(Object.keys(prevAnswers), Object.keys(newAnswers));
        angular.forEach(keys, function(key) {
            if (!self.isExtraAnswer(key[0])) {
                if (!$mmUtil.sameAtKeyMissingIsBlank(prevAnswers, newAnswers, key)) {
                    equal = false;
                }
            }
        });
        return equal;
    };
    self.convertAnswersArrayToObject = function(answers, removePrefix) {
        var result = {};
        angular.forEach(answers, function(answer) {
            if (removePrefix) {
                var nameWithoutPrefix = self.removeQuestionPrefix(answer.name);
                result[nameWithoutPrefix] = answer.value;
            } else {
                result[answer.name] = answer.value;
            }
        });
        return result;
    };
    self.getAnswer = function(component, attemptId, name, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().get(mmQuestionAnswersStore, [component, attemptId, name]);
        });
    };
    self.getAttemptAnswers = function(component, attemptId, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().whereEqual(mmQuestionAnswersStore, 'componentAndAttempt', [component, attemptId]);
        });
    };
    self.getAttemptQuestions = function(component, attemptId, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().whereEqual(mmQuestionStore, 'componentAndAttempt', [component, attemptId]);
        });
    };
    self.getBasicAnswers = function(answers) {
        var result = {};
        angular.forEach(answers, function(value, name) {
            if (!self.isExtraAnswer(name)) {
                result[name] = value;
            }
        });
        return result;
    };
    self.getQuestion = function(component, attemptId, slot, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().get(mmQuestionStore, [component, attemptId, slot]);
        });
    };
    self.getQuestionAnswers = function(component, attemptId, slot, filter, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().whereEqual(mmQuestionAnswersStore, 'componentAndAttemptAndQuestion',
                        [component, attemptId, slot]).then(function(answers) {
                if (filter) {
                    var result = [];
                    angular.forEach(answers, function(answer) {
                        if (self.isExtraAnswer(answer.name)) {
                            result.push(answer);
                        }
                    });
                    return result;
                } else {
                    return answers;
                }
            });
        });
    };
    self.getQuestionSlotFromName = function(name) {
        if (name) {
            var match = name.match(questionPrefixRegex);
            if (match && match[1]) {
                return parseInt(match[1], 10);
            }
        }
        return -1;
    };
    self.getState = function(name) {
        return states[name || 'unknown'];
    };
    self.isCompleteResponse = function(question, answers) {
        return $mmQuestionDelegate.isCompleteResponse(question, answers);
    };
    self.isExtraAnswer = function(name) {
        name = self.removeQuestionPrefix(name);
        return name[0] == '-' || name[0] == ':';
    };
    self.isGradableResponse = function(question, answers) {
        return $mmQuestionDelegate.isGradableResponse(question, answers);
    };
    self.isSameResponse = function(question, prevAnswers, newAnswers) {
        return $mmQuestionDelegate.isSameResponse(question, prevAnswers, newAnswers);
    };
    self.removeAttemptAnswers = function(component, attemptId, siteId) {
        siteId = siteId || $mmSite.getId();
        return self.getAttemptAnswers(component, attemptId, siteId).then(function(answers) {
            var promises = [];
            angular.forEach(answers, function(answer) {
                promises.push(self.removeAnswer(component, attemptId, answer.name, siteId));
            });
            return $q.all(promises);
        });
    };
    self.removeAttemptQuestions = function(component, attemptId, siteId) {
        siteId = siteId || $mmSite.getId();
        return self.getAttemptQuestions(component, attemptId, siteId).then(function(questions) {
            var promises = [];
            angular.forEach(questions, function(question) {
                promises.push(self.removeQuestion(component, attemptId, question.slot, siteId));
            });
            return $q.all(promises);
        });
    };
    self.removeAnswer = function(component, attemptId, name, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().remove(mmQuestionAnswersStore, [component, attemptId, name]);
        });
    };
    self.removeQuestion = function(component, attemptId, slot, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            return site.getDb().remove(mmQuestionStore, [component, attemptId, slot]);
        });
    };
    self.removeQuestionAnswers = function(component, attemptId, slot, siteId) {
        return self.getQuestionAnswers(component, attemptId, slot, false, siteId).then(function(answers) {
            var promises = [];
            angular.forEach(answers, function(answer) {
                promises.push(self.removeAnswer(component, attemptId, answer.name, siteId));
            });
            return $q.all(promises);
        });
    };
    self.removeQuestionPrefix = function(name) {
        if (name) {
            return name.replace(questionPrefixRegex, '');
        }
        return '';
    };
    self.saveAnswers = function(component, componentId, attemptId, userId, answers, timemod, siteId) {
        siteId = siteId || $mmSite.getId();
        timemod = timemod || $mmUtil.timestamp();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var db = site.getDb(),
                promises = [];
            angular.forEach(answers, function(value, name) {
                var entry = {
                    component: component,
                    componentId: componentId,
                    attemptid: attemptId,
                    userid: userId,
                    questionslot: self.getQuestionSlotFromName(name),
                    name: name,
                    value: value,
                    timemodified: timemod
                };
                promises.push(db.insert(mmQuestionAnswersStore, entry));
            });
            return $q.all(promises);
        });
    };
    self.saveQuestion = function(component, componentId, attemptId, userId, question, state, siteId) {
        siteId = siteId || $mmSite.getId();
        return $mmSitesManager.getSite(siteId).then(function(site) {
            var entry = {
                component: component,
                componentId: componentId,
                attemptid: attemptId,
                userid: userId,
                number: question.number,
                slot: question.slot,
                state: state
            };
            return site.getDb().insert(mmQuestionStore, entry);
        });
    };
    return self;
}]);

angular.module('mm.core.question')
.directive('mmQuestionBehaviour', ["$compile", function($compile) {
    return {
        restrict: 'A',
        link: function(scope, element) {
            if (scope.directive) {
                element[0].removeAttribute('mm-question-behaviour');
                element[0].setAttribute(scope.directive, '');
                $compile(element)(scope);
            }
        }
    };
}]);

angular.module('mm.core.question')
.directive('mmQuestion', ["$log", "$compile", "$mmQuestionDelegate", "$mmQuestionHelper", "$mmQuestionBehaviourDelegate", "$mmUtil", "$translate", "$q", "$mmQuestion", function($log, $compile, $mmQuestionDelegate, $mmQuestionHelper, $mmQuestionBehaviourDelegate, $mmUtil,
            $translate, $q, $mmQuestion) {
    $log = $log.getInstance('mmQuestion');
    return {
        restrict: 'E',
        templateUrl: 'core/components/question/templates/question.html',
        scope: {
            question: '=',
            component: '=?',
            componentId: '=?',
            attemptId: '=?',
            abort: '&',
            buttonClicked: '&?',
            offlineEnabled: '@?',
            scrollHandle: '@?'
        },
        link: function(scope, element) {
            var question = scope.question,
                component = scope.component,
                attemptId = scope.attemptId,
                questionContainer = element[0].querySelector('.mm-question-container'),
                behaviour,
                promise,
                offline = scope.offlineEnabled && scope.offlineEnabled !== '0' && scope.offlineEnabled !== 'false';
            if (question && questionContainer) {
                var directive = $mmQuestionDelegate.getDirectiveForQuestion(question);
                if (directive) {
                    $mmQuestionHelper.extractQuestionScripts(question);
                    behaviour = $mmQuestionDelegate.getBehaviourForQuestion(question, question.preferredBehaviour);
                    if (!$mmQuestionBehaviourDelegate.isBehaviourSupported(behaviour)) {
                        $log.warn('Aborting question because the behaviour is not supported.', question.name);
                        $mmQuestionHelper.showDirectiveError(scope,
                                $translate.instant('mma.mod_quiz.errorbehaviournotsupported') + ' ' + behaviour);
                        return;
                    }
                    scope.seqCheck = $mmQuestionHelper.getQuestionSequenceCheckFromHtml(question.html);
                    if (!scope.seqCheck) {
                        $log.warn('Aborting question because couldn\'t retrieve sequence check.', question.name);
                        $mmQuestionHelper.showDirectiveError(scope);
                        return;
                    }
                    if (offline) {
                        promise = $mmQuestion.getQuestionAnswers(component, attemptId, question.slot).then(function(answers) {
                            question.localAnswers = $mmQuestion.convertAnswersArrayToObject(answers, true);
                        }).catch(function() {
                            question.localAnswers = {};
                        });
                    } else {
                        question.localAnswers = {};
                        promise = $q.when();
                    }
                    promise.then(function() {
                        scope.behaviourDirectives = $mmQuestionBehaviourDelegate.handleQuestion(
                                        question, question.preferredBehaviour);
                        $mmQuestionHelper.extractQbehaviourRedoButton(question);
                        question.html = $mmUtil.removeElementFromHtml(question.html, '.im-controls');
                        question.validationError = $mmQuestionHelper.getValidationErrorFromHtml(question.html);
                        $mmQuestionHelper.loadLocalAnswersInHtml(question);
                        $mmQuestionHelper.extractQuestionFeedback(question);
                        $mmQuestionHelper.extractQuestionComment(question);
                        questionContainer.setAttribute(directive, '');
                        $compile(questionContainer)(scope);
                    });
                }
            }
        }
    };
}]);

angular.module('mm.core.settings')
.controller('mmSettingsAboutCtrl', ["$scope", "$window", "$mmApp", "$ionicPlatform", "$mmLang", "$mmFS", "$mmLocalNotifications", "mmCoreConfigConstants", function($scope, $window, $mmApp, $ionicPlatform, $mmLang, $mmFS,
            $mmLocalNotifications, mmCoreConfigConstants) {
    $scope.versionname = mmCoreConfigConstants.versionname;
    $scope.appname = $mmApp.isDesktop() ? mmCoreConfigConstants.desktopappname : mmCoreConfigConstants.appname;
    $scope.versioncode = mmCoreConfigConstants.versioncode;
    $scope.privacyPolicy = mmCoreConfigConstants.privacypolicy;
    $scope.navigator = $window.navigator;
    if ($window.location && $window.location.href) {
        var url = $window.location.href;
        $scope.locationhref = url.substr(0, url.indexOf('#/site/'));
    }
    $scope.appready = $mmApp.isReady() ? 'mm.core.yes' : 'mm.core.no';
    $scope.devicetype = $ionicPlatform.isTablet() ? 'mm.core.tablet' : 'mm.core.phone';
    if (ionic.Platform.isAndroid()) {
        $scope.deviceos = 'mm.core.android';
    } else if (ionic.Platform.isIOS()) {
        $scope.deviceos = 'mm.core.ios';
    } else if (ionic.Platform.isWindowsPhone()) {
        $scope.deviceos = 'mm.core.windowsphone';
    } else {
        var matches = navigator.userAgent.match(/\(([^\)]*)\)/);
        if (matches && matches.length > 1) {
            $scope.deviceos = matches[1];
        } else {
            $scope.deviceos = 'mm.core.unknown';
        }
    }
    $mmLang.getCurrentLanguage().then(function(lang) {
        $scope.currentlanguage = lang;
    });
    $scope.networkstatus = $mmApp.isOnline() ? 'mm.core.online' : 'mm.core.offline';
    $scope.wificonnection = $mmApp.isNetworkAccessLimited() ? 'mm.core.no' : 'mm.core.yes';
    $scope.devicewebworkers = !!window.Worker && !!window.URL ? 'mm.core.yes' : 'mm.core.no';
    $scope.device = ionic.Platform.device();
    if ($mmFS.isAvailable()) {
        $mmFS.getBasePath().then(function(basepath) {
            $scope.filesystemroot = basepath;
            $scope.fsclickable = $mmFS.usesHTMLAPI();
        });
    }
    $scope.storagetype = $mmApp.getDB().getType();
    $scope.localnotifavailable = $mmLocalNotifications.isAvailable() ? 'mm.core.yes' : 'mm.core.no';
}]);

angular.module('mm.core.settings')
.controller('mmSettingsGeneralCtrl', ["$scope", "$mmLang", "$ionicHistory", "$mmEvents", "$mmConfig", "mmCoreEventLanguageChanged", "mmCoreSettingsReportInBackground", "mmCoreConfigConstants", "mmCoreSettingsRichTextEditor", "$mmUtil", function($scope, $mmLang, $ionicHistory, $mmEvents, $mmConfig, mmCoreEventLanguageChanged,
            mmCoreSettingsReportInBackground, mmCoreConfigConstants, mmCoreSettingsRichTextEditor,
            $mmUtil) {
    $scope.langs = mmCoreConfigConstants.languages;
    $mmLang.getCurrentLanguage().then(function(currentLanguage) {
        $scope.selectedLanguage = currentLanguage;
    });
    $scope.languageChanged = function(newLang) {
        $mmLang.changeCurrentLanguage(newLang).finally(function() {
            $ionicHistory.clearCache();
            $mmEvents.trigger(mmCoreEventLanguageChanged);
        });
    };
    $scope.rteSupported = $mmUtil.isRichTextEditorSupported();
    if ($scope.rteSupported) {
        $mmConfig.get(mmCoreSettingsRichTextEditor, true).then(function(richTextEditorEnabled) {
            $scope.richTextEditor = richTextEditorEnabled;
        });
        $scope.richTextEditorChanged = function(richTextEditor) {
            $mmConfig.set(mmCoreSettingsRichTextEditor, richTextEditor);
        };
    }
    if (localStorage && localStorage.getItem && localStorage.setItem) {
        $scope.showReport = true;
        $scope.reportInBackground = parseInt(localStorage.getItem(mmCoreSettingsReportInBackground), 10) === 1;
        $scope.reportChanged = function(inBackground) {
            localStorage.setItem(mmCoreSettingsReportInBackground, inBackground ? '1' : '0');
        };
    } else {
        $scope.showReport = false;
    }
}]);

angular.module('mm.core.settings')
.controller('mmSettingsListCtrl', ["$scope", "$mmSettingsDelegate", function($scope, $mmSettingsDelegate) {
    $scope.isIOS = ionic.Platform.isIOS();
    $scope.handlers = $mmSettingsDelegate.getHandlers();
    $scope.areHandlersLoaded = $mmSettingsDelegate.areHandlersLoaded;
}]);

angular.module('mm.core.settings')
.controller('mmSettingsSpaceUsageCtrl', ["$log", "$scope", "$mmSitesManager", "$mmFS", "$q", "$mmUtil", "$translate", "$mmSite", "$mmText", "$mmFilepool", "$mmCourse", function($log, $scope, $mmSitesManager, $mmFS, $q, $mmUtil, $translate, $mmSite,
            $mmText, $mmFilepool, $mmCourse) {
    $log = $log.getInstance('mmSettingsSpaceUsageCtrl');
    $scope.currentSiteId = $mmSite.getId();
    function calculateSizeUsage() {
        return $mmSitesManager.getSites().then(function(sites) {
            var promises = [];
            $scope.sites = $mmSitesManager.sortSites(sites);
            angular.forEach(sites, function(siteEntry) {
                var promise = $mmSitesManager.getSite(siteEntry.id).then(function(site) {
                    return site.getSpaceUsage().then(function(size) {
                        siteEntry.spaceusage = size;
                    });
                });
                promises.push(promise);
            });
            return $q.all(promises);
        });
    }
    function calculateTotalUsage() {
        var total = 0;
        angular.forEach($scope.sites, function(site) {
            if (site.spaceusage) {
                total += parseInt(site.spaceusage, 10);
            }
        });
        $scope.totalusage = total;
    }
    function calculateFreeSpace() {
        if ($mmFS.isAvailable()) {
            return $mmFS.calculateFreeSpace().then(function(freespace) {
                $scope.freespace = freespace;
            }, function() {
                $scope.freespace = 0;
            });
        } else {
            $scope.freespace = 0;
        }
    }
    function fetchData() {
        var promises = [];
        promises.push(calculateSizeUsage().then(calculateTotalUsage));
        promises.push($q.when(calculateFreeSpace()));
        return $q.all(promises);
    }
    fetchData().finally(function() {
        $scope.sizeLoaded = true;
    });
    $scope.refresh = function() {
        fetchData().finally(function() {
            $scope.$broadcast('scroll.refreshComplete');
        });
    };
    function updateSiteUsage(site, newUsage) {
        var oldUsage = site.spaceusage;
        site.spaceusage = newUsage;
        $scope.totalusage -= oldUsage - newUsage;
        $scope.freespace += oldUsage - newUsage;
    }
    $scope.deleteSiteFiles = function(siteData) {
        if (siteData) {
            var siteid = siteData.id,
                sitename = siteData.sitename;
            $mmText.formatText(sitename).then(function(sitename) {
                $translate('mm.settings.deletesitefilestitle').then(function(title) {
                    return $mmUtil.showConfirm($translate('mm.settings.deletesitefiles', {sitename: sitename}), title);
                }).then(function() {
                    return $mmSitesManager.getSite(siteid);
                }).then(function(site) {
                    return site.deleteFolder().then(function() {
                        $mmCourse.clearAllCoursesStatus(siteid);
                        $mmFilepool.clearAllPackagesStatus(siteid);
                        $mmFilepool.clearFilepool(siteid);
                        updateSiteUsage(siteData, 0);
                    }).catch(function(error) {
                        if (error && error.code === FileError.NOT_FOUND_ERR) {
                            $mmFilepool.clearAllPackagesStatus(siteid);
                            updateSiteUsage(siteData, 0);
                        } else {
                            $mmUtil.showErrorModal('mm.settings.errordeletesitefiles', true);
                            site.getSpaceUsage().then(function(size) {
                                updateSiteUsage(siteData, size);
                            });
                        }
                    });
                });
            });
        }
    };
}]);

angular.module('mm.core.settings')
.controller('mmSettingsSynchronizationCtrl', ["$log", "$scope", "$mmUtil", "$mmConfig", "$mmSettingsHelper", "$mmSite", "mmCoreSettingsSyncOnlyOnWifi", "$mmSitesManager", function($log, $scope, $mmUtil, $mmConfig, $mmSettingsHelper, $mmSite,
            mmCoreSettingsSyncOnlyOnWifi, $mmSitesManager) {
    $log = $log.getInstance('mmSettingsSynchronizationCtrl');
    $scope.currentSiteId = $mmSite.getId();
    $mmSettingsHelper.getSites().then(function(sites) {
        $scope.sites = sites;
        angular.forEach(sites, function(site) {
            if (site.synchronizing) {
                $mmSettingsHelper.getSiteSyncPromise(site.id).catch(errorSyncing);
            }
        });
    });
    $mmConfig.get(mmCoreSettingsSyncOnlyOnWifi, true).then(function(syncOnlyOnWifi) {
        $scope.syncOnlyOnWifi = syncOnlyOnWifi;
    });
    $scope.syncWifiChanged = function(syncOnlyOnWifi) {
        $mmConfig.set(mmCoreSettingsSyncOnlyOnWifi, syncOnlyOnWifi);
    };
    $scope.synchronize = function(siteId) {
        if ($scope.sites[siteId] && !$scope.sites[siteId].synchronizing) {
            $mmSettingsHelper.synchronizeSite($scope.syncOnlyOnWifi, siteId).catch(errorSyncing);
        }
    };
    function errorSyncing(error) {
        if (!$scope.$$destroyed) {
            if (error) {
                $mmUtil.showErrorModal(error);
            } else {
                $mmUtil.showErrorModal('mm.settings.errorsyncsite', true);
            }
        }
    }
}]);

angular.module('mm.core.settings')
.provider('$mmSettingsDelegate', function() {
    var handlers = {},
        self = {};
    self.registerHandler = function(component, handler, priority) {
        if (typeof handlers[component] !== 'undefined') {
            console.log("$mmSettingsDelegateProvider: Handler '" + handlers[component].component + "' already registered as settings handler");
            return false;
        }
        console.log("$mmSettingsDelegateProvider: Registered component '" + component + "' as settings handler.");
        handlers[component] = {
            component: component,
            handler: handler,
            instance: undefined,
            priority: typeof priority === 'undefined' ? 100 : priority
        };
        return true;
    };
    self.$get = ["$q", "$log", "$mmSite", "$mmUtil", function($q, $log, $mmSite, $mmUtil) {
        var enabledHandlers = {},
            currentSiteHandlers = [], 
            self = {},
            loaded = false, 
            lastUpdateHandlersStart;
        $log = $log.getInstance('$mmSettingsDelegate');
        self.areHandlersLoaded = function() {
            return loaded;
        };
        self.clearSiteHandlers = function() {
            loaded = false;
            $mmUtil.emptyArray(currentSiteHandlers);
        };
        self.getHandlers = function() {
            return currentSiteHandlers;
        };
        self.isLastUpdateCall = function(time) {
            if (!lastUpdateHandlersStart) {
                return true;
            }
            return time == lastUpdateHandlersStart;
        };
        self.updateHandler = function(addon, handlerInfo, time) {
            var promise,
                siteId = $mmSite.getId();
            if (typeof handlerInfo.instance === 'undefined') {
                handlerInfo.instance = $mmUtil.resolveObject(handlerInfo.handler, true);
            }
            if (!$mmSite.isLoggedIn()) {
                promise = $q.reject();
            } else {
                promise = $q.when(handlerInfo.instance.isEnabled());
            }
            return promise.catch(function() {
                return false;
            }).then(function(enabled) {
                if (self.isLastUpdateCall(time) && $mmSite.isLoggedIn() && $mmSite.getId() === siteId) {
                    if (enabled) {
                        enabledHandlers[addon] = {
                            instance: handlerInfo.instance,
                            priority: handlerInfo.priority
                        };
                    } else {
                        delete enabledHandlers[addon];
                    }
                }
            });
        };
        self.updateHandlers = function() {
            var promises = [],
            